/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.TagInfo;
import java.util.Iterator;
import java.util.Vector;

public class Choice
extends BaseASN1Object {
    private Vector components;
    private ASN1Object currentChoice;

    public Choice() {
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
        this.setChoice(true);
    }

    public Choice(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
        this.setChoice(true);
    }

    public Choice(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
        this.setChoice(true);
        if (value instanceof Vector) {
            this.components = (Vector)value;
        }
    }

    public void setValue(Object value) {
        if (value instanceof BaseASN1Object) {
            try {
                byte[] valEnc = ((BaseASN1Object)value).getEncoded();
                this.decode(valEnc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getValue() {
        return this.currentChoice;
    }

    public void addElement(ASN1Object element) {
        if (this.components == null) {
            this.components = new Vector();
        }
        this.components.addElement(element);
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        Choice.trace("Choice." + this.getName() + ".decode: tagInfo =\n" + tagInfo.toString() + "\n");
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object comp = (ASN1Object)this.components.elementAt(i);
            Choice.trace("Choice." + this.getName() + ".decode: checking for match: " + comp.toString());
            if (comp.getType() != 0) {
                byte b1 = comp.getTagClass();
                Choice.trace("Choice." + this.getName() + ".decode: Comparing tag classes; component (" + b1 + ") == encoded (" + tagInfo.tagClass + ")?");
                if (b1 != tagInfo.tagClass) {
                    Choice.trace("tag classes are not equal");
                    continue;
                }
                int i1 = comp.getTagNumber();
                Choice.trace("Choice." + this.getName() + ".decode: Comparing tag numbers; component (" + i1 + ") == encoded (" + tagInfo.tagNumber + ")?");
                if (i1 != tagInfo.tagNumber) {
                    Choice.trace("tag numbers are not equal");
                    continue;
                }
            }
            Choice.trace("Choice." + this.getName() + ".decode: setting the value of " + comp.getName() + "\n");
            this.currentChoice = comp;
            this.setTagClass(comp.getTagClass());
            this.setTaggingMethod(comp.getTaggingMethod());
            this.setTagNumber(comp.getTagNumber());
            this.setType(comp.getType());
            this.setConstructed(comp.isConstructed());
            int y = tagInfo.contentLength + (tagInfo.contentIndex - tagInfo.tagIndex);
            byte[] content = new byte[y];
            System.arraycopy(data, tagInfo.tagIndex, content, 0, y);
            comp.decode(content);
            break;
        }
    }

    protected byte[] getContentEncoding() {
        if (this.currentChoice == null) {
            return null;
        }
        return ((BaseASN1Object)this.currentChoice).getContentEncoding();
    }

    public String toString() {
        return new String(super.toString());
    }

    public void clearElements() {
        this.components.clear();
    }

    public Vector getComponentTagClasses() {
        if (this.components == null || this.components.size() == 0) {
            return null;
        }
        Vector<Byte> tagClassVec = new Vector<Byte>();
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            tagClassVec.addElement(new Byte(((ASN1Object)iter.next()).getTagClass()));
        }
        return tagClassVec;
    }

    public Vector getComponentTagNumbers() {
        if (this.components == null || this.components.size() == 0) {
            return null;
        }
        Vector<Integer> tagNumberVec = new Vector<Integer>();
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            tagNumberVec.addElement(new Integer(((ASN1Object)iter.next()).getTagNumber()));
        }
        return tagNumberVec;
    }

    public void setTagToAllComponents(byte tclass, int tmethod, int tnumber) {
        for (int i = 0; i < this.components.size(); ++i) {
            ((BaseASN1Object)this.components.elementAt(i)).setTagClass(tclass);
            ((BaseASN1Object)this.components.elementAt(i)).setTaggingMethod(tmethod);
            ((BaseASN1Object)this.components.elementAt(i)).setTagNumber(tnumber);
        }
    }

    public void setForcedTagMethodToAllComponents(int ftm) {
        for (int i = 0; i < this.components.size(); ++i) {
            ((BaseASN1Object)this.components.elementAt(i)).setForcedTagMethod(ftm);
        }
    }

    public static void main(String[] args) {
        ASN1Integer integer = new ASN1Integer("integer");
        OctetString octetString = new OctetString("octetString");
        octetString.setTaggingMethod(1);
        octetString.setTagNumber(0);
        Choice choice = new Choice("Test choice");
        choice.addElement(integer);
        choice.addElement(octetString);
        byte[] bytes = new byte[]{2, 1, 27};
        byte[] ostring = new byte[]{85, 66, 3, 4};
        octetString.setValue(ostring);
        choice.setValue(octetString);
    }
}

