/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.math.BigInteger;

public class Enumerated
extends BaseASN1Object {
    private BigInteger value;
    private BigInteger defaultValue;

    public Enumerated() {
        super("");
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(10);
        this.setTagNumber(10);
    }

    public Enumerated(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(10);
        this.setTagNumber(10);
    }

    public Enumerated(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(10);
        this.setTagNumber(10);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof BigInteger) {
            this.value = (BigInteger)value;
        }
        if (value instanceof String) {
            this.value = new BigInteger((String)value);
        }
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return null;
    }

    public void setDefaultValue(Object value) {
        if (value instanceof BigInteger) {
            this.defaultValue = (BigInteger)value;
        }
        if (value instanceof String) {
            this.defaultValue = new BigInteger((String)value);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDefaultValue() {
        BigInteger x2;
        BigInteger x1;
        if (this.defaultValue == null) {
            return false;
        }
        if (this.value == null && this.defaultValue != null) {
            return true;
        }
        return this.value != null && this.defaultValue != null && (x1 = this.value).equals(x2 = this.defaultValue);
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        byte[] integerBytes = new byte[tagInfo.contentLength];
        System.arraycopy(data, tagInfo.contentIndex, integerBytes, 0, tagInfo.contentLength);
        this.value = new BigInteger(integerBytes);
    }

    protected byte[] getContentEncoding() {
        if (this.value == null) {
            return null;
        }
        return this.value.toByteArray();
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " value = " + this.value.toString());
        }
        return new String(super.toString());
    }
}

