/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class UTCTime
extends BaseASN1Object {
    private Date value;

    public UTCTime(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(23);
        this.setTagNumber(23);
    }

    public UTCTime(String name, Object value) {
        super(name, value);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(23);
        this.setTagNumber(23);
        if (value instanceof Date) {
            this.setValue(value);
        }
    }

    public void setValue(Object date) {
        this.value = (Date)date;
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(23);
        try {
            TimeZone tz;
            SimpleDateFormat sdf;
            String shortString;
            String dateString = new String(data, tagInfo.contentIndex, tagInfo.contentLength);
            UTCTime.trace("UTCTime.decode: " + dateString);
            if (dateString.charAt(10) >= '0' && dateString.charAt(10) <= '9') {
                UTCTime.trace("UTCTime.decode: seconds are included");
                shortString = dateString.substring(0, 12);
                sdf = new SimpleDateFormat("yyMMddHHmmss");
            } else {
                UTCTime.trace("UTCTime.decode: seconds are not included");
                shortString = dateString.substring(0, 10);
                sdf = new SimpleDateFormat("yyMMddHHmm");
            }
            int tzIdx = dateString.indexOf(90);
            if (tzIdx != -1) {
                UTCTime.trace("UTCTime.decode: using UTC");
                tz = TimeZone.getTimeZone("GMT");
            } else {
                tzIdx = dateString.indexOf(43);
                if (tzIdx == -1 && (tzIdx = dateString.indexOf(45)) == -1) {
                    UTCTime.trace("UTCTime.decode: no time zone specified in " + dateString);
                    return;
                }
                String tzString = new String("GMT" + dateString.substring(tzIdx, tzIdx + 3));
                tzString = tzString.concat(":" + dateString.substring(tzIdx += 3, tzIdx + 2));
                UTCTime.trace("UTCTime.decode: creating a time zone of " + tzString);
                tz = TimeZone.getTimeZone(tzString);
            }
            sdf.setTimeZone(tz);
            UTCTime.trace("UTCTime.decode: short string is " + shortString);
            this.value = sdf.parse(shortString);
        }
        catch (ParseException e) {
            throw new DecodeException();
        }
    }

    protected byte[] getContentEncoding() {
        if (this.value != null) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss'Z'");
            sdf.setTimeZone(tz);
            String x = sdf.format(this.value);
            return x.getBytes();
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " " + this.value.toString());
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        String x = new String("9905260909+1000");
        byte[] a = new byte[2 + x.length()];
        a[0] = 23;
        a[1] = (byte)x.length();
        System.arraycopy(x.getBytes(), 0, a, 2, x.length());
        UTCTime t = new UTCTime(x);
        t.decode(a);
        System.out.println(t.toString());
        byte[] f = t.getEncoded();
        for (int z = 0; z < f.length; ++z) {
            System.out.print(Integer.toString(f[z] & 0xFF, 16) + " ");
        }
        System.out.println("");
    }
}

