/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.ocsp.ResponderID;
import com.turktrust.ocsp.SingleResponse;
import com.turktrust.x509.Extensions;
import java.math.BigInteger;
import java.util.Vector;

public class ResponseData
extends Sequence {
    private ASN1Integer version = new ASN1Integer("default_version");
    private ResponderID responderId = new ResponderID("default_responderId");
    private GeneralizedTime producedAt = new GeneralizedTime("default_producedAt");
    private SequenceOf responses = new SequenceOf("default_responses", new SingleResponse());
    private Extensions responseExtensions = new Extensions("default_responseExtensions");

    public ResponseData() {
        super("default_responseData");
        this.setUpElements();
    }

    public ResponseData(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        this.version.setDefaultValue(new BigInteger("0"));
        this.version.setOptional(true);
        this.version.setTaggingMethod(2);
        this.version.setTagClass((byte)-128);
        this.version.setTagNumber(0);
        super.addElement(this.responderId);
        super.addElement(this.producedAt);
        super.addElement(this.responses);
        super.addElement(this.responseExtensions);
        this.responseExtensions.setOptional(true);
        this.responseExtensions.setTaggingMethod(2);
        this.responseExtensions.setTagClass((byte)-128);
        this.responseExtensions.setTagNumber(1);
    }

    public void setVersion(ASN1Integer value) {
        this.version = value;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public void setResponderId(ResponderID value) {
        this.responderId = value;
    }

    public ResponderID getResponderId() {
        return this.responderId;
    }

    public void setProducedAt(GeneralizedTime value) {
        this.producedAt = value;
    }

    public GeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public void setResponses(Vector responseVec) {
        this.responses.setValue(responseVec);
    }

    public Vector getReponses() {
        return (Vector)this.responses.getValue();
    }

    public void setResponseExtensions(Extensions value) {
        this.responseExtensions = value;
    }

    public Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

