/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.BitString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Certificate;
import java.util.Iterator;
import java.util.Vector;

public class Signature
extends Sequence {
    private AlgorithmIdentifier signatureAlgorithmIdentifier = new AlgorithmIdentifier("algId");
    private BitString signature = new BitString("signature");
    private SequenceOf certs = new SequenceOf("certs", new Certificate("default_cert"));

    public Signature() {
        super("default_signature");
        this.setUpElements();
    }

    public Signature(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.signatureAlgorithmIdentifier);
        super.addElement(this.signature);
        super.addElement(this.certs);
        this.certs.setOptional(true);
        this.certs.setTaggingMethod(2);
        this.certs.setTagClass((byte)-128);
        this.certs.setTagNumber(0);
    }

    public void setSignatureAlgorithmIdentifier(AlgorithmIdentifier algId) {
        this.signatureAlgorithmIdentifier = algId;
    }

    public AlgorithmIdentifier getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithmIdentifier;
    }

    public void setSignature(BitString value) {
        this.signature = value;
    }

    public BitString getSignature() {
        return this.signature;
    }

    public void setCerts(Vector certVec) {
        this.certs = new SequenceOf("certs", new Certificate("default_cert"));
        Iterator iter = certVec.iterator();
        while (iter.hasNext()) {
            this.certs.addElement((Certificate)iter.next());
        }
    }

    public SequenceOf getCerts() {
        return this.certs;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

