/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.asn1.UTCTime;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.smyy.utils.IptalBilgisi;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.AuthorityKeyId;
import com.turktrust.x509.CRLDistributionPoints;
import com.turktrust.x509.CRLNumber;
import com.turktrust.x509.CRLReason;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.CertificateList;
import com.turktrust.x509.DistributionPoint;
import com.turktrust.x509.DistributionPointName;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.Name;
import com.turktrust.x509.RevokedCertificate;
import com.turktrust.x509.RevokedCertificates;
import com.turktrust.x509.SubjectPublicKeyInfo;
import com.turktrust.x509.TBSCertList;
import com.turktrust.x509.Time;
import com.turktrust.x509.Version;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class CRLFabrikasi {
    public static TBSCertList generateTBSCertList(Certificate issuerCert, int validityInDays, Vector iptalBilgiVec, boolean authKeyIdExists, int crlNo) {
        try {
            RevokedCertificates revCerts = new RevokedCertificates("revCerts");
            for (IptalBilgisi ipt : iptalBilgiVec) {
                ASN1Integer serialAsn = new ASN1Integer("serialNo", ipt.getSerialNo());
                GeneralizedTime revGenTime = new GeneralizedTime("revGenTime");
                byte[] genTimeHead = new byte[]{24, 15};
                byte[] genTimeContent = ipt.getIptalTarihiStr().getBytes();
                byte[] genTimeAll = new byte[17];
                System.arraycopy(genTimeHead, 0, genTimeAll, 0, 2);
                System.arraycopy(genTimeContent, 0, genTimeAll, 2, 15);
                revGenTime.decode(genTimeAll);
                UTCTime revUTCtime = new UTCTime("revUTCtime");
                revUTCtime.setValue(revGenTime.getValue());
                Time revTime = new Time("revocationTime");
                revTime.setValue(revUTCtime);
                CRLReason reasonExt = new CRLReason("crlReason", false, ipt.getIptalNedeni());
                Extensions entryExts = new Extensions("entryExtensions");
                entryExts.addElement(reasonExt);
                RevokedCertificate rcert = new RevokedCertificate("revCert");
                rcert.setSerialNo(serialAsn);
                rcert.setRevocationDate(revTime);
                rcert.setExtensions(entryExts);
                rcert.commitElementUpdate();
                revCerts.addElement(rcert);
            }
            Time thisUpdate = new Time("ThisUpdate");
            Time nextUpdate = new Time("NextUpdate");
            Date now = new Date();
            Date finish = (Date)now.clone();
            finish.setTime(finish.getTime() + (long)validityInDays * 86400000L);
            UTCTime utcThis = new UTCTime("now", now);
            UTCTime utcNext = new UTCTime("finish", finish);
            thisUpdate.setValue(utcThis);
            nextUpdate.setValue(utcNext);
            Extensions crlExtensions = new Extensions("crlExtensions");
            if (authKeyIdExists) {
                SubjectPublicKeyInfo signerSpki = null;
                signerSpki = issuerCert.gettbsCertificate().getsubjectPublicKeyInfo();
                byte[] signerPubKeyBytes = (byte[])signerSpki.getsubjectPublicKey().getValue();
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                byte[] pubKeyHash = sha.digest(signerPubKeyBytes);
                AuthorityKeyId aki = new AuthorityKeyId("authKeyId", false, pubKeyHash);
                crlExtensions.addElement(aki);
            }
            if (crlNo != -1) {
                CRLNumber crlNumberExt = new CRLNumber("crlNumberExt", false, crlNo);
                crlExtensions.addElement(crlNumberExt);
            }
            Version ver = new Version("crl_ver");
            ver.setValue("1");
            ObjectID sha1_rsa_objId = new ObjectID("SHA1WithRSA");
            sha1_rsa_objId.setValue("1.2.840.113549.1.1.5");
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_RSA");
            algId.setalgorithm(sha1_rsa_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            Name issuerName = issuerCert.gettbsCertificate().getsubject();
            TBSCertList tbs = new TBSCertList("tbs");
            tbs.setversion(ver);
            tbs.setsignature(algId);
            tbs.setissuer(issuerName);
            tbs.setthisUpdate(thisUpdate);
            tbs.setnextUpdate(nextUpdate);
            if (((Vector)revCerts.getValue()).size() > 0) {
                tbs.setrevokedCertificates(revCerts);
            }
            if (((Vector)crlExtensions.getValue()).size() > 0) {
                tbs.setcrlExtensions(crlExtensions);
            }
            tbs.commitElementUpdate();
            return tbs;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static CertificateList signTBSCertList(TBSCertList tbsCertList, PrivateKey issuerPrivKey) {
        try {
            ObjectID sha1_rsa_objId = new ObjectID("SHA1WithRSA");
            sha1_rsa_objId.setValue("1.2.840.113549.1.1.5");
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_RSA");
            algId.setalgorithm(sha1_rsa_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            byte[] tbsBytes = tbsCertList.getEncoded();
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(issuerPrivKey);
            signer.update(tbsBytes);
            byte[] sigBytes = signer.sign();
            BitString signBitString = new BitString("signature");
            signBitString.setValue(sigBytes);
            CertificateList certList = new CertificateList("certList");
            certList.settbsCertList(tbsCertList);
            certList.setsignatureAlgorithm(algId);
            certList.setsignature(signBitString);
            certList.commitElementUpdate();
            return certList;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static boolean verifyCRL(CertificateList toBeVerifiedCRL, Certificate issuerCert) {
        try {
            byte[] tbsBytes = toBeVerifiedCRL.gettbsCertList().getEncoded();
            byte[] signatureBytes = (byte[])toBeVerifiedCRL.getsignature().getValue();
            byte[] issuerSpkiBytes = issuerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(issuerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey issuerPubKey = keyFac.generatePublic(xspec);
            Object signature = null;
            ObjectID signAlgObjId = toBeVerifiedCRL.getsignatureAlgorithm().getalgorithm();
            if (!ImzaFabrikasi.algoritmaDesteklenmeKontrolu((String)signAlgObjId.getValue())) {
                return false;
            }
            if (!ImzaFabrikasi.verifyPKCS1SignatureWithAlgorithmCheck(signatureBytes, issuerPubKey, tbsBytes, (String)signAlgObjId.getValue())) {
                return false;
            }
            Name issuerFromChild = toBeVerifiedCRL.gettbsCertList().getissuer();
            Name subjectFromParent = issuerCert.gettbsCertificate().getsubject();
            return issuerFromChild.isEqualTo(subjectFromParent);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static RevokedCertificate isCertificateInCRL(Certificate queryCert, CertificateList crl) {
        try {
            if (!crl.gettbsCertList().getissuer().isEqualTo(queryCert.gettbsCertificate().getissuer())) {
                return null;
            }
            SequenceOf revcerts = crl.gettbsCertList().getrevokedCertificates();
            Vector revocVec = (Vector)revcerts.getValue();
            BigInteger serialOfQueryCert = (BigInteger)queryCert.gettbsCertificate().getserialNumber().getValue();
            for (int i = 0; i < revocVec.size(); ++i) {
                RevokedCertificate rcert = (RevokedCertificate)revocVec.elementAt(i);
                if (((BigInteger)rcert.getSerialNo().getValue()).compareTo(serialOfQueryCert) != 0) continue;
                return rcert;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static boolean isCRLUptoDate(CertificateList crl) {
        try {
            Date notBefore = (Date)((UTCTime)crl.gettbsCertList().getthisUpdate().getValue()).getValue();
            Date notAfter = (Date)((UTCTime)crl.gettbsCertList().getnextUpdate().getValue()).getValue();
            Date now = new Date();
            return now.after(notBefore) && now.before(notAfter);
        }
        catch (Exception exc) {
            try {
                Date notBefore = (Date)((GeneralizedTime)crl.gettbsCertList().getthisUpdate().getValue()).getValue();
                Date notAfter = (Date)((GeneralizedTime)crl.gettbsCertList().getnextUpdate().getValue()).getValue();
                Date now = new Date();
                return now.after(notBefore) && now.before(notAfter);
            }
            catch (Exception exc2) {
                exc2.printStackTrace();
                return false;
            }
        }
    }

    public static boolean isCRLValidAtGivenDate(CertificateList crl, Date date) {
        try {
            Date notAfter = (Date)((UTCTime)crl.gettbsCertList().getnextUpdate().getValue()).getValue();
            return date.before(notAfter);
        }
        catch (Exception exc) {
            try {
                Date notAfter = (Date)((GeneralizedTime)crl.gettbsCertList().getnextUpdate().getValue()).getValue();
                return date.before(notAfter);
            }
            catch (Exception exc2) {
                exc2.printStackTrace();
                return false;
            }
        }
    }

    public static String getRevocationReasonTurkishExp(RevokedCertificate revCert) {
        try {
            Extensions exts = revCert.getExtensions();
            Extension reasonExt = exts.getExtensionByOID("2.5.29.21");
            if (reasonExt != null) {
                return reasonExt.getTurkishExplanation();
            }
            return "Tan\u0131ms\u0131z";
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return "Tan\u0131ms\u0131z";
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("D:\\codetest\\kokler\\YeniCRL\\TURKTRUST_SSL_SIL_s3.crl");
            byte[] crlBytes = new byte[fis.available()];
            fis.read(crlBytes);
            fis.close();
            CertificateList crl = new CertificateList("crl");
            crl.decode(crlBytes);
            FileInputStream fis2 = new FileInputStream("D:\\codetest\\kokler\\TT_SSL_altkok_3.crt");
            byte[] kokBytes = new byte[fis2.available()];
            fis2.read(kokBytes);
            fis2.close();
            Certificate kokCert = new Certificate("kokCert");
            kokCert.decode(kokBytes);
            boolean verifRes = CRLFabrikasi.verifyCRL(crl, kokCert);
            System.out.println("Verif Res = " + verifRes);
            if (!crl.gettbsCertList().getissuer().isEqualTo(kokCert.gettbsCertificate().getsubject())) {
                System.out.println("Tutmuyor!!!");
            } else {
                System.out.println("Isim tamam");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static CertificateList downloadCRL(Certificate cert) {
        CertificateList crl = null;
        Extensions exts = cert.gettbsCertificate().getextensions();
        Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
        if (crldpExt == null) {
            return null;
        }
        byte[] crldpBytes = (byte[])crldpExt.getextnValue().getValue();
        CRLDistributionPoints crldps = new CRLDistributionPoints();
        crldps.decodeExtVal(crldpBytes);
        Vector distPointVec = crldps.getDistributionPoints();
        boolean crlFound = false;
        Iterator dpIter = distPointVec.iterator();
        block2: while (!crlFound && dpIter.hasNext()) {
            DistributionPoint dp = (DistributionPoint)dpIter.next();
            DistributionPointName dpn = dp.getDistributionPointName();
            Vector dpnVec = dpn.getFullName();
            for (int k = 0; k < dpnVec.size(); ++k) {
                GeneralName gn = (GeneralName)dpnVec.elementAt(k);
                if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
                String crlAddress = gn.getURI();
                try {
                    int oneChar;
                    URL url = new URL(crlAddress);
                    URLConnection urlC = url.openConnection();
                    InputStream is = url.openStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((oneChar = is.read()) != -1) {
                        baos.write(oneChar);
                    }
                    is.close();
                    baos.close();
                    byte[] crlBytes = baos.toByteArray();
                    crl = new CertificateList("crl");
                    crl.decode(crlBytes);
                    crlFound = true;
                    continue block2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return crl;
    }
}

