/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.DecodeException;
import com.turktrust.pkcs1.DigestInfo;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class ImzaFabrikasi {
    public static final String SHA1withRSA = "1.2.840.113549.1.1.5";
    public static final String SHA256withRSA = "1.2.840.113549.1.1.11";
    public static final String SHA384withRSA = "1.2.840.113549.1.1.12";
    public static final String SHA512withRSA = "1.2.840.113549.1.1.13";
    public static final String SHA224withRSA = "1.2.840.113549.1.1.14";
    public static final String WHIRLPOOLwithRSA = "1.2.840.113549.1.1.15";
    public static final int HSM_LUNA_VERSION_4 = 4;
    public static final int HSM_LUNA_VERSION_5 = 5;

    public static boolean algoritmaDesteklenmeKontrolu(String algoritma) {
        return algoritma.equals(SHA1withRSA) || algoritma.equals(SHA224withRSA) || algoritma.equals(SHA256withRSA) || algoritma.equals(SHA384withRSA) || algoritma.equals(SHA512withRSA) || algoritma.equals(WHIRLPOOLwithRSA);
    }

    public static String mapHashOIDToSignatureAlgorithmOID(String hashAlgOID) {
        if (hashAlgOID == null) {
            return null;
        }
        if (hashAlgOID.equals("1.3.14.3.2.26")) {
            return SHA1withRSA;
        }
        if (hashAlgOID.equals("2.16.840.1.101.3.4.2.4")) {
            return SHA224withRSA;
        }
        if (hashAlgOID.equals("2.16.840.1.101.3.4.2.1")) {
            return SHA256withRSA;
        }
        if (hashAlgOID.equals("2.16.840.1.101.3.4.2.2")) {
            return SHA384withRSA;
        }
        if (hashAlgOID.equals("2.16.840.1.101.3.4.2.3")) {
            return SHA512withRSA;
        }
        if (hashAlgOID.equals("1.0.10118.3.0.55")) {
            return WHIRLPOOLwithRSA;
        }
        return null;
    }

    public static boolean verifyPKCS1Signature(byte[] signatureBytes, PublicKey signerPublicKey, byte[] originalBytes) {
        try {
            byte[] decResult = ImzaFabrikasi.decryptRSASignature(signatureBytes, signerPublicKey);
            byte[] dinfoBytes = ImzaFabrikasi.removePaddingFromDecryptedSignature(decResult);
            if (dinfoBytes == null) {
                return false;
            }
            DigestInfo dinfo = new DigestInfo("dinfo");
            dinfo.decode(dinfoBytes);
            AlgorithmIdentifier algId = dinfo.getDigestAlgorithmIdentifier();
            String algObjIdStr = (String)algId.getalgorithm().getValue();
            byte[] hashBytes1 = HashFabrikasi.hashAl(originalBytes, algObjIdStr);
            byte[] hashBytes2 = (byte[])dinfo.getDigest().getValue();
            return ImzaFabrikasi.areByteArraysEqual(hashBytes1, hashBytes2);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean verifyPKCS1SignatureWithReadyHash(byte[] signatureBytes, PublicKey signerPublicKey, byte[] hashBytes) {
        try {
            byte[] decResult = ImzaFabrikasi.decryptRSASignature(signatureBytes, signerPublicKey);
            byte[] dinfoBytes = ImzaFabrikasi.removePaddingFromDecryptedSignature(decResult);
            if (dinfoBytes == null) {
                return false;
            }
            DigestInfo dinfo = new DigestInfo("dinfo");
            dinfo.decode(dinfoBytes);
            byte[] hashBytes2 = (byte[])dinfo.getDigest().getValue();
            return ImzaFabrikasi.areByteArraysEqual(hashBytes, hashBytes2);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean verifyPKCS1SignatureWithAlgorithmCheck(byte[] signatureBytes, PublicKey signerPublicKey, byte[] originalBytes, String signatureAlgorithmOIDStr) {
        try {
            if (!(signatureAlgorithmOIDStr.equals(SHA1withRSA) || signatureAlgorithmOIDStr.equals(SHA224withRSA) || signatureAlgorithmOIDStr.equals(SHA256withRSA) || signatureAlgorithmOIDStr.equals(SHA384withRSA) || signatureAlgorithmOIDStr.equals(SHA512withRSA) || signatureAlgorithmOIDStr.equals(WHIRLPOOLwithRSA))) {
                return false;
            }
            byte[] decResult = ImzaFabrikasi.decryptRSASignature(signatureBytes, signerPublicKey);
            byte[] dinfoBytes = ImzaFabrikasi.removePaddingFromDecryptedSignature(decResult);
            if (dinfoBytes == null) {
                return false;
            }
            DigestInfo dinfo = new DigestInfo("dinfo");
            try {
                dinfo.decode(dinfoBytes);
            }
            catch (DecodeException dexc) {
                return false;
            }
            AlgorithmIdentifier algId = dinfo.getDigestAlgorithmIdentifier();
            String algObjIdStr = (String)algId.getalgorithm().getValue();
            if (signatureAlgorithmOIDStr.equals(SHA1withRSA) && !algObjIdStr.equals("1.3.14.3.2.26")) {
                return false;
            }
            if (signatureAlgorithmOIDStr.equals(SHA224withRSA) && !algObjIdStr.equals("2.16.840.1.101.3.4.2.4")) {
                return false;
            }
            if (signatureAlgorithmOIDStr.equals(SHA256withRSA) && !algObjIdStr.equals("2.16.840.1.101.3.4.2.1")) {
                return false;
            }
            if (signatureAlgorithmOIDStr.equals(SHA384withRSA) && !algObjIdStr.equals("2.16.840.1.101.3.4.2.2")) {
                return false;
            }
            if (signatureAlgorithmOIDStr.equals(SHA512withRSA) && !algObjIdStr.equals("2.16.840.1.101.3.4.2.3")) {
                return false;
            }
            if (signatureAlgorithmOIDStr.equals(WHIRLPOOLwithRSA) && !algObjIdStr.equals("1.0.10118.3.0.55")) {
                return false;
            }
            byte[] hashBytes1 = HashFabrikasi.hashAl(originalBytes, algObjIdStr);
            byte[] hashBytes2 = (byte[])dinfo.getDigest().getValue();
            return ImzaFabrikasi.areByteArraysEqual(hashBytes1, hashBytes2);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static byte[] decryptRSASignature(byte[] signatureBytes, PublicKey signerPublicKey) {
        try {
            RSAPublicKey rsaPubKey = (RSAPublicKey)signerPublicKey;
            BigInteger sig = new BigInteger(1, signatureBytes);
            BigInteger res = sig.modPow(rsaPubKey.getPublicExponent(), rsaPubKey.getModulus());
            byte[] resBytes = res.toByteArray();
            return resBytes;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static byte[] removePaddingFromDecryptedSignature(byte[] decryptedSignatureBytes) {
        try {
            int index = 2;
            while (decryptedSignatureBytes[index] == -1) {
                ++index;
            }
            if (decryptedSignatureBytes[index] == 0) {
                int valStart = index + 1;
                byte[] val = new byte[decryptedSignatureBytes.length - valStart];
                System.arraycopy(decryptedSignatureBytes, valStart, val, 0, val.length);
                return val;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static void prettyPrint(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            String astr;
            int a = input[i];
            if (a < 0) {
                a += 256;
            }
            if ((astr = Integer.toString(a, 16)).length() == 1) {
                astr = "0" + astr;
            }
            System.out.print(astr + " ");
        }
        System.out.println("");
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }
}

