/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.Extension;
import java.math.BigInteger;

public class BasicConstraints
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.19";
    private boolean caBool;
    private int pathLen;

    public BasicConstraints(String name, boolean critical, boolean isCACert) {
        super(name);
        this.caBool = isCACert;
        this.pathLen = -1;
        ObjectID basicConsObjId = new ObjectID("basicConstraints");
        basicConsObjId.setValue(EXT_OBJ_ID);
        this.setextnID(basicConsObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        Sequence seq = new Sequence("bcSeq");
        if (isCACert) {
            ASN1Boolean valBool = new ASN1Boolean("bcVal", new Boolean(isCACert));
            seq.addElement(valBool);
        }
        byte[] seqBytes = seq.getEncoded();
        OctetString octs = new OctetString("bcSeqOcts", seqBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public BasicConstraints(String name, boolean critical, int pathLength) {
        super(name);
        this.caBool = true;
        this.pathLen = pathLength;
        ObjectID basicConsObjId = new ObjectID("basicConstraints");
        basicConsObjId.setValue(EXT_OBJ_ID);
        this.setextnID(basicConsObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        Sequence seq = new Sequence("bcSeq");
        ASN1Boolean valBool = new ASN1Boolean("bcVal", new Boolean(true));
        ASN1Integer valPathLen = new ASN1Integer("bcPathLen");
        valPathLen.setValue(Integer.toString(pathLength));
        seq.addElement(valBool);
        seq.addElement(valPathLen);
        byte[] seqBytes = seq.getEncoded();
        OctetString octs = new OctetString("bcSeqOcts", seqBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public BasicConstraints() {
        super("defaultBC");
        this.caBool = false;
        this.pathLen = -1;
        ObjectID basicConsObjId = new ObjectID("basicConstraints");
        basicConsObjId.setValue(EXT_OBJ_ID);
        this.setextnID(basicConsObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        Sequence seq = new Sequence("bcSeq");
        ASN1Boolean valBool = new ASN1Boolean("bcVal");
        ASN1Integer valPathLen = new ASN1Integer("bcPathLen");
        valPathLen.setOptional(true);
        seq.addElement(valBool);
        seq.addElement(valPathLen);
        try {
            seq.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.caBool = (Boolean)valBool.getValue();
        if (valPathLen.getValue() != null) {
            this.pathLen = Integer.parseInt(((BigInteger)valPathLen.getValue()).toString());
        }
        OctetString octs = new OctetString("bcSeqOcts", extValBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Basic Constraints";
    }

    public String getTurkishExtensionTitle() {
        return "Temel S\u0131n\u0131rlamalar";
    }

    public String getExplanation() {
        String exp = "";
        if (this.caBool) {
            exp = "CA Sertifikas\u0131\n";
            if (this.pathLen != -1) {
                exp = exp + "Path Length = " + this.pathLen;
            }
        } else {
            exp = "Son kullan\u0131c\u0131 sertifikas\u0131";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        if (this.caBool) {
            exp = "ESHS Sertifikas\u0131\n";
            if (this.pathLen != -1) {
                exp = exp + "Hiyerar\u015fi derinli\u011fi = " + this.pathLen;
            }
        } else {
            exp = "Son kullan\u0131c\u0131 sertifikas\u0131";
        }
        return exp;
    }
}

