/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.DistributionPointName;
import com.turktrust.x509.Extension;
import com.turktrust.x509.GeneralName;
import java.util.Vector;

public class IssuingDistributionPoint
extends Extension {
    public IssuingDistributionPoint(String name, boolean critical, String distPointStr, boolean onlyUserCerts, boolean onlyCACerts, String reasonsStr, boolean indirectCRL) {
        ObjectID extObjId = new ObjectID("IssuingDistPointObjectId");
        extObjId.setValue("2.5.29.28");
        this.setextnID(extObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        Sequence seq = new Sequence("idp_seq");
        if (distPointStr.length() > 0) {
            GeneralName gn = new GeneralName("idp");
            gn.setURI(distPointStr);
            Vector<GeneralName> gnVec = new Vector<GeneralName>();
            gnVec.addElement(gn);
            DistributionPointName dpn = new DistributionPointName("crl_dpn");
            dpn.setFullName(gnVec);
            dpn.setOptional(true);
            dpn.setTagClass((byte)-128);
            dpn.setTaggingMethod(2);
            dpn.setInternalTagMethod(1);
            dpn.setTagNumber(0);
            seq.addElement(dpn);
        }
        if (onlyUserCerts) {
            ASN1Boolean userBool = new ASN1Boolean("userBool", new Boolean(true));
            userBool.setOptional(true);
            userBool.setTagClass((byte)-128);
            userBool.setTaggingMethod(1);
            userBool.setTagNumber(1);
            seq.addElement(userBool);
        }
        if (onlyCACerts) {
            ASN1Boolean caBool = new ASN1Boolean("caBool", new Boolean(true));
            caBool.setOptional(true);
            caBool.setTagClass((byte)-128);
            caBool.setTaggingMethod(1);
            caBool.setTagNumber(2);
            seq.addElement(caBool);
        }
        if (reasonsStr.length() > 0) {
            BitString reasonBits = new BitString("reasons");
            byte[] bitsVal = new byte[1];
            int first8Int = Integer.parseInt(reasonsStr, 2);
            if (first8Int > 127) {
                first8Int -= 256;
            }
            bitsVal[0] = (byte)first8Int;
            reasonBits.setValue(bitsVal);
            BitString rbs = new BitString("reasonsBitStr", bitsVal);
            rbs.setOptional(true);
            rbs.setTagClass((byte)-128);
            rbs.setTaggingMethod(1);
            rbs.setTagNumber(3);
            seq.addElement(rbs);
        }
        if (indirectCRL) {
            ASN1Boolean icrlBool = new ASN1Boolean("indirectCRLBool", new Boolean(true));
            icrlBool.setOptional(true);
            icrlBool.setTagClass((byte)-128);
            icrlBool.setTaggingMethod(1);
            icrlBool.setTagNumber(4);
            seq.addElement(icrlBool);
        }
        byte[] idpBytes = seq.getEncoded();
        OctetString idpOcts = new OctetString("idpOcts", idpBytes);
        this.setextnValue(idpOcts);
        this.commitElementUpdate();
    }
}

