/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;

public class KeyUsage
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.15";
    private String keyUsageBitString;

    public KeyUsage(String name, boolean critical, String keyUsageBitsStr) {
        super(name);
        int first8Int;
        String first8Str;
        this.keyUsageBitString = keyUsageBitsStr;
        BitString usageBits = new BitString("keyUsage");
        byte[] bitsVal = null;
        if (keyUsageBitsStr.length() > 8 && keyUsageBitsStr.charAt(8) == '1') {
            bitsVal = new byte[2];
            first8Str = keyUsageBitsStr.substring(0, 8);
            first8Int = Integer.parseInt(first8Str, 2);
            if (first8Int > 127) {
                first8Int -= 256;
            }
            bitsVal[0] = (byte)first8Int;
            bitsVal[1] = -128;
            usageBits.setValue(bitsVal);
            usageBits.setNumberOfUnusedBits(7);
        } else {
            bitsVal = new byte[1];
            first8Str = keyUsageBitsStr.substring(0, 8);
            first8Int = Integer.parseInt(first8Str, 2);
            if (first8Int > 127) {
                first8Int -= 256;
            }
            bitsVal[0] = (byte)first8Int;
            int unusedCount = 0;
            boolean foundSetBit = false;
            while (!foundSetBit && unusedCount < 8) {
                if (keyUsageBitsStr.charAt(7 - unusedCount) == '1') {
                    foundSetBit = true;
                    continue;
                }
                ++unusedCount;
            }
            usageBits.setValue(bitsVal);
            if (foundSetBit) {
                usageBits.setNumberOfUnusedBits(unusedCount);
            } else {
                usageBits.setNumberOfUnusedBits(0);
            }
        }
        ObjectID keyUsageObjId = new ObjectID("keyUsage");
        keyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(keyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        byte[] octBytes = usageBits.getEncoded();
        OctetString extOcts = new OctetString("extKeyUsage");
        extOcts.setValue(octBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public KeyUsage() {
        super("defaultKU");
        this.keyUsageBitString = null;
        ObjectID keyUsageObjId = new ObjectID("keyUsage");
        keyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(keyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        BitString usageBits = new BitString("keyUsage");
        try {
            usageBits.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        char[] kuChars = new char[9];
        byte[] usageBytes = (byte[])usageBits.getValue();
        int b1 = usageBytes[0];
        if (b1 < 0) {
            b1 += 256;
        }
        String b1Str = Integer.toString(b1, 2);
        while (b1Str.length() < 8) {
            b1Str = "0" + b1Str;
        }
        if (usageBytes.length == 2) {
            int b2 = usageBytes[1];
            if (b2 < 0) {
                b2 += 256;
            }
            String b2Str = Integer.toString(b2, 2);
            while (b2Str.length() < 8) {
                b2Str = "0" + b2Str;
            }
            this.keyUsageBitString = b1Str + b2Str.substring(0, 1);
        } else {
            this.keyUsageBitString = b1Str + "0";
        }
        OctetString extOcts = new OctetString("extKeyUsage", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Key Usage";
    }

    public String getTurkishExtensionTitle() {
        return "Anahtar Kullan\u0131m\u0131";
    }

    public String getExplanation() {
        String exp = "";
        if (this.keyUsageBitString.charAt(0) == '1') {
            exp = exp + "Digital Signature";
        }
        if (this.keyUsageBitString.charAt(1) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Non-repudiation";
        }
        if (this.keyUsageBitString.charAt(2) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Key Encipherment";
        }
        if (this.keyUsageBitString.charAt(3) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Data Encipherment";
        }
        if (this.keyUsageBitString.charAt(4) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Key Agreement";
        }
        if (this.keyUsageBitString.charAt(5) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "KeyCert Sign";
        }
        if (this.keyUsageBitString.charAt(6) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "CRL Sign";
        }
        if (this.keyUsageBitString.charAt(7) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Encipher Only";
        }
        if (this.keyUsageBitString.charAt(8) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Decipher Only";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        if (this.keyUsageBitString.charAt(0) == '1') {
            exp = exp + "Elektronik \u0130mza";
        }
        if (this.keyUsageBitString.charAt(1) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "\u0130nkar Edilemezlik";
        }
        if (this.keyUsageBitString.charAt(2) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Anahtar \u015eifreleme";
        }
        if (this.keyUsageBitString.charAt(3) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Veri \u015eifreleme";
        }
        if (this.keyUsageBitString.charAt(4) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Anahtar Anla\u015fmas\u0131";
        }
        if (this.keyUsageBitString.charAt(5) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Sertifika \u0130mzalama";
        }
        if (this.keyUsageBitString.charAt(6) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "\u0130ptal Listesi \u0130mzalama";
        }
        if (this.keyUsageBitString.charAt(7) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Sadece \u015eifreleme";
        }
        if (this.keyUsageBitString.charAt(8) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Sadece De\u015fifreleme";
        }
        return exp;
    }

    public String getKeyUsageBits() {
        return this.keyUsageBitString;
    }
}

