/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;
import com.turktrust.x509.LogotypeExtn;

public class LogotypeExtension
extends Extension {
    public static final String EXT_OBJ_ID = "1.3.6.1.5.5.7.1.12";
    private LogotypeExtn logotypeExtn;

    public LogotypeExtension(String name, boolean critical, LogotypeExtn logotypeExtn) {
        super(name);
        this.logotypeExtn = logotypeExtn;
        ObjectID keyUsageObjId = new ObjectID("logotypeExtension");
        keyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(keyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        byte[] octBytes = logotypeExtn.getEncoded();
        OctetString extOcts = new OctetString("extLogotype");
        extOcts.setValue(octBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public LogotypeExtension() {
        super("logoTypeExtension");
        this.logotypeExtn = null;
        ObjectID keyUsageObjId = new ObjectID("logotypeExtension");
        keyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(keyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", Boolean.FALSE);
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        try {
            this.logotypeExtn = new LogotypeExtn();
            this.logotypeExtn.decode(extValBytes);
            OctetString extOcts = new OctetString("extLogotype", extValBytes);
            this.setextnValue(extOcts);
            this.commitElementUpdate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExtensionTitle() {
        return "Logotype";
    }

    public String getTurkishExtensionTitle() {
        return "Logo";
    }

    public String getExplanation() {
        return "";
    }

    public String getTurkishExplanation() {
        return "";
    }
}

