/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.BMPString;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.Choice;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.PrintableString;
import com.turktrust.asn1.TeletexString;
import com.turktrust.asn1.UTF8String;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.AttributeTypeAndValue;
import com.turktrust.x509.AttributeValue;
import com.turktrust.x509.RDNSequence;
import com.turktrust.x509.RelativeDistinguishedName;
import java.util.Iterator;
import java.util.Vector;

public class Name
extends Choice {
    private RDNSequence rdnSequence = new RDNSequence("rdnSequence");
    private String OID_COMMON_NAME = "2.5.4.3";
    private String OID_COUNTRY = "2.5.4.6";
    private String OID_STATE = "2.5.4.8";
    private String OID_LOCALITY = "2.5.4.7";
    private String OID_ORGANIZATION = "2.5.4.10";
    private String OID_ORGANIZATIONAL_UNIT = "2.5.4.11";
    private String OID_EMAIL_ADDRESS = "1.2.840.113549.1.9.1";
    private String OID_TITLE = "2.5.4.12";
    private String OID_SERIAL_NO = "2.5.4.5";
    private String OID_BUSINESS_CATEGORY = "2.5.4.15";
    private String OID_STREET_ADDRESS = "2.5.4.9";
    private String OID_POSTAL_CODE = "2.5.4.17";

    public Name() {
        this("defaultName");
    }

    public Name(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.rdnSequence);
    }

    public void setAttrVal(String attrLongName, String attrVal) {
        if (attrLongName.equals("CommonName")) {
            this.addCN(attrVal);
        } else if (attrLongName.equals("Country")) {
            this.addC(attrVal);
        } else if (attrLongName.equals("State")) {
            this.addS(attrVal);
        } else if (attrLongName.equals("Locality")) {
            this.addL(attrVal);
        } else if (attrLongName.equals("Organization")) {
            this.addO(attrVal);
        } else if (attrLongName.equals("OrganizationalUnit")) {
            this.addOU(attrVal);
        } else if (attrLongName.equals("SerialNo")) {
            this.addSerialNo(attrVal);
        } else if (attrLongName.equals("Title")) {
            this.addTitle(attrVal);
        } else if (attrLongName.equals("EmailAddress")) {
            this.addE(attrVal);
        } else if (attrLongName.equals("BusinessCategory")) {
            this.addBusinessCategory(attrVal);
        } else if (attrLongName.equals("StreetAddress")) {
            this.addStreetAddress(attrVal);
        } else if (attrLongName.equals("PostalCode")) {
            this.addPostalCode(attrVal);
        } else if (attrLongName.equals("JurisdictionOfIncLocality")) {
            this.addJurisdictionOfIncLocality(attrVal);
        } else if (attrLongName.equals("JurisdictionOfIncStateOrProvince")) {
            this.addJurisdictionOfIncStateOrProvince(attrVal);
        } else if (attrLongName.equals("JurisdictionOfIncCountry")) {
            this.addJurisdictionOfIncStateOrProvince(attrVal);
        }
    }

    private void addCN(String value) {
        AttributeTypeAndValue attCN = this.formAttribute("2.5.4.3", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attCN);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addC(String value) {
        AttributeTypeAndValue attC = this.formAttribute("2.5.4.6", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attC);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addS(String value) {
        AttributeTypeAndValue attS = this.formAttribute("2.5.4.8", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attS);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addL(String value) {
        AttributeTypeAndValue attL = this.formAttribute("2.5.4.7", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attL);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addO(String value) {
        AttributeTypeAndValue attO = this.formAttribute("2.5.4.10", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attO);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addOU(String value) {
        AttributeTypeAndValue attOU = this.formAttribute("2.5.4.11", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attOU);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addE(String value) {
        AttributeTypeAndValue attE = this.formAttribute("1.2.840.113549.1.9.1", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attE);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addTitle(String value) {
        AttributeTypeAndValue attTitle = this.formAttribute("2.5.4.12", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attTitle);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addSerialNo(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.5", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addBusinessCategory(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.15", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addStreetAddress(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.9", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addPostalCode(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.17", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addJurisdictionOfIncLocality(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("1.3.6.1.4.1.311.60.2.1.1", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addJurisdictionOfIncStateOrProvince(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("1.3.6.1.4.1.311.60.2.1.2", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    private void addJurisdictionOfIncCountry(String value) {
        AttributeTypeAndValue attSerial = this.formAttribute("1.3.6.1.4.1.311.60.2.1.3", value);
        RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");
        rdn.addElement(attSerial);
        this.rdnSequence.addElement(rdn);
        this.setValue(this.rdnSequence);
    }

    public void setNameValue(String cn, String c, String s, String l, String o, String ou_1, String ou_2, String e, String title, String serialNo) {
        RelativeDistinguishedName rdn;
        RDNSequence rdnTemp = new RDNSequence("temp");
        if (cn == null && c == null && s == null && l == null && o == null && ou_1 == null && ou_2 == null && e == null && title == null && serialNo == null) {
            return;
        }
        if (serialNo != null) {
            AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.5", serialNo);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attSerial);
            rdnTemp.addElement(rdn);
        }
        if (title != null) {
            AttributeTypeAndValue attTitle = this.formAttribute("2.5.4.12", title);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attTitle);
            rdnTemp.addElement(rdn);
        }
        if (e != null) {
            AttributeTypeAndValue attE = this.formAttribute("1.2.840.113549.1.9.1", e);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attE);
            rdnTemp.addElement(rdn);
        }
        if (c != null) {
            AttributeTypeAndValue attC = this.formAttribute("2.5.4.6", c);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attC);
            rdnTemp.addElement(rdn);
        }
        if (s != null) {
            AttributeTypeAndValue attS = this.formAttribute("2.5.4.8", s);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attS);
            rdnTemp.addElement(rdn);
        }
        if (l != null) {
            AttributeTypeAndValue attL = this.formAttribute("2.5.4.7", l);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attL);
            rdnTemp.addElement(rdn);
        }
        if (ou_2 != null) {
            AttributeTypeAndValue attOU2 = this.formAttribute("2.5.4.11", ou_2);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attOU2);
            rdnTemp.addElement(rdn);
        }
        if (ou_1 != null) {
            AttributeTypeAndValue attOU1 = this.formAttribute("2.5.4.11", ou_1);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attOU1);
            rdnTemp.addElement(rdn);
        }
        if (o != null) {
            AttributeTypeAndValue attO = this.formAttribute("2.5.4.10", o);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attO);
            rdnTemp.addElement(rdn);
        }
        if (cn != null) {
            AttributeTypeAndValue attCN = this.formAttribute("2.5.4.3", cn);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attCN);
            rdnTemp.addElement(rdn);
        }
        this.rdnSequence = rdnTemp;
        this.setValue(rdnTemp);
    }

    public void setNameValue(String cn, String c, String s, String l, String o, String ou_1, String ou_2, String e, String title, String serialNo, String businessCategory, String streetAddress, String postalCode, String joiLocality, String joiState, String joiCountry) {
        RelativeDistinguishedName rdn;
        RDNSequence rdnTemp = new RDNSequence("temp");
        if (cn == null && c == null && s == null && l == null && o == null && ou_1 == null && ou_2 == null && e == null && title == null && serialNo == null) {
            return;
        }
        if (joiCountry != null) {
            AttributeTypeAndValue attJoiCountry = this.formAttribute("1.3.6.1.4.1.311.60.2.1.3", joiCountry);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attJoiCountry);
            rdnTemp.addElement(rdn);
        }
        if (joiState != null) {
            AttributeTypeAndValue attJoiState = this.formAttribute("1.3.6.1.4.1.311.60.2.1.2", joiState);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attJoiState);
            rdnTemp.addElement(rdn);
        }
        if (joiLocality != null) {
            AttributeTypeAndValue attJoiLoc = this.formAttribute("1.3.6.1.4.1.311.60.2.1.1", joiLocality);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attJoiLoc);
            rdnTemp.addElement(rdn);
        }
        if (postalCode != null) {
            AttributeTypeAndValue attPostal = this.formAttribute("2.5.4.17", postalCode);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attPostal);
            rdnTemp.addElement(rdn);
        }
        if (streetAddress != null) {
            AttributeTypeAndValue attStreet = this.formAttribute("2.5.4.9", streetAddress);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attStreet);
            rdnTemp.addElement(rdn);
        }
        if (businessCategory != null) {
            AttributeTypeAndValue attBC = this.formAttribute("2.5.4.15", businessCategory);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attBC);
            rdnTemp.addElement(rdn);
        }
        if (serialNo != null) {
            AttributeTypeAndValue attSerial = this.formAttribute("2.5.4.5", serialNo);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attSerial);
            rdnTemp.addElement(rdn);
        }
        if (title != null) {
            AttributeTypeAndValue attTitle = this.formAttribute("2.5.4.12", title);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attTitle);
            rdnTemp.addElement(rdn);
        }
        if (e != null) {
            AttributeTypeAndValue attE = this.formAttribute("1.2.840.113549.1.9.1", e);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attE);
            rdnTemp.addElement(rdn);
        }
        if (c != null) {
            AttributeTypeAndValue attC = this.formAttribute("2.5.4.6", c);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attC);
            rdnTemp.addElement(rdn);
        }
        if (s != null) {
            AttributeTypeAndValue attS = this.formAttribute("2.5.4.8", s);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attS);
            rdnTemp.addElement(rdn);
        }
        if (l != null) {
            AttributeTypeAndValue attL = this.formAttribute("2.5.4.7", l);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attL);
            rdnTemp.addElement(rdn);
        }
        if (ou_2 != null) {
            AttributeTypeAndValue attOU2 = this.formAttribute("2.5.4.11", ou_2);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attOU2);
            rdnTemp.addElement(rdn);
        }
        if (ou_1 != null) {
            AttributeTypeAndValue attOU1 = this.formAttribute("2.5.4.11", ou_1);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attOU1);
            rdnTemp.addElement(rdn);
        }
        if (o != null) {
            AttributeTypeAndValue attO = this.formAttribute("2.5.4.10", o);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attO);
            rdnTemp.addElement(rdn);
        }
        if (cn != null) {
            AttributeTypeAndValue attCN = this.formAttribute("2.5.4.3", cn);
            rdn = new RelativeDistinguishedName("rdn");
            rdn.addElement(attCN);
            rdnTemp.addElement(rdn);
        }
        this.rdnSequence = rdnTemp;
        this.setValue(rdnTemp);
    }

    private AttributeTypeAndValue formAttribute(String oidStr, String val) {
        AttributeTypeAndValue att = new AttributeTypeAndValue("att");
        AttributeType atype = new AttributeType("atype");
        atype.setValue(oidStr);
        AttributeValue avalue = new AttributeValue("aval");
        if (oidStr.equals("2.5.4.6") || oidStr.equals("2.5.4.5")) {
            PrintableString asnStr = new PrintableString("asnStr");
            asnStr.setValue(val);
            avalue.setValue(asnStr);
        } else if (oidStr.equals("1.2.840.113549.1.9.1")) {
            IA5String asnStr = new IA5String("asnStr");
            asnStr.setValue(val);
            avalue.setValue(asnStr);
        } else {
            UTF8String asnStr = new UTF8String("asnStr");
            asnStr.setValue(val);
            avalue.setValue(asnStr);
        }
        att.settype(atype);
        att.setvalue(avalue);
        att.commitElementUpdate();
        return att;
    }

    private String getAttributeVal(String oidStr) {
        RDNSequence rdnseq = (RDNSequence)this.getValue();
        Vector rdnVec = (Vector)rdnseq.getValue();
        for (int i = 0; i < rdnVec.size(); ++i) {
            RelativeDistinguishedName rdn = (RelativeDistinguishedName)rdnVec.elementAt(i);
            Vector attVec = (Vector)rdn.getValue();
            AttributeTypeAndValue att = (AttributeTypeAndValue)attVec.elementAt(0);
            if (!((String)att.gettype().getValue()).equals(oidStr)) continue;
            byte[] attValBytes = (byte[])att.getvalue().getValue();
            if (attValBytes[0] == 12) {
                UTF8String utf8 = new UTF8String("attVal");
                try {
                    utf8.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                return (String)utf8.getValue();
            }
            if (attValBytes[0] == 30) {
                BMPString bmp = new BMPString("attVal");
                try {
                    bmp.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                return (String)bmp.getValue();
            }
            if (attValBytes[0] == 19) {
                PrintableString prn = new PrintableString("attVal");
                try {
                    prn.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                return (String)prn.getValue();
            }
            if (attValBytes[0] == 22) {
                IA5String ia5 = new IA5String("attVal");
                try {
                    ia5.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                return (String)ia5.getValue();
            }
            if (attValBytes[0] != 20) continue;
            TeletexString prn = new TeletexString("attVal");
            try {
                prn.decode(attValBytes);
            }
            catch (Exception exc) {
                return null;
            }
            return (String)prn.getValue();
        }
        return null;
    }

    private Vector getAttributeValues(String oidStr) {
        RDNSequence rdnseq = (RDNSequence)this.getValue();
        Vector rdnVec = (Vector)rdnseq.getValue();
        Vector<String> resultVec = new Vector<String>();
        for (int i = 0; i < rdnVec.size(); ++i) {
            BaseASN1Object prn;
            RelativeDistinguishedName rdn = (RelativeDistinguishedName)rdnVec.elementAt(i);
            Vector attVec = (Vector)rdn.getValue();
            AttributeTypeAndValue att = (AttributeTypeAndValue)attVec.elementAt(0);
            if (!((String)att.gettype().getValue()).equals(oidStr)) continue;
            byte[] attValBytes = (byte[])att.getvalue().getValue();
            if (attValBytes[0] == 12) {
                UTF8String utf8 = new UTF8String("attVal");
                try {
                    utf8.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                resultVec.addElement((String)utf8.getValue());
                continue;
            }
            if (attValBytes[0] == 30) {
                BMPString bmp = new BMPString("attVal");
                try {
                    bmp.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                resultVec.addElement((String)bmp.getValue());
                continue;
            }
            if (attValBytes[0] == 19) {
                prn = new PrintableString("attVal");
                try {
                    ((PrintableString)prn).decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                resultVec.addElement((String)((PrintableString)prn).getValue());
                continue;
            }
            if (attValBytes[0] == 22) {
                IA5String ia5 = new IA5String("attVal");
                try {
                    ia5.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                resultVec.addElement((String)ia5.getValue());
                continue;
            }
            if (attValBytes[0] != 20) continue;
            prn = new TeletexString("attVal");
            try {
                ((TeletexString)prn).decode(attValBytes);
            }
            catch (Exception exc) {
                return null;
            }
            resultVec.addElement((String)((TeletexString)prn).getValue());
        }
        return resultVec;
    }

    public String getCN() {
        return this.getAttributeVal("2.5.4.3");
    }

    public Vector getCNSet() {
        return this.getAttributeValues("2.5.4.3");
    }

    public String getC() {
        return this.getAttributeVal("2.5.4.6");
    }

    public Vector getCSet() {
        return this.getAttributeValues("2.5.4.6");
    }

    public String getS() {
        return this.getAttributeVal("2.5.4.8");
    }

    public Vector getSSet() {
        return this.getAttributeValues("2.5.4.8");
    }

    public String getL() {
        return this.getAttributeVal("2.5.4.7");
    }

    public Vector getLSet() {
        return this.getAttributeValues("2.5.4.7");
    }

    public String getO() {
        return this.getAttributeVal("2.5.4.10");
    }

    public Vector getOSet() {
        return this.getAttributeValues("2.5.4.10");
    }

    public String getOU() {
        return this.getAttributeVal("2.5.4.11");
    }

    public Vector getOUSet() {
        return this.getAttributeValues("2.5.4.11");
    }

    public String getE() {
        return this.getAttributeVal("1.2.840.113549.1.9.1");
    }

    public Vector getESet() {
        return this.getAttributeValues("1.2.840.113549.1.9.1");
    }

    public String getTitle() {
        return this.getAttributeVal("2.5.4.12");
    }

    public Vector getTitleSet() {
        return this.getAttributeValues("2.5.4.12");
    }

    public String getSerialNo() {
        return this.getAttributeVal("2.5.4.5");
    }

    public Vector getSerialNoSet() {
        return this.getAttributeValues("2.5.4.5");
    }

    public String getBusinessCategory() {
        return this.getAttributeVal("2.5.4.15");
    }

    public Vector getBusinessCategorySet() {
        return this.getAttributeValues("2.5.4.15");
    }

    public String getStreetAddress() {
        return this.getAttributeVal("2.5.4.9");
    }

    public Vector getStreetAddressSet() {
        return this.getAttributeValues("2.5.4.9");
    }

    public String getPostalCode() {
        return this.getAttributeVal("2.5.4.17");
    }

    public Vector getPostalCodeSet() {
        return this.getAttributeValues("2.5.4.17");
    }

    public String getJurisdictionOfIncLocality() {
        return this.getAttributeVal("1.3.6.1.4.1.311.60.2.1.1");
    }

    public Vector getJurisdictionOfIncLocalitySet() {
        return this.getAttributeValues("1.3.6.1.4.1.311.60.2.1.1");
    }

    public String getJurisdictionOfIncStateOrProvince() {
        return this.getAttributeVal("1.3.6.1.4.1.311.60.2.1.2");
    }

    public Vector getJurisdictionOfIncStateOrProvinceSet() {
        return this.getAttributeValues("1.3.6.1.4.1.311.60.2.1.2");
    }

    public String getJurisdictionOfIncCountry() {
        return this.getAttributeVal("1.3.6.1.4.1.311.60.2.1.3");
    }

    public Vector getJurisdictionOfIncCountrySet() {
        return this.getAttributeValues("1.3.6.1.4.1.311.60.2.1.3");
    }

    public int getNameCount() {
        return ((Vector)((RDNSequence)this.getValue()).getValue()).size();
    }

    public void changeInternalTag(int tagMethod, int tagNo) {
        this.rdnSequence.setTaggingMethod(tagMethod);
        this.rdnSequence.setTagClass((byte)-128);
        this.rdnSequence.setTagNumber(tagNo);
    }

    private boolean areVectorContentsEqual(Vector v1, Vector v2) {
        if (v1 == null && v2 != null) {
            return false;
        }
        if (v1 != null && v2 == null) {
            return false;
        }
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        Iterator iter = v1.iterator();
        while (iter.hasNext()) {
            if (v2.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualTo(Name other) {
        if (!this.areVectorContentsEqual(this.getCNSet(), other.getCNSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getCSet(), other.getCSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getSSet(), other.getSSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getLSet(), other.getLSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getOSet(), other.getOSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getOUSet(), other.getOUSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getESet(), other.getESet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getTitleSet(), other.getTitleSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getSerialNoSet(), other.getSerialNoSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getBusinessCategorySet(), other.getBusinessCategorySet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getStreetAddressSet(), other.getStreetAddressSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getPostalCodeSet(), other.getPostalCodeSet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getJurisdictionOfIncLocalitySet(), other.getJurisdictionOfIncLocalitySet())) {
            return false;
        }
        if (!this.areVectorContentsEqual(this.getJurisdictionOfIncStateOrProvinceSet(), other.getJurisdictionOfIncStateOrProvinceSet())) {
            return false;
        }
        return this.areVectorContentsEqual(this.getJurisdictionOfIncCountrySet(), other.getJurisdictionOfIncCountrySet());
    }

    public void setRDNSequence(RDNSequence inputRdnSeq) {
        try {
            this.rdnSequence.clearElements();
            Vector inputRdnVec = (Vector)inputRdnSeq.getValue();
            for (int i = 0; i < inputRdnVec.size(); ++i) {
                this.rdnSequence.addElement((RelativeDistinguishedName)inputRdnVec.elementAt(i));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public Name cloneName() {
        Name cloned = new Name("cloned_" + this.getName());
        cloned.setRDNSequence((RDNSequence)this.getValue());
        cloned.setValue((RDNSequence)this.getValue());
        return cloned;
    }

    public void setAttrValues(String attrLongName, Vector valvec) {
        block16: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            block17: {
                                                                block15: {
                                                                    if (!attrLongName.equals("CommonName")) break block15;
                                                                    Iterator iter = valvec.iterator();
                                                                    while (iter.hasNext()) {
                                                                        this.addCN((String)iter.next());
                                                                    }
                                                                    break block16;
                                                                }
                                                                if (!attrLongName.equals("Country")) break block17;
                                                                Iterator iter = valvec.iterator();
                                                                while (iter.hasNext()) {
                                                                    this.addC((String)iter.next());
                                                                }
                                                                break block16;
                                                            }
                                                            if (!attrLongName.equals("State")) break block18;
                                                            Iterator iter = valvec.iterator();
                                                            while (iter.hasNext()) {
                                                                this.addS((String)iter.next());
                                                            }
                                                            break block16;
                                                        }
                                                        if (!attrLongName.equals("Locality")) break block19;
                                                        Iterator iter = valvec.iterator();
                                                        while (iter.hasNext()) {
                                                            this.addL((String)iter.next());
                                                        }
                                                        break block16;
                                                    }
                                                    if (!attrLongName.equals("Organization")) break block20;
                                                    Iterator iter = valvec.iterator();
                                                    while (iter.hasNext()) {
                                                        this.addO((String)iter.next());
                                                    }
                                                    break block16;
                                                }
                                                if (!attrLongName.equals("OrganizationalUnit")) break block21;
                                                Iterator iter = valvec.iterator();
                                                while (iter.hasNext()) {
                                                    this.addOU((String)iter.next());
                                                }
                                                break block16;
                                            }
                                            if (!attrLongName.equals("SerialNo")) break block22;
                                            Iterator iter = valvec.iterator();
                                            while (iter.hasNext()) {
                                                this.addSerialNo((String)iter.next());
                                            }
                                            break block16;
                                        }
                                        if (!attrLongName.equals("Title")) break block23;
                                        Iterator iter = valvec.iterator();
                                        while (iter.hasNext()) {
                                            this.addTitle((String)iter.next());
                                        }
                                        break block16;
                                    }
                                    if (!attrLongName.equals("EmailAddress")) break block24;
                                    Iterator iter = valvec.iterator();
                                    while (iter.hasNext()) {
                                        this.addE((String)iter.next());
                                    }
                                    break block16;
                                }
                                if (!attrLongName.equals("BusinessCategory")) break block25;
                                Iterator iter = valvec.iterator();
                                while (iter.hasNext()) {
                                    this.addBusinessCategory((String)iter.next());
                                }
                                break block16;
                            }
                            if (!attrLongName.equals("StreetAddress")) break block26;
                            Iterator iter = valvec.iterator();
                            while (iter.hasNext()) {
                                this.addStreetAddress((String)iter.next());
                            }
                            break block16;
                        }
                        if (!attrLongName.equals("PostalCode")) break block27;
                        Iterator iter = valvec.iterator();
                        while (iter.hasNext()) {
                            this.addPostalCode((String)iter.next());
                        }
                        break block16;
                    }
                    if (!attrLongName.equals("JurisdictionOfIncLocality")) break block28;
                    Iterator iter = valvec.iterator();
                    while (iter.hasNext()) {
                        this.addJurisdictionOfIncLocality((String)iter.next());
                    }
                    break block16;
                }
                if (!attrLongName.equals("JurisdictionOfIncStateOrProvince")) break block29;
                Iterator iter = valvec.iterator();
                while (iter.hasNext()) {
                    this.addJurisdictionOfIncStateOrProvince((String)iter.next());
                }
                break block16;
            }
            if (!attrLongName.equals("JurisdictionOfIncCountry")) break block16;
            Iterator iter = valvec.iterator();
            while (iter.hasNext()) {
                this.addJurisdictionOfIncCountry((String)iter.next());
            }
        }
    }

    public String getStringRepresentation() {
        String res = "";
        Vector cnvec = this.getCNSet();
        for (int i = 0; i < cnvec.size(); ++i) {
            res = res + "CN=" + cnvec.elementAt(i) + ",";
        }
        Vector cvec = this.getCSet();
        for (int i = 0; i < cvec.size(); ++i) {
            res = res + "C=" + cvec.elementAt(i) + ",";
        }
        Vector svec = this.getSSet();
        for (int i = 0; i < svec.size(); ++i) {
            res = res + "S=" + svec.elementAt(i) + ",";
        }
        Vector lvec = this.getLSet();
        for (int i = 0; i < lvec.size(); ++i) {
            res = res + "L=" + lvec.elementAt(i) + ",";
        }
        Vector ovec = this.getOSet();
        for (int i = 0; i < ovec.size(); ++i) {
            res = res + "O=" + ovec.elementAt(i) + ",";
        }
        Vector ouvec = this.getOUSet();
        for (int i = 0; i < ouvec.size(); ++i) {
            res = res + "OU=" + ouvec.elementAt(i) + ",";
        }
        Vector serialvec = this.getSerialNoSet();
        for (int i = 0; i < serialvec.size(); ++i) {
            res = res + "SN=" + serialvec.elementAt(i) + ",";
        }
        Vector titlevec = this.getTitleSet();
        for (int i = 0; i < titlevec.size(); ++i) {
            res = res + "T=" + titlevec.elementAt(i) + ",";
        }
        Vector evec = this.getESet();
        for (int i = 0; i < evec.size(); ++i) {
            res = res + "E=" + evec.elementAt(i) + ",";
        }
        Vector bcvec = this.getBusinessCategorySet();
        for (int i = 0; i < bcvec.size(); ++i) {
            res = res + "BC=" + bcvec.elementAt(i) + ",";
        }
        Vector savec = this.getStreetAddressSet();
        for (int i = 0; i < savec.size(); ++i) {
            res = res + "SA=" + savec.elementAt(i) + ",";
        }
        Vector pcvec = this.getPostalCodeSet();
        for (int i = 0; i < pcvec.size(); ++i) {
            res = res + "PC=" + pcvec.elementAt(i) + ",";
        }
        Vector joilvec = this.getJurisdictionOfIncLocalitySet();
        for (int i = 0; i < joilvec.size(); ++i) {
            res = res + "JOIL=" + joilvec.elementAt(i) + ",";
        }
        Vector joisvec = this.getJurisdictionOfIncStateOrProvinceSet();
        for (int i = 0; i < joisvec.size(); ++i) {
            res = res + "JOIS=" + joisvec.elementAt(i) + ",";
        }
        Vector joicvec = this.getJurisdictionOfIncCountrySet();
        for (int i = 0; i < joicvec.size(); ++i) {
            res = res + "JOIC=" + joicvec.elementAt(i) + ",";
        }
        return res.substring(0, res.length() - 1);
    }

    public String getLDAPStringRepresentation() {
        Vector rdnVec = (Vector)this.rdnSequence.getValue();
        String res = "";
        for (int i = rdnVec.size() - 1; i >= 0; --i) {
            BaseASN1Object prn;
            RelativeDistinguishedName rdn = (RelativeDistinguishedName)rdnVec.elementAt(i);
            Vector attVec = (Vector)rdn.getValue();
            AttributeTypeAndValue att = (AttributeTypeAndValue)attVec.elementAt(0);
            res = res + this.getStringHeaderForAttribute(att);
            byte[] attValBytes = (byte[])att.getvalue().getValue();
            if (attValBytes[0] == 12) {
                UTF8String utf8 = new UTF8String("attVal");
                try {
                    utf8.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                res = res + (String)utf8.getValue();
            } else if (attValBytes[0] == 30) {
                BMPString bmp = new BMPString("attVal");
                try {
                    bmp.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                res = res + (String)bmp.getValue();
            } else if (attValBytes[0] == 19) {
                prn = new PrintableString("attVal");
                try {
                    ((PrintableString)prn).decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                res = res + (String)((PrintableString)prn).getValue();
            } else if (attValBytes[0] == 22) {
                IA5String ia5 = new IA5String("attVal");
                try {
                    ia5.decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                res = res + (String)ia5.getValue();
            } else if (attValBytes[0] == 20) {
                prn = new TeletexString("attVal");
                try {
                    ((TeletexString)prn).decode(attValBytes);
                }
                catch (Exception exc) {
                    return null;
                }
                res = res + (String)((TeletexString)prn).getValue();
            }
            if (i <= 0) continue;
            res = res + ",";
        }
        return res;
    }

    public String getStringHeaderForAttribute(AttributeTypeAndValue att) {
        if (((String)att.gettype().getValue()).equals(this.OID_COMMON_NAME)) {
            return "CN=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_COUNTRY)) {
            return "C=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_STATE)) {
            return "ST=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_LOCALITY)) {
            return "L=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_ORGANIZATION)) {
            return "O=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_ORGANIZATIONAL_UNIT)) {
            return "OU=";
        }
        if (((String)att.gettype().getValue()).equals(this.OID_STREET_ADDRESS)) {
            return "STREET=";
        }
        return (String)att.gettype().getValue() + "=";
    }
}

