/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;

public class NetscapeCertType
extends Extension {
    public static final String EXT_OBJ_ID = "2.16.840.1.113730.1.1";
    private String certTypeBitString;

    public NetscapeCertType(String name, boolean critical, String certTypeBitsStr) {
        super(name);
        this.certTypeBitString = certTypeBitsStr;
        System.out.println("In cons. = " + certTypeBitsStr);
        if (this.certTypeBitString.length() < 8) {
            int padZeros = 8 - this.certTypeBitString.length();
            for (int i = 0; i < padZeros; ++i) {
                this.certTypeBitString = this.certTypeBitString + "0";
            }
        }
        BitString usageBits = new BitString("certType");
        byte[] bitsVal = new byte[1];
        int first8Int = Integer.parseInt(this.certTypeBitString, 2);
        if (first8Int > 127) {
            first8Int -= 256;
        }
        bitsVal[0] = (byte)first8Int;
        usageBits.setValue(bitsVal);
        usageBits.setNumberOfUnusedBits(8 - certTypeBitsStr.length());
        ObjectID nsCertTypeObjId = new ObjectID("netscapeCertType");
        nsCertTypeObjId.setValue(EXT_OBJ_ID);
        this.setextnID(nsCertTypeObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        byte[] octBytes = usageBits.getEncoded();
        OctetString extOcts = new OctetString("extNSCertType");
        extOcts.setValue(octBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public NetscapeCertType() {
        super("defaultNSCertType");
        this.certTypeBitString = null;
        ObjectID nsCertTypeObjId = new ObjectID("netscapeCertType");
        nsCertTypeObjId.setValue(EXT_OBJ_ID);
        this.setextnID(nsCertTypeObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        BitString usageBits = new BitString("certType");
        try {
            usageBits.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        char[] kuChars = new char[8];
        byte[] usageBytes = (byte[])usageBits.getValue();
        int b1 = usageBytes[0];
        if (b1 < 0) {
            b1 += 256;
        }
        String b1Str = Integer.toString(b1, 2);
        while (b1Str.length() < 8) {
            b1Str = "0" + b1Str;
        }
        this.certTypeBitString = b1Str;
        OctetString extOcts = new OctetString("extNSCertType", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Netscape Cert Type";
    }

    public String getTurkishExtensionTitle() {
        return "Netscape Sertifika Tipi";
    }

    public String getExplanation() {
        String exp = "";
        System.out.println("In getExplanation of NSCertType");
        System.out.println(this.certTypeBitString);
        if (this.certTypeBitString.charAt(0) == '1') {
            exp = exp + "SSL Client";
        }
        if (this.certTypeBitString.charAt(1) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "SSL Server";
        }
        if (this.certTypeBitString.charAt(2) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "S/MIME";
        }
        if (this.certTypeBitString.charAt(3) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Object Signing";
        }
        if (this.certTypeBitString.charAt(4) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Reserved";
        }
        if (this.certTypeBitString.charAt(5) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "SSL CA";
        }
        if (this.certTypeBitString.charAt(6) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "S/MIME CA";
        }
        if (this.certTypeBitString.charAt(7) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Object Signing CA";
        }
        System.out.println("Exp = " + exp);
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        if (this.certTypeBitString.charAt(0) == '1') {
            exp = exp + "SSL \u0130stemci";
        }
        if (this.certTypeBitString.charAt(1) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "SSL Sunucu";
        }
        if (this.certTypeBitString.charAt(2) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "S/MIME";
        }
        if (this.certTypeBitString.charAt(3) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Nesne \u0130mzalama";
        }
        if (this.certTypeBitString.charAt(4) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Rezerve";
        }
        if (this.certTypeBitString.charAt(5) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "SSL ESHS";
        }
        if (this.certTypeBitString.charAt(6) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "S/MIME ESHS";
        }
        if (this.certTypeBitString.charAt(7) == '1') {
            if (exp.length() > 0) {
                exp = exp + ", ";
            }
            exp = exp + "Nesne \u0130mzalama ESHS";
        }
        return exp;
    }
}

