/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.UTF8String;
import com.turktrust.x509.MonetaryValue;
import com.turktrust.x509.QCSemantics;
import java.math.BigInteger;

public class QCStatement
extends Sequence {
    private ObjectID statementId = new ObjectID("statementId");
    private Any statementInfo = new Any("statementInfo");

    public QCStatement() {
        super("default_qc_statement");
        this.setUpElements();
    }

    public QCStatement(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.statementId);
        super.addElement(this.statementInfo);
        this.statementInfo.setOptional(true);
    }

    public ObjectID getStatementId() {
        return this.statementId;
    }

    public void setStatementId(ObjectID given_statementId) {
        this.statementId = given_statementId;
    }

    public Any getStatementInfo() {
        return this.statementInfo;
    }

    public void setStatementInfo(Any given_statementInfo) {
        this.statementInfo = given_statementInfo;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] data) throws DecodeException {
        super.decode(data);
        this.setStatementId((ObjectID)super.getElement(0));
        this.setStatementInfo((Any)super.getElement(1));
        this.commitElementUpdate();
    }

    public String getExplanation() throws DecodeException {
        String exp = "";
        String oidStr = (String)this.statementId.getValue();
        if (oidStr.equals("0.4.0.1862.1.1")) {
            exp = "Nitelikli Sertifika (ISO ETSI 1862)";
            if (this.statementInfo.getGivenObject() != null) {
                ObjectID semOID = (ObjectID)this.statementInfo.getGivenObject();
                exp = exp + "\n Semantik OID: " + (String)semOID.getValue();
            }
        } else if (oidStr.equals("1.3.6.1.5.5.7.11.1")) {
            exp = "Nitelikli Sertifika (PKIX QCSyntax-v1)";
            if (this.statementInfo.getGivenObject() != null) {
                QCSemantics qcsem = (QCSemantics)this.statementInfo.getGivenObject();
                ObjectID semOID = qcsem.getSemanticOID();
                exp = exp + "\n Semantik OID: " + (String)semOID.getValue();
            }
        } else if (oidStr.equals("0.4.0.1862.1.2")) {
            MonetaryValue mval = new MonetaryValue();
            this.statementInfo.decodeInto(mval);
            exp = mval.getExplanation();
        } else if (oidStr.equals("0.4.0.1862.1.3")) {
            ASN1Integer retPerAsn = new ASN1Integer();
            this.statementInfo.decodeInto(retPerAsn);
            exp = "Bilgi Saklama S\u00fcresi = " + ((BigInteger)retPerAsn.getValue()).toString() + " y\u0131l";
        } else {
            exp = oidStr.equals("0.4.0.1862.1.4") ? "\"Secure Signature Creation Device\" kullan\u0131lmaktad\u0131r" : (oidStr.equals("2.16.792.1.61.0.1.5070.1.1") ? "Nitelikli Sertifika (5070 say\u0131l\u0131 kanun)" : oidStr);
        }
        return exp;
    }

    public String getTurkishExplanation() throws DecodeException {
        String exp = "";
        String oidStr = (String)this.statementId.getValue();
        if (oidStr.equals("0.4.0.1862.1.1")) {
            exp = "Nitelikli Sertifika (ISO ETSI 1862)";
            if (this.statementInfo.getGivenObject() != null) {
                ObjectID semOID = (ObjectID)this.statementInfo.getGivenObject();
                exp = exp + "\n Semantik OID: " + (String)semOID.getValue();
            }
        } else if (oidStr.equals("1.3.6.1.5.5.7.11.1")) {
            exp = "Nitelikli Sertifika (PKIX QCSyntax-v1)";
            if (this.statementInfo.getGivenObject() != null) {
                QCSemantics qcsem = (QCSemantics)this.statementInfo.getGivenObject();
                ObjectID semOID = qcsem.getSemanticOID();
                exp = exp + "\n Semantik OID: " + (String)semOID.getValue();
            }
        } else if (oidStr.equals("0.4.0.1862.1.2")) {
            MonetaryValue mval = new MonetaryValue();
            this.statementInfo.decodeInto(mval);
            exp = mval.getTurkishExplanation();
        } else if (oidStr.equals("0.4.0.1862.1.3")) {
            ASN1Integer retPerAsn = new ASN1Integer();
            this.statementInfo.decodeInto(retPerAsn);
            exp = "Bilgi Saklama S\u00fcresi = " + ((BigInteger)retPerAsn.getValue()).toString() + " y\u0131l";
        } else if (oidStr.equals("0.4.0.1862.1.4")) {
            exp = "\"G\u00fcvenli Elektronik \u0130mza Olu\u015fturma Arac\u0131\" kullan\u0131lmaktad\u0131r";
        } else if (oidStr.equals("2.16.792.1.61.0.1.5070.1.1")) {
            exp = "Nitelikli Sertifika (5070 say\u0131l\u0131 kanun)";
            if (this.statementInfo.getValue() != null) {
                UTF8String valUtf8 = new UTF8String("valUtf8");
                this.statementInfo.decodeInto(valUtf8);
                exp = exp + "\n" + (String)valUtf8.getValue();
            }
        } else {
            exp = oidStr;
        }
        return exp;
    }
}

