/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;
import com.turktrust.x509.SMIMECapabilities;
import com.turktrust.x509.SMIMECapability;
import java.util.Vector;

public class SMIMECapabilitiesExtension
extends Extension {
    public static final String EXT_OBJ_ID = "1.2.840.113549.1.9.15";
    private SMIMECapabilities smimeCaps;

    public SMIMECapabilitiesExtension(String name, boolean critical, SMIMECapabilities caps) {
        super(name);
        this.smimeCaps = caps;
        ObjectID smimeCapsObjId = new ObjectID("smimeCapsObjId");
        smimeCapsObjId.setValue(EXT_OBJ_ID);
        this.setextnID(smimeCapsObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        OctetString extOcts = new OctetString("extSmimeCaps");
        extOcts.setValue(this.smimeCaps.getEncoded());
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public SMIMECapabilitiesExtension() {
        super("defalut_SMIMECapabilitiesExtension");
        ObjectID smimeCapsObjId = new ObjectID("smimeCapsObjId");
        smimeCapsObjId.setValue(EXT_OBJ_ID);
        this.setextnID(smimeCapsObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        this.smimeCaps = new SMIMECapabilities("smimeCaps");
        try {
            this.smimeCaps.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        OctetString extOcts = new OctetString("extSmimeCaps", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public SMIMECapabilities getSMIMECapabilities() {
        return this.smimeCaps;
    }

    public String getExtensionTitle() {
        return "SMIME Capabilities";
    }

    public String getTurkishExtensionTitle() {
        return "SMIME Yetenekleri";
    }

    public String getExplanation() throws DecodeException {
        String exp = "";
        Vector capsVec = (Vector)this.smimeCaps.getValue();
        for (int i = 0; i < capsVec.size(); ++i) {
            SMIMECapability scap = (SMIMECapability)capsVec.elementAt(i);
            if (scap.getCapabilityID().getValue().equals("1.2.840.113549.3.2")) {
                exp = exp + "RC2-CBC" + "\n";
                continue;
            }
            if (scap.getCapabilityID().getValue().equals("1.2.840.113549.3.4")) {
                exp = exp + "RC4" + "\n";
                continue;
            }
            if (scap.getCapabilityID().getValue().equals("1.3.14.3.2.7")) {
                exp = exp + "DES-CBC" + "\n";
                continue;
            }
            if (!scap.getCapabilityID().getValue().equals("1.2.840.113549.3.7")) continue;
            exp = exp + "DES-EDE3-CBC" + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() throws DecodeException {
        String exp = "";
        Vector capsVec = (Vector)this.smimeCaps.getValue();
        for (int i = 0; i < capsVec.size(); ++i) {
            SMIMECapability scap = (SMIMECapability)capsVec.elementAt(i);
            if (scap.getCapabilityID().getValue().equals("1.2.840.113549.3.2")) {
                exp = exp + "RC2-CBC" + "\n";
                continue;
            }
            if (scap.getCapabilityID().getValue().equals("1.2.840.113549.3.4")) {
                exp = exp + "RC4" + "\n";
                continue;
            }
            if (scap.getCapabilityID().getValue().equals("1.3.14.3.2.7")) {
                exp = exp + "DES-CBC" + "\n";
                continue;
            }
            if (!scap.getCapabilityID().getValue().equals("1.2.840.113549.3.7")) continue;
            exp = exp + "DES-EDE3-CBC" + "\n";
        }
        return exp;
    }
}

