/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;
import java.math.BigInteger;

public class SubjectKeyId
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.14";
    private byte[] subjectKeyIdBytes;

    public SubjectKeyId(String name, boolean critical, byte[] keyIdBytes) {
        super(name);
        this.subjectKeyIdBytes = keyIdBytes;
        ObjectID subjectObjId = new ObjectID("subjectKeyId");
        subjectObjId.setValue(EXT_OBJ_ID);
        this.setextnID(subjectObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        OctetString octs = new OctetString("subjectKeyIdVal");
        octs.setValue(keyIdBytes);
        byte[] octBytes = octs.getEncoded();
        OctetString extOcts = new OctetString("extSubKeyId");
        extOcts.setValue(octBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public SubjectKeyId() {
        super("defaultSKI");
        this.subjectKeyIdBytes = null;
        ObjectID subjectObjId = new ObjectID("subjectKeyId");
        subjectObjId.setValue(EXT_OBJ_ID);
        this.setextnID(subjectObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        OctetString octs = new OctetString("subjectKeyIdVal");
        try {
            octs.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.subjectKeyIdBytes = (byte[])octs.getValue();
        OctetString extOcts = new OctetString("extSubKeyId", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Subject Key Id";
    }

    public String getTurkishExtensionTitle() {
        return "Sertifika Sahibi Anahtar Tan\u0131mlay\u0131c\u0131";
    }

    public String getExplanation() {
        BigInteger big = new BigInteger(1, this.subjectKeyIdBytes);
        String bigStr = big.toString(16);
        if (bigStr.length() % 2 != 0) {
            bigStr = "0" + bigStr;
        }
        String exp = "";
        for (int i = 0; i < bigStr.length() / 2; ++i) {
            exp = exp + bigStr.substring(i * 2, i * 2 + 2) + " ";
        }
        if (exp.equals("00 ")) {
            exp = "Hen\u00fcz anahtar olu\u015fturulmad\u0131\u011f\u0131 i\u00e7in de\u011fer g\u00f6sterilemiyor";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        return this.getExplanation();
    }
}

