/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.Sequence;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.CertificateSerialNumber;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.Name;
import com.turktrust.x509.SubjectPublicKeyInfo;
import com.turktrust.x509.UniqueIdentifier;
import com.turktrust.x509.Validity;
import com.turktrust.x509.Version;

public class TBSCertificate
extends Sequence {
    private Version version = new Version("version");
    private CertificateSerialNumber serialNumber = new CertificateSerialNumber("serialNumber");
    private AlgorithmIdentifier signature = new AlgorithmIdentifier("signature");
    private Name issuer = new Name("issuer");
    private Validity validity = new Validity("validity");
    private Name subject = new Name("subject");
    private SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo("subjectPublicKeyInfo");
    private UniqueIdentifier issuerUniqueID = new UniqueIdentifier("issuerUniqueID");
    private UniqueIdentifier subjectUniqueID = new UniqueIdentifier("subjectUniqueID");
    private Extensions extensions = new Extensions("extensions");

    public TBSCertificate(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        this.version.setTaggingMethod(2);
        this.version.setTagClass((byte)-128);
        this.version.setTagNumber(0);
        this.version.setDefaultValue("1");
        this.version.setOptional(true);
        super.addElement(this.serialNumber);
        super.addElement(this.signature);
        super.addElement(this.issuer);
        super.addElement(this.validity);
        super.addElement(this.subject);
        super.addElement(this.subjectPublicKeyInfo);
        super.addElement(this.issuerUniqueID);
        this.issuerUniqueID.setOptional(true);
        this.issuerUniqueID.setTaggingMethod(1);
        this.issuerUniqueID.setTagClass((byte)-128);
        this.issuerUniqueID.setTagNumber(1);
        super.addElement(this.subjectUniqueID);
        this.subjectUniqueID.setOptional(true);
        this.subjectUniqueID.setTaggingMethod(1);
        this.subjectUniqueID.setTagClass((byte)-128);
        this.subjectUniqueID.setTagNumber(2);
        super.addElement(this.extensions);
        this.extensions.setOptional(true);
        this.extensions.setTaggingMethod(2);
        this.extensions.setTagClass((byte)-128);
        this.extensions.setTagNumber(3);
    }

    public Version getversion() {
        return this.version;
    }

    public void setversion(Version value) {
        this.version = value;
    }

    public CertificateSerialNumber getserialNumber() {
        return this.serialNumber;
    }

    public void setserialNumber(CertificateSerialNumber value) {
        this.serialNumber = value;
    }

    public AlgorithmIdentifier getsignature() {
        return this.signature;
    }

    public void setsignature(AlgorithmIdentifier value) {
        this.signature = value;
    }

    public Name getissuer() {
        return this.issuer;
    }

    public void setissuer(Name value) {
        this.issuer = value;
    }

    public Validity getvalidity() {
        return this.validity;
    }

    public void setvalidity(Validity value) {
        this.validity = value;
    }

    public Name getsubject() {
        return this.subject;
    }

    public void setsubject(Name value) {
        this.subject = value;
    }

    public SubjectPublicKeyInfo getsubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setsubjectPublicKeyInfo(SubjectPublicKeyInfo value) {
        this.subjectPublicKeyInfo = value;
    }

    public UniqueIdentifier getissuerUniqueID() {
        return this.issuerUniqueID;
    }

    public void setissuerUniqueID(UniqueIdentifier value) {
        this.issuerUniqueID = value;
    }

    public UniqueIdentifier getsubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public void setsubjectUniqueID(UniqueIdentifier value) {
        this.subjectUniqueID = value;
    }

    public Extensions getextensions() {
        return this.extensions;
    }

    public void setextensions(Extensions value) {
        this.extensions = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

