/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1InvalidArgException;
import com.objsys.asn1j.runtime.Asn1PerEncodeTraceHandler;
import com.objsys.asn1j.runtime.Asn1PerEncoder;
import com.objsys.asn1j.runtime.Asn1PerMessageBuffer;
import com.objsys.asn1j.runtime.Asn1PerTraceHandler;
import com.objsys.asn1j.runtime.Asn1PerUtil;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Asn1PerEncodeBuffer
extends Asn1EncodeBuffer
implements Asn1PerMessageBuffer,
Asn1PerEncoder {
    private int a = -1;
    private boolean b;
    private static final byte[] c = new byte[]{0};
    protected Asn1PerTraceHandler mTraceHandler = new Asn1PerEncodeTraceHandler(this);
    private static h d = h.a();

    public Asn1PerEncodeBuffer(boolean bl) {
        this.mByteIndex = -1;
        this.b = bl;
    }

    public Asn1PerEncodeBuffer(boolean bl, int n2) {
        super(n2);
        this.mByteIndex = -1;
        this.b = bl;
    }

    public void binDump(PrintStream printStream, String string) {
        this.mTraceHandler.print(printStream, string);
    }

    public void byteAlign() {
        if (this.b) {
            this.a = -1;
        }
    }

    protected void checkSize(int n2) {
        int n3 = n2 + this.mByteIndex + 1;
        if (n3 > this.mData.length) {
            int n4 = this.mData.length * 2;
            if (n4 < n3) {
                n4 = n3;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.mData, 0, byArray, 0, this.mByteIndex + 1);
            this.mData = byArray;
        }
    }

    public void copy(byte by) {
        try {
            this.encodeBits(by, 8);
        }
        catch (Asn1InvalidArgException asn1InvalidArgException) {
            // empty catch block
        }
    }

    public void copy(byte[] byArray) throws Asn1Exception {
        this.encodeBits(byArray, 0, byArray.length * 8);
    }

    public void encodeBit(boolean bl, String string) {
        if (string != null) {
            this.mTraceHandler.newBitField(string, 1);
        }
        if (this.a < 0) {
            this.checkSize(1);
            this.mData[++this.mByteIndex] = 0;
            this.a = 7;
        }
        if (bl) {
            int n2 = this.mByteIndex;
            this.mData[n2] = (byte)(this.mData[n2] | 1 << this.a);
        }
        --this.a;
    }

    public void encodeBit(boolean bl) {
        this.encodeBit(bl, "value");
    }

    public void encodeBits(byte by, int n2) throws Asn1InvalidArgException {
        if (n2 > 0) {
            int n3 = -1;
            if (n2 > 8) {
                throw new Asn1InvalidArgException("nbits", Integer.toString(n2));
            }
            n3 = (byte)(n3 << 8 - n2);
            by = (byte)(by & n3);
            if (this.a < 0) {
                this.checkSize(1);
                this.mData[++this.mByteIndex] = by;
                this.a = 7 - n2;
                int n4 = this.mByteIndex;
            } else {
                int n5 = this.a + 1;
                int n6 = 7 - this.a;
                int n7 = this.mByteIndex;
                int n8 = this.mByteIndex++;
                this.mData[n8] = (byte)(this.mData[n8] | (byte)((by & 0xFF) >> n6));
                this.a -= n2;
                if (this.a < -1) {
                    this.checkSize(1);
                    this.mData[this.mByteIndex] = (byte)(by << n5);
                    this.a += 8;
                }
            }
        }
    }

    public void encodeBits(byte[] byArray, int n2, int n3, String string) throws Asn1InvalidArgException {
        this.encodeBits(byArray, n2, 0, n3, string);
    }

    public void encodeBits(byte[] byArray, int n2, int n3, int n4, String string) throws Asn1InvalidArgException {
        if (string != null) {
            this.mTraceHandler.newBitField(string, n4);
        }
        if (n4 > 0) {
            byte by;
            int n5;
            if (n3 > 0) {
                if (n3 > 7) {
                    throw new Asn1InvalidArgException("bitOffset", Integer.toString(n3));
                }
                n5 = 8 - n3;
                if (n5 > n4) {
                    n5 = n4;
                }
                by = byArray[n2];
                by = (byte)(by << n3);
                this.encodeBits(by, n5);
                ++n2;
                if ((n4 -= n5) == 0) {
                    return;
                }
            }
            n5 = 0;
            by = n4 % 8;
            int n6 = n4 / 8;
            if (n6 > 0) {
                if (this.a < 0) {
                    this.checkSize(n6);
                    ++this.mByteIndex;
                    System.arraycopy(byArray, n2, this.mData, this.mByteIndex, n6);
                    this.mByteIndex += n6 - 1;
                    n5 = n6;
                } else {
                    for (n5 = 0; n5 < n6; ++n5) {
                        this.encodeBits(byArray[n5 + n2], 8);
                    }
                }
            }
            if (by != 0) {
                this.encodeBits(byArray[n5 + n2], by);
            }
        }
    }

    public void encodeBits(byte[] byArray, int n2, int n3) throws Asn1InvalidArgException {
        this.encodeBits(byArray, n2, n3, "value");
    }

    public void encodeCharString(String string, int n2, int n3, int n4, int n5, Asn1CharSet asn1CharSet) throws Asn1Exception {
        block8: {
            int n6;
            char c2;
            int n7;
            boolean bl;
            block7: {
                bl = Asn1Exception.z;
                if (asn1CharSet == null) break block7;
                boolean bl2 = false;
                n7 = asn1CharSet.getNumBitsPerChar(this.isAligned());
                if (n7 < 31 && (1 << n7) - 1 < asn1CharSet.getMaxValue()) {
                    bl2 = true;
                }
                this.mTraceHandler.newBitField("value", n2 * n7);
                for (int i2 = 0; i2 < n2; ++i2) {
                    c2 = string.charAt(n3 + i2);
                    if (!bl2) {
                        this.encodeInt((long)c2, n7, null);
                        if (!bl) continue;
                    }
                    n6 = asn1CharSet.getCharIndex(c2);
                    this.encodeInt((long)n6, n7, null);
                    if (!bl) continue;
                }
                if (!bl) break block8;
            }
            n7 = this.isAligned() ? n4 : n5;
            this.mTraceHandler.newBitField("value", n2 * n7);
            for (n6 = 0; n6 < n2; ++n6) {
                c2 = string.charAt(n3 + n6);
                this.encodeInt((long)c2, n7, null);
                if (!bl) continue;
            }
        }
        d.lcheck(2);
    }

    public void encodeConsWholeNumber(long l2, long l3, String string) throws Asn1InvalidArgException {
        block6: {
            block10: {
                int n2;
                boolean bl;
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                bl = Asn1Exception.z;
                                n2 = Asn1Integer.getUnsignedBitCount(l3 - 1L);
                                if (l2 - Long.MIN_VALUE >= l3 - Long.MIN_VALUE && l3 != 0L) {
                                    throw new Asn1InvalidArgException("adjustedValue", Long.toString(l2));
                                }
                                d.lcheck(2);
                                if (this.b) break block5;
                                this.encodeInt(l2, n2, string);
                                if (!bl) break block6;
                            }
                            if (l3 <= 0L) {
                                l3 = 65537L;
                            }
                            if (l3 > 255L) break block7;
                            this.encodeInt(l2, n2, string);
                            if (!bl) break block6;
                        }
                        if (l3 != 256L) break block8;
                        this.byteAlign();
                        this.encodeInt(l2, 8, string);
                        if (!bl) break block6;
                    }
                    if (l3 > 65536L) break block9;
                    this.byteAlign();
                    this.encodeInt(l2, 16, string);
                    if (!bl) break block6;
                }
                int n3 = l2 == 0L ? 0 : (Asn1Integer.getUnsignedBitCount(l2) + 7) / 8 - 1;
                int n4 = Asn1Integer.getBitCount((n2 + 7) / 8 - 1);
                this.encodeInt((long)n3, n4, "length");
                this.byteAlign();
                if (l2 != 0L) break block10;
                this.encodeInt(0L, 8, "value");
                if (!bl) break block6;
            }
            this.encodeInt(l2, false, false);
        }
    }

    public void encodeConsWholeNumber(long l2, long l3) throws Asn1InvalidArgException {
        this.encodeConsWholeNumber(l2, l3, "value");
    }

    public void encodeInt(long l2, int n2, String string) throws Asn1InvalidArgException {
        boolean bl = Asn1Exception.z;
        if (string != null) {
            this.mTraceHandler.newBitField(string, n2);
        }
        if (n2 > 0) {
            l2 <<= 64 - n2;
            while (n2 > 0) {
                long l3 = l2 >>> 56;
                this.encodeBits((byte)l3, n2 > 8 ? 8 : n2);
                l2 <<= 8;
                n2 -= 8;
                if (!bl) continue;
            }
        }
    }

    public void encodeInt(long l2, int n2) throws Asn1InvalidArgException {
        this.encodeInt(l2, n2, "value");
    }

    public void encodeInt(long l2, boolean bl, boolean bl2, String string) throws Asn1InvalidArgException {
        int n2;
        block7: {
            block8: {
                boolean bl3;
                block6: {
                    bl3 = Asn1Exception.z;
                    if (!bl2) break block6;
                    n2 = Asn1Integer.getBitCount(l2);
                    if (!bl3) break block7;
                }
                if ((n2 = Asn1Integer.getBitCount(l2 >>> 1)) != 0) break block8;
                n2 = (int)l2 & 1;
                if (!bl3) break block7;
            }
            ++n2;
        }
        n2 = n2 + 7 & 0xFFFFFFF8;
        d.lcheck(2);
        if (bl2) {
            long l3 = 1L << n2 - 1;
            if (l2 < 0L && (l2 & l3) == 0L || l2 > 0L && (l2 & l3) != 0L) {
                n2 += 8;
            }
        }
        if (bl) {
            int n3 = n2 / 8;
            this.encodeLength(n3);
            this.byteAlign();
        }
        this.encodeInt(l2, n2, string);
    }

    public void encodeInt(long l2, boolean bl, boolean bl2) throws Asn1InvalidArgException {
        this.encodeInt(l2, bl, bl2, "value");
    }

    public long encodeLength(long l2) throws Asn1InvalidArgException {
        long l3;
        block5: {
            long l4;
            block6: {
                boolean bl;
                block4: {
                    bl = Asn1Exception.z;
                    l3 = l2;
                    this.byteAlign();
                    if (l2 >= 128L) break block4;
                    this.encodeInt(l2, 8, "length");
                    if (!bl) break block5;
                }
                if (l2 >= 16384L) break block6;
                this.encodeBit(true, "extlen");
                this.encodeInt(l2, 15, "length");
                if (!bl) break block5;
            }
            if ((l4 = l2 / 16384L) > 4L) {
                l4 = 4L;
            }
            this.encodeBit(true, "extlen");
            this.encodeBit(true, "extlen");
            this.encodeInt(l4, 6, "len*16k");
            l3 = 16384L * l4;
        }
        d.lcheck(2);
        return l3;
    }

    public void encodeLength(long l2, long l3, long l4) throws Asn1Exception {
        block4: {
            block2: {
                block5: {
                    boolean bl;
                    block3: {
                        bl = Asn1Exception.z;
                        if (l2 < l3 || l2 > l4) break block2;
                        if (l4 >= 65536L) break block3;
                        if (l3 == l4) break block4;
                        this.encodeConsWholeNumber(l2 - l3, l4 - l3 + 1L, "length");
                        if (!bl) break block4;
                    }
                    if (l2 >= 16384L) break block5;
                    this.encodeLength(l2);
                    if (!bl) break block4;
                }
                throw new Asn1ConsVioException("length", l2);
            }
            throw new Asn1ConsVioException("length", l2);
        }
    }

    public void encodeLengthEOM(long l2) {
        if (l2 >= 16384L && l2 % 16384L == 0L) {
            try {
                this.encodeLength(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void encodeOIDLengthAndValue(int[] nArray) throws Asn1Exception {
        int n2;
        boolean bl = Asn1Exception.z;
        int n3 = 1;
        for (n2 = 2; n2 < nArray.length; ++n2) {
            n3 += h.d(nArray[n2]);
            if (!bl) continue;
        }
        this.encodeLength(n3);
        this.mTraceHandler.newBitField("value", n3 * 8);
        this.checkSize(n3);
        long l2 = nArray[0] * 40 + nArray[1];
        this.a(l2);
        for (n2 = 2; n2 < nArray.length; ++n2) {
            this.a(nArray[n2]);
            if (!bl) continue;
        }
    }

    public void encodeRelOIDLengthAndValue(int[] nArray) throws Asn1Exception {
        int n2;
        boolean bl = Asn1Exception.z;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += h.d(nArray[n2]);
            if (!bl) continue;
        }
        this.encodeLength(n3);
        this.mTraceHandler.newBitField("value", n3 * 8);
        this.checkSize(n3);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.a(nArray[n2]);
            if (!bl) continue;
        }
    }

    public void encodeOctetString(byte[] byArray, int n2, int n3) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        int n4 = n3;
        int n5 = n2;
        do {
            int n6;
            if ((n6 = (int)this.encodeLength(n4)) > 0) {
                this.byteAlign();
                this.encodeBits(byArray, n5, n6 * 8);
            }
            if ((n4 -= n6) <= 0) break;
            n5 += n6;
        } while (!bl);
        d.lcheck(2);
        this.encodeLengthEOM(n4);
    }

    public void encodeOpenType(byte[] byArray, int n2, int n3) throws Asn1Exception {
        block3: {
            block2: {
                if (n3 != 0) break block2;
                this.encodeOctetString(c, 0, 1);
                if (!Asn1Exception.z) break block3;
            }
            this.encodeOctetString(byArray, n2, n3);
        }
    }

    public void encodeOpenType(Asn1PerEncodeBuffer asn1PerEncodeBuffer, String string) throws Asn1Exception {
        if (string != null) {
            this.mTraceHandler.addElemName(string, -1);
        }
        this.byteAlign();
        this.encodeOpenType(asn1PerEncodeBuffer.getBuffer(), 0, asn1PerEncodeBuffer.getMsgByteCnt());
        if (string != null) {
            this.mTraceHandler.removeLastElemName();
        }
    }

    public void encodeSmallLength(int n2) throws Asn1InvalidArgException {
        block3: {
            block2: {
                if (n2 >= 64) break block2;
                this.encodeBit(false, "<= 64");
                this.encodeInt(n2 - 1, 6);
                if (!Asn1Exception.z) break block3;
            }
            this.encodeBit(true, "> 64");
            this.encodeLength(n2);
        }
        d.lcheck(2);
    }

    public void encodeSmallNonNegWholeNumber(int n2) throws Asn1InvalidArgException {
        block3: {
            block2: {
                if (n2 >= 64) break block2;
                this.encodeInt(n2, 7);
                if (!Asn1Exception.z) break block3;
            }
            this.encodeBit(true, ">= 64");
            this.byteAlign();
            this.encodeInt((long)n2, true, false);
        }
        d.lcheck(2);
    }

    public byte[] getBuffer() {
        return this.mData;
    }

    public int getByteIndex() {
        return this.mByteIndex;
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        return new ByteArrayInputStream(this.mData, 0, this.mByteIndex + 1);
    }

    public InputStream getInputStream() {
        return this.getByteArrayInputStream();
    }

    public int getMsgBitCnt() {
        return Asn1PerUtil.getMsgBitCnt(this.mByteIndex, this.a);
    }

    public int getMsgByteCnt() {
        return this.mByteIndex + 1;
    }

    public byte[] getMsgCopy() {
        int n2 = 0;
        int n3 = this.getMsgByteCnt();
        byte[] byArray = new byte[n3];
        System.arraycopy(this.mData, n2, byArray, 0, n3);
        return byArray;
    }

    public int getMsgLength() {
        return this.getMsgByteCnt();
    }

    public void hexDump() {
        Asn1PerEncodeBuffer.hexDump(this.getByteArrayInputStream());
    }

    public boolean isAligned() {
        return this.b;
    }

    public void reset() {
        this.mByteIndex = -1;
        this.a = -1;
        this.mTraceHandler.reset();
    }

    public void reverseBytes(int n2, int n3) {
        boolean bl = Asn1Exception.z;
        int n4 = n2;
        for (int i2 = n2 + (n3 - 1); n4 < i2; ++n4, --i2) {
            byte by = this.mData[i2];
            this.mData[i2] = this.mData[n4];
            this.mData[n4] = by;
            if (!bl) continue;
        }
    }

    public void setAligned(boolean bl) {
        this.b = bl;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.mData, 0, this.mByteIndex + 1);
    }

    public Asn1PerTraceHandler getTraceHandler() {
        return this.mTraceHandler;
    }

    private void a(long l2) throws Asn1Exception {
        block6: {
            block5: {
                boolean bl = Asn1Exception.z;
                long l3 = 127L;
                int n2 = 0;
                n2 = h.d(l2);
                l3 <<= 7 * n2;
                d.lcheck(2);
                if (n2 <= 0) break block5;
                while (n2 > 0) {
                    long l4 = (l2 & (l3 >>>= 7)) >>> --n2 * 7;
                    if (n2 != 0) {
                        l4 |= 0x80L;
                    }
                    this.encodeInt(l4, 8, null);
                    if (!bl) continue;
                }
                if (!bl) break block6;
            }
            this.encodeInt(0L, 8, null);
        }
    }

    public String toString() {
        boolean bl = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer((this.mByteIndex + 1) * 2);
        for (int i2 = 0; i2 < this.mByteIndex + 1; ++i2) {
            Asn1Util.toHexString(this.mData[i2], stringBuffer);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }
}

