/*
 * Decompiled with CFR 0.152.
 */
package com.phison.gti;

import android.os.Environment;
import com.phison.gti.Gti2Exception;
import com.phison.gti.Utils;
import com.phison.gtijni.GtiLib;
import java.io.File;
import java.io.RandomAccessFile;

public class Gti2Stream {
    private long m_dwRfilePos = 0L;
    private File m_SDCardPath;
    private boolean m_isFilesInited = false;
    private File m_rFile = null;
    private RandomAccessFile m_rfileRandomFile = null;
    private File m_cachefile = null;
    private RandomAccessFile m_cachefileRandomFile = null;
    private File m_writePath = null;
    private RandomAccessFile m_hWrite = null;
    private byte[] m_byWriteBuf = new byte[25088];
    private byte[] m_byReadBuf = new byte[65536];
    private byte[] m_byHeaderBuf = new byte[32];
    private byte m_byCmdType = 0;
    GtiLib oGtiJni = new GtiLib();

    public String sGetSDCardPath() {
        return this.m_SDCardPath.getPath();
    }

    private File fGetSDCardPath() {
        return Environment.getExternalStorageDirectory();
    }

    private void vReadCacheOffset() throws Gti2Exception {
        boolean bNeedparse = true;
        int dwReadlen = 0;
        try {
            if (this.m_cachefile == null || this.m_cachefileRandomFile == null) {
                this.m_cachefile = new File(this.m_SDCardPath, "gticache.bin");
                if (!this.m_cachefile.exists()) {
                    this.m_cachefile.createNewFile();
                    bNeedparse = false;
                    this.m_dwRfilePos = 0L;
                }
            }
            this.m_cachefileRandomFile = new RandomAccessFile(this.m_cachefile, "rw");
            if (bNeedparse) {
                dwReadlen = this.m_cachefileRandomFile.read(this.m_byReadBuf, 0, 4);
                this.m_dwRfilePos = dwReadlen == -1 || dwReadlen != 4 ? 0L : (long)Utils.four_bytes_to_int(this.m_byReadBuf[0], this.m_byReadBuf[1], this.m_byReadBuf[2], this.m_byReadBuf[3]);
            }
        }
        catch (Exception ex) {
            throw new Gti2Exception(518, 770, " readCacheOffset " + ex.toString());
        }
    }

    private void vWriteCacheOffset(byte[] pbyData, int dwDatalen) throws Gti2Exception {
        try {
            this.m_cachefileRandomFile.seek(0L);
            this.m_cachefileRandomFile.write(pbyData, 0, dwDatalen);
            this.m_cachefileRandomFile.getFD().sync();
        }
        catch (Exception ex) {
            throw new Gti2Exception(518, 771, "writeCacheOffset + " + ex.toString());
        }
    }

    private void vWriteStream(byte[] byData, int dwDatalen) throws Gti2Exception {
        if (byData == null || dwDatalen == 0) {
            throw new Gti2Exception(518, 778, "byData is null.");
        }
        long dwCurrPointer = -1L;
        try {
            this.m_hWrite.seek(0L);
            dwCurrPointer = this.m_hWrite.getFilePointer();
            if (dwCurrPointer != 0L) {
                throw new Gti2Exception(518, 780, "m_hWrite seek() failed, pointer = " + Long.toString(dwCurrPointer));
            }
            this.m_hWrite.write(byData, 0, dwDatalen);
            this.m_hWrite.getFD().sync();
        }
        catch (Exception ex) {
            throw new Gti2Exception(518, 781, "writeStream failed " + ex.toString());
        }
    }

    private void vTryReadStreamRandomRfile(byte[] byResp, int[] dwbuflen, int dwTimeOutMode) throws Gti2Exception {
        if (byResp == null || dwbuflen[0] == 0 || dwbuflen == null) {
            throw new Gti2Exception(518, 778, "vTryReadStreamRandomRfile-byResp is null.");
        }
        int dwErr = 793;
        int buflen = dwbuflen[0];
        int dwReadlen = 0;
        int dwRetry = 0;
        int dwErrcnt = 0;
        long dwTick = 0L;
        long dwDelta = 0L;
        dwTick = System.currentTimeMillis();
        try {
            while (true) {
                this.vShiftFilePosition();
                dwReadlen = this.m_rfileRandomFile.read(this.m_byReadBuf, 0, 65536);
                if (dwReadlen == -1) {
                    if (++dwErrcnt > 4) {
                        throw new Gti2Exception(518, 785, "vTryReadStreamRandomRfile get -1, retry = " + Integer.toString(dwErrcnt));
                    }
                    this.vRfileSeek(0L);
                    continue;
                }
                dwDelta = System.currentTimeMillis() - dwTick;
                if (dwDelta > (long)(dwTimeOutMode * 1000)) {
                    throw new Gti2Exception(518, 523, "vTryReadStreamRandomRfile read timeout = " + Long.toString(dwDelta));
                }
                dwbuflen[0] = buflen;
                dwErr = this.dwParseAndCheckResponse(this.m_byReadBuf, dwReadlen, byResp, dwbuflen);
                if (dwErr == 791 || dwErr == 792) {
                    if (dwRetry++ <= 17000) continue;
                    throw new Gti2Exception(518, 786, "MAX_CACHE_RETRY retry:" + Integer.toString(dwRetry));
                }
                if (dwErr == 790) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new Gti2Exception(518, 776, "vTryReadStreamRandomRfile " + ex.toString());
        }
    }

    private int dwParseAndCheckResponse(byte[] byTmpbuf, int dwTmpbuflen, byte[] byResp, int[] dwRespBufLen) throws Gti2Exception {
        if (byResp == null || dwRespBufLen[0] == 0 || dwRespBufLen == null) {
            throw new Gti2Exception(518, 778, "parseAndCheckResponse-byResp is null.");
        }
        boolean k = false;
        if (!this.bCompareHeader(byTmpbuf)) {
            return 792;
        }
        if (!this.bCompareWToken(byTmpbuf)) {
            return 791;
        }
        int dwValidRespDataLen = 0;
        int dwFirst = 0;
        int dwSecond = 0;
        dwFirst = byTmpbuf[32] & 0xFF;
        dwSecond = byTmpbuf[33] & 0xFF;
        dwValidRespDataLen = dwFirst << 8 | dwSecond;
        if (dwValidRespDataLen < 2) {
            throw new Gti2Exception(518, 787, "parseAndCheckResponse-response length invalid.");
        }
        if (dwValidRespDataLen == 2 && byTmpbuf[34] == 98 && byTmpbuf[35] == 0 && byTmpbuf[27] == 1) {
            dwRespBufLen[0] = 0;
            return 790;
        }
        if (this.m_byCmdType == 1 && byTmpbuf[27] != this.m_byCmdType) {
            throw new Gti2Exception(518, 788, "parseAndCheckResponse-payload type error.");
        }
        dwRespBufLen[0] = dwValidRespDataLen;
        System.arraycopy(byTmpbuf, 34, byResp, 0, dwValidRespDataLen);
        return 768;
    }

    private boolean bCompareHeader(byte[] byTmpbuf) {
        int dwLoop = 0;
        while (dwLoop < 27) {
            if (this.m_byHeaderBuf[dwLoop] != byTmpbuf[dwLoop]) {
                return false;
            }
            ++dwLoop;
        }
        return true;
    }

    private boolean bCompareWToken(byte[] byTmpbuf) {
        int dwLoop = 0;
        while (dwLoop < 4) {
            if (this.m_byHeaderBuf[28 + dwLoop] != byTmpbuf[28 + dwLoop]) {
                return false;
            }
            ++dwLoop;
        }
        return true;
    }

    private void vShiftFilePosition() throws Gti2Exception {
        this.m_dwRfilePos += 65536L;
        if (this.m_dwRfilePos % 65536L != 0L) {
            throw new Gti2Exception(518, 782, "vShiftFilePosition error.");
        }
        if (this.m_dwRfilePos >= 0x6400000L) {
            this.m_dwRfilePos = 65536L;
        }
        this.vRfileSeek(this.m_dwRfilePos);
    }

    private void vRfileSeek(long pos) throws Gti2Exception {
        if (pos > 0x6400000L) {
            throw new Gti2Exception(518, 783, "vRfileSeek pos over rfile size.");
        }
        long dwCurrFilepos = -1L;
        try {
            this.m_rfileRandomFile.seek(pos);
            dwCurrFilepos = this.m_rfileRandomFile.getFilePointer();
        }
        catch (Exception ex) {
            throw new Gti2Exception(518, 780, "vRfileSeek failed " + ex.toString());
        }
        if (dwCurrFilepos != pos) {
            throw new Gti2Exception(518, 784, "vRfileSeek dwCurrFilepos != pos.");
        }
    }

    public long dwGetRfileOffset() {
        return this.m_dwRfilePos;
    }

    public void vOpen(String strSDCardPath) throws Gti2Exception {
        if (!this.m_isFilesInited) {
            int dwRet = this.oGtiJni.dwOpen(strSDCardPath.getBytes(), strSDCardPath.length());
            if (dwRet != 0) {
                throw new Gti2Exception(772, dwRet, "Gti2Stream.open error.");
            }
            this.m_isFilesInited = true;
        }
    }

    public void vClose() throws Gti2Exception {
        if (!this.m_isFilesInited) {
            throw new Gti2Exception(518, 774, "Gti2Stream.close no initial.");
        }
        int dwRet = this.oGtiJni.dwClose();
        if (dwRet != 0) {
            throw new Gti2Exception(518, dwRet, "Gti2Stream.close no initial.");
        }
        this.m_isFilesInited = false;
    }

    public void vWriteCmd(byte[] byData, int dwDatalen, int dwCmdType) throws Gti2Exception {
        if (byData == null || dwDatalen == 0) {
            throw new Gti2Exception(518, 778, "byData is null.");
        }
        if (dwDatalen > 25088) {
            throw new Gti2Exception(518, 777, "write data length invalid = " + Integer.toString(dwDatalen));
        }
        int dwRet = this.oGtiJni.dwWriteCmd(byData, dwDatalen, dwCmdType);
        if (dwRet != 0) {
            throw new Gti2Exception(518, dwRet, "dwWriteCmd failed.");
        }
    }

    public void vReadResponse(byte[] byResp, int[] dwbuflen, int dwTimeOutMode) throws Gti2Exception {
        if (byResp == null || dwbuflen[0] == 0 || dwbuflen == null) {
            throw new Gti2Exception(518, 778, "vReadResponse-byResp is null.");
        }
        int dwRet = this.oGtiJni.dwReadResponse(byResp, dwbuflen, dwTimeOutMode);
        if (dwRet != 0) {
            throw new Gti2Exception(518, dwRet, "dwReadResponse failed.");
        }
        if (dwbuflen[0] == 0) {
            throw new Gti2Exception(518, 777, "vTransmitAndGetResponse-Response len invalid.");
        }
    }
}

