/*
 * Decompiled with CFR 0.152.
 */
package com.scdroid.smartcard.protocol;

import com.scdroid.smartcard.protocol.T1Block;
import com.scdroid.smartcard.protocol.T1Exception;

public class T1BlockFactory {
    public static T1Block createIBlock(int sourceID, int destID, int edcAlg, int sendSequenceNumber, boolean moreDataBit, byte[] data) throws T1Exception {
        int n = 0xFF & sendSequenceNumber % 2 << 6;
        if (moreDataBit) {
            n = 0xFF & (n | 0x20);
        }
        return new T1Block(sourceID, destID, n, data, edcAlg);
    }

    public static T1Block createRBlock(int sourceID, int destID, int edcAlg, int sequenceNumber, int errInfo) throws T1Exception {
        int n = 0xFF & (0x80 | sequenceNumber % 2 << 4);
        n = 0xFF & (n | errInfo);
        return new T1Block(sourceID, destID, n, null, edcAlg);
    }

    public static T1Block createSBlock(int sourceID, int destID, int edcAlg, int statusInfo, byte[] data) throws T1Exception {
        int n = 192;
        n = 0xFF & (n | statusInfo);
        return new T1Block(sourceID, destID, n, data, edcAlg);
    }
}

