/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

import java.util.Arrays;

public class PinProperties {
    private byte[] a = new byte[4];

    public PinProperties() {
    }

    public PinProperties(byte[] buffer, int bufferLength) {
        this.fromByteArray(buffer, bufferLength);
    }

    public void clear() {
        Arrays.fill(this.a, (byte)0);
    }

    public int getLcdLayout() {
        return this.a[0] & 0xFF | (this.a[1] & 0xFF) << 8;
    }

    public int getEntryValidationCondition() {
        return this.a[2] & 0xFF;
    }

    public int getTimeOut2() {
        return this.a[3] & 0xFF;
    }

    public void fromByteArray(byte[] buffer, int bufferLength) {
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        if (bufferLength < this.a.length) {
            throw new IllegalArgumentException("The buffer length is less than " + this.a.length + ".");
        }
        if (bufferLength > buffer.length) {
            throw new IllegalArgumentException("The buffer length is greater than the buffer size.");
        }
        System.arraycopy(buffer, 0, this.a, 0, this.a.length);
    }
}

