/*
 * Decompiled with CFR 0.152.
 */
package com.acs.smartcard;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class TlvProperties {
    public static final int PROPERTY_wLcdLayout = 1;
    public static final int PROPERTY_bEntryValidationCondition = 2;
    public static final int PROPERTY_bTimeOut2 = 3;
    public static final int PROPERTY_wLcdMaxCharacters = 4;
    public static final int PROPERTY_wLcdMaxLines = 5;
    public static final int PROPERTY_bMinPINSize = 6;
    public static final int PROPERTY_bMaxPINSize = 7;
    public static final int PROPERTY_sFirmwareID = 8;
    public static final int PROPERTY_bPPDUSupport = 9;
    public static final int PROPERTY_dwMaxAPDUDataSize = 10;
    public static final int PROPERTY_wIdVendor = 11;
    public static final int PROPERTY_wIdProduct = 12;
    private Object[] a = new Object[13];

    public TlvProperties() {
    }

    public TlvProperties(byte[] buffer, int bufferLength) {
        this.fromByteArray(buffer, bufferLength);
    }

    public void clear() {
        Arrays.fill(this.a, null);
    }

    public Object getProperty(int property) {
        if (!TlvProperties.a(property)) {
            return null;
        }
        return this.a[property];
    }

    public void fromByteArray(byte[] buffer, int bufferLength) {
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        if (bufferLength <= 0) {
            throw new IllegalArgumentException("The buffer length is less than or equal to zero.");
        }
        if (bufferLength > buffer.length) {
            throw new IllegalArgumentException("The buffer length is greater than the buffer size.");
        }
        this.clear();
        int n = 0;
        while (n < bufferLength) {
            int n2;
            int n3 = buffer[n] & 0xFF;
            if (TlvProperties.a(n3) && n + 1 < bufferLength && n + 1 + (n2 = buffer[n + 1] & 0xFF) < bufferLength) {
                switch (n3) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: {
                        if (n2 != 1) break;
                        this.a[n3] = buffer[n + 2] & 0xFF;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 11: 
                    case 12: {
                        if (n2 != 2) break;
                        this.a[n3] = buffer[n + 2] & 0xFF | (buffer[n + 3] & 0xFF) << 8;
                        break;
                    }
                    case 10: {
                        if (n2 != 4) break;
                        this.a[n3] = buffer[n + 2] & 0xFF | (buffer[n + 3] & 0xFF) << 8 | (buffer[n + 4] & 0xFF) << 16 | (buffer[n + 5] & 0xFF) << 24;
                        break;
                    }
                    case 8: {
                        if (n2 <= 0) break;
                        try {
                            this.a[n3] = new String(buffer, n + 2, n2, "UTF-8");
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                }
            }
            if (n + 1 >= bufferLength) break;
            n += (buffer[n + 1] & 0xFF) + 2;
        }
    }

    private static boolean a(int n) {
        return n > 0 && n <= 12;
    }
}

