/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.find;

import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Find;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.FinderOCSPResponseSource;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ItemFinderIteration;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ListItemSource;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;

public class OCSPResponseFinderIteration
extends ItemFinderIteration<EOCSPResponse> {
    protected int mSourceIndex;
    private ECertificate a;
    private ECertificate b;

    public OCSPResponseFinderIteration(ECertificate aCertificate, ECertificate aIssuer, ValidationSystem aValidationSystem) {
        this.a = aCertificate;
        this.b = aIssuer;
        this.mSourceIndex = -1;
        this._initSources(aValidationSystem);
    }

    @Override
    protected void _initSources(ValidationSystem aDS) {
        this.mSources.add(0, new ListItemSource<EOCSPResponse>(aDS.getUserInitialOCSPResponseSet()));
        this.mSources.add(new FinderOCSPResponseSource(this.a, this.b, aDS.getFindSystem().getOCSPResponseFinders()));
    }

    @Override
    protected boolean _nextSource(ValidationSystem aDS) {
        ++this.mSourceIndex;
        if (this.mSourceIndex < this.mSources.size()) {
            this.mCurrentSource = (ItemSource)this.mSources.get(this.mSourceIndex);
        }
        return this.mSourceIndex < this.mSources.size();
    }

    @Override
    public boolean nextIteration(ValidationSystem aDS) throws ESYAException {
        MatchSystem matchSystem = aDS.getMatchSystem();
        while (super.nextIteration(aDS)) {
            if (!Find.isMatchingOCSPResponse(matchSystem, this.a, this.b, (EOCSPResponse)this.mCurrentItem)) continue;
            return true;
        }
        return false;
    }
}

