/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.SDOHeader;

public class PIN {
    public SDOHeader header;
    byte minPinLen;
    byte maxPinLen;
    byte[] pin;
    byte[] pen;

    public PIN() {
        this.header = new SDOHeader();
        this.minPinLen = (byte)4;
        this.maxPinLen = (byte)16;
        this.pin = null;
        this.pen = null;
    }

    public PIN(SDOHeader header, byte minPinLen, byte maxPinLen, byte[] pin, byte[] pen) {
        this.header = header;
        this.minPinLen = minPinLen;
        this.maxPinLen = maxPinLen;
        if (pin == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (pin.length > 16 || pen != null && pen.length > 32) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.pin = pin;
        this.pen = pen;
    }

    public byte[] CreateSDOHeaderList(boolean op) {
        int i = 0;
        byte index = 0;
        int len = 0;
        byte[] headerList = new byte[256];
        if (this.header.access == null || this.pin == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.maxTryCount == -1 || this.maxPinLen == -1 || this.minPinLen == -1) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        headerList[i++] = -65;
        headerList[i++] = -127;
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = (byte)i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        headerList[i++] = -102;
        headerList[i++] = 1;
        if (op) {
            headerList[i++] = (byte)this.header.maxTryCount;
        }
        if (this.header.maxUsageCount != -1) {
            headerList[i++] = -100;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.maxUsageCount >> 8);
                headerList[i++] = (byte)this.header.maxUsageCount;
            }
        }
        if (this.header.len != -1) {
            headerList[i++] = -128;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.len >> 8);
                headerList[i++] = (byte)this.header.len;
            }
        }
        headerList[i++] = -95;
        if (op) {
            len = this.header.access.toByteArray().length;
            headerList[i++] = (byte)len;
            System.arraycopy(this.header.access.toByteArray(), 0, headerList, i, len);
            i += len;
        } else if (this.header.access.toByteArray().length == 5) {
            headerList[i++] = 2;
            headerList[i++] = this.header.access.toByteArray()[0];
            headerList[i++] = 3;
        } else {
            headerList[i++] = 4;
            headerList[i++] = -53;
            headerList[i++] = 3;
            headerList[i++] = -52;
            headerList[i++] = 3;
        }
        if (this.header.berTLVInfo != null) {
            headerList[i++] = -91;
            headerList[i++] = (byte)this.header.berTLVInfo.length;
            if (op) {
                System.arraycopy(this.header.berTLVInfo, 0, headerList, i, this.header.berTLVInfo.length);
                i += this.header.berTLVInfo.length;
            }
        }
        if (this.header.info != null) {
            headerList[i++] = -123;
            headerList[i++] = (byte)this.header.info.length;
            if (op) {
                System.arraycopy(this.header.info, 0, headerList, i, this.header.info.length);
                i += this.header.info.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (!op) {
            headerList[i++] = 127;
            headerList[i++] = 65;
            index = (byte)i;
            headerList[i++] = 0;
            headerList[i++] = -128;
            headerList[i++] = 1;
            headerList[i++] = -127;
            headerList[i++] = 1;
            headerList[i++] = -126;
            headerList[i++] = (byte)this.pin.length;
            if (this.pen != null) {
                headerList[i++] = -64;
                headerList[i++] = (byte)this.pen.length;
            }
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
            headerList[index] = (byte)(i - index - 1);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate() {
        int i = 0;
        byte[] data = new byte[512];
        data[i++] = -65;
        data[i++] = -127;
        data[i++] = this.header.keyID;
        data[i++] = 0;
        data[i++] = 127;
        data[i++] = 65;
        data[i++] = 0;
        data[i++] = -128;
        data[i++] = 1;
        data[i++] = this.maxPinLen;
        data[i++] = -127;
        data[i++] = 1;
        data[i++] = this.minPinLen;
        data[i++] = -126;
        data[i++] = (byte)this.pin.length;
        System.arraycopy(this.pin, 0, data, i, this.pin.length);
        i += this.pin.length;
        if (this.pen != null) {
            data[i++] = -64;
            data[i++] = (byte)this.pen.length;
            System.arraycopy(this.pen, 0, data, i, this.pen.length);
            i += (byte)this.pen.length;
        }
        data[6] = (byte)(i - 7);
        data[3] = (byte)(i - 4);
        byte[] resizedData = new byte[i];
        System.arraycopy(data, 0, resizedData, 0, i);
        return resizedData;
    }

    public void CreateKeyFromSDO(byte[] sdo) {
        if (sdo[0] != -65 || sdo[1] != -127) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        int i = 4;
        if (sdo[i] == -96) {
            this.header.CreateHeaderFromSDO(sdo);
        } else if (sdo[i + 1] == 65) {
            if (sdo[i += 3] == -128) {
                this.maxPinLen = sdo[i + 2];
                i += sdo[i + 1];
            }
            if (sdo[i] == -127) {
                this.minPinLen = sdo[i + 2];
                i += sdo[i + 1];
            }
        }
    }

    public static byte[] UpdatePIN(byte pinNo, byte[] newPIN) {
        byte[] updatePINHeader = new byte[]{-65, -127, pinNo, 0, 127, 65, 0, -126, 0};
        byte[] updatePIN = new byte[updatePINHeader.length + newPIN.length];
        System.arraycopy(updatePINHeader, 0, updatePIN, 0, updatePINHeader.length);
        System.arraycopy(newPIN, 0, updatePIN, updatePINHeader.length, newPIN.length);
        updatePIN[8] = (byte)newPIN.length;
        updatePIN[6] = (byte)(newPIN.length + 2);
        updatePIN[3] = (byte)(newPIN.length + 5);
        return updatePIN;
    }
}

