/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeader;

public class SymmetricKey {
    public SDOHeader header;
    private byte[] KMac;
    private byte[] KEnc;
    public byte[] key;
    public KeyType type;

    public SymmetricKey() {
        this.header = new SDOHeader();
        this.key = null;
        this.type = null;
        this.KMac = null;
        this.KEnc = null;
    }

    public SymmetricKey(SDOHeader mHdr, byte[] kmac, byte[] kenc) {
        this.header = mHdr;
        if (kenc == null || kmac == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (kenc.length != 16 || kmac.length != 16) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.KMac = kmac;
        this.KEnc = kenc;
    }

    public SymmetricKey(SDOHeader mHdr, byte[] key, KeyType type) {
        if (mHdr == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (key == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (type == KeyType.SYMMETRIC_3DES && key.length != 16) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (type == KeyType.SYMMETRIC_AES && key.length != 16 && key.length != 24 && key.length != 32) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.header = mHdr;
        this.type = type;
        this.key = key;
    }

    public byte[] CreateSDOHeaderList(KeyType keyType, boolean op) {
        int i = 0;
        byte index = 0;
        int len = 0;
        byte[] headerList = new byte[256];
        if (this.KEnc == null || this.KMac == null || this.header.access == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.maxTryCount == -1) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (keyType != KeyType.SYMMETRIC) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = -65;
        headerList[i++] = -118;
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = (byte)i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        headerList[i++] = -102;
        headerList[i++] = 1;
        if (op) {
            headerList[i++] = (byte)this.header.maxTryCount;
        }
        if (this.header.maxUsageCount != -1) {
            headerList[i++] = -100;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.maxUsageCount >> 8);
                headerList[i++] = (byte)this.header.maxUsageCount;
            }
        }
        if (this.header.len != -1) {
            headerList[i++] = -128;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.len >> 8);
                headerList[i++] = (byte)this.header.len;
            }
        }
        headerList[i++] = -95;
        if (op) {
            len = this.header.access.toByteArray().length;
            headerList[i++] = (byte)len;
            System.arraycopy(this.header.access.toByteArray(), 0, headerList, i, len);
            i += len;
        } else if (this.header.access.toByteArray().length == 5) {
            headerList[i++] = 2;
            headerList[i++] = this.header.access.toByteArray()[0];
            headerList[i++] = 3;
        } else {
            headerList[i++] = 4;
            headerList[i++] = -53;
            headerList[i++] = 3;
            headerList[i++] = -52;
            headerList[i++] = 3;
        }
        if (this.header.berTLVInfo != null) {
            headerList[i++] = -91;
            headerList[i++] = (byte)this.header.berTLVInfo.length;
            if (op) {
                System.arraycopy(this.header.berTLVInfo, 0, headerList, i, this.header.berTLVInfo.length);
                i += this.header.berTLVInfo.length;
            }
        }
        if (this.header.info != null) {
            headerList[i++] = -123;
            headerList[i++] = (byte)this.header.info.length;
            if (op) {
                System.arraycopy(this.header.info, 0, headerList, i, this.header.info.length);
                i += this.header.info.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (!op) {
            headerList[i++] = -94;
            headerList[i++] = 4;
            headerList[i++] = -111;
            headerList[i++] = (byte)this.KEnc.length;
            headerList[i++] = -112;
            headerList[i++] = (byte)this.KMac.length;
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] CreateSDOHeaderList(boolean op) {
        int i = 0;
        byte index = 0;
        int len = 0;
        byte[] headerList = new byte[256];
        if (this.header.access == null) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (this.header.maxTryCount == -1) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (!op) {
            headerList[i++] = 77;
            headerList[i++] = 0;
        }
        if (this.type == KeyType.SYMMETRIC_3DES) {
            headerList[i++] = -65;
            headerList[i++] = -117;
        } else if (this.type == KeyType.SYMMETRIC_AES) {
            headerList[i++] = -65;
            headerList[i++] = -118;
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        headerList[i++] = this.header.keyID;
        headerList[i++] = 0;
        headerList[i++] = -96;
        index = (byte)i;
        headerList[i++] = 0;
        if (this.header.name != null) {
            headerList[i++] = -124;
            headerList[i++] = (byte)this.header.name.length;
            if (op) {
                System.arraycopy(this.header.name, 0, headerList, i, this.header.name.length);
                i += this.header.name.length;
            }
        }
        if (this.header.maxUsageCount != -1) {
            headerList[i++] = -100;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.maxUsageCount >> 8);
                headerList[i++] = (byte)this.header.maxUsageCount;
            }
        }
        if (this.header.len != -1) {
            headerList[i++] = -128;
            headerList[i++] = 2;
            if (op) {
                headerList[i++] = (byte)(this.header.len >> 8);
                headerList[i++] = (byte)this.header.len;
            }
        }
        headerList[i++] = -95;
        if (op) {
            len = this.header.access.toByteArray().length;
            headerList[i++] = (byte)len;
            System.arraycopy(this.header.access.toByteArray(), 0, headerList, i, len);
            i += len;
        } else if (this.header.access.toByteArray().length == 5) {
            headerList[i++] = 2;
            headerList[i++] = this.header.access.toByteArray()[0];
            headerList[i++] = 3;
        } else {
            headerList[i++] = 4;
            headerList[i++] = -53;
            headerList[i++] = 3;
            headerList[i++] = -52;
            headerList[i++] = 3;
        }
        if (this.header.berTLVInfo != null) {
            headerList[i++] = -91;
            headerList[i++] = (byte)this.header.berTLVInfo.length;
            if (op) {
                System.arraycopy(this.header.berTLVInfo, 0, headerList, i, this.header.berTLVInfo.length);
                i += this.header.berTLVInfo.length;
            }
        }
        if (this.header.info != null) {
            headerList[i++] = -123;
            headerList[i++] = (byte)this.header.info.length;
            if (op) {
                System.arraycopy(this.header.info, 0, headerList, i, this.header.info.length);
                i += this.header.info.length;
            }
        }
        headerList[index] = (byte)(i - index - 1);
        if (!op) {
            headerList[i++] = -94;
            headerList[i++] = 2;
            headerList[i++] = -111;
            headerList[i++] = (byte)this.key.length;
            headerList[1] = (byte)(i - 2);
            headerList[5] = (byte)(headerList[1] - 4);
        } else {
            headerList[3] = (byte)(i - 4);
        }
        byte[] resizedHeaderList = new byte[i];
        System.arraycopy(headerList, 0, resizedHeaderList, 0, i);
        return resizedHeaderList;
    }

    public byte[] SDOUpdate(int tag) {
        int i = 0;
        byte[] data = new byte[512];
        data[i++] = -65;
        data[i++] = -118;
        data[i++] = this.header.keyID;
        data[i++] = 0;
        data[i++] = -94;
        data[i++] = 0;
        if (tag == -112) {
            data[i++] = -112;
            data[i++] = (byte)this.KMac.length;
            System.arraycopy(this.KMac, 0, data, i, this.KMac.length);
            i += this.KMac.length;
        } else if (tag == -111) {
            data[i++] = -111;
            data[i++] = (byte)this.KEnc.length;
            System.arraycopy(this.KEnc, 0, data, i, this.KEnc.length);
            i += this.KEnc.length;
        }
        data[5] = (byte)(i - 6);
        data[3] = (byte)(i - 4);
        byte[] resizedData = new byte[i];
        System.arraycopy(data, 0, resizedData, 0, i);
        return resizedData;
    }

    public byte[] SDOUpdate() {
        int i = 0;
        byte[] data = new byte[512];
        data[i++] = -65;
        data[i++] = this.type == KeyType.SYMMETRIC_3DES ? -117 : -118;
        data[i++] = this.header.keyID;
        data[i++] = 0;
        data[i++] = -94;
        data[i++] = 0;
        data[i++] = -111;
        data[i++] = (byte)this.key.length;
        System.arraycopy(this.key, 0, data, i, this.key.length);
        data[5] = (byte)((i += this.key.length) - 6);
        data[3] = (byte)(i - 4);
        byte[] resizedData = new byte[i];
        System.arraycopy(data, 0, resizedData, 0, i);
        return resizedData;
    }
}

