/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.functions;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.functions.Conversions;

public class Crypto {
    public static boolean testPrint(String a) {
        System.out.println(a);
        return true;
    }

    public static byte[] computeHashValue(byte[] input, String alg) {
        byte[] hash = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(alg);
            sha.update(input);
            hash = sha.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return hash;
    }

    public static byte[] aes(byte[] key, byte[] data, boolean encrypt) throws AkisCIFException {
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            int mode = 0;
            mode = encrypt ? 1 : 2;
            cipher.init(mode, aesKey);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AkisCIFException(e);
        }
    }

    public static byte[] aesCBC(byte[] key, byte[] IV, byte[] data, boolean encrypt) throws AkisCIFException {
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            int mode = 0;
            mode = encrypt ? 1 : 2;
            cipher.init(mode, (Key)aesKey, new IvParameterSpec(IV));
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AkisCIFException(e);
        }
    }

    public static byte[] retailMacAes(byte[] inputMessage, byte[] keyBytes) throws AkisCIFException {
        byte[] K1;
        byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] paddedMessage = Crypto.padData(inputMessage, 16);
        byte[] a = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int numBlocks = paddedMessage.length / 16;
        byte[] L = Crypto.aes(keyBytes, a, true);
        if ((L[0] & 0xFFFFFF80) == 0) {
            K1 = Conversions.MultiplyBy2(L);
        } else {
            L = Conversions.MultiplyBy2(L);
            a[15] = -121;
            K1 = Conversions.xor(L, a);
        }
        byte[] temp = new byte[16];
        System.arraycopy(paddedMessage, paddedMessage.length - 16, temp, 0, 16);
        temp = Conversions.xor(K1, temp);
        System.arraycopy(temp, 0, paddedMessage, paddedMessage.length - 16, 16);
        for (int i = 0; i < numBlocks; ++i) {
            byte[] eightBytesofMessage = new byte[16];
            System.arraycopy(paddedMessage, i * 16, eightBytesofMessage, 0, 16);
            byte[] xorOutput = Conversions.xor(IV, eightBytesofMessage);
            IV = Crypto.aes(keyBytes, xorOutput, true);
        }
        return IV;
    }

    public static byte[] triDes(byte[] keysABA, byte[] data, boolean encrypt) throws AkisCIFException {
        try {
            SecretKeySpec triDesKey = new SecretKeySpec(keysABA, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            int mode = 0;
            mode = encrypt ? 1 : 2;
            cipher.init(mode, triDesKey);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AkisCIFException(e);
        }
    }

    public static byte[] triDesCBC(byte[] keysABA, byte[] data, boolean encrypt) throws AkisCIFException {
        try {
            SecretKeySpec triDesKey = new SecretKeySpec(keysABA, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int mode = 0;
            mode = encrypt ? 1 : 2;
            cipher.init(mode, (Key)triDesKey, new IvParameterSpec(iv));
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AkisCIFException(e);
        }
    }

    public static byte[] des(byte[] keyA, byte[] data, boolean encrypt) throws AkisCIFException {
        try {
            DESKeySpec ks = new DESKeySpec(keyA);
            SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = kf.generateSecret(ks);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            int mode = 0;
            mode = encrypt ? 1 : 2;
            cipher.init(mode, desKey);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AkisCIFException(e);
        }
    }

    public static byte[] retailMacDes(byte[] inputMessage, byte[] keyBytes) throws AkisCIFException {
        byte[] keyA = new byte[8];
        byte[] keyB = new byte[8];
        System.arraycopy(keyBytes, 0, keyA, 0, 8);
        System.arraycopy(keyBytes, 8, keyB, 0, 8);
        byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] paddedMessage = Crypto.padData(inputMessage, 8);
        for (int i = 0; i < paddedMessage.length / 8; ++i) {
            byte[] eightBytesofMessage = new byte[8];
            System.arraycopy(paddedMessage, i * 8, eightBytesofMessage, 0, 8);
            byte[] xorOutput = Conversions.xor(IV, eightBytesofMessage);
            IV = Crypto.des(keyA, xorOutput, true);
        }
        byte[] dec = Crypto.des(keyB, IV, false);
        byte[] enc = Crypto.des(keyA, dec, true);
        return enc;
    }

    public static byte[] padData(byte[] unpadded, int blockLen) {
        byte[] padded = new byte[unpadded.length + (blockLen - unpadded.length % blockLen)];
        System.arraycopy(unpadded, 0, padded, 0, unpadded.length);
        padded[unpadded.length] = -128;
        for (int i = 0; i < padded.length - unpadded.length - 1; ++i) {
            padded[unpadded.length + 1 + i] = 0;
        }
        return padded;
    }

    public static byte[] unPadData(byte[] padded) {
        byte[] unpadded = null;
        int i = padded.length - 1;
        while (i > 0 && padded[i] == 0 && padded[--i] != -128) {
        }
        if (padded[i] == -128) {
            unpadded = new byte[i];
            System.arraycopy(padded, 0, unpadded, 0, i);
        } else {
            unpadded = new byte[padded.length];
            System.arraycopy(padded, 0, unpadded, 0, padded.length);
        }
        return unpadded;
    }
}

