/*
 * Decompiled with CFR 0.152.
 */
package sune.security.provider;

import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import sune.security.util.Cache;
import sune.security.x509.X509CRLImpl;
import sune.security.x509.X509CertImpl;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final int defaultExpectedLineLength = 80;
    private static final char[] endBoundary = "-----END".toCharArray();
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache certCache = Cache.newSoftMemoryCache(750);
    private static final Cache crlCache = Cache.newSoftMemoryCache(750);

    @Override
    public CRL engineGenerateCRL(InputStream arg0) throws CRLException {
        return null;
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream arg0) throws CRLException {
        return null;
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream arg0) throws CertificateException {
        return null;
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream arg0) throws CertificateException {
        return null;
    }

    public static synchronized X509CertImpl intern(X509Certificate c) throws CertificateException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CertImpl;
        byte[] encoding = isImpl ? ((X509CertImpl)c).getEncodedInternal() : c.getEncoded();
        X509CertImpl newC = (X509CertImpl)X509Factory.getFromCache(certCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CertImpl)c;
        } else {
            newC = new X509CertImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, encoding, newC);
        return newC;
    }

    public static synchronized X509CRLImpl intern(X509CRL c) throws CRLException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CRLImpl;
        byte[] encoding = isImpl ? ((X509CRLImpl)c).getEncodedInternal() : c.getEncoded();
        X509CRLImpl newC = (X509CRLImpl)X509Factory.getFromCache(crlCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CRLImpl)c;
        } else {
            newC = new X509CRLImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(crlCache, encoding, newC);
        return newC;
    }

    private static synchronized Object getFromCache(Cache cache, byte[] encoding) {
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        Object value = cache.get(key);
        return value;
    }

    private static synchronized void addToCache(Cache cache, byte[] encoding, Object value) {
        if (encoding.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        cache.put(key, value);
    }
}

