/*
 * Decompiled with CFR 0.152.
 */
package sune.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import sune.security.timestamp.TSRequest;
import sune.security.timestamp.TSResponse;
import sune.security.timestamp.Timestamper;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final boolean DEBUG = false;
    private String tsaUrl = null;

    public HttpTimestamper(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSResponse generateTimestamp(TSRequest tsQuery) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.tsaUrl).openConnection();
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(15000);
        connection.connect();
        try (DataOutputStream output = null;){
            output = new DataOutputStream(connection.getOutputStream());
            byte[] request = tsQuery.encode();
            output.write(request, 0, request.length);
            output.flush();
        }
        byte[] replyBuffer = null;
        try (BufferedInputStream input = null;){
            input = new BufferedInputStream(connection.getInputStream());
            int contentLength = connection.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            HttpTimestamper.verifyMimeType(connection.getContentType());
            replyBuffer = new byte[contentLength];
            int count = 0;
            for (int total = 0; count != -1 && total < contentLength; total += count) {
                count = input.read(replyBuffer, total, replyBuffer.length - total);
            }
        }
        return new TSResponse(replyBuffer);
    }

    private static void verifyMimeType(String contentType) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(contentType)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

