/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sune.misc.HexDumpEncoder;
import sune.security.x509.Extension;
import sune.security.x509.OIDMap;

class UnparseableExtension
extends Extension {
    protected static Logger logger = LoggerFactory.getLogger(UnparseableExtension.class);
    private String name = "";
    private Throwable why;

    public UnparseableExtension(Extension ext, Throwable why) {
        super(ext);
        try {
            Class extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass != null) {
                Field field = extClass.getDeclaredField("NAME");
                this.name = (String)field.get(null) + " ";
            }
        }
        catch (Exception e) {
            logger.warn("Warning in UnparseableExtension", (Throwable)e);
        }
        this.why = why;
    }

    @Override
    public String toString() {
        return super.toString() + "Unparseable " + this.name + "extension due to\n" + this.why + "\n\n" + new HexDumpEncoder().encodeBuffer(this.getExtensionValue());
    }
}

