/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSP;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSPToWrite;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.OCSPSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreOCSPOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreOCSPOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreOCSPOps.a(27010, 31898));
            throw new ESYARuntimeException(CertStoreOCSPOps.a(27029, -25911) + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoOCSP readStoreOCSPResponse(long aOCSPNo) throws CertStoreException {
        DepoOCSP depoOCSP;
        try {
            DepoOCSP depoOCSP2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoOCSP = depoOCSP2 = depoVEN.ocspCevabiOku(aOCSPNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27022, -6482), notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27030, -19228), certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27030, -19228), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoOCSP;
            JDBCUtil.commit(this.b.getConn());
            return depoOCSP;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27013, 26461), certStoreException);
        }
    }

    public void writeOCSPResponseAndCertificate(EOCSPResponse aResponse, ECertificate aCertificate) throws CertStoreException {
        EBasicOCSPResponse eBasicOCSPResponse = aResponse.getBasicOCSPResponse();
        boolean bl = CertStoreRootCertificateOps.c;
        ESingleResponse eSingleResponse = CertStoreUtil.getOCSPResponseForCertificate(eBasicOCSPResponse, aCertificate);
        if (eSingleResponse == null) {
            throw new CertStoreException(CertStoreOCSPOps.a(27020, -13357));
        }
        DepoSertifika depoSertifika = CertStoreUtil.eSYASertifikaTODepoSertifika(aCertificate);
        DepoOCSPToWrite depoOCSPToWrite = CertStoreUtil.asnOCSPResponseTODepoOCSP(aResponse);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getBasicOCSPResponse(), OzneTipi.OCSP_BASIC_RESPONSE);
            List<DepoOzet> list2 = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getOCSPResponse(), OzneTipi.OCSP_RESPONSE);
            ArrayList<DepoOzet> arrayList = new ArrayList<DepoOzet>(list);
            arrayList.addAll(list2);
            List<DepoOzet> list3 = CertStoreUtil.convertToDepoOzet(depoSertifika.getValue(), OzneTipi.SERTIFIKA);
            depoVEN.ocspCevabiVeSertifikaYaz(depoOCSPToWrite, arrayList, depoSertifika, list3, eSingleResponse);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreOCSPOps.a(27025, 1905), certStoreException);
        }
        if (bl) {
            int n = CertStoreException.b;
            CertStoreException.b = ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoOzet> listOCSPResponseHashes(long aOCSPNo) throws CertStoreException {
        List<DepoOzet> list2;
        try {
            List<DepoOzet> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ItemSource<DepoOzet> itemSource = depoVEN.ocspOzetleriniListele(aOCSPNo);
            list2 = list = ((RsItemSource)itemSource).toList();
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27027, -29580), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27027, -29580), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27021, 8207), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoOCSP> listStoreOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource2;
        try {
            ItemSource<DepoOCSP> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSablon);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.ocspCevabiListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreOCSPOps.a(27014, 1558), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreOCSPOps.a(27014, 1558), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreOCSPOps.a(27026, -30143), certStoreException);
        }
    }

    public EBasicOCSPResponse listOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource = this.listStoreOCSPResponses(aSablon);
        if (itemSource == null) {
            return null;
        }
        DepoOCSP depoOCSP = null;
        try {
            depoOCSP = (DepoOCSP)itemSource.nextItem();
            itemSource.close();
            if (depoOCSP == null) {
                return null;
            }
            return new EBasicOCSPResponse(depoOCSP.getBasicOCSPResponse());
        }
        catch (Exception exception) {
            throw new CertStoreException(depoOCSP.getOCSPNo() + CertStoreOCSPOps.a(27023, 9604), exception);
        }
    }

    public int deleteOCSPResponse(long aOCSPNo) throws CertStoreException {
        try {
            if (aOCSPNo <= 0L) {
                throw new CertStoreException(CertStoreOCSPOps.a(27009, -31752));
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            int n = depoVEN.ocspCevabiSil(aOCSPNo);
            JDBCUtil.commit(this.b.getConn());
            return n;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(27012, -29763), certStoreException);
        }
    }

    private Pair<String, List<Object>> a(OCSPSearchTemplate oCSPSearchTemplate) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block30: {
            OzetTipi ozetTipi;
            block28: {
                boolean bl;
                block29: {
                    stringBuffer = new StringBuffer("");
                    arrayList = new ArrayList<Object>();
                    stringBuffer.append(CertStoreOCSPOps.a(27037, 13746));
                    byte[] byArray = oCSPSearchTemplate.getHash();
                    bl = CertStoreRootCertificateOps.c;
                    ozetTipi = oCSPSearchTemplate.getHashType();
                    if (byArray == null) break block28;
                    stringBuffer.append(CertStoreOCSPOps.a(27008, -17445));
                    arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
                    arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
                    arrayList.add(byArray);
                    if (ozetTipi == null) break block29;
                    stringBuffer.append(CertStoreOCSPOps.a(27016, 8915));
                    arrayList.add(ozetTipi.getIntValue());
                    if (!bl) break block30;
                }
                stringBuffer.append(CertStoreOCSPOps.a(27017, 10489));
                if (!bl) break block30;
            }
            if (ozetTipi == null) break block30;
            stringBuffer.append(CertStoreOCSPOps.a(27031, -21587));
            arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
            arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
            arrayList.add(ozetTipi.getIntValue());
        }
        byte[] byArray = oCSPSearchTemplate.getOCSPResponderID();
        if (byArray != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27024, 1515));
            arrayList.add(byArray);
        }
        byte[] byArray2 = oCSPSearchTemplate.getOCSPValue();
        if (byArray2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27011, -6979));
            arrayList.add(byArray2);
        }
        Date date = oCSPSearchTemplate.getProducedAtAfter();
        if (date != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27018, -21859));
            arrayList.add(date);
        }
        Date date2 = oCSPSearchTemplate.getProducedAt();
        if (date2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27028, -14855));
            arrayList.add(date2);
        }
        Date date3 = oCSPSearchTemplate.getProducedAtBefore();
        if (date3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27015, -8284));
            arrayList.add(date3);
        }
        byte[] byArray3 = oCSPSearchTemplate.getCertSerialNumber();
        if (byArray3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(27019, -17038));
            arrayList.add(byArray3);
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[25];
                var3_1 = 0;
                var2_2 = "+Z\u00da\\\u00c3d\u00b7\u00c3h\u00f3\u00e8\fr\u0083\u00ee\u00c5\rn\u00e5\u00ac0\u00f5\u00c7\u009b\u0090ET:wX\u00a6e\u00fe\u0093\u0088\u00f3Z\u00b7\u00b8\u00d1\u00ce\u00d3~}\u00efO\u00ee\u00dbbl\u00d4bU\u00034\u00ebc\u000f\u0003\u00e3\u00c0\u00c9\u00c8\u00efA\u009e\"\u00f6\u00a4\u0007\u009d\u00a0\u00c4\u0007yz\u00ab+\u00ac\u000e\u00ff\u00e5\u0019l\u00c6\u00c9\u00be\u00b5Mv5\u00c2K\u00fc\u0010\u00b3\u007f\u00a7\u00b8\u00f6\u00cc\u00d5-b\u0006\u00bc\u00d75$\u000bx5\u00cb\u00ea\u0016\u00dfj\u0088\u009c\u0081\u00d8\u0091@\u00f0\u00a1]N9W\u00d2\"\u00f7X\u0003\u001f\u00e3\u000e\u00b4$\u0087\u00cc0\u001a\u00b6YP\u00d6\u00bb\u00be\u0012h\u00d8X\u00176*\u00f6\u00ebp\u0006\u00f3\u007fppo0[T\u00a6\u00c4Mj3\u0018wq\u00ef\u00b6\u00dd\u00aa=\u0016\u0016\u00e1\u0081\u00f2N\u001d)\u00b4\u00d6J\u00d8\u00d3,\u009a(8f\u00a9AF\u00cd\r\u008c(cL\u000eE\u00df\u00d6b\u0099<\u0081\u00d4\u00e2\u0015:%.\u000b<O&qOkVLB\u00bb\u00b5\u0018,\u008cD\u00c7\u00e7\u00fa\\\u00ea[\u008b!\tsx-\u001bCA)vb\u0085\u00cbH\u00d4\u00ef\u00fa\u0085\u008c\u00f2\f \u0083\u00f6\\\u008cT\u0001\u0012\u009c\u0096\u00f3i*h\u00f5\r\u00c1\u00b6\u0095-\u00da\u008a\u000f\u00c8\u001d\u0097\u00c4\u008e\u00f3w\u00e3\u0007?Z\u00bes\u008d\u008b%6\u0097!\u001d{\u0016|\u00a7\u00b3\u000bK*s\u00a6d5h\u0005\u00ad>@\u000f\u00a5\u00fdI\u00ab\u00aa\u0098\u009d\u00f6\u00a2\u0096\u0094Q\"0\u00c2\u00fb\u00e9\u001bX\u00fd\u00a8\u00da*\u00eek\u00bc\u0012<\u001a=\u001eN\u009bt\u000e\u0081\u00a3.w\u00c9%\u00fe\u00b2aZF\u00d4_9\u008e\u0018d7\u00fb\u0090#b\u00eb@\u00b7\u00f8\u00b9\u0006\u009f\u00ec\u00bd>\b[\u00d3\u001e\u0082e\f\u0006\u00ad\u00ab>\n>*~\u00f7\u008dwN\u00a3\u0094\u00a5\u0001\u00df\u00fe\u00b8S\u0083j\u00ac\u0087\u00bf\u0013m\u00cc3l\u00ae \u00c9\u00f9-\u00a4F\u000b\u00de\u009e(H\u00f5t\u00d5\u001a\u00c2\u00e8\u001a\u00e0_\f\u0013\u00ffFc\u00e6\u00d2gq\u0013\u0080/\u008d\u00d7\u00b3\u00eeZ\u00fd\u0092\u0000W9O?V\u00f0R\u00f1\u0085q.\u00a5 \u00c6k\u00da\u00cd\u00eeiEoK\u00f2\u00ado\u00a6t\u001e?+O\u00166U^\u00ec\u001eD\u001c%3\"\u00bdO\u00030\u00d1\u00cfy^p\u00feJcf\u0091M!u!\u00dc\u00f1\u009a\u009dF\u00a2\u00ee\u00f4hN\u00db\u0091\u0014&7\u00fe\u008e*\u007fN\u00eb\u00e5de\u0013\u00e21\u0083{\u00a6\u00b0(\u00d5@\u009cZ,\\\u001ddl\u00c3\u0013\u00f3\u0087\u000e\u0089\u0099\u0004\u009d16m\u0096\u00dd\u00b6\u0001]\u00b7\u00df\u00b39\fX\u0084\u0015\u00c21n\u00a4\u008fp\b\u00e2\u0085f\u00c1\u0018\u001d\u008b\u00e1\u00cch\u00c8\n\u0004R\u00aau\u0002|\r3\u008e\u009bP`\u00d6+\u00ff@@\u001f\u0090\f\u00dd\u00ce%RA8G\u0005H\u0015\u00d9tf\u00e1}\u0094\u0088CQ+D:M\b\u009f\u0011\u00b3]O\r\t\u00ef7\u00bel\u0088C\u0003\"q\u00bd\u0014j\u00f1\u00d3\u00cb\u00b2\u00d3h@G\u00b5,w\u0098\u00cb\u00ef\u0012\u00ac\u009e\u000b\u00f0\u00863\u00ce\u00f8,\u00d7(\u00e6\u00f8\u00c8\u009c\u00f4[{z'\u008fgA\u00f6\u00ae#d\u0000\u00e9\u00bf\u00a7\u00a2\u00f8i\u00d7\u001dT\r\u00f1\\\u0081\u0085\u00af\u00d1\u00cb\u008c+\\+\u0012\u0097\u00d8\u00a7\n\u0086@H(u\u0083\u00ed\u00c6\u0093g\u0017\u00d6P\u008c\u00c3\u00db\u00c4\u0081P\u00d5\u001b\u00f2\u00a3\u00dd\u00c4\u00a1\u001e\u00c9r]72\u00c2\u00d5v.\u008c\u00f0l9\u0081\u00fb\u00fcf\u00aaA\u00bc\u00b1\u008dUg\u000f\u00ac\u00a7~\u00ae\u00c5\u0084 \u00b0x\u0090L\u00df\u00e2q\u00c5\n6g\u00e6\u0080\u00bc\"A\u00cf\u000f\u0018\u008f\u00f3\u008c\u0015N\u00d4\u00e4]\u00be\u00fbI\u008a\u00e1\u00fc b\u0010\u00cf\u00ef1\u00187K&\u00eatG\b\u0015\u00b0\u00c6sg\u00f4\u00b9\u0092\n\u009aq\u00fd\u0080\u00c4\u00ed'\u00b3{\u0017QTxGAq\u00da\u00b4\u000e\u0087\u00b3\u00f1\u00ee\u001e\u00a1Ew\u0019\u00cd`wr\u00ad\u00ae\u00a2&\u0088\u00c6\u0089\u00ef\u0093P\u0019i\u008d\u00a0\u00c2\u00f1\u009d\u000b:\u0093\u000e\u0010\r\u001c\u00df\u001a\u00b83\u00a55f)\u001b\u00be\u00c3\u0095\u0085\u00ae\u00a0-j\u0081\u00d1\u001e\u0084x\u00bb\u00f0\u00d9S\u00a6X\u00d6\u001f\u00f6\u00c3\u0007\u00c7\u00e5\u00c3[\"\u00be\u00da\"\u0093\u00e9n\u00c0\u00d9\u009b\u00d6\u00bbK\b\u00d3\u0019\u00e6\u008e\u001by\u00a1,\u00ca\u0016t\u00d6\u00d7\u0094U9(>?o+\u0084a\u00dd\u00a5L\u00b37_\u00e45\u00b1\u00b2rW(\u00e9\t\u00f6\u00e6\u00c8\u001e]\u001bI\u00aa+\u00e0\u0001\u0088g?\u00c0\u008c\u0093\u00ee\u00ed\u00c4\u00ab\u001d\u0084@\u00b1}s}\u00fawg\u0084\u0089d\u00da\u00c8\u001c\u00ed\u0018i\u00d4\u0092\u0004\u00a7HY\u0015\u00d6\u00b6Y;\u00e3\u0082m\u0018m\u0080\u001d\n%\u00bc\u0015\u00f3\u00c7\u00e0[yT\u009a\u00a42\u00eb\u00ed%\u0007\u00f9\tg\u009c\u0091\u009cP\u008d\t\u00bd\u00eapK\u00b0e|3\u0018\u00c5f\u0087y\u00c4X\u00eeW\u00ade\u00b9f\u00c7\u0083\u00e1\u00d8\u0010U\u00a1\u0015\u00a8p`\u00f6\u00aa\u0082\u00ff|\u0094\u0004\u00edy\u00d6\u0096h\u0090\u0084\u00ed\u00dd\u00e0j\u008d>1\u008fpj\u00fe0\u00b4\u00d9\u00e0-\u00825\u00ef\u00b1e\u00d9ct\u00f2\u0005\u00bb\u00d2\u0018X\u00a3\u00be\u00a4\u0001\u00d0A\u0096H\u0013,\n\u00b3\u0007\u00e4\u001d\u0083\u00eb\u001eW\u00fc\u00bd\u001e\u00fc\nlfT%-\u00a3\u0085=\u00cf$\u00d8#IW\u0013\u009b\u00a5]H\u00ca\u0015c2\u00b9\u00f3\u0080\u00ackrH\u00e0\u00d8\u00e2O3X\u00ce,\b\u00c5B\u00d6\u0017\u001f\u00a8\u0094\u00f9\u00b8=H\u00f6K\u00b9\u009e\u0001\u0095\u00b2q|\u00cb{\u00ccc\u00aa\u0093\u00a8)\u00a5\u009e\u0019\u0007a~\u00d9\u0007\u0096\u00fc/\u008bz\u0096KE`\u00b0\u0085$\u00f2k\bV\u00f8\u00a1N\u00e89\u0087\u00c8O\u000eq.\u00e1\u008a\u00a2\u00da\u00b1)Y'\u008bQ\u00a1\u00b2v\u00b5\u00d1r\u000b]\u00f8a\u00ae\u00c4}\u00ebp\u00ea\u0096\u001b\u0007\u00ba?\u00faW\u00d910\u0092\u00df\u00e32?\u00e1\u00b8\tS\u009dEN)\u00da\u00f9";
                var4_3 = "+Z\u00da\\\u00c3d\u00b7\u00c3h\u00f3\u00e8\fr\u0083\u00ee\u00c5\rn\u00e5\u00ac0\u00f5\u00c7\u009b\u0090ET:wX\u00a6e\u00fe\u0093\u0088\u00f3Z\u00b7\u00b8\u00d1\u00ce\u00d3~}\u00efO\u00ee\u00dbbl\u00d4bU\u00034\u00ebc\u000f\u0003\u00e3\u00c0\u00c9\u00c8\u00efA\u009e\"\u00f6\u00a4\u0007\u009d\u00a0\u00c4\u0007yz\u00ab+\u00ac\u000e\u00ff\u00e5\u0019l\u00c6\u00c9\u00be\u00b5Mv5\u00c2K\u00fc\u0010\u00b3\u007f\u00a7\u00b8\u00f6\u00cc\u00d5-b\u0006\u00bc\u00d75$\u000bx5\u00cb\u00ea\u0016\u00dfj\u0088\u009c\u0081\u00d8\u0091@\u00f0\u00a1]N9W\u00d2\"\u00f7X\u0003\u001f\u00e3\u000e\u00b4$\u0087\u00cc0\u001a\u00b6YP\u00d6\u00bb\u00be\u0012h\u00d8X\u00176*\u00f6\u00ebp\u0006\u00f3\u007fppo0[T\u00a6\u00c4Mj3\u0018wq\u00ef\u00b6\u00dd\u00aa=\u0016\u0016\u00e1\u0081\u00f2N\u001d)\u00b4\u00d6J\u00d8\u00d3,\u009a(8f\u00a9AF\u00cd\r\u008c(cL\u000eE\u00df\u00d6b\u0099<\u0081\u00d4\u00e2\u0015:%.\u000b<O&qOkVLB\u00bb\u00b5\u0018,\u008cD\u00c7\u00e7\u00fa\\\u00ea[\u008b!\tsx-\u001bCA)vb\u0085\u00cbH\u00d4\u00ef\u00fa\u0085\u008c\u00f2\f \u0083\u00f6\\\u008cT\u0001\u0012\u009c\u0096\u00f3i*h\u00f5\r\u00c1\u00b6\u0095-\u00da\u008a\u000f\u00c8\u001d\u0097\u00c4\u008e\u00f3w\u00e3\u0007?Z\u00bes\u008d\u008b%6\u0097!\u001d{\u0016|\u00a7\u00b3\u000bK*s\u00a6d5h\u0005\u00ad>@\u000f\u00a5\u00fdI\u00ab\u00aa\u0098\u009d\u00f6\u00a2\u0096\u0094Q\"0\u00c2\u00fb\u00e9\u001bX\u00fd\u00a8\u00da*\u00eek\u00bc\u0012<\u001a=\u001eN\u009bt\u000e\u0081\u00a3.w\u00c9%\u00fe\u00b2aZF\u00d4_9\u008e\u0018d7\u00fb\u0090#b\u00eb@\u00b7\u00f8\u00b9\u0006\u009f\u00ec\u00bd>\b[\u00d3\u001e\u0082e\f\u0006\u00ad\u00ab>\n>*~\u00f7\u008dwN\u00a3\u0094\u00a5\u0001\u00df\u00fe\u00b8S\u0083j\u00ac\u0087\u00bf\u0013m\u00cc3l\u00ae \u00c9\u00f9-\u00a4F\u000b\u00de\u009e(H\u00f5t\u00d5\u001a\u00c2\u00e8\u001a\u00e0_\f\u0013\u00ffFc\u00e6\u00d2gq\u0013\u0080/\u008d\u00d7\u00b3\u00eeZ\u00fd\u0092\u0000W9O?V\u00f0R\u00f1\u0085q.\u00a5 \u00c6k\u00da\u00cd\u00eeiEoK\u00f2\u00ado\u00a6t\u001e?+O\u00166U^\u00ec\u001eD\u001c%3\"\u00bdO\u00030\u00d1\u00cfy^p\u00feJcf\u0091M!u!\u00dc\u00f1\u009a\u009dF\u00a2\u00ee\u00f4hN\u00db\u0091\u0014&7\u00fe\u008e*\u007fN\u00eb\u00e5de\u0013\u00e21\u0083{\u00a6\u00b0(\u00d5@\u009cZ,\\\u001ddl\u00c3\u0013\u00f3\u0087\u000e\u0089\u0099\u0004\u009d16m\u0096\u00dd\u00b6\u0001]\u00b7\u00df\u00b39\fX\u0084\u0015\u00c21n\u00a4\u008fp\b\u00e2\u0085f\u00c1\u0018\u001d\u008b\u00e1\u00cch\u00c8\n\u0004R\u00aau\u0002|\r3\u008e\u009bP`\u00d6+\u00ff@@\u001f\u0090\f\u00dd\u00ce%RA8G\u0005H\u0015\u00d9tf\u00e1}\u0094\u0088CQ+D:M\b\u009f\u0011\u00b3]O\r\t\u00ef7\u00bel\u0088C\u0003\"q\u00bd\u0014j\u00f1\u00d3\u00cb\u00b2\u00d3h@G\u00b5,w\u0098\u00cb\u00ef\u0012\u00ac\u009e\u000b\u00f0\u00863\u00ce\u00f8,\u00d7(\u00e6\u00f8\u00c8\u009c\u00f4[{z'\u008fgA\u00f6\u00ae#d\u0000\u00e9\u00bf\u00a7\u00a2\u00f8i\u00d7\u001dT\r\u00f1\\\u0081\u0085\u00af\u00d1\u00cb\u008c+\\+\u0012\u0097\u00d8\u00a7\n\u0086@H(u\u0083\u00ed\u00c6\u0093g\u0017\u00d6P\u008c\u00c3\u00db\u00c4\u0081P\u00d5\u001b\u00f2\u00a3\u00dd\u00c4\u00a1\u001e\u00c9r]72\u00c2\u00d5v.\u008c\u00f0l9\u0081\u00fb\u00fcf\u00aaA\u00bc\u00b1\u008dUg\u000f\u00ac\u00a7~\u00ae\u00c5\u0084 \u00b0x\u0090L\u00df\u00e2q\u00c5\n6g\u00e6\u0080\u00bc\"A\u00cf\u000f\u0018\u008f\u00f3\u008c\u0015N\u00d4\u00e4]\u00be\u00fbI\u008a\u00e1\u00fc b\u0010\u00cf\u00ef1\u00187K&\u00eatG\b\u0015\u00b0\u00c6sg\u00f4\u00b9\u0092\n\u009aq\u00fd\u0080\u00c4\u00ed'\u00b3{\u0017QTxGAq\u00da\u00b4\u000e\u0087\u00b3\u00f1\u00ee\u001e\u00a1Ew\u0019\u00cd`wr\u00ad\u00ae\u00a2&\u0088\u00c6\u0089\u00ef\u0093P\u0019i\u008d\u00a0\u00c2\u00f1\u009d\u000b:\u0093\u000e\u0010\r\u001c\u00df\u001a\u00b83\u00a55f)\u001b\u00be\u00c3\u0095\u0085\u00ae\u00a0-j\u0081\u00d1\u001e\u0084x\u00bb\u00f0\u00d9S\u00a6X\u00d6\u001f\u00f6\u00c3\u0007\u00c7\u00e5\u00c3[\"\u00be\u00da\"\u0093\u00e9n\u00c0\u00d9\u009b\u00d6\u00bbK\b\u00d3\u0019\u00e6\u008e\u001by\u00a1,\u00ca\u0016t\u00d6\u00d7\u0094U9(>?o+\u0084a\u00dd\u00a5L\u00b37_\u00e45\u00b1\u00b2rW(\u00e9\t\u00f6\u00e6\u00c8\u001e]\u001bI\u00aa+\u00e0\u0001\u0088g?\u00c0\u008c\u0093\u00ee\u00ed\u00c4\u00ab\u001d\u0084@\u00b1}s}\u00fawg\u0084\u0089d\u00da\u00c8\u001c\u00ed\u0018i\u00d4\u0092\u0004\u00a7HY\u0015\u00d6\u00b6Y;\u00e3\u0082m\u0018m\u0080\u001d\n%\u00bc\u0015\u00f3\u00c7\u00e0[yT\u009a\u00a42\u00eb\u00ed%\u0007\u00f9\tg\u009c\u0091\u009cP\u008d\t\u00bd\u00eapK\u00b0e|3\u0018\u00c5f\u0087y\u00c4X\u00eeW\u00ade\u00b9f\u00c7\u0083\u00e1\u00d8\u0010U\u00a1\u0015\u00a8p`\u00f6\u00aa\u0082\u00ff|\u0094\u0004\u00edy\u00d6\u0096h\u0090\u0084\u00ed\u00dd\u00e0j\u008d>1\u008fpj\u00fe0\u00b4\u00d9\u00e0-\u00825\u00ef\u00b1e\u00d9ct\u00f2\u0005\u00bb\u00d2\u0018X\u00a3\u00be\u00a4\u0001\u00d0A\u0096H\u0013,\n\u00b3\u0007\u00e4\u001d\u0083\u00eb\u001eW\u00fc\u00bd\u001e\u00fc\nlfT%-\u00a3\u0085=\u00cf$\u00d8#IW\u0013\u009b\u00a5]H\u00ca\u0015c2\u00b9\u00f3\u0080\u00ackrH\u00e0\u00d8\u00e2O3X\u00ce,\b\u00c5B\u00d6\u0017\u001f\u00a8\u0094\u00f9\u00b8=H\u00f6K\u00b9\u009e\u0001\u0095\u00b2q|\u00cb{\u00ccc\u00aa\u0093\u00a8)\u00a5\u009e\u0019\u0007a~\u00d9\u0007\u0096\u00fc/\u008bz\u0096KE`\u00b0\u0085$\u00f2k\bV\u00f8\u00a1N\u00e89\u0087\u00c8O\u000eq.\u00e1\u008a\u00a2\u00da\u00b1)Y'\u008bQ\u00a1\u00b2v\u00b5\u00d1r\u000b]\u00f8a\u00ae\u00c4}\u00ebp\u00ea\u0096\u001b\u0007\u00ba?\u00faW\u00d910\u0092\u00df\u00e32?\u00e1\u00b8\tS\u009dEN)\u00da\u00f9".length();
                var1_4 = 45;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u008aZ\u00fe\u00b2\u00f1\u00f7\u00a6u\u0091\u0011\u0013\u00aaP\u00a8e\u008f#02iD\u008d=aqfV\u009b\u00930f\u00e0\u00ee]\u0083\u00ec;\u001a\u009f\u00ee\u0015\u00bd\u00dad\u0019\u0011] Y(y\u00da\u00bf\u00c3K\u00ac\t.\u0003u\u00d3|";
                    var4_3 = "\u008aZ\u00fe\u00b2\u00f1\u00f7\u00a6u\u0091\u0011\u0013\u00aaP\u00a8e\u008f#02iD\u008d=aqfV\u009b\u00930f\u00e0\u00ee]\u0083\u00ec;\u001a\u009f\u00ee\u0015\u00bd\u00dad\u0019\u0011] Y(y\u00da\u00bf\u00c3K\u00ac\t.\u0003u\u00d3|".length();
                    var1_4 = 58;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 44;
                            break;
                        }
                        case 1: {
                            v13 = 5;
                            break;
                        }
                        case 2: {
                            v13 = 113;
                            break;
                        }
                        case 3: {
                            v13 = 120;
                            break;
                        }
                        case 4: {
                            v13 = 65;
                            break;
                        }
                        case 5: {
                            v13 = 33;
                            break;
                        }
                        default: {
                            v13 = 83;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreOCSPOps.c = var5;
        CertStoreOCSPOps.d = new String[25];
        CertStoreOCSPOps.a = LoggerFactory.getLogger(CertStoreOCSPOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x6985) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 104;
                    break;
                }
                case 1: {
                    n5 = 5;
                    break;
                }
                case 2: {
                    n5 = 133;
                    break;
                }
                case 3: {
                    n5 = 80;
                    break;
                }
                case 4: {
                    n5 = 71;
                    break;
                }
                case 5: {
                    n5 = 16;
                    break;
                }
                case 6: {
                    n5 = 160;
                    break;
                }
                case 7: {
                    n5 = 54;
                    break;
                }
                case 8: {
                    n5 = 110;
                    break;
                }
                case 9: {
                    n5 = 188;
                    break;
                }
                case 10: {
                    n5 = 176;
                    break;
                }
                case 11: {
                    n5 = 70;
                    break;
                }
                case 12: {
                    n5 = 81;
                    break;
                }
                case 13: {
                    n5 = 170;
                    break;
                }
                case 14: {
                    n5 = 203;
                    break;
                }
                case 15: {
                    n5 = 114;
                    break;
                }
                case 16: {
                    n5 = 129;
                    break;
                }
                case 17: {
                    n5 = 30;
                    break;
                }
                case 18: {
                    n5 = 208;
                    break;
                }
                case 19: {
                    n5 = 126;
                    break;
                }
                case 20: {
                    n5 = 172;
                    break;
                }
                case 21: {
                    n5 = 207;
                    break;
                }
                case 22: {
                    n5 = 137;
                    break;
                }
                case 23: {
                    n5 = 181;
                    break;
                }
                case 24: {
                    n5 = 14;
                    break;
                }
                case 25: {
                    n5 = 85;
                    break;
                }
                case 26: {
                    n5 = 164;
                    break;
                }
                case 27: {
                    n5 = 149;
                    break;
                }
                case 28: {
                    n5 = 33;
                    break;
                }
                case 29: {
                    n5 = 0;
                    break;
                }
                case 30: {
                    n5 = 142;
                    break;
                }
                case 31: {
                    n5 = 51;
                    break;
                }
                case 32: {
                    n5 = 12;
                    break;
                }
                case 33: {
                    n5 = 112;
                    break;
                }
                case 34: {
                    n5 = 101;
                    break;
                }
                case 35: {
                    n5 = 211;
                    break;
                }
                case 36: {
                    n5 = 138;
                    break;
                }
                case 37: {
                    n5 = 237;
                    break;
                }
                case 38: {
                    n5 = 103;
                    break;
                }
                case 39: {
                    n5 = 155;
                    break;
                }
                case 40: {
                    n5 = 152;
                    break;
                }
                case 41: {
                    n5 = 210;
                    break;
                }
                case 42: {
                    n5 = 255;
                    break;
                }
                case 43: {
                    n5 = 224;
                    break;
                }
                case 44: {
                    n5 = 205;
                    break;
                }
                case 45: {
                    n5 = 67;
                    break;
                }
                case 46: {
                    n5 = 124;
                    break;
                }
                case 47: {
                    n5 = 62;
                    break;
                }
                case 48: {
                    n5 = 17;
                    break;
                }
                case 49: {
                    n5 = 1;
                    break;
                }
                case 50: {
                    n5 = 175;
                    break;
                }
                case 51: {
                    n5 = 42;
                    break;
                }
                case 52: {
                    n5 = 148;
                    break;
                }
                case 53: {
                    n5 = 99;
                    break;
                }
                case 54: {
                    n5 = 228;
                    break;
                }
                case 55: {
                    n5 = 156;
                    break;
                }
                case 56: {
                    n5 = 41;
                    break;
                }
                case 57: {
                    n5 = 223;
                    break;
                }
                case 58: {
                    n5 = 28;
                    break;
                }
                case 59: {
                    n5 = 125;
                    break;
                }
                case 60: {
                    n5 = 24;
                    break;
                }
                case 61: {
                    n5 = 254;
                    break;
                }
                case 62: {
                    n5 = 196;
                    break;
                }
                case 63: {
                    n5 = 191;
                    break;
                }
                case 64: {
                    n5 = 247;
                    break;
                }
                case 65: {
                    n5 = 92;
                    break;
                }
                case 66: {
                    n5 = 178;
                    break;
                }
                case 67: {
                    n5 = 56;
                    break;
                }
                case 68: {
                    n5 = 238;
                    break;
                }
                case 69: {
                    n5 = 130;
                    break;
                }
                case 70: {
                    n5 = 109;
                    break;
                }
                case 71: {
                    n5 = 239;
                    break;
                }
                case 72: {
                    n5 = 77;
                    break;
                }
                case 73: {
                    n5 = 214;
                    break;
                }
                case 74: {
                    n5 = 6;
                    break;
                }
                case 75: {
                    n5 = 199;
                    break;
                }
                case 76: {
                    n5 = 111;
                    break;
                }
                case 77: {
                    n5 = 122;
                    break;
                }
                case 78: {
                    n5 = 9;
                    break;
                }
                case 79: {
                    n5 = 64;
                    break;
                }
                case 80: {
                    n5 = 45;
                    break;
                }
                case 81: {
                    n5 = 202;
                    break;
                }
                case 82: {
                    n5 = 105;
                    break;
                }
                case 83: {
                    n5 = 185;
                    break;
                }
                case 84: {
                    n5 = 169;
                    break;
                }
                case 85: {
                    n5 = 143;
                    break;
                }
                case 86: {
                    n5 = 189;
                    break;
                }
                case 87: {
                    n5 = 108;
                    break;
                }
                case 88: {
                    n5 = 215;
                    break;
                }
                case 89: {
                    n5 = 74;
                    break;
                }
                case 90: {
                    n5 = 46;
                    break;
                }
                case 91: {
                    n5 = 171;
                    break;
                }
                case 92: {
                    n5 = 229;
                    break;
                }
                case 93: {
                    n5 = 87;
                    break;
                }
                case 94: {
                    n5 = 193;
                    break;
                }
                case 95: {
                    n5 = 117;
                    break;
                }
                case 96: {
                    n5 = 22;
                    break;
                }
                case 97: {
                    n5 = 151;
                    break;
                }
                case 98: {
                    n5 = 98;
                    break;
                }
                case 99: {
                    n5 = 204;
                    break;
                }
                case 100: {
                    n5 = 31;
                    break;
                }
                case 101: {
                    n5 = 73;
                    break;
                }
                case 102: {
                    n5 = 240;
                    break;
                }
                case 103: {
                    n5 = 127;
                    break;
                }
                case 104: {
                    n5 = 184;
                    break;
                }
                case 105: {
                    n5 = 162;
                    break;
                }
                case 106: {
                    n5 = 243;
                    break;
                }
                case 107: {
                    n5 = 145;
                    break;
                }
                case 108: {
                    n5 = 195;
                    break;
                }
                case 109: {
                    n5 = 44;
                    break;
                }
                case 110: {
                    n5 = 245;
                    break;
                }
                case 111: {
                    n5 = 107;
                    break;
                }
                case 112: {
                    n5 = 198;
                    break;
                }
                case 113: {
                    n5 = 96;
                    break;
                }
                case 114: {
                    n5 = 206;
                    break;
                }
                case 115: {
                    n5 = 82;
                    break;
                }
                case 116: {
                    n5 = 226;
                    break;
                }
                case 117: {
                    n5 = 23;
                    break;
                }
                case 118: {
                    n5 = 52;
                    break;
                }
                case 119: {
                    n5 = 40;
                    break;
                }
                case 120: {
                    n5 = 209;
                    break;
                }
                case 121: {
                    n5 = 19;
                    break;
                }
                case 122: {
                    n5 = 141;
                    break;
                }
                case 123: {
                    n5 = 18;
                    break;
                }
                case 124: {
                    n5 = 220;
                    break;
                }
                case 125: {
                    n5 = 167;
                    break;
                }
                case 126: {
                    n5 = 140;
                    break;
                }
                case 127: {
                    n5 = 218;
                    break;
                }
                case 128: {
                    n5 = 250;
                    break;
                }
                case 129: {
                    n5 = 173;
                    break;
                }
                case 130: {
                    n5 = 190;
                    break;
                }
                case 131: {
                    n5 = 69;
                    break;
                }
                case 132: {
                    n5 = 132;
                    break;
                }
                case 133: {
                    n5 = 166;
                    break;
                }
                case 134: {
                    n5 = 75;
                    break;
                }
                case 135: {
                    n5 = 48;
                    break;
                }
                case 136: {
                    n5 = 179;
                    break;
                }
                case 137: {
                    n5 = 144;
                    break;
                }
                case 138: {
                    n5 = 78;
                    break;
                }
                case 139: {
                    n5 = 55;
                    break;
                }
                case 140: {
                    n5 = 38;
                    break;
                }
                case 141: {
                    n5 = 68;
                    break;
                }
                case 142: {
                    n5 = 234;
                    break;
                }
                case 143: {
                    n5 = 4;
                    break;
                }
                case 144: {
                    n5 = 121;
                    break;
                }
                case 145: {
                    n5 = 10;
                    break;
                }
                case 146: {
                    n5 = 235;
                    break;
                }
                case 147: {
                    n5 = 221;
                    break;
                }
                case 148: {
                    n5 = 163;
                    break;
                }
                case 149: {
                    n5 = 79;
                    break;
                }
                case 150: {
                    n5 = 182;
                    break;
                }
                case 151: {
                    n5 = 192;
                    break;
                }
                case 152: {
                    n5 = 59;
                    break;
                }
                case 153: {
                    n5 = 57;
                    break;
                }
                case 154: {
                    n5 = 123;
                    break;
                }
                case 155: {
                    n5 = 34;
                    break;
                }
                case 156: {
                    n5 = 135;
                    break;
                }
                case 157: {
                    n5 = 49;
                    break;
                }
                case 158: {
                    n5 = 100;
                    break;
                }
                case 159: {
                    n5 = 139;
                    break;
                }
                case 160: {
                    n5 = 200;
                    break;
                }
                case 161: {
                    n5 = 227;
                    break;
                }
                case 162: {
                    n5 = 230;
                    break;
                }
                case 163: {
                    n5 = 36;
                    break;
                }
                case 164: {
                    n5 = 11;
                    break;
                }
                case 165: {
                    n5 = 212;
                    break;
                }
                case 166: {
                    n5 = 76;
                    break;
                }
                case 167: {
                    n5 = 249;
                    break;
                }
                case 168: {
                    n5 = 39;
                    break;
                }
                case 169: {
                    n5 = 153;
                    break;
                }
                case 170: {
                    n5 = 97;
                    break;
                }
                case 171: {
                    n5 = 233;
                    break;
                }
                case 172: {
                    n5 = 60;
                    break;
                }
                case 173: {
                    n5 = 90;
                    break;
                }
                case 174: {
                    n5 = 86;
                    break;
                }
                case 175: {
                    n5 = 136;
                    break;
                }
                case 176: {
                    n5 = 244;
                    break;
                }
                case 177: {
                    n5 = 61;
                    break;
                }
                case 178: {
                    n5 = 106;
                    break;
                }
                case 179: {
                    n5 = 253;
                    break;
                }
                case 180: {
                    n5 = 115;
                    break;
                }
                case 181: {
                    n5 = 95;
                    break;
                }
                case 182: {
                    n5 = 246;
                    break;
                }
                case 183: {
                    n5 = 180;
                    break;
                }
                case 184: {
                    n5 = 27;
                    break;
                }
                case 185: {
                    n5 = 217;
                    break;
                }
                case 186: {
                    n5 = 63;
                    break;
                }
                case 187: {
                    n5 = 158;
                    break;
                }
                case 188: {
                    n5 = 183;
                    break;
                }
                case 189: {
                    n5 = 131;
                    break;
                }
                case 190: {
                    n5 = 186;
                    break;
                }
                case 191: {
                    n5 = 194;
                    break;
                }
                case 192: {
                    n5 = 147;
                    break;
                }
                case 193: {
                    n5 = 216;
                    break;
                }
                case 194: {
                    n5 = 219;
                    break;
                }
                case 195: {
                    n5 = 2;
                    break;
                }
                case 196: {
                    n5 = 13;
                    break;
                }
                case 197: {
                    n5 = 113;
                    break;
                }
                case 198: {
                    n5 = 21;
                    break;
                }
                case 199: {
                    n5 = 168;
                    break;
                }
                case 200: {
                    n5 = 119;
                    break;
                }
                case 201: {
                    n5 = 50;
                    break;
                }
                case 202: {
                    n5 = 83;
                    break;
                }
                case 203: {
                    n5 = 236;
                    break;
                }
                case 204: {
                    n5 = 72;
                    break;
                }
                case 205: {
                    n5 = 37;
                    break;
                }
                case 206: {
                    n5 = 225;
                    break;
                }
                case 207: {
                    n5 = 222;
                    break;
                }
                case 208: {
                    n5 = 15;
                    break;
                }
                case 209: {
                    n5 = 53;
                    break;
                }
                case 210: {
                    n5 = 201;
                    break;
                }
                case 211: {
                    n5 = 187;
                    break;
                }
                case 212: {
                    n5 = 232;
                    break;
                }
                case 213: {
                    n5 = 66;
                    break;
                }
                case 214: {
                    n5 = 93;
                    break;
                }
                case 215: {
                    n5 = 91;
                    break;
                }
                case 216: {
                    n5 = 65;
                    break;
                }
                case 217: {
                    n5 = 102;
                    break;
                }
                case 218: {
                    n5 = 150;
                    break;
                }
                case 219: {
                    n5 = 25;
                    break;
                }
                case 220: {
                    n5 = 177;
                    break;
                }
                case 221: {
                    n5 = 116;
                    break;
                }
                case 222: {
                    n5 = 251;
                    break;
                }
                case 223: {
                    n5 = 241;
                    break;
                }
                case 224: {
                    n5 = 94;
                    break;
                }
                case 225: {
                    n5 = 58;
                    break;
                }
                case 226: {
                    n5 = 29;
                    break;
                }
                case 227: {
                    n5 = 197;
                    break;
                }
                case 228: {
                    n5 = 146;
                    break;
                }
                case 229: {
                    n5 = 242;
                    break;
                }
                case 230: {
                    n5 = 35;
                    break;
                }
                case 231: {
                    n5 = 120;
                    break;
                }
                case 232: {
                    n5 = 231;
                    break;
                }
                case 233: {
                    n5 = 32;
                    break;
                }
                case 234: {
                    n5 = 154;
                    break;
                }
                case 235: {
                    n5 = 7;
                    break;
                }
                case 236: {
                    n5 = 159;
                    break;
                }
                case 237: {
                    n5 = 47;
                    break;
                }
                case 238: {
                    n5 = 248;
                    break;
                }
                case 239: {
                    n5 = 165;
                    break;
                }
                case 240: {
                    n5 = 20;
                    break;
                }
                case 241: {
                    n5 = 174;
                    break;
                }
                case 242: {
                    n5 = 26;
                    break;
                }
                case 243: {
                    n5 = 252;
                    break;
                }
                case 244: {
                    n5 = 161;
                    break;
                }
                case 245: {
                    n5 = 43;
                    break;
                }
                case 246: {
                    n5 = 157;
                    break;
                }
                case 247: {
                    n5 = 84;
                    break;
                }
                case 248: {
                    n5 = 213;
                    break;
                }
                case 249: {
                    n5 = 89;
                    break;
                }
                case 250: {
                    n5 = 3;
                    break;
                }
                case 251: {
                    n5 = 8;
                    break;
                }
                case 252: {
                    n5 = 128;
                    break;
                }
                case 253: {
                    n5 = 134;
                    break;
                }
                case 254: {
                    n5 = 88;
                    break;
                }
                default: {
                    n5 = 118;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreOCSPOps.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

