/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.alg;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.algorithms._aesValues;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Mod;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.OAEPPadding;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Padding;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithGCMSpec;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithIV;
import tr.gov.tubitak.uekae.esya.asn.algorithms.GCMParameters;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;

public class CipherAlg
implements Algorithm {
    private static Map<OID, CipherAlg> a;
    private static Map<String, CipherAlg> b;
    public static final CipherAlg AES128_CBC;
    public static final CipherAlg AES128_CFB;
    public static final CipherAlg AES128_ECB;
    public static final CipherAlg AES128_OFB;
    public static final CipherAlg AES128_GCM;
    public static final CipherAlg AES192_CBC;
    public static final CipherAlg AES192_CFB;
    public static final CipherAlg AES192_ECB;
    public static final CipherAlg AES192_OFB;
    public static final CipherAlg AES192_GCM;
    public static final CipherAlg AES256_CBC;
    public static final CipherAlg AES256_CFB;
    public static final CipherAlg AES256_ECB;
    public static final CipherAlg AES256_OFB;
    public static final CipherAlg AES256_GCM;
    public static final CipherAlg RC2_CBC;
    public static final CipherAlg DES_EDE3_CBC;
    public static final CipherAlg RSA_PKCS1;
    public static final CipherAlg RSA_RAW;
    @Deprecated
    public static final CipherAlg RSA_OAEP;
    public static final CipherAlg RSA_ECB_PKCS1;
    @Deprecated
    public static final CipherAlg RSA_ECB_OAEP;
    public static final CipherAlg RSA_OAEP_SHA256;
    public static final CipherAlg RSA_OAEP_SHA512;
    protected int[] mOID;
    protected String mName;
    protected int mBlockSize;
    protected Mod mMod;
    protected Padding mPadding;
    public static boolean c;
    private static final String[] f;
    private static final String[] g;

    public CipherAlg(int[] aOId, String aName, int aBlockSize, Mod aMod, Padding aPadding) {
        this.mOID = aOId;
        this.mName = aName;
        this.mBlockSize = aBlockSize;
        this.mMod = aMod;
        this.mPadding = aPadding;
        if (aOId != null) {
            OID oID = new OID(aOId);
            a.put(oID, this);
        }
        b.put(aName, this);
    }

    @Override
    public int[] getOID() {
        return this.mOID;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public Mod getMod() {
        return this.mMod;
    }

    public Padding getPadding() {
        return this.mPadding;
    }

    public EAlgorithmIdentifier toAlgorithmIdentifier(byte[] aIV) throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = new EAlgorithmIdentifier(new AlgorithmIdentifier());
        eAlgorithmIdentifier.setAlgorithm(new Asn1ObjectIdentifier(this.getOID()));
        if (aIV != null) {
            try {
                Asn1OctetString asn1OctetString = new Asn1OctetString(aIV);
                Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                Asn1OpenType asn1OpenType = new Asn1OpenType(asn1DerEncodeBuffer.getMsgCopy());
                eAlgorithmIdentifier.setParameters(asn1OpenType);
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(CipherAlg.a(29706, 26642), asn1Exception);
            }
        }
        return eAlgorithmIdentifier;
    }

    public static CipherAlg fromOID(int[] aOid) {
        OID oID = new OID(aOid);
        return a.get(oID);
    }

    public static CipherAlg fromName(String aAlgName) {
        return b.get(aAlgName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<CipherAlg, AlgorithmParams> fromAlgorithmIdentifier(EAlgorithmIdentifier aAlgoritma) throws CryptoException {
        CipherAlg cipherAlg;
        int[] nArray = aAlgoritma.getAlgorithm().value;
        Asn1OpenType asn1OpenType = aAlgoritma.getParameters();
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        ParamsWithIV paramsWithIV = null;
        if (Arrays.equals(nArray, _algorithmsValues.id_RSAES_OAEP)) {
            try {
                OAEPPadding oAEPPadding = null;
                if (asn1OpenType.equals(new byte[]{48, 0})) {
                    oAEPPadding = OAEPPadding.OAEP_SHA1_MGF1;
                    return new Pair((Object)new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(29700, 30582), 0, Mod.NONE, oAEPPadding), null);
                }
                oAEPPadding = OAEPPadding.fromRSAES_OAEP_params(asn1OpenType.value);
                return new Pair((Object)new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(29700, 30582), 0, Mod.NONE, oAEPPadding), null);
            }
            catch (IOException iOException) {
                throw new CryptoException(CipherAlg.a(29702, 530), iOException);
            }
        }
        if (asn1OpenType != null && asn1OpenType.value.length > 1 && (asn1OpenType.value[0] != 5 || asn1OpenType.value[1] != 0)) {
            try {
                if (CipherAlg.isGCMOID(nArray)) {
                    cipherAlg = new Asn1DerDecodeBuffer(asn1OpenType.value);
                    GCMParameters gCMParameters = new GCMParameters();
                    gCMParameters.decode((Asn1BerDecodeBuffer)cipherAlg);
                    asn1OctetString = gCMParameters.aes_nonce;
                    paramsWithIV = new ParamsWithGCMSpec(asn1OctetString.value);
                } else {
                    cipherAlg = new Asn1DerEncodeBuffer();
                    asn1OpenType.encode((Asn1BerEncodeBuffer)cipherAlg);
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(cipherAlg.getMsgCopy());
                    asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                    paramsWithIV = new ParamsWithIV(asn1OctetString.value);
                }
            }
            catch (Asn1Exception asn1Exception) {
                throw new CryptoException(CipherAlg.a(29707, -9599), asn1Exception);
            }
            catch (IOException iOException) {
                throw new CryptoException(CipherAlg.a(29704, -19506), iOException);
            }
        }
        cipherAlg = CipherAlg.fromOID(nArray);
        return new Pair((Object)new CipherAlg(cipherAlg.getOID(), cipherAlg.getName(), cipherAlg.getBlockSize(), cipherAlg.getMod(), cipherAlg.getPadding()), paramsWithIV);
    }

    public static boolean isGCMOID(int[] oid) {
        block7: {
            block6: {
                if (Arrays.equals(oid, _aesValues.id_aes128_GCM) || Arrays.equals(oid, _aesValues.id_aes192_GCM)) break block6;
                if (!Arrays.equals(oid, _aesValues.id_aes256_GCM)) break block7;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        CipherAlg cipherAlg;
        block28: {
            block27: {
                block26: {
                    if (this == o) {
                        return true;
                    }
                    if (o != null && this.getClass() == o.getClass()) break block26;
                    return false;
                }
                cipherAlg = (CipherAlg)o;
                if (this.mBlockSize != cipherAlg.mBlockSize) {
                    return false;
                }
                if (this.mMod != cipherAlg.mMod) {
                    return false;
                }
                if (this.mName == null) break block27;
                if (this.mName.equals(cipherAlg.mName)) break block28;
                return false;
            }
            if (cipherAlg.mName == null) break block28;
            return false;
        }
        if (!Arrays.equals(this.mOID, cipherAlg.mOID)) {
            return false;
        }
        if (this.mPadding == cipherAlg.mPadding) return true;
        return false;
    }

    public int hashCode() {
        int n;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    boolean bl2 = DigestAlg.e;
                    int n2 = this.mOID != null ? Arrays.hashCode(this.mOID) : 0;
                    int n3 = n2;
                    int n4 = 31 * n3;
                    int n5 = this.mName != null ? this.mName.hashCode() : 0;
                    n3 = n4 + n5;
                    n3 = 31 * n3 + this.mBlockSize;
                    int n6 = 31 * n3;
                    int n7 = this.mMod != null ? this.mMod.hashCode() : 0;
                    n3 = n6 + n7;
                    int n8 = 31 * n3;
                    int n9 = this.mPadding != null ? this.mPadding.hashCode() : 0;
                    n3 = n8 + n9;
                    n = n3;
                    if (!bl2) break block12;
                    if (!CryptoException.b) break block13;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            CryptoException.b = bl;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[13];
                var3_1 = 0;
                var2_2 = "\u007f/\b{\u00a1\u00973QSf\u00e9*Q\u00143{\u00f2\u00e3\u00ee\u0089{T\u0089\u00e5 \u00c8M\u00b4&Zq\u00a5\u00e1e\u000e\u00c6GLd9y\u0081J\u00d69\u00c1\u00a99@\r\u00c2\u00ea\u00cc\u00d1)\u00cf\u0083\u009c\u0096\u00fc\u00c3\u00eb11><\u0004\u0093\u00ee\u00e9\u00fa\u0097\u0086z\u00e3\u001b!y\u0082\u00a7\u001b\u0087\u001e\u00f2\u00ec \u0092\u013ed\u00de\\\u00a8(\u0013\u01b4w\u0127O\u00f76\u00d8\u00e2J\u008e(\u0092Y>\u00ae\u00aa\u01fc\u008a1\f/\u00f7qr\u0095\u00b7rtE\u00c8\u00d1\u00b7\u001d\u00e5\u000bv\u00d7\u00da\u00f4c0ZGt\u00dam\u0094y\u00fc$\u00cd\u00b2\u008c(;\u0091\u0084\u00e5c\u00fcl\u00cd1\u00ecb^X\u00a5\u0090\u0093\u00b8\u00ab\u009fF\u00a7\u0095\u00ee\u0014U\u00c9\u00d9D9\u00a7Y\u00fb\u0111I;\u00f9\u0014\u009c\u0084\u0122\u0085\u01f5\u0011\u00ad\u00fd\u0093\u009b#\u00a1\u0005w\u00fc\u0082\u001a=\u016ax\u00e3\r\u00af\u00a5a8\u009c\u00f25;@\b\u0019uj\u000e\u00ee\u00ff\u0000\u00faUUMD\u00c2>CIiZ:\u00e5\u00f2\u007fJ\u0081\u00d2\u0017\u00f0;\u0096T\u0086\u00d7\u00ca\\\u00d1\u00c0Ic<\u00e08\u009f\u00e0,\u0087\u00d9\u00ce\u0095#\u00c4a_\u00f0\u00178\u00b0\u00ef\u00c4\u0116g\u018b\u00bbC\u00e3\u009a\u0002\u00e8j\u008a/F]\u0017,\u0133\u00ac\u00e9";
                var4_3 = "\u007f/\b{\u00a1\u00973QSf\u00e9*Q\u00143{\u00f2\u00e3\u00ee\u0089{T\u0089\u00e5 \u00c8M\u00b4&Zq\u00a5\u00e1e\u000e\u00c6GLd9y\u0081J\u00d69\u00c1\u00a99@\r\u00c2\u00ea\u00cc\u00d1)\u00cf\u0083\u009c\u0096\u00fc\u00c3\u00eb11><\u0004\u0093\u00ee\u00e9\u00fa\u0097\u0086z\u00e3\u001b!y\u0082\u00a7\u001b\u0087\u001e\u00f2\u00ec \u0092\u013ed\u00de\\\u00a8(\u0013\u01b4w\u0127O\u00f76\u00d8\u00e2J\u008e(\u0092Y>\u00ae\u00aa\u01fc\u008a1\f/\u00f7qr\u0095\u00b7rtE\u00c8\u00d1\u00b7\u001d\u00e5\u000bv\u00d7\u00da\u00f4c0ZGt\u00dam\u0094y\u00fc$\u00cd\u00b2\u008c(;\u0091\u0084\u00e5c\u00fcl\u00cd1\u00ecb^X\u00a5\u0090\u0093\u00b8\u00ab\u009fF\u00a7\u0095\u00ee\u0014U\u00c9\u00d9D9\u00a7Y\u00fb\u0111I;\u00f9\u0014\u009c\u0084\u0122\u0085\u01f5\u0011\u00ad\u00fd\u0093\u009b#\u00a1\u0005w\u00fc\u0082\u001a=\u016ax\u00e3\r\u00af\u00a5a8\u009c\u00f25;@\b\u0019uj\u000e\u00ee\u00ff\u0000\u00faUUMD\u00c2>CIiZ:\u00e5\u00f2\u007fJ\u0081\u00d2\u0017\u00f0;\u0096T\u0086\u00d7\u00ca\\\u00d1\u00c0Ic<\u00e08\u009f\u00e0,\u0087\u00d9\u00ce\u0095#\u00c4a_\u00f0\u00178\u00b0\u00ef\u00c4\u0116g\u018b\u00bbC\u00e3\u009a\u0002\u00e8j\u008a/F]\u0017,\u0133\u00ac\u00e9".length();
                var1_4 = 13;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0091T\u00a6\u0006d5*\u00c3\u00a3\u0017e\u0096\u00e5\u007f3#\u00d3\u008d\u00b1\u0083\r\u00ba\u00c7\u00c3t\u00c3w\u00b8l\u0003\u00c1\u00e3\u00de\u0016";
                    var4_3 = "\u0091T\u00a6\u0006d5*\u00c3\u00a3\u0017e\u0096\u00e5\u007f3#\u00d3\u008d\u00b1\u0083\r\u00ba\u00c7\u00c3t\u00c3w\u00b8l\u0003\u00c1\u00e3\u00de\u0016".length();
                    var1_4 = 20;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 69;
                            break;
                        }
                        case 1: {
                            v13 = 79;
                            break;
                        }
                        case 2: {
                            v13 = 101;
                            break;
                        }
                        case 3: {
                            v13 = 115;
                            break;
                        }
                        case 4: {
                            v13 = 59;
                            break;
                        }
                        case 5: {
                            v13 = 30;
                            break;
                        }
                        default: {
                            v13 = 8;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CipherAlg.f = var5;
        CipherAlg.g = new String[13];
        CipherAlg.a = new HashMap<OID, CipherAlg>();
        CipherAlg.b = new HashMap<String, CipherAlg>();
        CipherAlg.AES128_CBC = new CipherAlg(_aesValues.id_aes128_CBC, Algorithms.CIPHER_AES128_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES128_CFB = new CipherAlg(_aesValues.id_aes128_CFB, Algorithms.CIPHER_AES128_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES128_ECB = new CipherAlg(_aesValues.id_aes128_ECB, Algorithms.CIPHER_AES128_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES128_OFB = new CipherAlg(_aesValues.id_aes128_OFB, Algorithms.CIPHER_AES128_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES128_GCM = new CipherAlg(_aesValues.id_aes128_GCM, Algorithms.CIPHER_AES128_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.AES192_CBC = new CipherAlg(_aesValues.id_aes192_CBC, Algorithms.CIPHER_AES192_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES192_CFB = new CipherAlg(_aesValues.id_aes192_CFB, Algorithms.CIPHER_AES192_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES192_ECB = new CipherAlg(_aesValues.id_aes192_ECB, Algorithms.CIPHER_AES192_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES192_OFB = new CipherAlg(_aesValues.id_aes192_OFB, Algorithms.CIPHER_AES192_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES192_GCM = new CipherAlg(_aesValues.id_aes192_GCM, Algorithms.CIPHER_AES192_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.AES256_CBC = new CipherAlg(_aesValues.id_aes256_CBC, Algorithms.CIPHER_AES256_CBC, 16, Mod.CBC, Padding.PKCS7);
        CipherAlg.AES256_CFB = new CipherAlg(_aesValues.id_aes256_CFB, Algorithms.CIPHER_AES256_CFB, 16, Mod.CFB, Padding.PKCS7);
        CipherAlg.AES256_ECB = new CipherAlg(_aesValues.id_aes256_ECB, Algorithms.CIPHER_AES256_ECB, 16, Mod.ECB, Padding.PKCS7);
        CipherAlg.AES256_OFB = new CipherAlg(_aesValues.id_aes256_OFB, Algorithms.CIPHER_AES256_OFB, 16, Mod.OFB, Padding.PKCS7);
        CipherAlg.AES256_GCM = new CipherAlg(_aesValues.id_aes256_GCM, Algorithms.CIPHER_AES256_GCM, 16, Mod.GCM, Padding.NONE);
        CipherAlg.RC2_CBC = new CipherAlg(_algorithmsValues.rc2_cbc, CipherAlg.a(29708, 18316), 8, Mod.CBC, Padding.PKCS7);
        CipherAlg.DES_EDE3_CBC = new CipherAlg(_algorithmsValues.des_ede3_cbc, CipherAlg.a(29701, 17640), 8, Mod.CBC, Padding.PKCS7);
        CipherAlg.RSA_PKCS1 = new CipherAlg(_algorithmsValues.rsaEncryption, CipherAlg.a(29710, 19907), 0, Mod.NONE, Padding.PKCS1);
        CipherAlg.RSA_RAW = new CipherAlg(null, Algorithms.CIPHER_RSA_RAW, 0, Mod.NONE, null);
        CipherAlg.RSA_OAEP = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(29711, 6134), 0, Mod.NONE, OAEPPadding.OAEP_SHA1_MGF1);
        CipherAlg.RSA_ECB_PKCS1 = new CipherAlg(null, CipherAlg.a(29696, 724), 0, Mod.ECB, Padding.PKCS1);
        CipherAlg.RSA_ECB_OAEP = new CipherAlg(null, CipherAlg.a(29705, 11642), 0, Mod.ECB, OAEPPadding.OAEP_SHA1_MGF1);
        CipherAlg.RSA_OAEP_SHA256 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(29703, 12141), 0, Mod.NONE, OAEPPadding.OAEP_SHA256_MGF1);
        CipherAlg.RSA_OAEP_SHA512 = new CipherAlg(_algorithmsValues.id_RSAES_OAEP, CipherAlg.a(29709, 24862), 0, Mod.NONE, OAEPPadding.OAEP_SHA512_MGF1);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x740C) & 0xFFFF;
        if (g[n3] == null) {
            int n4;
            int n5;
            char[] cArray = f[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 97;
                    break;
                }
                case 1: {
                    n5 = 191;
                    break;
                }
                case 2: {
                    n5 = 235;
                    break;
                }
                case 3: {
                    n5 = 211;
                    break;
                }
                case 4: {
                    n5 = 245;
                    break;
                }
                case 5: {
                    n5 = 30;
                    break;
                }
                case 6: {
                    n5 = 164;
                    break;
                }
                case 7: {
                    n5 = 61;
                    break;
                }
                case 8: {
                    n5 = 210;
                    break;
                }
                case 9: {
                    n5 = 237;
                    break;
                }
                case 10: {
                    n5 = 253;
                    break;
                }
                case 11: {
                    n5 = 19;
                    break;
                }
                case 12: {
                    n5 = 88;
                    break;
                }
                case 13: {
                    n5 = 5;
                    break;
                }
                case 14: {
                    n5 = 219;
                    break;
                }
                case 15: {
                    n5 = 126;
                    break;
                }
                case 16: {
                    n5 = 204;
                    break;
                }
                case 17: {
                    n5 = 251;
                    break;
                }
                case 18: {
                    n5 = 124;
                    break;
                }
                case 19: {
                    n5 = 29;
                    break;
                }
                case 20: {
                    n5 = 194;
                    break;
                }
                case 21: {
                    n5 = 55;
                    break;
                }
                case 22: {
                    n5 = 69;
                    break;
                }
                case 23: {
                    n5 = 223;
                    break;
                }
                case 24: {
                    n5 = 12;
                    break;
                }
                case 25: {
                    n5 = 180;
                    break;
                }
                case 26: {
                    n5 = 169;
                    break;
                }
                case 27: {
                    n5 = 102;
                    break;
                }
                case 28: {
                    n5 = 187;
                    break;
                }
                case 29: {
                    n5 = 152;
                    break;
                }
                case 30: {
                    n5 = 100;
                    break;
                }
                case 31: {
                    n5 = 196;
                    break;
                }
                case 32: {
                    n5 = 0;
                    break;
                }
                case 33: {
                    n5 = 59;
                    break;
                }
                case 34: {
                    n5 = 146;
                    break;
                }
                case 35: {
                    n5 = 157;
                    break;
                }
                case 36: {
                    n5 = 182;
                    break;
                }
                case 37: {
                    n5 = 25;
                    break;
                }
                case 38: {
                    n5 = 224;
                    break;
                }
                case 39: {
                    n5 = 127;
                    break;
                }
                case 40: {
                    n5 = 161;
                    break;
                }
                case 41: {
                    n5 = 225;
                    break;
                }
                case 42: {
                    n5 = 65;
                    break;
                }
                case 43: {
                    n5 = 41;
                    break;
                }
                case 44: {
                    n5 = 234;
                    break;
                }
                case 45: {
                    n5 = 220;
                    break;
                }
                case 46: {
                    n5 = 52;
                    break;
                }
                case 47: {
                    n5 = 229;
                    break;
                }
                case 48: {
                    n5 = 159;
                    break;
                }
                case 49: {
                    n5 = 86;
                    break;
                }
                case 50: {
                    n5 = 119;
                    break;
                }
                case 51: {
                    n5 = 107;
                    break;
                }
                case 52: {
                    n5 = 40;
                    break;
                }
                case 53: {
                    n5 = 144;
                    break;
                }
                case 54: {
                    n5 = 195;
                    break;
                }
                case 55: {
                    n5 = 91;
                    break;
                }
                case 56: {
                    n5 = 37;
                    break;
                }
                case 57: {
                    n5 = 84;
                    break;
                }
                case 58: {
                    n5 = 36;
                    break;
                }
                case 59: {
                    n5 = 212;
                    break;
                }
                case 60: {
                    n5 = 138;
                    break;
                }
                case 61: {
                    n5 = 255;
                    break;
                }
                case 62: {
                    n5 = 132;
                    break;
                }
                case 63: {
                    n5 = 114;
                    break;
                }
                case 64: {
                    n5 = 128;
                    break;
                }
                case 65: {
                    n5 = 254;
                    break;
                }
                case 66: {
                    n5 = 17;
                    break;
                }
                case 67: {
                    n5 = 236;
                    break;
                }
                case 68: {
                    n5 = 92;
                    break;
                }
                case 69: {
                    n5 = 105;
                    break;
                }
                case 70: {
                    n5 = 51;
                    break;
                }
                case 71: {
                    n5 = 67;
                    break;
                }
                case 72: {
                    n5 = 238;
                    break;
                }
                case 73: {
                    n5 = 13;
                    break;
                }
                case 74: {
                    n5 = 42;
                    break;
                }
                case 75: {
                    n5 = 21;
                    break;
                }
                case 76: {
                    n5 = 95;
                    break;
                }
                case 77: {
                    n5 = 172;
                    break;
                }
                case 78: {
                    n5 = 130;
                    break;
                }
                case 79: {
                    n5 = 75;
                    break;
                }
                case 80: {
                    n5 = 82;
                    break;
                }
                case 81: {
                    n5 = 53;
                    break;
                }
                case 82: {
                    n5 = 192;
                    break;
                }
                case 83: {
                    n5 = 89;
                    break;
                }
                case 84: {
                    n5 = 1;
                    break;
                }
                case 85: {
                    n5 = 154;
                    break;
                }
                case 86: {
                    n5 = 215;
                    break;
                }
                case 87: {
                    n5 = 93;
                    break;
                }
                case 88: {
                    n5 = 178;
                    break;
                }
                case 89: {
                    n5 = 150;
                    break;
                }
                case 90: {
                    n5 = 101;
                    break;
                }
                case 91: {
                    n5 = 165;
                    break;
                }
                case 92: {
                    n5 = 38;
                    break;
                }
                case 93: {
                    n5 = 26;
                    break;
                }
                case 94: {
                    n5 = 189;
                    break;
                }
                case 95: {
                    n5 = 181;
                    break;
                }
                case 96: {
                    n5 = 158;
                    break;
                }
                case 97: {
                    n5 = 243;
                    break;
                }
                case 98: {
                    n5 = 137;
                    break;
                }
                case 99: {
                    n5 = 162;
                    break;
                }
                case 100: {
                    n5 = 199;
                    break;
                }
                case 101: {
                    n5 = 96;
                    break;
                }
                case 102: {
                    n5 = 142;
                    break;
                }
                case 103: {
                    n5 = 85;
                    break;
                }
                case 104: {
                    n5 = 177;
                    break;
                }
                case 105: {
                    n5 = 239;
                    break;
                }
                case 106: {
                    n5 = 66;
                    break;
                }
                case 107: {
                    n5 = 151;
                    break;
                }
                case 108: {
                    n5 = 109;
                    break;
                }
                case 109: {
                    n5 = 163;
                    break;
                }
                case 110: {
                    n5 = 125;
                    break;
                }
                case 111: {
                    n5 = 188;
                    break;
                }
                case 112: {
                    n5 = 120;
                    break;
                }
                case 113: {
                    n5 = 121;
                    break;
                }
                case 114: {
                    n5 = 117;
                    break;
                }
                case 115: {
                    n5 = 116;
                    break;
                }
                case 116: {
                    n5 = 98;
                    break;
                }
                case 117: {
                    n5 = 9;
                    break;
                }
                case 118: {
                    n5 = 250;
                    break;
                }
                case 119: {
                    n5 = 2;
                    break;
                }
                case 120: {
                    n5 = 193;
                    break;
                }
                case 121: {
                    n5 = 48;
                    break;
                }
                case 122: {
                    n5 = 218;
                    break;
                }
                case 123: {
                    n5 = 148;
                    break;
                }
                case 124: {
                    n5 = 34;
                    break;
                }
                case 125: {
                    n5 = 106;
                    break;
                }
                case 126: {
                    n5 = 63;
                    break;
                }
                case 127: {
                    n5 = 141;
                    break;
                }
                case 128: {
                    n5 = 221;
                    break;
                }
                case 129: {
                    n5 = 133;
                    break;
                }
                case 130: {
                    n5 = 83;
                    break;
                }
                case 131: {
                    n5 = 242;
                    break;
                }
                case 132: {
                    n5 = 76;
                    break;
                }
                case 133: {
                    n5 = 230;
                    break;
                }
                case 134: {
                    n5 = 170;
                    break;
                }
                case 135: {
                    n5 = 33;
                    break;
                }
                case 136: {
                    n5 = 57;
                    break;
                }
                case 137: {
                    n5 = 54;
                    break;
                }
                case 138: {
                    n5 = 201;
                    break;
                }
                case 139: {
                    n5 = 23;
                    break;
                }
                case 140: {
                    n5 = 208;
                    break;
                }
                case 141: {
                    n5 = 140;
                    break;
                }
                case 142: {
                    n5 = 168;
                    break;
                }
                case 143: {
                    n5 = 226;
                    break;
                }
                case 144: {
                    n5 = 46;
                    break;
                }
                case 145: {
                    n5 = 184;
                    break;
                }
                case 146: {
                    n5 = 43;
                    break;
                }
                case 147: {
                    n5 = 90;
                    break;
                }
                case 148: {
                    n5 = 227;
                    break;
                }
                case 149: {
                    n5 = 64;
                    break;
                }
                case 150: {
                    n5 = 179;
                    break;
                }
                case 151: {
                    n5 = 143;
                    break;
                }
                case 152: {
                    n5 = 173;
                    break;
                }
                case 153: {
                    n5 = 167;
                    break;
                }
                case 154: {
                    n5 = 160;
                    break;
                }
                case 155: {
                    n5 = 18;
                    break;
                }
                case 156: {
                    n5 = 249;
                    break;
                }
                case 157: {
                    n5 = 113;
                    break;
                }
                case 158: {
                    n5 = 56;
                    break;
                }
                case 159: {
                    n5 = 206;
                    break;
                }
                case 160: {
                    n5 = 49;
                    break;
                }
                case 161: {
                    n5 = 22;
                    break;
                }
                case 162: {
                    n5 = 68;
                    break;
                }
                case 163: {
                    n5 = 108;
                    break;
                }
                case 164: {
                    n5 = 11;
                    break;
                }
                case 165: {
                    n5 = 27;
                    break;
                }
                case 166: {
                    n5 = 115;
                    break;
                }
                case 167: {
                    n5 = 202;
                    break;
                }
                case 168: {
                    n5 = 246;
                    break;
                }
                case 169: {
                    n5 = 153;
                    break;
                }
                case 170: {
                    n5 = 78;
                    break;
                }
                case 171: {
                    n5 = 80;
                    break;
                }
                case 172: {
                    n5 = 248;
                    break;
                }
                case 173: {
                    n5 = 129;
                    break;
                }
                case 174: {
                    n5 = 155;
                    break;
                }
                case 175: {
                    n5 = 20;
                    break;
                }
                case 176: {
                    n5 = 60;
                    break;
                }
                case 177: {
                    n5 = 232;
                    break;
                }
                case 178: {
                    n5 = 94;
                    break;
                }
                case 179: {
                    n5 = 47;
                    break;
                }
                case 180: {
                    n5 = 50;
                    break;
                }
                case 181: {
                    n5 = 197;
                    break;
                }
                case 182: {
                    n5 = 241;
                    break;
                }
                case 183: {
                    n5 = 205;
                    break;
                }
                case 184: {
                    n5 = 44;
                    break;
                }
                case 185: {
                    n5 = 111;
                    break;
                }
                case 186: {
                    n5 = 240;
                    break;
                }
                case 187: {
                    n5 = 58;
                    break;
                }
                case 188: {
                    n5 = 4;
                    break;
                }
                case 189: {
                    n5 = 103;
                    break;
                }
                case 190: {
                    n5 = 233;
                    break;
                }
                case 191: {
                    n5 = 99;
                    break;
                }
                case 192: {
                    n5 = 207;
                    break;
                }
                case 193: {
                    n5 = 175;
                    break;
                }
                case 194: {
                    n5 = 71;
                    break;
                }
                case 195: {
                    n5 = 228;
                    break;
                }
                case 196: {
                    n5 = 6;
                    break;
                }
                case 197: {
                    n5 = 166;
                    break;
                }
                case 198: {
                    n5 = 216;
                    break;
                }
                case 199: {
                    n5 = 110;
                    break;
                }
                case 200: {
                    n5 = 203;
                    break;
                }
                case 201: {
                    n5 = 16;
                    break;
                }
                case 202: {
                    n5 = 31;
                    break;
                }
                case 203: {
                    n5 = 7;
                    break;
                }
                case 204: {
                    n5 = 209;
                    break;
                }
                case 205: {
                    n5 = 135;
                    break;
                }
                case 206: {
                    n5 = 45;
                    break;
                }
                case 207: {
                    n5 = 217;
                    break;
                }
                case 208: {
                    n5 = 198;
                    break;
                }
                case 209: {
                    n5 = 118;
                    break;
                }
                case 210: {
                    n5 = 186;
                    break;
                }
                case 211: {
                    n5 = 8;
                    break;
                }
                case 212: {
                    n5 = 231;
                    break;
                }
                case 213: {
                    n5 = 183;
                    break;
                }
                case 214: {
                    n5 = 176;
                    break;
                }
                case 215: {
                    n5 = 10;
                    break;
                }
                case 216: {
                    n5 = 62;
                    break;
                }
                case 217: {
                    n5 = 156;
                    break;
                }
                case 218: {
                    n5 = 122;
                    break;
                }
                case 219: {
                    n5 = 252;
                    break;
                }
                case 220: {
                    n5 = 136;
                    break;
                }
                case 221: {
                    n5 = 134;
                    break;
                }
                case 222: {
                    n5 = 32;
                    break;
                }
                case 223: {
                    n5 = 171;
                    break;
                }
                case 224: {
                    n5 = 74;
                    break;
                }
                case 225: {
                    n5 = 70;
                    break;
                }
                case 226: {
                    n5 = 112;
                    break;
                }
                case 227: {
                    n5 = 28;
                    break;
                }
                case 228: {
                    n5 = 244;
                    break;
                }
                case 229: {
                    n5 = 79;
                    break;
                }
                case 230: {
                    n5 = 24;
                    break;
                }
                case 231: {
                    n5 = 72;
                    break;
                }
                case 232: {
                    n5 = 73;
                    break;
                }
                case 233: {
                    n5 = 174;
                    break;
                }
                case 234: {
                    n5 = 190;
                    break;
                }
                case 235: {
                    n5 = 77;
                    break;
                }
                case 236: {
                    n5 = 214;
                    break;
                }
                case 237: {
                    n5 = 222;
                    break;
                }
                case 238: {
                    n5 = 14;
                    break;
                }
                case 239: {
                    n5 = 145;
                    break;
                }
                case 240: {
                    n5 = 35;
                    break;
                }
                case 241: {
                    n5 = 213;
                    break;
                }
                case 242: {
                    n5 = 147;
                    break;
                }
                case 243: {
                    n5 = 81;
                    break;
                }
                case 244: {
                    n5 = 200;
                    break;
                }
                case 245: {
                    n5 = 139;
                    break;
                }
                case 246: {
                    n5 = 15;
                    break;
                }
                case 247: {
                    n5 = 185;
                    break;
                }
                case 248: {
                    n5 = 131;
                    break;
                }
                case 249: {
                    n5 = 104;
                    break;
                }
                case 250: {
                    n5 = 3;
                    break;
                }
                case 251: {
                    n5 = 87;
                    break;
                }
                case 252: {
                    n5 = 247;
                    break;
                }
                case 253: {
                    n5 = 149;
                    break;
                }
                case 254: {
                    n5 = 123;
                    break;
                }
                default: {
                    n5 = 39;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CipherAlg.g[n3] = new String(cArray).intern();
        }
        return g[n3];
    }
}

