/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.asn.x509;

import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1BitString;
import java.math.BigInteger;
import java.util.Calendar;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EName;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.asn.util.UtilTime;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;
import tr.gov.tubitak.uekae.esya.asn.x509.SubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.asn.x509.TBSCertificate;
import tr.gov.tubitak.uekae.esya.asn.x509.Validity;

public class ETBSCertificate
extends BaseASNWrapper<TBSCertificate> {
    public ETBSCertificate() {
        super(new TBSCertificate());
        ((TBSCertificate)this.mObject).validity = new Validity();
    }

    public ETBSCertificate(long aVersion, BigInteger aSerialNumber, EAlgorithmIdentifier aSignatureAlg, EName aIssuer, Calendar aNotBefore, Calendar aNotAfter, EName aSubject, ESubjectPublicKeyInfo aSubjectPublicKeyInfo, byte[] aIssuerUniqueId, byte[] aSubjectUniqueId, EExtensions aExtensions) {
        this();
        this.setVersion(aVersion);
        this.setSerialNumber(aSerialNumber);
        this.setSignature(aSignatureAlg);
        this.setIssuer(aIssuer);
        this.setNotBefore(aNotBefore);
        this.setNotAfter(aNotAfter);
        this.setSubject(aSubject);
        this.setSubjectPublicKeyInfo(aSubjectPublicKeyInfo);
        this.setIssuerUniqueID(aIssuerUniqueId);
        this.setSubjectUniqueID(aSubjectUniqueId);
        this.setExtensions(aExtensions);
    }

    public ETBSCertificate(TBSCertificate aTBSCertificate) {
        super(aTBSCertificate);
    }

    public long getVersion() {
        return ((TBSCertificate)this.mObject).version.value;
    }

    public void setVersion(long aVersion) {
        ((TBSCertificate)this.mObject).version.value = aVersion;
    }

    public BigInteger getSerialNumber() {
        return ((TBSCertificate)this.mObject).serialNumber.value;
    }

    public void setSerialNumber(BigInteger aSerialNumber) {
        ((TBSCertificate)this.mObject).serialNumber = new Asn1BigInteger(aSerialNumber);
    }

    public EAlgorithmIdentifier getSignatureAlgorithm() {
        return new EAlgorithmIdentifier(((TBSCertificate)this.mObject).signature);
    }

    public void setSignature(EAlgorithmIdentifier aSignature) {
        ((TBSCertificate)this.mObject).signature = (AlgorithmIdentifier)((Object)aSignature.getObject());
    }

    public EName getIssuer() {
        return new EName(((TBSCertificate)this.mObject).issuer);
    }

    public void setIssuer(EName aIssuer) {
        ((TBSCertificate)this.mObject).issuer = (Name)((Object)aIssuer.getObject());
    }

    public Calendar getNotBefore() {
        return UtilTime.timeToCalendar(((TBSCertificate)this.mObject).validity.notBefore);
    }

    public void setNotBefore(Calendar aNotBefore) {
        ((TBSCertificate)this.mObject).validity.notBefore = UtilTime.calendarToTimeFor3280(aNotBefore);
    }

    public Calendar getNotAfter() {
        return UtilTime.timeToCalendar(((TBSCertificate)this.mObject).validity.notAfter);
    }

    public void setNotAfter(Calendar aNotAfter) {
        ((TBSCertificate)this.mObject).validity.notAfter = UtilTime.calendarToTimeFor3280(aNotAfter);
    }

    public EName getSubject() {
        return new EName(((TBSCertificate)this.mObject).subject);
    }

    public void setSubject(EName aSubject) {
        ((TBSCertificate)this.mObject).subject = (Name)((Object)aSubject.getObject());
    }

    public ESubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return new ESubjectPublicKeyInfo(((TBSCertificate)this.mObject).subjectPublicKeyInfo);
    }

    public void setSubjectPublicKeyInfo(ESubjectPublicKeyInfo aSubjectPublicKeyInfo) {
        ((TBSCertificate)this.mObject).subjectPublicKeyInfo = (SubjectPublicKeyInfo)((Object)aSubjectPublicKeyInfo.getObject());
    }

    public byte[] getIssuerUniqueID() {
        if (((TBSCertificate)this.mObject).issuerUniqueID == null) {
            return null;
        }
        return ((TBSCertificate)this.mObject).issuerUniqueID.value;
    }

    public void setIssuerUniqueID(byte[] aIssuerUniqueID) {
        ((TBSCertificate)this.mObject).issuerUniqueID = aIssuerUniqueID == null ? null : new Asn1BitString(aIssuerUniqueID.length << 3, aIssuerUniqueID);
    }

    public byte[] getSubjectUniqueID() {
        if (((TBSCertificate)this.mObject).subjectUniqueID == null) {
            return null;
        }
        return ((TBSCertificate)this.mObject).subjectUniqueID.value;
    }

    public void setSubjectUniqueID(byte[] aSubjectUniqueID) {
        ((TBSCertificate)this.mObject).subjectUniqueID = aSubjectUniqueID == null ? null : new Asn1BitString(aSubjectUniqueID.length << 3, aSubjectUniqueID);
    }

    public EExtensions getExtensions() {
        if (((TBSCertificate)this.mObject).extensions == null) {
            return null;
        }
        return new EExtensions(((TBSCertificate)this.mObject).extensions);
    }

    public void setExtensions(EExtensions aExtensions) {
        ((TBSCertificate)this.mObject).extensions = aExtensions == null ? null : (Extensions)((Object)aExtensions.getObject());
    }
}

