/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.StatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;

public class CRLValidationCache {
    public static final int CAPACITY = 10000;
    protected List<CRLStatusInfo> mCheckResults = new ArrayList<CRLStatusInfo>();
    protected List<ECRL> mCheckedCRLs = new ArrayList<ECRL>();

    public List<CRLStatusInfo> getCheckResults() {
        return this.mCheckResults;
    }

    public List<ECRL> getCheckedCRLs() {
        return this.mCheckedCRLs;
    }

    public List<ECRL> getCheckedCRLs(CRLStatus aCRLStatus) {
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        Iterator<CRLStatusInfo> iterator = this.mCheckResults.iterator();
        int n = StatusInfo.c;
        while (iterator.hasNext()) {
            CRLStatusInfo cRLStatusInfo = iterator.next();
            if (cRLStatusInfo != null && cRLStatusInfo.getCRLStatus().equals(aCRLStatus)) {
                arrayList.add(cRLStatusInfo.getCRL());
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    public CRLStatusInfo getCheckResult(ECRL aCRL) {
        Iterator<CRLStatusInfo> iterator = this.mCheckResults.iterator();
        int n = StatusInfo.c;
        while (iterator.hasNext()) {
            CRLStatusInfo cRLStatusInfo = iterator.next();
            if (cRLStatusInfo.getCRL().equals((Object)aCRL)) {
                return cRLStatusInfo;
            }
            if (n == 0) continue;
        }
        return null;
    }

    public void addCheckResult(CRLStatusInfo aCRLStatusInfo) {
        if (aCRLStatusInfo == null || this.getCheckResult(aCRLStatusInfo.getCRL()) != null) {
            return;
        }
        if (this.mCheckResults.size() >= 10000) {
            this.mCheckResults.remove(0);
        }
        if (this.mCheckedCRLs.size() >= 10000) {
            this.mCheckedCRLs.remove(0);
        }
        this.mCheckResults.add(aCRLStatusInfo);
        this.mCheckedCRLs.add(aCRLStatusInfo.getCRL());
    }

    public void clearCheckResults() {
        this.mCheckResults.clear();
        this.mCheckedCRLs.clear();
    }
}

