/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.ElementF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;

public abstract class ECGNUPoint
extends ECPoint {
    static Chronometer a;
    public static final int COMPRESSED = 0;
    public static final int UNCOMPRESSED = 1;
    public static final int HYBRID = 2;
    protected static final BigInteger TWO;
    protected static final BigInteger THREE;
    protected static final BigInteger FOUR;
    protected static final BigInteger EIGHT;
    protected final Curve mCurve;
    protected final Field mField;
    private static int b;
    private static final String[] g;
    private static final String[] h;

    public static void sifirla() {
        a.reset();
    }

    public static void yaz() {
        System.out.println(a.toString(ECGNUPoint.a(-23497, 6037)));
        a.reset();
    }

    public ECGNUPoint(Curve aCurve) {
        super(TWO, TWO);
        this.mCurve = aCurve;
        this.mField = this.mCurve.mField;
    }

    protected BigInteger[] fromOctetString(byte[] aOctet) throws EllipticCurveException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        block25: {
            block22: {
                boolean bl;
                byte by;
                block24: {
                    block20: {
                        by = aOctet[0];
                        try {
                            if (by != 2 && by != 3) break block20;
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                        bl = false;
                        break block24;
                    }
                    if (by == 4) {
                        bl = true;
                    } else {
                        throw new EllipticCurveException(ECGNUPoint.a(-23498, 5585));
                    }
                }
                if (!bl) {
                    block21: {
                        byte[] byArray = new byte[aOctet.length - 1];
                        System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                        bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                        try {
                            try {
                                if (by == 2 || by == 3) break block21;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                            throw new EllipticCurveException(ECGNUPoint.a(-23500, -11842));
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                    }
                    bigInteger = this._convert(bigInteger2, by - 2);
                } else {
                    block23: {
                        try {
                            try {
                                if (!bl) break block22;
                                if (by == 4) break block23;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                            throw new EllipticCurveException(ECGNUPoint.a(-23496, 27889));
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                    }
                    int n = aOctet.length - 1;
                    try {
                        if ((n & 1) == 1) {
                            throw new EllipticCurveException(ECGNUPoint.a(-23502, 25515));
                        }
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                    byte[] byArray = new byte[n >>= 1];
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                    bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                    System.arraycopy(aOctet, byArray.length + 1, byArray2, 0, byArray2.length);
                    bigInteger = this.mField.fromOctetToFieldElement(byArray2);
                }
                break block25;
            }
            throw new EllipticCurveException();
        }
        try {
            if (!this.mCurve.onCurve(bigInteger2, bigInteger)) {
                throw new EllipticCurveException(ECGNUPoint.a(-23499, -22353));
            }
        }
        catch (EllipticCurveException ellipticCurveException) {
            throw ECGNUPoint.b(ellipticCurveException);
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public final ECGNUPoint add(ECGNUPoint aElem) throws EllipticCurveException {
        block10: {
            try {
                if (!this.getClass().isInstance(aElem)) {
                    throw new EllipticCurveException(ECGNUPoint.a(-23501, 9925));
                }
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
            try {
                block9: {
                    try {
                        try {
                            if (this.mCurve == aElem.mCurve) break block9;
                            if (!this.mField.equals(aElem.mField)) break block10;
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                        if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block10;
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                }
                return this._add(aElem);
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
        }
        throw new EllipticCurveException(ECGNUPoint.a(-23504, 20203));
    }

    protected abstract ECGNUPoint _add(ECGNUPoint var1);

    public void addToThis(ECGNUPoint aElem) throws EllipticCurveException {
        block13: {
            int n = ECGNUPoint.b();
            try {
                if (!this.getClass().isInstance(aElem)) {
                    throw new EllipticCurveException(ECGNUPoint.a(-23493, -18850));
                }
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
            try {
                block12: {
                    try {
                        block11: {
                            try {
                                try {
                                    if (this.mCurve == aElem.mCurve) break block11;
                                    if (!this.mField.equals(aElem.mField)) break block12;
                                }
                                catch (EllipticCurveException ellipticCurveException) {
                                    throw ECGNUPoint.b(ellipticCurveException);
                                }
                                if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block12;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                        }
                        this._addToThis(aElem);
                        if (n != 0) break block13;
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                }
                throw new EllipticCurveException(ECGNUPoint.a(-23495, 7294));
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
        }
    }

    protected abstract void _addToThis(ECGNUPoint var1);

    public abstract ECGNUPoint negate();

    public abstract void negateThis();

    public ECGNUPoint multiply(BigInteger aKatsayi) {
        ECGNUPoint eCGNUPoint;
        int n = 5;
        int n2 = ECGNUPoint.c();
        ECGNUPoint[] eCGNUPointArray = new ECGNUPoint[1 << n - 1];
        eCGNUPointArray[0] = eCGNUPoint = (ECGNUPoint)this.clone();
        ECGNUPoint eCGNUPoint2 = eCGNUPoint.multiplyBy2();
        for (int k = 1; k < eCGNUPointArray.length; ++k) {
            eCGNUPointArray[k] = eCGNUPointArray[k - 1]._add(eCGNUPoint2);
            if (n2 == 0) continue;
        }
        return this.multiply(aKatsayi, eCGNUPointArray);
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, BigInteger aN) {
        BigInteger bigInteger;
        int n;
        block15: {
            block14: {
                n = ECGNUPoint.b();
                if (aN != null) break block14;
                bigInteger = aKatsayi;
                if (n != 0) break block15;
            }
            bigInteger = aKatsayi.mod(aN);
        }
        BigInteger bigInteger2 = bigInteger.add(bigInteger).add(bigInteger);
        ECGNUPoint eCGNUPoint = (ECGNUPoint)this.clone();
        ECGNUPoint eCGNUPoint2 = this.negate();
        for (int k = bigInteger2.bitLength() - 2; k > 0; --k) {
            try {
                try {
                    try {
                        block13: {
                            try {
                                try {
                                    eCGNUPoint.multiplyThisBy2();
                                    if (!bigInteger2.testBit(k) || bigInteger.testBit(k)) break block13;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw ECGNUPoint.b(runtimeException);
                                }
                                eCGNUPoint._addToThis(this);
                                if (n != 0) continue;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ECGNUPoint.b(runtimeException);
                            }
                        }
                        if (bigInteger2.testBit(k)) continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ECGNUPoint.b(runtimeException);
                    }
                    if (!bigInteger.testBit(k)) continue;
                }
                catch (RuntimeException runtimeException) {
                    throw ECGNUPoint.b(runtimeException);
                }
                eCGNUPoint._addToThis(eCGNUPoint2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
        }
        return eCGNUPoint;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[][] aPreComputation) {
        byte[] byArray = this.a(aKatsayi);
        int n = ECGNUPoint.c();
        int n2 = 0;
        while (byArray[n2] == 0) {
            ++n2;
            if (n == 0) continue;
        }
        ECGNUPoint eCGNUPoint = (ECGNUPoint)aPreComputation[n2][byArray[n2] - 1].clone();
        ++n2;
        while (n2 < byArray.length) {
            try {
                if (byArray[n2] != 0) {
                    eCGNUPoint._addToThis(aPreComputation[n2][byArray[n2] - 1]);
                }
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            ++n2;
            if (n == 0) continue;
        }
        return eCGNUPoint;
    }

    private byte[] a(BigInteger bigInteger) {
        int n = bigInteger.bitLength() / 4 + 1;
        int n2 = ECGNUPoint.b();
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int k = 0; k < byArray.length; ++k) {
            int n4;
            try {
                int n5 = n4 = bigInteger.testBit(n3++) ? 1 : 0;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 2);
            }
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 4);
            }
            if (bigInteger.testBit(n3++)) {
                n4 = (byte)(n4 + 8);
            }
            byArray[k] = n4;
            if (n2 != 0) continue;
        }
        return byArray;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[] aOddPowers) {
        ECGNUPoint eCGNUPoint;
        int n;
        int n2;
        int[] nArray;
        block13: {
            block12: {
                int n3 = aKatsayi.bitLength();
                nArray = new int[n3 + 1];
                n2 = ECGNUPoint.c();
                ECGNUPoint.determineNAF(nArray, aKatsayi, 5);
                n = n3;
                while (nArray[n] == 0) {
                    --n;
                    if (n2 == 0) continue;
                }
                if (nArray[n] <= 0) break block12;
                eCGNUPoint = (ECGNUPoint)aOddPowers[nArray[n] - 1 >> 1].clone();
                if (n2 == 0) break block13;
            }
            eCGNUPoint = aOddPowers[0 - nArray[n] - 1 >> 1].negate();
        }
        --n;
        while (n >= 0) {
            block11: {
                try {
                    try {
                        block10: {
                            try {
                                eCGNUPoint.multiplyThisBy2();
                                if (nArray[n] <= 0) break block10;
                                eCGNUPoint._addToThis(aOddPowers[nArray[n] - 1 >> 1]);
                                if (n2 == 0) break block11;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ECGNUPoint.b(runtimeException);
                            }
                        }
                        if (nArray[n] >= 0) break block11;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ECGNUPoint.b(runtimeException);
                    }
                    eCGNUPoint._addToThis(aOddPowers[0 - nArray[n] - 1 >> 1].negate());
                }
                catch (RuntimeException runtimeException) {
                    throw ECGNUPoint.b(runtimeException);
                }
            }
            --n;
            if (n2 == 0) continue;
        }
        return eCGNUPoint;
    }

    /*
     * Unable to fully structure code
     */
    public ECGNUPoint multiplyAndAdd(BigInteger aKatsayi, ECGNUPoint[] aOddPowers, ECGNUPoint aQ, BigInteger aKatsayi2) {
        block31: {
            var6_5 = 5;
            var9_6 = new ECGNUPoint[1 << var6_5 - 1];
            var9_6[0] = var10_7 = (ECGNUPoint)aQ.clone();
            var5_8 = ECGNUPoint.b();
            var11_9 = var10_7.multiplyBy2();
            for (var12_10 = 1; var12_10 < var9_6.length; ++var12_10) {
                var9_6[var12_10] = var9_6[var12_10 - 1]._add(var11_9);
                if (var5_8 != 0) continue;
            }
            var7_12 = aKatsayi.bitLength();
            var8_13 = aKatsayi2.bitLength();
            if (var8_13 > var7_12) {
                var7_12 = var8_13;
            }
            var12_11 = new int[var7_12 + 1];
            var13_14 = new int[var7_12 + 1];
            ECGNUPoint.determineNAF(var12_11, aKatsayi, var6_5);
            ECGNUPoint.determineNAF(var13_14, aKatsayi2, var6_5);
            var14_15 = var7_12;
            while (var12_11[var14_15] == 0) {
                try {
                    if (var13_14[var14_15] != 0) break;
                    --var14_15;
                    if (var5_8 != 0) continue;
                    break;
                }
                catch (RuntimeException v0) {
                    throw ECGNUPoint.b(v0);
                }
            }
            var15_16 = null;
            var16_17 = null;
            if (var12_11[var14_15] > 0) {
                var15_16 = (ECGNUPoint)aOddPowers[var12_11[var14_15] - 1 >> 1].clone();
            } else if (var12_11[var14_15] < 0) {
                var15_16 = aOddPowers[0 - var12_11[var14_15] - 1 >> 1].negate();
            }
            if (var13_14[var14_15] > 0) {
                var16_17 = (ECGNUPoint)var9_6[var13_14[var14_15] - 1 >> 1].clone();
            } else if (var13_14[var14_15] < 0) {
                var16_17 = var9_6[0 - var13_14[var14_15] - 1 >> 1].negate();
            }
            if (var15_16 != null) ** GOTO lbl43
            var15_16 = var16_17;
            try {
                try {
                    if (var5_8 != 0) break block31;
lbl43:
                    // 2 sources

                    if (var16_17 == null) break block31;
                }
                catch (RuntimeException v1) {
                    throw ECGNUPoint.b(v1);
                }
                var15_16._addToThis(var16_17);
            }
            catch (RuntimeException v2) {
                throw ECGNUPoint.b(v2);
            }
        }
        --var14_15;
        while (var14_15 >= 0) {
            block35: {
                block33: {
                    try {
                        try {
                            block32: {
                                try {
                                    ElementF2mPolynomial.say = true;
                                    var15_16.multiplyThisBy2();
                                    ElementF2mPolynomial.say = false;
                                    if (var12_11[var14_15] <= 0) break block32;
                                    var15_16._addToThis(aOddPowers[var12_11[var14_15] - 1 >> 1]);
                                    if (var5_8 != 0) break block33;
                                }
                                catch (RuntimeException v3) {
                                    throw ECGNUPoint.b(v3);
                                }
                            }
                            if (var12_11[var14_15] >= 0) break block33;
                        }
                        catch (RuntimeException v4) {
                            throw ECGNUPoint.b(v4);
                        }
                        var15_16._addToThis(aOddPowers[0 - var12_11[var14_15] - 1 >> 1].negate());
                    }
                    catch (RuntimeException v5) {
                        throw ECGNUPoint.b(v5);
                    }
                }
                try {
                    try {
                        block34: {
                            try {
                                if (var13_14[var14_15] <= 0) break block34;
                                var15_16._addToThis(var9_6[var13_14[var14_15] - 1 >> 1]);
                                if (var5_8 != 0) break block35;
                            }
                            catch (RuntimeException v6) {
                                throw ECGNUPoint.b(v6);
                            }
                        }
                        if (var13_14[var14_15] >= 0) break block35;
                    }
                    catch (RuntimeException v7) {
                        throw ECGNUPoint.b(v7);
                    }
                    var15_16._addToThis(var9_6[0 - var13_14[var14_15] - 1 >> 1].negate());
                }
                catch (RuntimeException v8) {
                    throw ECGNUPoint.b(v8);
                }
            }
            --var14_15;
            if (var5_8 != 0) continue;
        }
        try {
            v9 = var15_16;
            if (BaseCipher.b() != null) {
                ECGNUPoint.b(++var5_8);
            }
        }
        catch (RuntimeException v10) {
            throw ECGNUPoint.b(v10);
        }
        return v9;
    }

    public void multiplyThisBy(BigInteger aKatsayi) {
        throw new RuntimeException();
    }

    public void multiplyThisBy(BigInteger aKatsayi, BigInteger aN) {
        throw new RuntimeException();
    }

    public ECGNUPoint multiplyBy2() {
        return this._add(this);
    }

    public void multiplyThisBy2() {
        this._addToThis(this);
    }

    @Override
    public abstract boolean equals(Object var1);

    public abstract Object clone();

    @Override
    public abstract BigInteger getAffineX();

    @Override
    public abstract BigInteger getAffineY();

    protected abstract boolean _ypTilda();

    protected abstract BigInteger _convert(BigInteger var1, int var2) throws EllipticCurveException;

    public byte[] toOctetString(int aCompressionMode) {
        byte[] byArray = this.b(this.getAffineX());
        if (aCompressionMode == 0) {
            int n;
            byte[] byArray2 = new byte[byArray.length + 1];
            try {
                byte[] byArray3 = byArray2;
                int n2 = 0;
                n = this._ypTilda() ? 3 : 2;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            byArray3[n2] = n;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        if (aCompressionMode == 1) {
            byte[] byArray4 = this.b(this.getAffineY());
            byte[] byArray5 = new byte[byArray.length + byArray4.length + 1];
            byArray5[0] = 4;
            System.arraycopy(byArray, 0, byArray5, 1, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length + 1, byArray4.length);
            return byArray5;
        }
        if (aCompressionMode == 2) {
            int n;
            byte[] byArray6 = this.b(this.getAffineY());
            byte[] byArray7 = new byte[byArray.length + byArray6.length + 1];
            try {
                byte[] byArray8 = byArray7;
                int n3 = 0;
                n = this._ypTilda() ? 7 : 6;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            byArray8[n3] = n;
            System.arraycopy(byArray, 0, byArray7, 1, byArray.length);
            System.arraycopy(byArray6, 0, byArray7, byArray.length + 1, byArray6.length);
            return byArray7;
        }
        throw new RuntimeException();
    }

    private byte[] b(BigInteger bigInteger) {
        byte[] byArray;
        int n = (this.mCurve.getField().getFieldSize() + 7) / 8;
        if (n < (byArray = bigInteger.toByteArray()).length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (n > byArray.length) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    protected static final void determineNAF(int[] N, BigInteger e2, int wi) {
        int n = 1 << wi;
        BigInteger bigInteger = e2.abs();
        int n2 = ECGNUPoint.b();
        int n3 = e2.signum();
        int n4 = 0;
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            int n5;
            block11: {
                block10: {
                    if (!bigInteger.testBit(0)) break block10;
                    n5 = bigInteger.intValue() & (n << 1) - 1;
                    if ((n5 & n) != 0) {
                        n5 -= n << 1;
                    }
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(n5));
                    if (n2 != 0) break block11;
                }
                n5 = 0;
            }
            try {
                int n6;
                try {
                    int[] nArray = N;
                    int n7 = n4++;
                    n6 = n3 > 0 ? n5 : -n5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw ECGNUPoint.b(arrayIndexOutOfBoundsException);
                }
                nArray[n7] = n6;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ArrayIndexOutOfBoundsException(ECGNUPoint.a(-23503, 20831) + n4);
            }
            bigInteger = bigInteger.shiftRight(1);
            if (n2 != 0) continue;
        }
        while (n4 < N.length) {
            N[n4++] = 0;
            if (n2 != 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "\u00ff\u0000\u00e1\u00db\"$\u00ef\u00a6\u00dbU\u00c4 \u001f\u009fn\u00a4hbby:\u00b3\u0005\u00fc\u0087\t*\u00b3\u0002\u0081\u0000\n\u00cb\u0087\u008a\u00c1G\u00ec6\u00ea\u001c\u0081\u00ef\u00c0\u00e0\u00ac\u00bf\nr\u0093\u00d8Rzu\u00c3u\u009f\u00987\u0085\u0098\u000f\u00b5\u0007,\u000b\"\u00a6\u0012W\u00f7\u00f4%\u0080\u00f5\u00b1Y[\u00a4\u00c9\u00f0I\u00eb\u00d4\u00ba\u001a9\u0013$\u00d6ZO\u00ec~\u00d8KA\u00f9B\u009b\u00a9\u0018 \u00f2>\u0085\u00d9\u000f\u00ebH\u00fb\u0090\u0086#?\u00c4\n\u00d1\u001cB\u00a7/\u00bd\u0012\u0090\u00a4\fO\u009f\u00b8R\u00f0'\u0091FV\u00b8\u001f\u00ea\u0000\u00ddn\bsG9\u0091_[\u008d\u0089\r\u00b83\t\u00bd?\u00e6A7\u00bf\u00aa\u00e0\u00bd\u0006\u000b\u00ccQ\u00ceS\u00a1\u0003R\u0082R~f\u0012\u00c6-\u00c6~\u00c6\u009ey4B\t\u00eaE-]Xl\u008b\u00e3\b\u0085!\u00e7]\u0084\u00c2\u00f6\u00ba";
                var4_3 = "\u00ff\u0000\u00e1\u00db\"$\u00ef\u00a6\u00dbU\u00c4 \u001f\u009fn\u00a4hbby:\u00b3\u0005\u00fc\u0087\t*\u00b3\u0002\u0081\u0000\n\u00cb\u0087\u008a\u00c1G\u00ec6\u00ea\u001c\u0081\u00ef\u00c0\u00e0\u00ac\u00bf\nr\u0093\u00d8Rzu\u00c3u\u009f\u00987\u0085\u0098\u000f\u00b5\u0007,\u000b\"\u00a6\u0012W\u00f7\u00f4%\u0080\u00f5\u00b1Y[\u00a4\u00c9\u00f0I\u00eb\u00d4\u00ba\u001a9\u0013$\u00d6ZO\u00ec~\u00d8KA\u00f9B\u009b\u00a9\u0018 \u00f2>\u0085\u00d9\u000f\u00ebH\u00fb\u0090\u0086#?\u00c4\n\u00d1\u001cB\u00a7/\u00bd\u0012\u0090\u00a4\fO\u009f\u00b8R\u00f0'\u0091FV\u00b8\u001f\u00ea\u0000\u00ddn\bsG9\u0091_[\u008d\u0089\r\u00b83\t\u00bd?\u00e6A7\u00bf\u00aa\u00e0\u00bd\u0006\u000b\u00ccQ\u00ceS\u00a1\u0003R\u0082R~f\u0012\u00c6-\u00c6~\u00c6\u009ey4B\t\u00eaE-]Xl\u008b\u00e3\b\u0085!\u00e7]\u0084\u00c2\u00f6\u00ba".length();
                var1_4 = 68;
                var0_5 = -1;
                ECGNUPoint.b(42);
lbl8:
                // 2 sources

                while (true) {
                    v0 = 62;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u001c\u00e7\u0085\u00b1\u00cfyds\u000e&s\u00b8W\u00a4'\u00bd\u0006\u00b4\u0006\u0012>A\u0097b\u00a1\u00e3q\u00c5+\u00e7\u00ef\u00f0?\\Z\u00daR\u0084";
                    var4_3 = "\u001c\u00e7\u0085\u00b1\u00cfyds\u000e&s\u00b8W\u00a4'\u00bd\u0006\u00b4\u0006\u0012>A\u0097b\u00a1\u00e3q\u00c5+\u00e7\u00ef\u00f0?\\Z\u00daR\u0084".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 1;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 28;
                            break;
                        }
                        case 1: {
                            v15 = 46;
                            break;
                        }
                        case 2: {
                            v15 = 87;
                            break;
                        }
                        case 3: {
                            v15 = 11;
                            break;
                        }
                        case 4: {
                            v15 = 61;
                            break;
                        }
                        case 5: {
                            v15 = 74;
                            break;
                        }
                        default: {
                            v15 = 107;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        ECGNUPoint.g = var5;
        ECGNUPoint.h = new String[12];
        ECGNUPoint.a = new Chronometer(ECGNUPoint.a(-23494, -1339));
        ECGNUPoint.TWO = new BigInteger("2");
        ECGNUPoint.THREE = new BigInteger("3");
        ECGNUPoint.FOUR = new BigInteger("4");
        ECGNUPoint.EIGHT = new BigInteger("8");
    }

    public static void b(int n) {
        b = n;
    }

    public static int b() {
        return b;
    }

    public static int c() {
        int n = ECGNUPoint.b();
        try {
            if (n == 0) {
                return 111;
            }
        }
        catch (RuntimeException runtimeException) {
            throw ECGNUPoint.b(runtimeException);
        }
        return 0;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFA431) & 0xFFFF;
        if (h[n3] == null) {
            int n4;
            int n5;
            char[] cArray = g[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 138;
                    break;
                }
                case 1: {
                    n5 = 15;
                    break;
                }
                case 2: {
                    n5 = 158;
                    break;
                }
                case 3: {
                    n5 = 208;
                    break;
                }
                case 4: {
                    n5 = 171;
                    break;
                }
                case 5: {
                    n5 = 92;
                    break;
                }
                case 6: {
                    n5 = 125;
                    break;
                }
                case 7: {
                    n5 = 153;
                    break;
                }
                case 8: {
                    n5 = 170;
                    break;
                }
                case 9: {
                    n5 = 55;
                    break;
                }
                case 10: {
                    n5 = 224;
                    break;
                }
                case 11: {
                    n5 = 244;
                    break;
                }
                case 12: {
                    n5 = 191;
                    break;
                }
                case 13: {
                    n5 = 94;
                    break;
                }
                case 14: {
                    n5 = 27;
                    break;
                }
                case 15: {
                    n5 = 167;
                    break;
                }
                case 16: {
                    n5 = 146;
                    break;
                }
                case 17: {
                    n5 = 98;
                    break;
                }
                case 18: {
                    n5 = 50;
                    break;
                }
                case 19: {
                    n5 = 49;
                    break;
                }
                case 20: {
                    n5 = 228;
                    break;
                }
                case 21: {
                    n5 = 43;
                    break;
                }
                case 22: {
                    n5 = 68;
                    break;
                }
                case 23: {
                    n5 = 165;
                    break;
                }
                case 24: {
                    n5 = 54;
                    break;
                }
                case 25: {
                    n5 = 126;
                    break;
                }
                case 26: {
                    n5 = 51;
                    break;
                }
                case 27: {
                    n5 = 87;
                    break;
                }
                case 28: {
                    n5 = 159;
                    break;
                }
                case 29: {
                    n5 = 33;
                    break;
                }
                case 30: {
                    n5 = 66;
                    break;
                }
                case 31: {
                    n5 = 133;
                    break;
                }
                case 32: {
                    n5 = 79;
                    break;
                }
                case 33: {
                    n5 = 100;
                    break;
                }
                case 34: {
                    n5 = 74;
                    break;
                }
                case 35: {
                    n5 = 183;
                    break;
                }
                case 36: {
                    n5 = 144;
                    break;
                }
                case 37: {
                    n5 = 21;
                    break;
                }
                case 38: {
                    n5 = 119;
                    break;
                }
                case 39: {
                    n5 = 216;
                    break;
                }
                case 40: {
                    n5 = 63;
                    break;
                }
                case 41: {
                    n5 = 99;
                    break;
                }
                case 42: {
                    n5 = 214;
                    break;
                }
                case 43: {
                    n5 = 184;
                    break;
                }
                case 44: {
                    n5 = 10;
                    break;
                }
                case 45: {
                    n5 = 107;
                    break;
                }
                case 46: {
                    n5 = 212;
                    break;
                }
                case 47: {
                    n5 = 253;
                    break;
                }
                case 48: {
                    n5 = 101;
                    break;
                }
                case 49: {
                    n5 = 22;
                    break;
                }
                case 50: {
                    n5 = 57;
                    break;
                }
                case 51: {
                    n5 = 140;
                    break;
                }
                case 52: {
                    n5 = 188;
                    break;
                }
                case 53: {
                    n5 = 78;
                    break;
                }
                case 54: {
                    n5 = 37;
                    break;
                }
                case 55: {
                    n5 = 169;
                    break;
                }
                case 56: {
                    n5 = 61;
                    break;
                }
                case 57: {
                    n5 = 117;
                    break;
                }
                case 58: {
                    n5 = 32;
                    break;
                }
                case 59: {
                    n5 = 211;
                    break;
                }
                case 60: {
                    n5 = 121;
                    break;
                }
                case 61: {
                    n5 = 236;
                    break;
                }
                case 62: {
                    n5 = 14;
                    break;
                }
                case 63: {
                    n5 = 3;
                    break;
                }
                case 64: {
                    n5 = 223;
                    break;
                }
                case 65: {
                    n5 = 123;
                    break;
                }
                case 66: {
                    n5 = 162;
                    break;
                }
                case 67: {
                    n5 = 190;
                    break;
                }
                case 68: {
                    n5 = 20;
                    break;
                }
                case 69: {
                    n5 = 96;
                    break;
                }
                case 70: {
                    n5 = 59;
                    break;
                }
                case 71: {
                    n5 = 195;
                    break;
                }
                case 72: {
                    n5 = 2;
                    break;
                }
                case 73: {
                    n5 = 120;
                    break;
                }
                case 74: {
                    n5 = 154;
                    break;
                }
                case 75: {
                    n5 = 213;
                    break;
                }
                case 76: {
                    n5 = 4;
                    break;
                }
                case 77: {
                    n5 = 93;
                    break;
                }
                case 78: {
                    n5 = 160;
                    break;
                }
                case 79: {
                    n5 = 163;
                    break;
                }
                case 80: {
                    n5 = 58;
                    break;
                }
                case 81: {
                    n5 = 189;
                    break;
                }
                case 82: {
                    n5 = 175;
                    break;
                }
                case 83: {
                    n5 = 142;
                    break;
                }
                case 84: {
                    n5 = 192;
                    break;
                }
                case 85: {
                    n5 = 0;
                    break;
                }
                case 86: {
                    n5 = 235;
                    break;
                }
                case 87: {
                    n5 = 104;
                    break;
                }
                case 88: {
                    n5 = 145;
                    break;
                }
                case 89: {
                    n5 = 23;
                    break;
                }
                case 90: {
                    n5 = 245;
                    break;
                }
                case 91: {
                    n5 = 219;
                    break;
                }
                case 92: {
                    n5 = 110;
                    break;
                }
                case 93: {
                    n5 = 193;
                    break;
                }
                case 94: {
                    n5 = 243;
                    break;
                }
                case 95: {
                    n5 = 112;
                    break;
                }
                case 96: {
                    n5 = 91;
                    break;
                }
                case 97: {
                    n5 = 13;
                    break;
                }
                case 98: {
                    n5 = 176;
                    break;
                }
                case 99: {
                    n5 = 30;
                    break;
                }
                case 100: {
                    n5 = 47;
                    break;
                }
                case 101: {
                    n5 = 238;
                    break;
                }
                case 102: {
                    n5 = 5;
                    break;
                }
                case 103: {
                    n5 = 179;
                    break;
                }
                case 104: {
                    n5 = 35;
                    break;
                }
                case 105: {
                    n5 = 218;
                    break;
                }
                case 106: {
                    n5 = 151;
                    break;
                }
                case 107: {
                    n5 = 255;
                    break;
                }
                case 108: {
                    n5 = 221;
                    break;
                }
                case 109: {
                    n5 = 56;
                    break;
                }
                case 110: {
                    n5 = 105;
                    break;
                }
                case 111: {
                    n5 = 12;
                    break;
                }
                case 112: {
                    n5 = 111;
                    break;
                }
                case 113: {
                    n5 = 73;
                    break;
                }
                case 114: {
                    n5 = 201;
                    break;
                }
                case 115: {
                    n5 = 127;
                    break;
                }
                case 116: {
                    n5 = 149;
                    break;
                }
                case 117: {
                    n5 = 198;
                    break;
                }
                case 118: {
                    n5 = 86;
                    break;
                }
                case 119: {
                    n5 = 252;
                    break;
                }
                case 120: {
                    n5 = 248;
                    break;
                }
                case 121: {
                    n5 = 215;
                    break;
                }
                case 122: {
                    n5 = 226;
                    break;
                }
                case 123: {
                    n5 = 102;
                    break;
                }
                case 124: {
                    n5 = 65;
                    break;
                }
                case 125: {
                    n5 = 53;
                    break;
                }
                case 126: {
                    n5 = 156;
                    break;
                }
                case 127: {
                    n5 = 136;
                    break;
                }
                case 128: {
                    n5 = 209;
                    break;
                }
                case 129: {
                    n5 = 42;
                    break;
                }
                case 130: {
                    n5 = 62;
                    break;
                }
                case 131: {
                    n5 = 95;
                    break;
                }
                case 132: {
                    n5 = 222;
                    break;
                }
                case 133: {
                    n5 = 217;
                    break;
                }
                case 134: {
                    n5 = 80;
                    break;
                }
                case 135: {
                    n5 = 207;
                    break;
                }
                case 136: {
                    n5 = 241;
                    break;
                }
                case 137: {
                    n5 = 232;
                    break;
                }
                case 138: {
                    n5 = 225;
                    break;
                }
                case 139: {
                    n5 = 180;
                    break;
                }
                case 140: {
                    n5 = 81;
                    break;
                }
                case 141: {
                    n5 = 114;
                    break;
                }
                case 142: {
                    n5 = 166;
                    break;
                }
                case 143: {
                    n5 = 177;
                    break;
                }
                case 144: {
                    n5 = 229;
                    break;
                }
                case 145: {
                    n5 = 242;
                    break;
                }
                case 146: {
                    n5 = 67;
                    break;
                }
                case 147: {
                    n5 = 172;
                    break;
                }
                case 148: {
                    n5 = 178;
                    break;
                }
                case 149: {
                    n5 = 77;
                    break;
                }
                case 150: {
                    n5 = 239;
                    break;
                }
                case 151: {
                    n5 = 29;
                    break;
                }
                case 152: {
                    n5 = 246;
                    break;
                }
                case 153: {
                    n5 = 26;
                    break;
                }
                case 154: {
                    n5 = 203;
                    break;
                }
                case 155: {
                    n5 = 132;
                    break;
                }
                case 156: {
                    n5 = 152;
                    break;
                }
                case 157: {
                    n5 = 187;
                    break;
                }
                case 158: {
                    n5 = 199;
                    break;
                }
                case 159: {
                    n5 = 122;
                    break;
                }
                case 160: {
                    n5 = 141;
                    break;
                }
                case 161: {
                    n5 = 206;
                    break;
                }
                case 162: {
                    n5 = 150;
                    break;
                }
                case 163: {
                    n5 = 46;
                    break;
                }
                case 164: {
                    n5 = 89;
                    break;
                }
                case 165: {
                    n5 = 18;
                    break;
                }
                case 166: {
                    n5 = 139;
                    break;
                }
                case 167: {
                    n5 = 250;
                    break;
                }
                case 168: {
                    n5 = 82;
                    break;
                }
                case 169: {
                    n5 = 64;
                    break;
                }
                case 170: {
                    n5 = 60;
                    break;
                }
                case 171: {
                    n5 = 17;
                    break;
                }
                case 172: {
                    n5 = 39;
                    break;
                }
                case 173: {
                    n5 = 124;
                    break;
                }
                case 174: {
                    n5 = 40;
                    break;
                }
                case 175: {
                    n5 = 251;
                    break;
                }
                case 176: {
                    n5 = 108;
                    break;
                }
                case 177: {
                    n5 = 137;
                    break;
                }
                case 178: {
                    n5 = 205;
                    break;
                }
                case 179: {
                    n5 = 230;
                    break;
                }
                case 180: {
                    n5 = 174;
                    break;
                }
                case 181: {
                    n5 = 164;
                    break;
                }
                case 182: {
                    n5 = 237;
                    break;
                }
                case 183: {
                    n5 = 249;
                    break;
                }
                case 184: {
                    n5 = 168;
                    break;
                }
                case 185: {
                    n5 = 116;
                    break;
                }
                case 186: {
                    n5 = 85;
                    break;
                }
                case 187: {
                    n5 = 227;
                    break;
                }
                case 188: {
                    n5 = 24;
                    break;
                }
                case 189: {
                    n5 = 36;
                    break;
                }
                case 190: {
                    n5 = 71;
                    break;
                }
                case 191: {
                    n5 = 8;
                    break;
                }
                case 192: {
                    n5 = 88;
                    break;
                }
                case 193: {
                    n5 = 128;
                    break;
                }
                case 194: {
                    n5 = 118;
                    break;
                }
                case 195: {
                    n5 = 157;
                    break;
                }
                case 196: {
                    n5 = 34;
                    break;
                }
                case 197: {
                    n5 = 106;
                    break;
                }
                case 198: {
                    n5 = 84;
                    break;
                }
                case 199: {
                    n5 = 109;
                    break;
                }
                case 200: {
                    n5 = 220;
                    break;
                }
                case 201: {
                    n5 = 38;
                    break;
                }
                case 202: {
                    n5 = 240;
                    break;
                }
                case 203: {
                    n5 = 103;
                    break;
                }
                case 204: {
                    n5 = 9;
                    break;
                }
                case 205: {
                    n5 = 72;
                    break;
                }
                case 206: {
                    n5 = 194;
                    break;
                }
                case 207: {
                    n5 = 90;
                    break;
                }
                case 208: {
                    n5 = 204;
                    break;
                }
                case 209: {
                    n5 = 186;
                    break;
                }
                case 210: {
                    n5 = 76;
                    break;
                }
                case 211: {
                    n5 = 130;
                    break;
                }
                case 212: {
                    n5 = 131;
                    break;
                }
                case 213: {
                    n5 = 48;
                    break;
                }
                case 214: {
                    n5 = 135;
                    break;
                }
                case 215: {
                    n5 = 148;
                    break;
                }
                case 216: {
                    n5 = 185;
                    break;
                }
                case 217: {
                    n5 = 134;
                    break;
                }
                case 218: {
                    n5 = 161;
                    break;
                }
                case 219: {
                    n5 = 69;
                    break;
                }
                case 220: {
                    n5 = 181;
                    break;
                }
                case 221: {
                    n5 = 210;
                    break;
                }
                case 222: {
                    n5 = 1;
                    break;
                }
                case 223: {
                    n5 = 129;
                    break;
                }
                case 224: {
                    n5 = 254;
                    break;
                }
                case 225: {
                    n5 = 83;
                    break;
                }
                case 226: {
                    n5 = 173;
                    break;
                }
                case 227: {
                    n5 = 41;
                    break;
                }
                case 228: {
                    n5 = 202;
                    break;
                }
                case 229: {
                    n5 = 52;
                    break;
                }
                case 230: {
                    n5 = 197;
                    break;
                }
                case 231: {
                    n5 = 6;
                    break;
                }
                case 232: {
                    n5 = 231;
                    break;
                }
                case 233: {
                    n5 = 31;
                    break;
                }
                case 234: {
                    n5 = 16;
                    break;
                }
                case 235: {
                    n5 = 196;
                    break;
                }
                case 236: {
                    n5 = 115;
                    break;
                }
                case 237: {
                    n5 = 182;
                    break;
                }
                case 238: {
                    n5 = 19;
                    break;
                }
                case 239: {
                    n5 = 75;
                    break;
                }
                case 240: {
                    n5 = 233;
                    break;
                }
                case 241: {
                    n5 = 44;
                    break;
                }
                case 242: {
                    n5 = 155;
                    break;
                }
                case 243: {
                    n5 = 7;
                    break;
                }
                case 244: {
                    n5 = 45;
                    break;
                }
                case 245: {
                    n5 = 113;
                    break;
                }
                case 246: {
                    n5 = 143;
                    break;
                }
                case 247: {
                    n5 = 11;
                    break;
                }
                case 248: {
                    n5 = 25;
                    break;
                }
                case 249: {
                    n5 = 97;
                    break;
                }
                case 250: {
                    n5 = 70;
                    break;
                }
                case 251: {
                    n5 = 234;
                    break;
                }
                case 252: {
                    n5 = 200;
                    break;
                }
                case 253: {
                    n5 = 28;
                    break;
                }
                case 254: {
                    n5 = 147;
                    break;
                }
                default: {
                    n5 = 247;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            ECGNUPoint.h[n3] = new String(cArray).intern();
        }
        return h[n3];
    }
}

