/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1Boolean
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 1);
    public static final Asn1Boolean TRUE_VALUE = new Asn1Boolean(true);
    public static final Asn1Boolean FALSE_VALUE = new Asn1Boolean(false);
    public transient boolean value;
    private static byte d = (byte)-1;
    private static final long serialVersionUID = 6822741769471077623L;

    public Asn1Boolean() {
        this.value = false;
    }

    public Asn1Boolean(boolean bl) {
        this.value = bl;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3;
        if (bl) {
            Asn1Boolean.matchTag(asn1BerDecodeBuffer, TAG);
        }
        if ((n3 = asn1BerDecodeBuffer.read()) < 0) {
            throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
        }
        asn1BerDecodeBuffer.setTypeCode((short)1);
        this.value = n3 != 0;
    }

    public static void setTrueEncodedByte(byte by) {
        d = (byte)(by == 0 ? -1 : (int)by);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = 1;
        asn1BerEncodeBuffer.copy(this.value ? d : (byte)0);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.value = asn1PerDecodeBuffer.decodeBit();
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        asn1PerEncodeBuffer.encodeBit(this.value);
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BOOLEAN";
        }
        asn1XerEncoder.encodeNamedValue(this.value ? "true" : "false", string);
    }

    public void encode(Asn1XerEncodeBuffer asn1XerEncodeBuffer) throws Asn1Exception {
        asn1XerEncodeBuffer.encodeNamedValueElement(this.value ? "true" : "false");
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = Asn1Exception.z;
                    if ((string = string.trim()).compareTo("true") != 0) break block2;
                    this.value = true;
                    if (!bl) break block3;
                }
                if (string.compareTo("false") != 0) break block4;
                this.value = false;
                if (!bl) break block3;
            }
            throw new Asn1Exception("Invalid BOOLEAN value");
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BOOLEAN";
        }
        asn1XmlEncoder.encodeNamedValue(this.value ? "true" : "false", string, string2);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2, boolean bl) throws IOException, Asn1Exception {
        block5: {
            block4: {
                if (string == null) {
                    string = "BOOLEAN";
                }
                if (!bl) break block4;
                asn1XmlEncoder.encodeNamedValue(this.value ? "true" : "false", string, string2);
                if (!Asn1Exception.z) break block5;
            }
            String string3 = this.value ? "true" : "false";
            asn1XmlEncoder.encodeStartElement(string, string2, true);
            asn1XmlEncoder.encodeEmptyElement(string3, "");
            asn1XmlEncoder.encodeEndElement(string, string2);
        }
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws IOException, Asn1Exception {
        if (string != null) {
            asn1XmlEncoder.encodeAttr(string, this.value ? "true" : "false");
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        this.value = asn1JsonDecodeBuffer.readBoolean();
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        block3: {
            block2: {
                if (!this.value) break block2;
                asn1JsonOutputStream.write("true");
                if (!Asn1Exception.z) break block3;
            }
            asn1JsonOutputStream.write("false");
        }
    }

    public boolean equals(boolean bl) {
        return this.value == bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1Boolean)) {
            return false;
        }
        return this.value == ((Asn1Boolean)object).value;
    }

    public int hashCode() {
        return this.value ? 1 : 2;
    }

    public String toString() {
        return this.value ? "TRUE" : "FALSE";
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeLength(1);
        asn1BerOutputStream.write(this.value ? d : (byte)0);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        asn1PerOutputStream.b.encodeBit(this.value);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readBoolean();
    }
}

