/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1InvalidObjectIDException;
import com.objsys.asn1j.runtime.Asn1MessageBuffer;
import com.objsys.asn1j.runtime.h;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public abstract class Asn1DecodeBuffer
extends Asn1MessageBuffer {
    protected int mByteCount;
    private InputStream a;
    private ArrayList b;
    private byte[] c;
    private int d;
    private boolean e;
    private int[] f;

    Asn1DecodeBuffer(byte[] byArray) {
        this.b = null;
        this.c = new byte[128];
        this.setInputStream(byArray, 0, byArray.length);
    }

    Asn1DecodeBuffer(InputStream inputStream) {
        block3: {
            block2: {
                this.b = null;
                this.c = new byte[128];
                if (inputStream.markSupported()) break block2;
                this.a = new BufferedInputStream(inputStream);
                if (!Asn1Exception.z) break block3;
            }
            this.a = inputStream;
        }
        this.init();
    }

    public void capture(int n2) throws Asn1EndOfBufferException, IOException {
        int n3;
        boolean bl = Asn1Exception.z;
        int n4 = this.b.size();
        for (int i2 = 0; i2 < n2; i2 += n3) {
            int n5 = n2 - i2 > this.c.length ? this.c.length : n2 - i2;
            n3 = this.a.read(this.c, 0, n5);
            if (n3 > 0) {
                if (this.b != null) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        ((ByteArrayOutputStream)this.b.get(i3)).write(this.c, 0, n3);
                        if (!bl) continue;
                    }
                }
                this.mByteCount += n3;
                if (!bl) continue;
            }
            throw new Asn1EndOfBufferException(this);
        }
    }

    public long decodeIntValue(int n2, boolean bl) throws Asn1Exception, IOException {
        return h.a(this, n2, bl);
    }

    public int[] decodeOIDContents(int n2) throws Asn1Exception, IOException {
        int n3 = 0;
        if (this.f == null) {
            this.f = new int[128];
        }
        while (n2 > 0) {
            if (n3 < 128) {
                int n4;
                this.f[n3] = 0;
                do {
                    n4 = this.readByte();
                    this.f[n3] = this.f[n3] * 128 + (n4 & 0x7F);
                    --n2;
                } while ((n4 & 0x80) != 0);
                if (n3 == 0) {
                    int n5 = this.f[0];
                    this.f[0] = n5 / 40 >= 2 ? 2 : n5 / 40;
                    this.f[1] = this.f[0] == 2 ? n5 - 80 : n5 % 40;
                    n3 = 2;
                    continue;
                }
                ++n3;
                continue;
            }
            throw new Asn1InvalidObjectIDException();
        }
        if (n2 != 0) {
            throw new Asn1InvalidLengthException();
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.f, 0, nArray, 0, n3);
        return nArray;
    }

    public int[] decodeRelOIDContents(int n2) throws Asn1Exception, IOException {
        int n3 = 0;
        if (this.f == null) {
            this.f = new int[128];
        }
        while (n2 > 0) {
            if (n3 < 128) {
                int n4;
                this.f[n3] = 0;
                do {
                    n4 = this.readByte();
                    this.f[n3] = this.f[n3] * 128 + (n4 & 0x7F);
                    --n2;
                } while ((n4 & 0x80) != 0);
                ++n3;
                continue;
            }
            throw new Asn1InvalidObjectIDException();
        }
        if (n2 != 0) {
            throw new Asn1InvalidLengthException();
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.f, 0, nArray, 0, n3);
        return nArray;
    }

    public void addCaptureBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(byteArrayOutputStream);
    }

    public void removeCaptureBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        boolean bl = Asn1Exception.z;
        if (this.b != null) {
            int n2 = this.b.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byteArrayOutputStream != (ByteArrayOutputStream)this.b.get(i2)) continue;
                this.b.remove(i2);
                if (this.b.size() == 0) {
                    this.b = null;
                }
                return;
            }
        }
    }

    public int getByteCount() {
        return this.mByteCount;
    }

    public InputStream getInputStream() {
        return this.a;
    }

    public boolean getLazyOpenTypeDecode() {
        return this.e;
    }

    public void hexDump() {
        Asn1DecodeBuffer.hexDump(this.a);
    }

    protected void init() {
        this.mByteCount = 0;
        this.d = 0;
    }

    public void mark(int n2) {
        this.d = this.mByteCount;
        this.a.mark(n2);
    }

    public final int read2Bytes() throws Asn1EndOfBufferException, IOException {
        byte[] byArray = new byte[2];
        this.read(byArray, 0, 2);
        int n2 = (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
        return n2;
    }

    public final int read4Bytes() throws Asn1EndOfBufferException, IOException {
        byte[] byArray = new byte[4];
        this.read(byArray, 0, 4);
        int n2 = (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        return n2;
    }

    public final int read() throws Asn1EndOfBufferException, IOException {
        int n2 = this.a.read();
        if (n2 != -1) {
            if (this.b != null) {
                int n3 = this.b.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    ((ByteArrayOutputStream)this.b.get(i2)).write(n2);
                }
            }
            ++this.mByteCount;
        } else {
            throw new Asn1EndOfBufferException(this);
        }
        return n2;
    }

    public abstract int readByte() throws Asn1Exception, IOException;

    public final void read(byte[] byArray, int n2, int n3) throws Asn1EndOfBufferException, IOException {
        int n4;
        int n5 = n2;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            n4 = this.a.read(byArray, n5, i2);
            if (n4 < 0) {
                throw new Asn1EndOfBufferException(this);
            }
            n5 += n4;
        }
        if (this.b != null && n3 > 0) {
            int n6 = this.b.size();
            for (int i3 = 0; i3 < n6; ++i3) {
                ((ByteArrayOutputStream)this.b.get(i3)).write(byArray, n2, n3);
            }
        }
        this.mByteCount += n3;
    }

    public void read(byte[] byArray) throws Asn1EndOfBufferException, IOException {
        this.read(byArray, 0, byArray.length);
    }

    public void reset() {
        try {
            this.a.reset();
            this.mByteCount = this.d;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLazyOpenTypeDecode(boolean bl) {
        this.e = bl;
    }

    public void setInputStream(byte[] byArray, int n2, int n3) {
        this.a = new ByteArrayInputStream(byArray, n2, n3);
        this.init();
    }

    public long skip(long l2) throws IOException {
        return this.a.skip(l2);
    }
}

