/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BitString;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1MessageBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class Asn1EncodeBuffer
extends Asn1MessageBuffer {
    protected int mByteIndex;
    protected byte[] mData;
    public static final int INITIAL_SIZE = 1024;

    Asn1EncodeBuffer() {
        this.initBuffer(1024);
    }

    Asn1EncodeBuffer(int n2) {
        if (n2 == 0) {
            n2 = 1024;
        }
        this.initBuffer(n2);
    }

    public void binDump(String string) {
        this.binDump(System.out, string);
    }

    public abstract void binDump(PrintStream var1, String var2);

    protected void checkSize(int n2) {
        int n3 = n2 + this.mByteIndex;
        if (n3 > this.mData.length) {
            int n4 = this.mData.length * 2;
            if (n4 < n3) {
                n4 = n3;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.mData, 0, byArray, 0, this.mByteIndex);
            this.mData = byArray;
        }
    }

    public int trimBitString(Asn1BitString asn1BitString) {
        boolean bl = Asn1Exception.z;
        while (asn1BitString.numbits > 0 && !asn1BitString.isSet(asn1BitString.numbits - 1)) {
            --asn1BitString.numbits;
            if (!bl) continue;
        }
        return asn1BitString.numbits;
    }

    public abstract void copy(byte var1);

    public abstract void copy(byte[] var1) throws Asn1Exception;

    public abstract byte[] getMsgCopy();

    public abstract int getMsgLength();

    public void hexDump() {
        Asn1EncodeBuffer.hexDump(this.getInputStream());
    }

    public void hexDump(PrintStream printStream) {
        Asn1EncodeBuffer.hexDump(this.getInputStream(), printStream);
    }

    protected void initBuffer(int n2) {
        this.mData = new byte[n2];
        this.mByteIndex = 0;
    }

    public abstract void reset();

    public abstract void write(OutputStream var1) throws IOException;
}

