/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1InvalidObjectIDException;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1ObjectIdentifier
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 6);
    public static final int MAXSUBIDS = 128;
    public transient int[] value;
    private static final long serialVersionUID = -2735122526060278835L;
    private static h d = h.a();

    public Asn1ObjectIdentifier() {
        this.value = null;
    }

    public Asn1ObjectIdentifier(int[] nArray) {
        this.value = nArray;
    }

    public void append(int[] nArray) {
        int n2;
        block3: {
            block2: {
                n2 = 0;
                if (this.value != null) break block2;
                this.value = new int[nArray.length];
                if (!Asn1Exception.z) break block3;
            }
            int[] nArray2 = this.value;
            n2 = this.value.length;
            this.value = new int[this.value.length + nArray.length];
            System.arraycopy(nArray2, 0, this.value, 0, nArray2.length);
        }
        System.arraycopy(nArray, 0, this.value, n2, nArray.length);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3;
        int n4 = n3 = bl ? Asn1ObjectIdentifier.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        if (n3 <= 0) {
            throw new Asn1InvalidLengthException();
        }
        this.value = asn1BerDecodeBuffer.decodeOIDContents(n3);
        d.lcheck(1);
        asn1BerDecodeBuffer.setTypeCode((short)6);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        boolean bl2 = Asn1Exception.z;
        if (this.value.length < 2 || this.value[0] > 2 || this.value[0] != 2 && this.value[1] > 39) {
            throw new Asn1InvalidObjectIDException();
        }
        int n2 = 0;
        for (int i2 = this.value.length - 1; i2 >= 1; --i2) {
            n2 += asn1BerEncodeBuffer.encodeIdentifier(i2 == 1 ? this.value[0] * 40 + this.value[1] : this.value[i2]);
            if (!bl2) continue;
        }
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        d.lcheck(1);
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        block3: {
            block2: {
                int n2 = (int)asn1PerDecodeBuffer.decodeLength();
                if (n2 <= 0) break block2;
                asn1PerDecodeBuffer.getTraceHandler().newBitField("value", 0);
                this.value = asn1PerDecodeBuffer.decodeOIDContents(n2);
                asn1PerDecodeBuffer.getTraceHandler().setBitCount();
                asn1PerDecodeBuffer.setTypeCode((short)6);
                if (!Asn1Exception.z) break block3;
            }
            this.value = new int[0];
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.value.length < 2 || this.value[0] > 2 || this.value[0] != 2 && this.value[1] > 39) {
            throw new Asn1InvalidObjectIDException();
        }
        asn1PerEncodeBuffer.encodeOIDLengthAndValue(this.value);
    }

    private void a(String string) {
        boolean bl = Asn1Exception.z;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new Asn1InvalidObjectIDException();
        }
        int n4 = 0;
        int n5 = -1;
        while ((n5 = string.indexOf(46, n5 + 1)) > 0) {
            ++n4;
            if (!bl) continue;
        }
        this.value = new int[++n4];
        int n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            char c2 = string.charAt(n5);
            if (Character.isDigit(c2)) {
                n2 = n2 * 10 + (c2 - 48);
                if (!bl) continue;
            }
            if (c2 == '.') {
                if (n5 + 1 >= n3) {
                    throw new Asn1InvalidObjectIDException();
                }
                this.value[n6++] = n2;
                n2 = 0;
                if (!bl) continue;
            }
            throw new Asn1InvalidObjectIDException();
        }
        this.value[n6] = n2;
        this.validate();
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "OBJECT_IDENTIFIER";
        }
        asn1XerEncoder.encodeStartElement(string);
        d.lcheck(4);
        asn1XerEncoder.copy(this.toXMLValue());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        string = string.trim();
        this.a(string);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "OBJECT_IDENTIFIER";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        d.lcheck(4);
        asn1XmlEncoder.copy(this.toXMLValue());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        String string = asn1JsonDecodeBuffer.readString();
        this.a(string);
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        asn1JsonOutputStream.write(34);
        asn1JsonOutputStream.write(this.toXMLValue());
        asn1JsonOutputStream.write(34);
    }

    public boolean equals(Object object) {
        boolean bl = Asn1Exception.z;
        if (this == object) {
            return true;
        }
        if (object instanceof Asn1ObjectIdentifier) {
            Asn1ObjectIdentifier asn1ObjectIdentifier = (Asn1ObjectIdentifier)object;
            if (asn1ObjectIdentifier.value == null) {
                return this.value == null;
            }
            if (asn1ObjectIdentifier.value.length == this.value.length) {
                for (int i2 = 0; i2 < this.value.length; ++i2) {
                    if (this.value[i2] == asn1ObjectIdentifier.value[i2]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        boolean bl = Asn1Exception.z;
        int n2 = 1;
        if (this.value != null) {
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                n2 += this.value[i2];
                if (!bl) continue;
            }
        }
        return n2;
    }

    protected void validate() {
        if (this.value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.value.length < 2 || this.value.length > 128 || this.value[0] > 2 || this.value[0] != 2 && this.value[1] > 39) {
            throw new Asn1InvalidObjectIDException();
        }
    }

    public String toXMLValue() {
        boolean bl = Asn1Exception.z;
        this.validate();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.value.length - 1; ++i2) {
            stringBuffer.append(this.value[i2]);
            stringBuffer.append('.');
            if (!bl) continue;
        }
        stringBuffer.append(this.value[this.value.length - 1]);
        return stringBuffer.toString();
    }

    public String toString() {
        boolean bl = Asn1Exception.z;
        if (this.value == null) {
            throw new NullPointerException("Object identifier value is null!");
        }
        StringBuffer stringBuffer = new StringBuffer(this.value.length * 4 + 3);
        stringBuffer.append("{ ");
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            String string = Integer.toString(this.value[i2]);
            if (stringBuffer.length() + string.length() + 2 >= stringBuffer.capacity()) {
                stringBuffer.ensureCapacity((string.length() + 1) * (this.value.length - i2) + 1);
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
            if (!bl) continue;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        int n2;
        boolean bl2 = Asn1Exception.z;
        if (this.value.length < 2 || this.value[0] > 2 || this.value[0] != 2 && this.value[1] > 39) {
            throw new Asn1InvalidObjectIDException();
        }
        int n3 = 1;
        for (n2 = 2; n2 < this.value.length; ++n2) {
            n3 += h.d(this.value[n2]);
            if (!bl2) continue;
        }
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeLength(n3);
        long l2 = this.value[0] * 40 + this.value[1];
        asn1BerOutputStream.encodeIdentifier(l2);
        for (n2 = 2; n2 < this.value.length; ++n2) {
            asn1BerOutputStream.encodeIdentifier(this.value[n2]);
            if (!bl2) continue;
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        if (this.value.length < 2 || this.value[0] > 2 || this.value[0] != 2 && this.value[1] > 39) {
            throw new Asn1InvalidObjectIDException();
        }
        asn1PerOutputStream.encodeOIDLengthAndValue(this.value);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (int[])objectInputStream.readObject();
    }
}

