/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType$SaxHandler;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1XerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerSaxHandler;
import com.objsys.asn1j.runtime.Asn1XmlEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.Asn1XmlXerEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class Asn1OpenType
extends Asn1OctetString {
    public static final int UNKNOWN = 0;
    public static final int BER = 1;
    public static final int PER = 2;
    public static final int XER = 3;
    public static final int JSON = 4;
    protected transient int mLength;
    protected transient Asn1EncodeBuffer mEncodeBuffer;
    protected int dataEncoding;
    private char[] e;
    protected static final String EDATAMSG = "ENCODED DATA";
    private transient Asn1XerSaxHandler f;
    private static final long serialVersionUID = 1794928988706612636L;

    public Asn1OpenType() {
        this.f = null;
        this.mLength = 0;
        this.dataEncoding = 0;
    }

    public Asn1OpenType(byte[] byArray) {
        this(byArray, 0);
    }

    public Asn1OpenType(byte[] byArray, int n2) {
        super(byArray);
        this.f = null;
        if (n2 == 4) {
            throw new IllegalArgumentException("encoding == JSON");
        }
        this.mLength = 0;
        this.dataEncoding = n2;
    }

    public Asn1OpenType(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, 0);
    }

    public Asn1OpenType(byte[] byArray, int n2, int n3, int n4) {
        super(byArray, n2, n3);
        this.f = null;
        if (n4 == 4) {
            throw new IllegalArgumentException("encoding == JSON");
        }
        this.mLength = 0;
        this.dataEncoding = n4;
    }

    public Asn1OpenType(Asn1EncodeBuffer asn1EncodeBuffer) {
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = Asn1Exception.z;
                    this.f = null;
                    this.value = null;
                    this.dataEncoding = 0;
                    if (!(asn1EncodeBuffer instanceof Asn1BerEncodeBuffer)) break block2;
                    this.mLength = asn1EncodeBuffer.getMsgLength();
                    this.mEncodeBuffer = asn1EncodeBuffer;
                    this.dataEncoding = 1;
                    if (!bl) break block3;
                }
                if (!(asn1EncodeBuffer instanceof Asn1XerEncodeBuffer) && !(asn1EncodeBuffer instanceof Asn1XmlEncodeBuffer)) break block4;
                this.value = asn1EncodeBuffer.getMsgCopy();
                this.dataEncoding = 3;
                if (!bl) break block3;
            }
            this.value = asn1EncodeBuffer.getMsgCopy();
        }
    }

    public Asn1OpenType(int n2) {
        this.f = null;
        this.mLength = n2;
        this.value = null;
        this.dataEncoding = 0;
    }

    public Asn1OpenType(String string, int n2) {
        this(string.toCharArray(), n2);
    }

    public Asn1OpenType(char[] cArray, int n2) {
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = Asn1Exception.z;
                    this.f = null;
                    if (n2 != 3) break block2;
                    this.value = Asn1OpenType.a(cArray, "UTF-8");
                    if (!bl) break block3;
                }
                if (n2 != 4) break block4;
                this.e = cArray;
                this.value = null;
                if (!bl) break block3;
            }
            throw new IllegalArgumentException("encoding not JSON");
        }
        this.dataEncoding = n2;
    }

    public char[] getCharData() {
        if (this.dataEncoding != 4) {
            throw new RuntimeException("getCharData not supported for this data encoding");
        }
        return this.e;
    }

    public void setBinaryData(byte[] byArray, int n2) {
        if (this.dataEncoding == 4) {
            throw new RuntimeException("setBinaryData invoked for JSON.Use setCharData for JSON data ");
        }
        if (byArray == null) {
            throw new NullPointerException("data is null");
        }
        this.value = byArray;
        this.e = null;
        this.dataEncoding = n2;
    }

    public void setCharData(String string, int n2) {
        this.setCharData(string.toCharArray(), n2);
    }

    public void setCharData(char[] cArray, int n2) {
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = Asn1Exception.z;
                    if (cArray == null) {
                        throw new NullPointerException("data is null");
                    }
                    if (n2 != 4) break block4;
                    this.value = null;
                    this.e = cArray;
                    this.dataEncoding = n2;
                    if (!bl) break block5;
                }
                if (n2 != 3) break block6;
                this.setBinaryData(Asn1OpenType.a(cArray, "UTF-8"), n2);
                if (!bl) break block5;
            }
            throw new RuntimeException("invalid encoding specified");
        }
    }

    public int getDataEncoding() {
        return this.dataEncoding;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        this.value = asn1BerDecodeBuffer.decodeOpenType();
        asn1BerDecodeBuffer.setTypeCode((short)99);
        this.dataEncoding = 1;
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        if (this.dataEncoding != 1 && this.dataEncoding != 0) {
            throw new Asn1Exception("Asn1OpenType: trying to encode non-BER data to BER");
        }
        return this.value != null ? super.encode(asn1BerEncodeBuffer, false) : this.mLength;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        super.decode(asn1PerDecodeBuffer);
        this.dataEncoding = 2;
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.dataEncoding != 2 && this.dataEncoding != 0) {
            throw new Asn1Exception("Asn1OpenType: trying to encode non-PER data to PER");
        }
        asn1PerEncodeBuffer.encodeOpenType(this.value, 0, this.value.length);
    }

    private void a(Asn1XmlXerEncoder asn1XmlXerEncoder) throws IOException, Asn1Exception {
        asn1XmlXerEncoder.copy("<!-- unknown binary extension item ");
        asn1XmlXerEncoder.indent();
        byte[] byArray = this.a();
        String string = Asn1Util.toHexString(byArray, 0, byArray.length);
        asn1XmlXerEncoder.copy(string);
        asn1XmlXerEncoder.indent();
        asn1XmlXerEncoder.copy("-->");
    }

    public void encodeAsExtension(Asn1XmlEncoder asn1XmlEncoder) throws IOException, Asn1Exception {
        block3: {
            block2: {
                if (this.dataEncoding == 3) break block2;
                asn1XmlEncoder.indent();
                this.a(asn1XmlEncoder);
                if (!Asn1Exception.z) break block3;
            }
            this.encode(asn1XmlEncoder, null, null);
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        this.encode(asn1XmlEncoder);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder) throws IOException, Asn1Exception {
        block3: {
            block2: {
                if (this.dataEncoding == 3) break block2;
                asn1XmlEncoder.encodeHexStrValue(this.a());
                if (!Asn1Exception.z) break block3;
            }
            asn1XmlEncoder.copy(new String(this.value));
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        asn1XerEncoder.encodeStartElement(string);
        this.encode(asn1XerEncoder);
        asn1XerEncoder.encodeEndElement(string);
    }

    public void encodeAsExtension(Asn1XerEncoder asn1XerEncoder) throws IOException, Asn1Exception {
        block5: {
            block4: {
                if (this.dataEncoding == 3) break block4;
                if (asn1XerEncoder.getState() == 3) {
                    asn1XerEncoder.indent();
                }
                this.a(asn1XerEncoder);
                if (!Asn1Exception.z) break block5;
            }
            this.encode(asn1XerEncoder);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder) throws IOException, Asn1Exception {
        block7: {
            block6: {
                int n2;
                boolean bl = Asn1Exception.z;
                if (asn1XerEncoder.getState() == 3) {
                    asn1XerEncoder.indent();
                }
                if (this.dataEncoding != 3) break block6;
                for (n2 = 0; this.value[n2] < 48 && n2 < this.value.length; ++n2) {
                    if (!bl) continue;
                }
                if (n2 < this.value.length) {
                    asn1XerEncoder.copy(this.value, n2, this.value.length - n2);
                }
                if (!bl) break block7;
            }
            asn1XerEncoder.encodeHexStrValue(this.a());
        }
    }

    private static byte[] a(char[] cArray, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
            outputStreamWriter.write(cArray);
            outputStreamWriter.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("unsupported encoding exception: " + string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private byte[] a() throws IOException {
        if (this.dataEncoding == 4) {
            return Asn1OpenType.a(this.e, "UTF-8");
        }
        return this.value;
    }

    public void decodeExtension(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer, String string) throws IOException {
        String string2 = asn1JsonDecodeBuffer.readJsonValue();
        int n2 = string.length();
        int n3 = string2.length();
        this.e = new char[n2 + n3 + 3];
        this.e[0] = 34;
        string.getChars(0, n2, this.e, 1);
        this.e[n2 + 1] = 34;
        this.e[n2 + 2] = 58;
        string2.getChars(0, n3, this.e, n2 + 3);
        this.dataEncoding = 4;
    }

    public void encodeAsExtension(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        if (this.dataEncoding == 4) {
            asn1JsonOutputStream.write(this.e);
        }
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        block5: {
            int n2;
            block6: {
                boolean bl;
                block4: {
                    bl = Asn1Exception.z;
                    n2 = asn1JsonDecodeBuffer.seekCharacter();
                    if (n2 < 0) {
                        throw new Asn1Exception("unexpected end of input");
                    }
                    if (n2 != 123) break block4;
                    asn1JsonDecodeBuffer.readCharacter('{');
                    asn1JsonDecodeBuffer.readString("value");
                    asn1JsonDecodeBuffer.readCharacter(':');
                    String string = asn1JsonDecodeBuffer.readJsonValue();
                    asn1JsonDecodeBuffer.readCharacter('}');
                    this.e = string.toCharArray();
                    this.dataEncoding = 4;
                    if (!bl) break block5;
                }
                if (n2 != 34) break block6;
                super.decode(asn1JsonDecodeBuffer);
                this.dataEncoding = 0;
                if (!bl) break block5;
            }
            throw new Asn1Exception("expected '{' or '\"' but found '" + (char)n2 + "'");
        }
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        block3: {
            block2: {
                if (this.dataEncoding != 4) break block2;
                asn1JsonOutputStream.write(123);
                asn1JsonOutputStream.write("\"value\":");
                asn1JsonOutputStream.write(this.e);
                asn1JsonOutputStream.write(125);
                if (!Asn1Exception.z) break block3;
            }
            super.encode(asn1JsonOutputStream);
        }
    }

    public String toString() {
        if (this.dataEncoding == 3) {
            if (this.value != null) {
                try {
                    return new String(this.value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return EDATAMSG;
        }
        if (this.dataEncoding == 4) {
            if (this.e != null) {
                return new String(this.e);
            }
            return EDATAMSG;
        }
        if (this.value != null) {
            return super.toString();
        }
        if (this.mEncodeBuffer != null) {
            return this.mEncodeBuffer.toString();
        }
        return EDATAMSG;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (this.dataEncoding != 1 && this.dataEncoding != 0) {
            throw new Asn1Exception("Asn1OpenType: trying to encode non-BER data to BER");
        }
        if (this.value != null) {
            asn1BerOutputStream.write(this.value);
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        if (this.dataEncoding != 2 && this.dataEncoding != 0) {
            throw new Asn1Exception("Asn1OpenType: trying to encode non-PER data to PER");
        }
        asn1PerOutputStream.encodeOpenType(this.value, 0, this.value.length);
    }

    public Asn1XerSaxHandler getSaxHandler() {
        return this.getSaxHandler(true);
    }

    public Asn1XerSaxHandler getSaxHandler(boolean bl) {
        if (this.f == null) {
            this.f = new Asn1OpenType$SaxHandler(this, bl);
        }
        return this.f;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeInt(this.mLength);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.mLength = objectInputStream.readInt();
        this.mEncodeBuffer = null;
    }
}

