/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1DecodeBuffer;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1InvalidArgException;
import com.objsys.asn1j.runtime.Asn1PerDecodeTraceHandler;
import com.objsys.asn1j.runtime.Asn1PerMessageBuffer;
import com.objsys.asn1j.runtime.Asn1PerTraceHandler;
import com.objsys.asn1j.runtime.Asn1PerUtil;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class Asn1PerDecodeBuffer
extends Asn1DecodeBuffer
implements Asn1PerMessageBuffer {
    private int g = -1;
    private int h;
    private boolean i;
    protected Asn1PerTraceHandler mTraceHandler = new Asn1PerDecodeTraceHandler(this);
    private static h j = com.objsys.asn1j.runtime.h.a();

    public Asn1PerDecodeBuffer(byte[] byArray, boolean bl) {
        super(byArray);
        this.i = bl;
    }

    public Asn1PerDecodeBuffer(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.i = bl;
    }

    public void binDump(String string) {
        this.binDump(System.out, string);
    }

    public void binDump(PrintStream printStream, String string) {
        this.mTraceHandler.print(printStream, string);
    }

    public void byteAlign() {
        if (this.i) {
            this.g = -1;
        }
    }

    public boolean decodeBit(String string) throws Asn1EndOfBufferException, IOException {
        if (string != null) {
            this.mTraceHandler.newBitField(string, 1);
        }
        if (this.g < 0) {
            this.h = this.read();
            this.g = 7;
        }
        boolean bl = (this.h & 1 << this.g) != 0;
        --this.g;
        return bl;
    }

    public boolean decodeBit() throws Asn1EndOfBufferException, IOException {
        return this.decodeBit("value");
    }

    public long decodeBitsToLong(int n2, String string) throws Asn1Exception, IOException {
        long l2;
        block8: {
            int n3;
            boolean bl;
            block9: {
                int n4;
                bl = Asn1Exception.z;
                if (n2 < 0 || n2 > 64) {
                    throw new Asn1InvalidArgException("nbits", Integer.toString(n2));
                }
                if (string != null) {
                    this.mTraceHandler.newBitField(string, n2);
                }
                l2 = 0L;
                if (n2 <= 0) break block8;
                if (this.g < 0) {
                    this.h = this.read();
                    this.g = 7;
                }
                if (n2 > (n4 = this.g + 1)) break block9;
                n3 = (1 << n4) - 1;
                l2 = this.h & n3;
                l2 >>>= n4 - n2;
                this.g -= n2;
                if (!bl) break block8;
            }
            n3 = (1 << this.g + 1) - 1;
            l2 = this.h & n3;
            n2 -= this.g + 1;
            this.g = -1;
            while (n2 >= 8) {
                this.h = this.read();
                l2 = l2 << 8 | (long)this.h;
                n2 -= 8;
                if (!bl) continue;
            }
            if (n2 > 0) {
                this.h = this.read();
                this.g = 7 - n2;
                l2 = l2 << n2 | (long)(this.h >>> this.g + 1);
            }
        }
        j.lcheck(2);
        return l2;
    }

    public long decodeBitsToLong(int n2) throws Asn1Exception, IOException {
        return this.decodeBitsToLong(n2, "value");
    }

    public int decodeBitsToInt(int n2, String string) throws Asn1Exception, IOException {
        if (n2 < 0 || n2 > 32) {
            throw new Asn1InvalidArgException("nbits", Integer.toString(n2));
        }
        return (int)this.decodeBitsToLong(n2, string);
    }

    public int decodeBitsToInt(int n2) throws Asn1Exception, IOException {
        return this.decodeBitsToInt(n2, "value");
    }

    public void decodeBitsToOctetArray(byte[] byArray, int n2, int n3, String string) throws Asn1Exception, IOException {
        this.decodeBitsToOctetArray(byArray, n2, 0, n3, string);
    }

    public void decodeBitsToOctetArray(byte[] byArray, int n2, int n3, int n4, String string) throws Asn1Exception, IOException {
        int n5;
        int n6;
        block12: {
            int n7;
            block13: {
                boolean bl;
                block14: {
                    block11: {
                        bl = Asn1Exception.z;
                        if (n3 < 0 || n3 > 7) {
                            throw new Asn1InvalidArgException("bitOffset", Integer.toString(n3));
                        }
                        if (string != null) {
                            this.mTraceHandler.newBitField(string, n4);
                        }
                        int n8 = (n4 + n3 + 7) / 8;
                        n6 = 0;
                        if (n8 > byArray.length - n2) {
                            throw new Asn1EndOfBufferException(this);
                        }
                        j.lcheck(2);
                        if (n3 != 0) {
                            n5 = 8 - n3;
                            if (n5 > n4) {
                                n5 = n4;
                            }
                            int n9 = n2;
                            byArray[n9] = (byte)(byArray[n9] & 255 << 8 - n3);
                            int n10 = n2++;
                            byArray[n10] = (byte)(byArray[n10] | this.decodeBitsToInt(n5, null));
                            --n8;
                            n4 -= n5;
                        }
                        if (this.g != -1) break block11;
                        this.read(byArray, n2, n8);
                        n6 = n2 + n8 - 1;
                        if ((n4 %= 8) == 0) break block12;
                        this.h = byArray[n6];
                        this.g = 7 - n4;
                        if (!bl) break block12;
                    }
                    n6 = n2;
                    n5 = this.g + 1;
                    n7 = 8 - n5;
                    while (n4 >= 8) {
                        byArray[n6] = (byte)(this.h << n7);
                        this.h = this.read();
                        int n11 = n6++;
                        byArray[n11] = (byte)(byArray[n11] | (byte)(this.h >> n5));
                        n4 -= 8;
                        if (!bl) continue;
                    }
                    if (n4 < n5) break block13;
                    byArray[n6] = (byte)(this.h << n7);
                    int n12 = n4 - n5;
                    if (n12 <= 0) break block14;
                    this.h = this.read();
                    int n13 = n6;
                    byArray[n13] = (byte)(byArray[n13] | (byte)(this.h >> n5));
                    this.g = 7 - n12;
                    if (!bl) break block12;
                }
                this.g = -1;
                if (!bl) break block12;
            }
            if (n4 > 0) {
                byArray[n6] = (byte)(this.h << n7);
                this.g -= n4;
            }
        }
        if (n4 > 0) {
            n5 = -1 << 8 - n4;
            byArray[n6] = (byte)(byArray[n6] & n5);
        }
    }

    public void decodeBitsToOctetArray(byte[] byArray, int n2, int n3) throws Asn1Exception, IOException {
        this.decodeBitsToOctetArray(byArray, n2, n3, "value");
    }

    public void decodeCharString(int n2, int n3, int n4, Asn1CharSet asn1CharSet, StringBuffer stringBuffer) throws Asn1Exception, IOException {
        block8: {
            int n5;
            int n6;
            int n7;
            boolean bl;
            block7: {
                bl = Asn1Exception.z;
                if (asn1CharSet == null) break block7;
                n7 = 0;
                n6 = asn1CharSet.getNumBitsPerChar(this.isAligned());
                if (n6 < 31 && (1 << n6) - 1 < asn1CharSet.getMaxValue()) {
                    n7 = 1;
                }
                this.mTraceHandler.newBitField("value", n2 * n6);
                for (int i2 = 0; i2 < n2; ++i2) {
                    n5 = this.decodeBitsToInt(n6, null);
                    if (n7 == 0) {
                        stringBuffer.append((char)n5);
                        if (!bl) continue;
                    }
                    stringBuffer.append((char)asn1CharSet.getCharAtIndex(n5));
                    if (!bl) continue;
                }
                if (!bl) break block8;
            }
            n6 = this.isAligned() ? n3 : n4;
            this.mTraceHandler.newBitField("value", n2 * n6);
            for (n7 = 0; n7 < n2; ++n7) {
                n5 = this.decodeBitsToInt(n6, null);
                stringBuffer.append((char)n5);
                if (!bl) continue;
            }
        }
        j.lcheck(2);
    }

    public long decodeConsWholeNumber(long l2, String string) throws Asn1Exception, IOException {
        long l3;
        block6: {
            block8: {
                int n2;
                boolean bl;
                block7: {
                    block5: {
                        bl = Asn1Exception.z;
                        n2 = Asn1Integer.getUnsignedBitCount(l2 - 1L);
                        j.lcheck(2);
                        if (this.i) break block5;
                        l3 = this.decodeBitsToLong(n2, string);
                        if (!bl) break block6;
                    }
                    if (l2 > 0L && l2 <= 65536L) break block7;
                    int n3 = Asn1Integer.getBitCount((n2 + 7) / 8 - 1);
                    int n4 = this.decodeBitsToInt(n3, "length");
                    this.byteAlign();
                    n3 = (n4 + 1) * 8;
                    l3 = this.decodeBitsToLong(n3, "value");
                    if (!bl) break block6;
                }
                if (l2 > 255L) break block8;
                l3 = this.decodeBitsToLong(n2, string);
                if (!bl) break block6;
            }
            if (l2 == 256L) {
                this.byteAlign();
                return this.decodeBitsToLong(8, string);
            }
            this.byteAlign();
            l3 = this.decodeBitsToLong(16, string);
        }
        if (l2 != 0L && l3 - Long.MIN_VALUE >= l2 - Long.MIN_VALUE) {
            throw new Asn1ConsVioException("adjValue", l3);
        }
        return l3;
    }

    public long decodeConsWholeNumber(long l2) throws Asn1Exception, IOException {
        return this.decodeConsWholeNumber(l2, "value");
    }

    public long decodeExtLength() throws Asn1Exception, IOException {
        long l2 = this.decodeLength();
        long l3 = this.getBitOffset();
        return l2 * 8L + l3;
    }

    public long decodeInt(int n2, boolean bl, String string) throws Asn1Exception, IOException {
        this.mTraceHandler.newBitField(string, n2 * 8);
        return com.objsys.asn1j.runtime.h.a(this, n2, bl);
    }

    public long decodeInt(int n2, boolean bl) throws Asn1Exception, IOException {
        return this.decodeInt(n2, bl, "value");
    }

    public long decodeLength() throws Asn1Exception, IOException {
        int n2;
        block5: {
            block4: {
                n2 = 0;
                this.byteAlign();
                if (!this.decodeBit("extlen1")) break block4;
                if (this.decodeBit("extlen2")) {
                    int n3 = this.decodeBitsToInt(6, "len/16k");
                    return 16384 * n3;
                }
                n2 = this.decodeBitsToInt(14, "length");
                if (!Asn1Exception.z) break block5;
            }
            n2 = this.decodeBitsToInt(7, "length");
        }
        j.lcheck(2);
        return n2;
    }

    public long decodeLength(long l2, long l3) throws Asn1Exception, IOException {
        if (l3 < 65536L) {
            if (l2 != l3) {
                return this.decodeConsWholeNumber(l3 - l2 + 1L, "length") + l2;
            }
            return l2;
        }
        return this.decodeLength();
    }

    public int decodeSmallLength() throws Asn1Exception, IOException {
        if (this.decodeBit("extbit")) {
            int n2 = (int)this.decodeLength();
            if (n2 >= 16384) {
                throw new Asn1Exception("small length is too large");
            }
            j.lcheck(2);
            return n2;
        }
        return this.decodeBitsToInt(6) + 1;
    }

    public int decodeSmallNonNegWholeNumber() throws Asn1Exception, IOException {
        if (this.decodeBit("extbit")) {
            int n2 = (int)this.decodeLength();
            if (n2 > 4) {
                throw new Asn1Exception("small non-negative whole number is too large");
            }
            this.byteAlign();
            int n3 = (int)this.decodeInt(n2, false);
            if (n3 < 0) {
                throw new Asn1Exception("small non-negative whole number can't be negative");
            }
            j.lcheck(2);
            return n3;
        }
        return this.decodeBitsToInt(6);
    }

    public long getBitOffset() {
        return Asn1PerUtil.getMsgBitCnt(this.mByteCount - 1, this.g);
    }

    public int getMsgBitCnt() {
        return Asn1PerUtil.getMsgBitCnt(this.mByteCount - 1, this.g);
    }

    public boolean isAligned() {
        return this.i;
    }

    public void moveBitCursor(long l2) throws Asn1EndOfBufferException, IOException {
        boolean bl = Asn1Exception.z;
        for (long i2 = this.getBitOffset(); i2 < l2; ++i2) {
            this.decodeBit(null);
            if (!bl) continue;
        }
    }

    public int readByte() throws Asn1Exception, IOException {
        return this.decodeBitsToInt(8, null);
    }

    public void setAligned(boolean bl) {
        this.i = bl;
    }

    public static Asn1PerDecodeBuffer setBuffer(Asn1PerDecodeBuffer asn1PerDecodeBuffer, byte[] byArray, boolean bl) {
        if (asn1PerDecodeBuffer == null) {
            return new Asn1PerDecodeBuffer(byArray, bl);
        }
        asn1PerDecodeBuffer.setInputStream(byArray, 0, byArray.length);
        return asn1PerDecodeBuffer;
    }

    public void setInputStream(byte[] byArray, int n2, int n3) {
        super.setInputStream(byArray, n2, n3);
        this.g = -1;
        this.h = 0;
    }

    public Asn1PerTraceHandler getTraceHandler() {
        return this.mTraceHandler;
    }
}

