/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerMessageBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.Asn1XmlXerEncoder;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1UniversalString
extends Asn1Type {
    public static final int BITSPERCHAR = 32;
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 28);
    public transient int[] value;
    protected transient StringBuffer mStringBuffer;
    private static final int[] d = new int[]{-2048, -65536, -2097152, -67108864};
    private static final int[] e = new int[]{192, 224, 240, 248, 252};
    private static final long serialVersionUID = -1570296157849439388L;

    public Asn1UniversalString() {
        this.value = new int[0];
    }

    public Asn1UniversalString(int[] nArray) {
        this.value = nArray;
    }

    public Asn1UniversalString(String string) {
        this.a(string);
    }

    private void a(String string) {
        block6: {
            boolean bl;
            block5: {
                bl = Asn1Exception.z;
                if (string != null) break block5;
                this.value = new int[0];
                if (!bl) break block6;
            }
            int n2 = string.codePointCount(0, string.length());
            this.value = new int[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                this.value[n4] = string.codePointAt(n3);
                if (this.value[n4] > 65535) {
                    ++n3;
                }
                ++n4;
                ++n3;
                if (!bl) continue;
            }
        }
    }

    private void a(Asn1BerDecodeBuffer asn1BerDecodeBuffer, int n2, IntHolder intHolder) throws Asn1Exception, IOException {
        int n3;
        int n4;
        boolean bl;
        block9: {
            block8: {
                bl = Asn1Exception.z;
                if (n2 < 0 || n2 % 4 != 0) {
                    throw new Asn1InvalidLengthException();
                }
                n4 = n2 / 4;
                if (this.value.length != 0) break block8;
                this.value = new int[n4];
                if (!bl) break block9;
            }
            if (intHolder.value + n4 >= this.value.length) {
                this.a(intHolder.value + n4);
            }
        }
        for (n3 = intHolder.value; n3 < intHolder.value + n4; ++n3) {
            this.value[n3] = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                int n5 = asn1BerDecodeBuffer.read();
                if (n5 == -1) {
                    throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                }
                this.value[n3] = this.value[n3] * 256 + n5;
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        intHolder.value = n3;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1UniversalString.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        IntHolder intHolder = new IntHolder(0);
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n4 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            while (!asn1BerDecodeContext.expired()) {
                int n5 = Asn1UniversalString.matchTag(asn1BerDecodeBuffer, Asn1OctetString.TAG);
                if (n5 > 0) {
                    n4 += n5;
                    this.a(asn1BerDecodeBuffer, n5, intHolder);
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n3 == -9999) {
                Asn1UniversalString.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            this.a(asn1BerDecodeBuffer, n3, intHolder);
        }
        asn1BerDecodeBuffer.setTypeCode((short)28);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = this.value.length;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = this.value[i2];
            for (int i3 = 0; i3 < 4; ++i3) {
                int n4 = n3 % 256;
                n3 /= 256;
                asn1BerEncodeBuffer.copy((byte)n4);
            }
        }
        n2 *= 4;
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 32, 32, null);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 32, 32, asn1CharSet);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 32, 32, asn1CharSet, l2, l3);
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            int n6 = n5;
            n5 += n4;
            asn1PerDecodeBuffer.byteAlign();
            if (this.value.length == 0) {
                this.value = new int[n5];
            } else {
                this.a(n5);
            }
            this.decode(asn1PerDecodeBuffer, n4, n2, n3, asn1CharSet, n6);
        } while (n4 >= 16384);
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2, int n3, int n4, Asn1CharSet asn1CharSet, int n5) throws Asn1Exception, IOException {
        if (asn1CharSet != null) {
            boolean bl = false;
            int n6 = asn1CharSet.getNumBitsPerChar(asn1PerDecodeBuffer.isAligned());
            if (n6 < 31 && (1 << n6) - 1 < asn1CharSet.getMaxValue()) {
                bl = true;
            }
            asn1PerDecodeBuffer.mTraceHandler.newBitField("value", n2 * n6);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n7 = asn1PerDecodeBuffer.decodeBitsToInt(n6, null);
                this.value[n5 + i2] = !bl ? n7 : asn1CharSet.getCharAtIndex(n7);
            }
        } else {
            int n8 = asn1PerDecodeBuffer.isAligned() ? n3 : n4;
            asn1PerDecodeBuffer.mTraceHandler.newBitField("value", n2 * n8);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n9;
                this.value[n5 + i3] = n9 = asn1PerDecodeBuffer.decodeBitsToInt(n8, null);
            }
        }
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        if (l3 < 65536L) {
            int n4 = (int)asn1PerDecodeBuffer.decodeLength(l2, l3);
            if (n4 > 0) {
                int n5 = asn1CharSet == null ? (asn1PerDecodeBuffer.isAligned() ? n2 : n3) : asn1CharSet.getNumBitsPerChar(asn1PerDecodeBuffer.isAligned());
                this.a(asn1PerDecodeBuffer, n5, l2, l3);
                this.value = new int[n4];
                this.decode(asn1PerDecodeBuffer, n4, n2, n3, asn1CharSet, 0);
            }
        } else {
            this.decode(asn1PerDecodeBuffer, n2, n3, asn1CharSet);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 32, 32, null);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 32, 32, asn1CharSet);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 32, 32, asn1CharSet, l2, l3);
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n2, int n3, int n4, int n5, Asn1CharSet asn1CharSet) throws Asn1Exception {
        if (asn1CharSet != null) {
            boolean bl = false;
            int n6 = asn1CharSet.getNumBitsPerChar(asn1PerEncodeBuffer.isAligned());
            if (n6 < 31 && (1 << n6) - 1 < asn1CharSet.getMaxValue()) {
                bl = true;
            }
            asn1PerEncodeBuffer.mTraceHandler.newBitField("value", n2 * n6);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n7 = this.value[n3 + i2];
                if (!bl) {
                    asn1PerEncodeBuffer.encodeInt((long)n7, n6, null);
                    continue;
                }
                int n8 = asn1CharSet.getCharIndex(n7);
                asn1PerEncodeBuffer.encodeInt((long)n8, n6, null);
            }
        } else {
            int n9 = asn1PerEncodeBuffer.isAligned() ? n4 : n5;
            asn1PerEncodeBuffer.mTraceHandler.newBitField("value", n2 * n9);
            for (int i3 = 0; i3 < n2; ++i3) {
                asn1PerEncodeBuffer.encodeInt((long)this.value[n3 + i3], n9, null);
            }
        }
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n4 = this.value.length;
        int n5 = 0;
        while (true) {
            int n6;
            if ((n6 = (int)asn1PerEncodeBuffer.encodeLength(n4)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                this.encode(asn1PerEncodeBuffer, n6, n5, n2, n3, asn1CharSet);
            }
            if ((n4 -= n6) <= 0) break;
            n5 += n6;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(n4);
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        int n4 = this.value.length;
        if ((long)n4 >= l2 && (long)n4 <= l3) {
            if (l3 < 65536L) {
                asn1PerEncodeBuffer.encodeLength(n4, l2, l3);
                if (n4 > 0) {
                    int n5 = asn1CharSet == null ? (asn1PerEncodeBuffer.isAligned() ? n2 : n3) : asn1CharSet.getNumBitsPerChar(asn1PerEncodeBuffer.isAligned());
                    this.a(asn1PerEncodeBuffer, n5, l2, l3);
                    this.encode(asn1PerEncodeBuffer, n4, 0, n2, n3, asn1CharSet);
                }
            } else {
                this.encode(asn1PerEncodeBuffer, n2, n3, asn1CharSet);
            }
        } else {
            throw new Asn1ConsVioException("Asn1UniversalString.length", n4);
        }
    }

    private void a(Asn1PerMessageBuffer asn1PerMessageBuffer, int n2, long l2, long l3) {
        block5: {
            boolean bl;
            block7: {
                long l4;
                block6: {
                    if (!asn1PerMessageBuffer.isAligned()) break block5;
                    l4 = l3 * (long)n2;
                    bl = true;
                    if (l3 != l2) break block6;
                    if (l4 > 16L) break block7;
                    bl = false;
                    if (!Asn1Exception.z) break block7;
                }
                if (l4 < 16L) {
                    bl = false;
                }
            }
            if (bl) {
                asn1PerMessageBuffer.byteAlign();
            }
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "UniversalString";
        }
        asn1XerEncoder.encodeStartElement(string);
        this.encodeData(asn1XerEncoder);
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        string = string.trim();
        this.value = new int[string.length()];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            this.value[i2] = string.charAt(i2);
            if (!bl) continue;
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "UniversalString";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        this.encodeData(asn1XmlEncoder);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeData(Asn1XmlXerEncoder asn1XmlXerEncoder) throws IOException, Asn1Exception {
        boolean bl = Asn1Exception.z;
        byte[] byArray = new byte[6];
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            int n2;
            int n3 = this.value[i2];
            if (n3 < 0 || n3 > Integer.MAX_VALUE) {
                throw new Asn1Exception("not a correct ISO 10646 encoded string");
            }
            if (n3 < 128) {
                asn1XmlXerEncoder.copy((byte)n3);
                if (!bl) continue;
            }
            for (n2 = 2; n2 < 6 && ((n3 & d[n2 - 2]) != 0 || bl); ++n2) {
                if (!bl) continue;
            }
            int n4 = n2;
            byArray[0] = (byte)e[n2 - 2];
            --n2;
            do {
                byArray[n2] = (byte)(0x80 | n3 & 0x3F);
                n3 >>>= 6;
            } while (--n2 > 0);
            byArray[0] = (byte)(byArray[0] | n3);
            asn1XmlXerEncoder.copy(byArray, 0, n4);
            if (!bl) continue;
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        this.a(asn1JsonDecodeBuffer.readString());
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        asn1JsonOutputStream.encodeString(this.toString());
    }

    public boolean equals(Object object) {
        boolean bl = Asn1Exception.z;
        if (this == object) {
            return true;
        }
        if (object instanceof Asn1UniversalString) {
            Asn1UniversalString asn1UniversalString = (Asn1UniversalString)object;
            if (this.value == null) {
                return asn1UniversalString.value == null;
            }
            if (asn1UniversalString.value == null) {
                return false;
            }
            if (this.value.length != asn1UniversalString.value.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                if (this.value[i2] == asn1UniversalString.value[i2]) continue;
                return false;
            }
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.value.length != string.length()) {
                return false;
            }
            for (int i3 = 0; i3 < this.value.length; ++i3) {
                if (this.value[i3] == string.charAt(i3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        boolean bl = Asn1Exception.z;
        if (this.value == null) {
            return 1;
        }
        int n2 = 1;
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            n2 += this.value[i2];
            if (!bl) continue;
        }
        return n2;
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.value.length;
    }

    public String toString() {
        return new String(this.value, 0, this.value.length);
    }

    private void a(int n2) {
        int[] nArray = this.value;
        this.value = new int[n2];
        if (nArray != null) {
            System.arraycopy(nArray, 0, this.value, 0, nArray.length);
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        asn1BerOutputStream.encodeUnivString(this.value, bl, TAG);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 32, 32, null);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 32, 32, asn1CharSet);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 32, 32, asn1CharSet, l2, l3);
        asn1PerOutputStream.a(false);
    }

    protected void encode(Asn1PerOutputStream asn1PerOutputStream, int n2, int n3, int n4, int n5, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, n2, n3, n4, n5, asn1CharSet);
        asn1PerOutputStream.a(false);
    }

    protected void encode(Asn1PerOutputStream asn1PerOutputStream, int n2, int n3, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, n2, n3, asn1CharSet);
        asn1PerOutputStream.a(false);
    }

    protected void encode(Asn1PerOutputStream asn1PerOutputStream, int n2, int n3, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, n2, n3, asn1CharSet, l2, l3);
        asn1PerOutputStream.a(false);
    }

    public boolean validate(Asn1CharSet asn1CharSet) {
        return asn1CharSet.validate(this.toString());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (int[])objectInputStream.readObject();
    }
}

