/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.agreement;

import gnu.crypto.agreement.BaseAgreement;
import gnu.crypto.agreement.ECDHAgreement;
import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.key.ecdsa.ECDSAPrivateKey;
import gnu.crypto.key.ecdsa.ECDSAPublicKey;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECDomainParameter;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import gnu.crypto.util.Util;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class ECCofactorDHAgreement
implements BaseAgreement {
    ECDSAPrivateKey a;

    @Override
    public byte[] calculateAgreement(Key pubKey) {
        ECDSAPublicKey eCDSAPublicKey = ECDSAPublicKey.fromECPublicKey((ECPublicKey)pubKey);
        ECDomainParameter eCDomainParameter = eCDSAPublicKey.getMParameters();
        BigInteger bigInteger = BigInteger.valueOf(eCDomainParameter.getCofactor());
        ECGNUPoint eCGNUPoint = eCDSAPublicKey.getMQ().multiply(bigInteger.multiply(this.a.getMD()));
        BigInteger bigInteger2 = eCGNUPoint.getAffineX();
        boolean bl = ECDHAgreement.b();
        int n2 = (eCDSAPublicKey.getMParameters().getCurve().getField().getFieldSize() + 7) / 8;
        byte[] byArray = Util.toBytes(bigInteger2, n2);
        if (bl) {
            BaseCipher.b("ASNIS");
        }
        return byArray;
    }

    @Override
    public void init(Key privKey) {
        this.a = ECDSAPrivateKey.fromECPrivateKey((ECPrivateKey)privKey);
    }
}

