/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pad;

import gnu.crypto.pad.IPad;
import gnu.crypto.pad.WrongPaddingException;

public abstract class BasePad
implements IPad {
    protected String name;
    protected int blockSize;

    protected BasePad(String name) {
        this.name = name;
        this.blockSize = -1;
    }

    @Override
    public String name() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        try {
            if (this.blockSize != -1) {
                stringBuffer.append('-').append(String.valueOf(8 * this.blockSize));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BasePad.b(illegalStateException);
        }
        return stringBuffer.toString();
    }

    @Override
    public void init(int bs) throws IllegalStateException {
        try {
            if (this.blockSize != -1) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BasePad.b(illegalStateException);
        }
        this.blockSize = bs;
        this.setup();
    }

    @Override
    public void reset() {
        this.blockSize = -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean selfTest() {
        int n2 = 5;
        int n3 = 1024;
        byte[] byArray = new byte[1024];
        int n4 = WrongPaddingException.b();
        for (int i2 = 2; i2 < 256; ++i2) {
            this.init(i2);
            for (int i3 = 0; i3 < 1019 - this.blockSize; ++i3) {
                byte[] byArray2 = this.pad(byArray, 5, i3);
                try {
                    if ((i3 + byArray2.length) % this.blockSize != 0) {
                        new RuntimeException(this.name()).printStackTrace(System.err);
                        return false;
                    }
                }
                catch (WrongPaddingException wrongPaddingException) {
                    throw BasePad.b(wrongPaddingException);
                }
                try {
                    System.arraycopy(byArray2, 0, byArray, 5 + i3, byArray2.length);
                    try {
                        if (byArray2.length == this.unpad(byArray, 5, i3 + byArray2.length)) continue;
                        new RuntimeException(this.name()).printStackTrace(System.err);
                        return false;
                    }
                    catch (WrongPaddingException wrongPaddingException) {
                        wrongPaddingException.printStackTrace(System.err);
                        return false;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw BasePad.b(illegalStateException);
                }
            }
            this.reset();
            if (n4 == 0) continue;
        }
        return true;
    }

    public abstract void setup();

    @Override
    public abstract byte[] pad(byte[] var1, int var2, int var3);

    @Override
    public abstract int unpad(byte[] var1, int var2, int var3) throws WrongPaddingException;

    private static Exception b(Exception exception) {
        return exception;
    }
}

