/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.math.BigInteger;

public class CurveFp
extends Curve {
    private static final String c;

    public CurveFp(Field aField, BigInteger aA, BigInteger aB) throws EllipticCurveException {
        super(aField, aA, aB);
        if (!(this.mField instanceof FieldFp)) {
            throw new EllipticCurveException(c);
        }
    }

    @Override
    public boolean onCurve(BigInteger aAffineX, BigInteger aAffineY) {
        BigInteger bigInteger = this.mField.getMSize();
        return aAffineY.pow(2).mod(bigInteger).compareTo(aAffineX.pow(3).add(this.mA.multiply(aAffineX)).add(this.mB).mod(bigInteger)) == 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n2;
            char[] cArray2;
            int n3;
            int n4;
            block11: {
                char[] cArray3 = "\u0003K%2v7\u0018?M<w7q\u0001(H52r{\r A?f".toCharArray();
                int n5 = cArray3.length;
                n4 = 0;
                n3 = 64;
                cArray2 = cArray3;
                n2 = n5;
                if (n5 <= 1) break block11;
                cArray = cArray2;
                n2 = n2;
                if (n2 <= n4) break block12;
            }
            do {
                int n6 = n3;
                cArray2 = cArray2;
                char[] cArray4 = cArray2;
                int n7 = n3;
                int n8 = n4;
                while (true) {
                    int n9;
                    switch (n4 % 7) {
                        case 0: {
                            n9 = 13;
                            break;
                        }
                        case 1: {
                            n9 = 100;
                            break;
                        }
                        case 2: {
                            n9 = 17;
                            break;
                        }
                        case 3: {
                            n9 = 82;
                            break;
                        }
                        case 4: {
                            n9 = 87;
                            break;
                        }
                        case 5: {
                            n9 = 87;
                            break;
                        }
                        default: {
                            n9 = 40;
                        }
                    }
                    cArray4[n8] = (char)(cArray4[n8] ^ (n7 ^ n9));
                    ++n4;
                    n3 = n6;
                    if (n6 != 0) break;
                    n6 = n3;
                    cArray2 = cArray2;
                    n8 = n3;
                    cArray4 = cArray2;
                    n7 = n3;
                }
                cArray = cArray2;
                n2 = n2;
            } while (n2 > n4);
        }
        c = new String(cArray).intern();
    }
}

