/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.ElementF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;

public abstract class ECGNUPoint
extends ECPoint {
    static Chronometer a;
    public static final int COMPRESSED = 0;
    public static final int UNCOMPRESSED = 1;
    public static final int HYBRID = 2;
    protected static final BigInteger TWO;
    protected static final BigInteger THREE;
    protected static final BigInteger FOUR;
    protected static final BigInteger EIGHT;
    protected final Curve mCurve;
    protected final Field mField;
    private static int b;
    private static final String[] g;
    private static final String[] h;

    public static void sifirla() {
        a.reset();
    }

    public static void yaz() {
        System.out.println(a.toString(ECGNUPoint.a(-17333, 31523)));
        a.reset();
    }

    public ECGNUPoint(Curve aCurve) {
        super(TWO, TWO);
        this.mCurve = aCurve;
        this.mField = this.mCurve.mField;
    }

    protected BigInteger[] fromOctetString(byte[] aOctet) throws EllipticCurveException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        block25: {
            block22: {
                boolean bl;
                byte by;
                block24: {
                    block20: {
                        by = aOctet[0];
                        try {
                            if (by != 2 && by != 3) break block20;
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                        bl = false;
                        break block24;
                    }
                    if (by == 4) {
                        bl = true;
                    } else {
                        throw new EllipticCurveException(ECGNUPoint.a(-17335, -28791));
                    }
                }
                if (!bl) {
                    block21: {
                        byte[] byArray = new byte[aOctet.length - 1];
                        System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                        bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                        try {
                            try {
                                if (by == 2 || by == 3) break block21;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                            throw new EllipticCurveException(ECGNUPoint.a(-17339, 348));
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                    }
                    bigInteger = this._convert(bigInteger2, by - 2);
                } else {
                    block23: {
                        try {
                            try {
                                if (!bl) break block22;
                                if (by == 4) break block23;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                            throw new EllipticCurveException(ECGNUPoint.a(-17330, 18914));
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                    }
                    int n2 = aOctet.length - 1;
                    try {
                        if ((n2 & 1) == 1) {
                            throw new EllipticCurveException(ECGNUPoint.a(-17338, 399));
                        }
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                    byte[] byArray = new byte[n2 >>= 1];
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(aOctet, 1, byArray, 0, byArray.length);
                    bigInteger2 = this.mField.fromOctetToFieldElement(byArray);
                    System.arraycopy(aOctet, byArray.length + 1, byArray2, 0, byArray2.length);
                    bigInteger = this.mField.fromOctetToFieldElement(byArray2);
                }
                break block25;
            }
            throw new EllipticCurveException();
        }
        try {
            if (!this.mCurve.onCurve(bigInteger2, bigInteger)) {
                throw new EllipticCurveException(ECGNUPoint.a(-17340, 7442));
            }
        }
        catch (EllipticCurveException ellipticCurveException) {
            throw ECGNUPoint.b(ellipticCurveException);
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public final ECGNUPoint add(ECGNUPoint aElem) throws EllipticCurveException {
        block10: {
            try {
                if (!this.getClass().isInstance(aElem)) {
                    throw new EllipticCurveException(ECGNUPoint.a(-17336, -29307));
                }
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
            try {
                block9: {
                    try {
                        try {
                            if (this.mCurve == aElem.mCurve) break block9;
                            if (!this.mField.equals(aElem.mField)) break block10;
                        }
                        catch (EllipticCurveException ellipticCurveException) {
                            throw ECGNUPoint.b(ellipticCurveException);
                        }
                        if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block10;
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                }
                return this._add(aElem);
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
        }
        throw new EllipticCurveException(ECGNUPoint.a(-17331, -30071));
    }

    protected abstract ECGNUPoint _add(ECGNUPoint var1);

    public void addToThis(ECGNUPoint aElem) throws EllipticCurveException {
        block13: {
            int n2 = ECGNUPoint.b();
            try {
                if (!this.getClass().isInstance(aElem)) {
                    throw new EllipticCurveException(ECGNUPoint.a(-17329, 29023));
                }
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
            try {
                block12: {
                    try {
                        block11: {
                            try {
                                try {
                                    if (this.mCurve == aElem.mCurve) break block11;
                                    if (!this.mField.equals(aElem.mField)) break block12;
                                }
                                catch (EllipticCurveException ellipticCurveException) {
                                    throw ECGNUPoint.b(ellipticCurveException);
                                }
                                if (!this.mCurve.onCurve(aElem.getAffineX(), aElem.getAffineY())) break block12;
                            }
                            catch (EllipticCurveException ellipticCurveException) {
                                throw ECGNUPoint.b(ellipticCurveException);
                            }
                        }
                        this._addToThis(aElem);
                        if (n2 != 0) break block13;
                    }
                    catch (EllipticCurveException ellipticCurveException) {
                        throw ECGNUPoint.b(ellipticCurveException);
                    }
                }
                throw new EllipticCurveException(ECGNUPoint.a(-17334, -23029));
            }
            catch (EllipticCurveException ellipticCurveException) {
                throw ECGNUPoint.b(ellipticCurveException);
            }
        }
    }

    protected abstract void _addToThis(ECGNUPoint var1);

    public abstract ECGNUPoint negate();

    public abstract void negateThis();

    public ECGNUPoint multiply(BigInteger aKatsayi) {
        int n2 = 5;
        ECGNUPoint[] eCGNUPointArray = new ECGNUPoint[1 << n2 - 1];
        ECGNUPoint eCGNUPoint = (ECGNUPoint)this.clone();
        int n3 = ECGNUPoint.b();
        eCGNUPointArray[0] = eCGNUPoint;
        ECGNUPoint eCGNUPoint2 = eCGNUPoint.multiplyBy2();
        for (int i2 = 1; i2 < eCGNUPointArray.length; ++i2) {
            eCGNUPointArray[i2] = eCGNUPointArray[i2 - 1]._add(eCGNUPoint2);
            if (n3 != 0) continue;
        }
        return this.multiply(aKatsayi, eCGNUPointArray);
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, BigInteger aN) {
        BigInteger bigInteger;
        int n2;
        block15: {
            block14: {
                n2 = ECGNUPoint.b();
                if (aN != null) break block14;
                bigInteger = aKatsayi;
                if (n2 != 0) break block15;
            }
            bigInteger = aKatsayi.mod(aN);
        }
        BigInteger bigInteger2 = bigInteger.add(bigInteger).add(bigInteger);
        ECGNUPoint eCGNUPoint = (ECGNUPoint)this.clone();
        ECGNUPoint eCGNUPoint2 = this.negate();
        for (int i2 = bigInteger2.bitLength() - 2; i2 > 0; --i2) {
            try {
                try {
                    try {
                        block13: {
                            try {
                                try {
                                    eCGNUPoint.multiplyThisBy2();
                                    if (!bigInteger2.testBit(i2) || bigInteger.testBit(i2)) break block13;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw ECGNUPoint.b(runtimeException);
                                }
                                eCGNUPoint._addToThis(this);
                                if (n2 != 0) continue;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ECGNUPoint.b(runtimeException);
                            }
                        }
                        if (bigInteger2.testBit(i2)) continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ECGNUPoint.b(runtimeException);
                    }
                    if (!bigInteger.testBit(i2)) continue;
                }
                catch (RuntimeException runtimeException) {
                    throw ECGNUPoint.b(runtimeException);
                }
                eCGNUPoint._addToThis(eCGNUPoint2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
        }
        return eCGNUPoint;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[][] aPreComputation) {
        byte[] byArray = this.a(aKatsayi);
        int n2 = 0;
        int n3 = ECGNUPoint.c();
        while (byArray[n2] == 0) {
            ++n2;
            if (n3 == 0) continue;
        }
        ECGNUPoint eCGNUPoint = (ECGNUPoint)aPreComputation[n2][byArray[n2] - 1].clone();
        ++n2;
        while (n2 < byArray.length) {
            try {
                if (byArray[n2] != 0) {
                    eCGNUPoint._addToThis(aPreComputation[n2][byArray[n2] - 1]);
                }
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            ++n2;
            if (n3 == 0) continue;
        }
        return eCGNUPoint;
    }

    private byte[] a(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength() / 4 + 1;
        byte[] byArray = new byte[n2];
        int n3 = ECGNUPoint.c();
        int n4 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n5;
            try {
                int n6 = n5 = bigInteger.testBit(n4++) ? 1 : 0;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            if (bigInteger.testBit(n4++)) {
                n5 = (byte)(n5 + 2);
            }
            if (bigInteger.testBit(n4++)) {
                n5 = (byte)(n5 + 4);
            }
            if (bigInteger.testBit(n4++)) {
                n5 = (byte)(n5 + 8);
            }
            byArray[i2] = n5;
            if (n3 == 0) continue;
        }
        return byArray;
    }

    public ECGNUPoint multiply(BigInteger aKatsayi, ECGNUPoint[] aOddPowers) {
        ECGNUPoint eCGNUPoint;
        int n2;
        int[] nArray;
        int n3;
        block13: {
            block12: {
                int n4 = aKatsayi.bitLength();
                n3 = ECGNUPoint.b();
                nArray = new int[n4 + 1];
                ECGNUPoint.determineNAF(nArray, aKatsayi, 5);
                n2 = n4;
                while (nArray[n2] == 0) {
                    --n2;
                    if (n3 != 0) continue;
                }
                if (nArray[n2] <= 0) break block12;
                eCGNUPoint = (ECGNUPoint)aOddPowers[nArray[n2] - 1 >> 1].clone();
                if (n3 != 0) break block13;
            }
            eCGNUPoint = aOddPowers[0 - nArray[n2] - 1 >> 1].negate();
        }
        --n2;
        while (n2 >= 0) {
            block11: {
                try {
                    try {
                        block10: {
                            try {
                                eCGNUPoint.multiplyThisBy2();
                                if (nArray[n2] <= 0) break block10;
                                eCGNUPoint._addToThis(aOddPowers[nArray[n2] - 1 >> 1]);
                                if (n3 != 0) break block11;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ECGNUPoint.b(runtimeException);
                            }
                        }
                        if (nArray[n2] >= 0) break block11;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ECGNUPoint.b(runtimeException);
                    }
                    eCGNUPoint._addToThis(aOddPowers[0 - nArray[n2] - 1 >> 1].negate());
                }
                catch (RuntimeException runtimeException) {
                    throw ECGNUPoint.b(runtimeException);
                }
            }
            --n2;
            if (n3 != 0) continue;
        }
        return eCGNUPoint;
    }

    /*
     * Unable to fully structure code
     */
    public ECGNUPoint multiplyAndAdd(BigInteger aKatsayi, ECGNUPoint[] aOddPowers, ECGNUPoint aQ, BigInteger aKatsayi2) {
        block31: {
            var6_5 = 5;
            var9_6 = new ECGNUPoint[1 << var6_5 - 1];
            var5_7 = ECGNUPoint.b();
            var9_6[0] = var10_8 = (ECGNUPoint)aQ.clone();
            var11_9 = var10_8.multiplyBy2();
            for (var12_10 = 1; var12_10 < var9_6.length; ++var12_10) {
                var9_6[var12_10] = var9_6[var12_10 - 1]._add(var11_9);
                if (var5_7 != 0) continue;
            }
            var7_12 = aKatsayi.bitLength();
            var8_13 = aKatsayi2.bitLength();
            if (var8_13 > var7_12) {
                var7_12 = var8_13;
            }
            var12_11 = new int[var7_12 + 1];
            var13_14 = new int[var7_12 + 1];
            ECGNUPoint.determineNAF(var12_11, aKatsayi, var6_5);
            ECGNUPoint.determineNAF(var13_14, aKatsayi2, var6_5);
            var14_15 = var7_12;
            while (var12_11[var14_15] == 0) {
                try {
                    if (var13_14[var14_15] != 0) break;
                    --var14_15;
                    if (var5_7 != 0) continue;
                    break;
                }
                catch (RuntimeException v0) {
                    throw ECGNUPoint.b(v0);
                }
            }
            var15_16 = null;
            var16_17 = null;
            if (var12_11[var14_15] > 0) {
                var15_16 = (ECGNUPoint)aOddPowers[var12_11[var14_15] - 1 >> 1].clone();
            } else if (var12_11[var14_15] < 0) {
                var15_16 = aOddPowers[0 - var12_11[var14_15] - 1 >> 1].negate();
            }
            if (var13_14[var14_15] > 0) {
                var16_17 = (ECGNUPoint)var9_6[var13_14[var14_15] - 1 >> 1].clone();
            } else if (var13_14[var14_15] < 0) {
                var16_17 = var9_6[0 - var13_14[var14_15] - 1 >> 1].negate();
            }
            if (var15_16 != null) ** GOTO lbl43
            var15_16 = var16_17;
            try {
                try {
                    if (var5_7 != 0) break block31;
lbl43:
                    // 2 sources

                    if (var16_17 == null) break block31;
                }
                catch (RuntimeException v1) {
                    throw ECGNUPoint.b(v1);
                }
                var15_16._addToThis(var16_17);
            }
            catch (RuntimeException v2) {
                throw ECGNUPoint.b(v2);
            }
        }
        --var14_15;
        while (var14_15 >= 0) {
            block35: {
                block33: {
                    try {
                        try {
                            block32: {
                                try {
                                    ElementF2mPolynomial.say = true;
                                    var15_16.multiplyThisBy2();
                                    ElementF2mPolynomial.say = false;
                                    if (var12_11[var14_15] <= 0) break block32;
                                    var15_16._addToThis(aOddPowers[var12_11[var14_15] - 1 >> 1]);
                                    if (var5_7 != 0) break block33;
                                }
                                catch (RuntimeException v3) {
                                    throw ECGNUPoint.b(v3);
                                }
                            }
                            if (var12_11[var14_15] >= 0) break block33;
                        }
                        catch (RuntimeException v4) {
                            throw ECGNUPoint.b(v4);
                        }
                        var15_16._addToThis(aOddPowers[0 - var12_11[var14_15] - 1 >> 1].negate());
                    }
                    catch (RuntimeException v5) {
                        throw ECGNUPoint.b(v5);
                    }
                }
                try {
                    try {
                        block34: {
                            try {
                                if (var13_14[var14_15] <= 0) break block34;
                                var15_16._addToThis(var9_6[var13_14[var14_15] - 1 >> 1]);
                                if (var5_7 != 0) break block35;
                            }
                            catch (RuntimeException v6) {
                                throw ECGNUPoint.b(v6);
                            }
                        }
                        if (var13_14[var14_15] >= 0) break block35;
                    }
                    catch (RuntimeException v7) {
                        throw ECGNUPoint.b(v7);
                    }
                    var15_16._addToThis(var9_6[0 - var13_14[var14_15] - 1 >> 1].negate());
                }
                catch (RuntimeException v8) {
                    throw ECGNUPoint.b(v8);
                }
            }
            --var14_15;
            if (var5_7 != 0) continue;
        }
        try {
            v9 = var15_16;
            if (BaseCipher.b() != null) {
                ECGNUPoint.b(++var5_7);
            }
        }
        catch (RuntimeException v10) {
            throw ECGNUPoint.b(v10);
        }
        return v9;
    }

    public void multiplyThisBy(BigInteger aKatsayi) {
        throw new RuntimeException();
    }

    public void multiplyThisBy(BigInteger aKatsayi, BigInteger aN) {
        throw new RuntimeException();
    }

    public ECGNUPoint multiplyBy2() {
        return this._add(this);
    }

    public void multiplyThisBy2() {
        this._addToThis(this);
    }

    @Override
    public abstract boolean equals(Object var1);

    public abstract Object clone();

    @Override
    public abstract BigInteger getAffineX();

    @Override
    public abstract BigInteger getAffineY();

    protected abstract boolean _ypTilda();

    protected abstract BigInteger _convert(BigInteger var1, int var2) throws EllipticCurveException;

    public byte[] toOctetString(int aCompressionMode) {
        byte[] byArray = this.b(this.getAffineX());
        if (aCompressionMode == 0) {
            int n2;
            byte[] byArray2 = new byte[byArray.length + 1];
            try {
                byte[] byArray3 = byArray2;
                int n3 = 0;
                n2 = this._ypTilda() ? 3 : 2;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            byArray3[n3] = n2;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        if (aCompressionMode == 1) {
            byte[] byArray4 = this.b(this.getAffineY());
            byte[] byArray5 = new byte[byArray.length + byArray4.length + 1];
            byArray5[0] = 4;
            System.arraycopy(byArray, 0, byArray5, 1, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length + 1, byArray4.length);
            return byArray5;
        }
        if (aCompressionMode == 2) {
            int n4;
            byte[] byArray6 = this.b(this.getAffineY());
            byte[] byArray7 = new byte[byArray.length + byArray6.length + 1];
            try {
                byte[] byArray8 = byArray7;
                int n5 = 0;
                n4 = this._ypTilda() ? 7 : 6;
            }
            catch (RuntimeException runtimeException) {
                throw ECGNUPoint.b(runtimeException);
            }
            byArray8[n5] = n4;
            System.arraycopy(byArray, 0, byArray7, 1, byArray.length);
            System.arraycopy(byArray6, 0, byArray7, byArray.length + 1, byArray6.length);
            return byArray7;
        }
        throw new RuntimeException();
    }

    private byte[] b(BigInteger bigInteger) {
        byte[] byArray;
        int n2 = (this.mCurve.getField().getFieldSize() + 7) / 8;
        if (n2 < (byArray = bigInteger.toByteArray()).length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (n2 > byArray.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    protected static final void determineNAF(int[] N, BigInteger e2, int wi) {
        int n2 = 1 << wi;
        int n3 = ECGNUPoint.b();
        BigInteger bigInteger = e2.abs();
        int n4 = e2.signum();
        int n5 = 0;
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            int n6;
            block11: {
                block10: {
                    if (!bigInteger.testBit(0)) break block10;
                    n6 = bigInteger.intValue() & (n2 << 1) - 1;
                    if ((n6 & n2) != 0) {
                        n6 -= n2 << 1;
                    }
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(n6));
                    if (n3 != 0) break block11;
                }
                n6 = 0;
            }
            try {
                int n7;
                try {
                    int[] nArray = N;
                    int n8 = n5++;
                    n7 = n4 > 0 ? n6 : -n6;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw ECGNUPoint.b(arrayIndexOutOfBoundsException);
                }
                nArray[n8] = n7;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ArrayIndexOutOfBoundsException(ECGNUPoint.a(-17332, -24322) + n5);
            }
            bigInteger = bigInteger.shiftRight(1);
            if (n3 != 0) continue;
        }
        while (n5 < N.length) {
            N[n5++] = 0;
            if (n3 != 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "J\u0089\u008e[\u00da/7B\u0013!mj+\u0099\u00df|:\u0090Gk?\u00a1\u0086dd&D\u00a9D]\u00fb%\u00b7\u00c9\u0084\u0098\u00f7p\u00ef\u00a2\u0004\u00fe\u0011\u00170\u00d7\u00e3\u00e6d\u00a0U\u0013\u00b0V\u00f3=\u00e6\u00a5nd\u00e44w\u007f\u009a\u00bc\u0017Z\u00e6\u00bc\n\u00be\u00f4Z9\u009b\u0095\u00fc%L\u0014\u00fb\u00ce\u00de\byr{\u00cbb\u00eb\u00e0\u00de\u00c3\u00a0\u00cc\u00a0\u0012\u0000A\u008e\u00e0\u00bc`<\u00ae\u00af\u00caDN\u00d56\u0002DP\u00f5\u0012\u00a8O\u009b!\u001eXh\u00a9%*\u0015R\u00ff\u00b5G4\u00f8\u00fb\rya\u00a1\u00e4Y\u00e0\u0087\u00b2\"\u008a@\u00ca?\u0013\u00ea\u00ac\u0013\u0013\u00b6\u00d8\u0099\u00da,[\u00fc\u00bcS\u00f6:j\u00ed\u0085\u00d0\u000b\u0000\u0096\u00c7\u00b8\u00f3S\u0012\u00cd\u001f\u0007\u00dc\u000f\f\u00d4\u0097\u0010x\u001e\u00ea&\u00f5\u001d\u00f0\u00a8\u0017x\u00ee\u0012\u0089\u00ae)T\u00dd\u00d0,>\u001d\u00d0\u00e2\u00bdk'M(\u00f8\u0011";
                var4_3 = "J\u0089\u008e[\u00da/7B\u0013!mj+\u0099\u00df|:\u0090Gk?\u00a1\u0086dd&D\u00a9D]\u00fb%\u00b7\u00c9\u0084\u0098\u00f7p\u00ef\u00a2\u0004\u00fe\u0011\u00170\u00d7\u00e3\u00e6d\u00a0U\u0013\u00b0V\u00f3=\u00e6\u00a5nd\u00e44w\u007f\u009a\u00bc\u0017Z\u00e6\u00bc\n\u00be\u00f4Z9\u009b\u0095\u00fc%L\u0014\u00fb\u00ce\u00de\byr{\u00cbb\u00eb\u00e0\u00de\u00c3\u00a0\u00cc\u00a0\u0012\u0000A\u008e\u00e0\u00bc`<\u00ae\u00af\u00caDN\u00d56\u0002DP\u00f5\u0012\u00a8O\u009b!\u001eXh\u00a9%*\u0015R\u00ff\u00b5G4\u00f8\u00fb\rya\u00a1\u00e4Y\u00e0\u0087\u00b2\"\u008a@\u00ca?\u0013\u00ea\u00ac\u0013\u0013\u00b6\u00d8\u0099\u00da,[\u00fc\u00bcS\u00f6:j\u00ed\u0085\u00d0\u000b\u0000\u0096\u00c7\u00b8\u00f3S\u0012\u00cd\u001f\u0007\u00dc\u000f\f\u00d4\u0097\u0010x\u001e\u00ea&\u00f5\u001d\u00f0\u00a8\u0017x\u00ee\u0012\u0089\u00ae)T\u00dd\u00d0,>\u001d\u00d0\u00e2\u00bdk'M(\u00f8\u0011".length();
                var1_4 = 8;
                var0_5 = -1;
                ECGNUPoint.b(42);
lbl8:
                // 2 sources

                while (true) {
                    v0 = 48;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u008a\u00c78\u00d7\u008da\u00fdip\u00d5XJ\u00b1qio\u00daw\b\u0017\u0006\u00c2M\u00b4\n\u001d\u0001";
                    var4_3 = "\u008a\u00c78\u00d7\u008da\u00fdip\u00d5XJ\u00b1qio\u00daw\b\u0017\u0006\u00c2M\u00b4\n\u001d\u0001".length();
                    var1_4 = 18;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 55;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 30;
                            break;
                        }
                        case 1: {
                            v15 = 97;
                            break;
                        }
                        case 2: {
                            v15 = 72;
                            break;
                        }
                        case 3: {
                            v15 = 62;
                            break;
                        }
                        case 4: {
                            v15 = 98;
                            break;
                        }
                        case 5: {
                            v15 = 14;
                            break;
                        }
                        default: {
                            v15 = 69;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        ECGNUPoint.g = var5;
        ECGNUPoint.h = new String[12];
        ECGNUPoint.a = new Chronometer(ECGNUPoint.a(-17337, 5581));
        ECGNUPoint.TWO = new BigInteger("2");
        ECGNUPoint.THREE = new BigInteger("3");
        ECGNUPoint.FOUR = new BigInteger("4");
        ECGNUPoint.EIGHT = new BigInteger("8");
    }

    public static void b(int n2) {
        b = n2;
    }

    public static int b() {
        return b;
    }

    public static int c() {
        int n2 = ECGNUPoint.b();
        try {
            if (n2 == 0) {
                return 111;
            }
        }
        catch (RuntimeException runtimeException) {
            throw ECGNUPoint.b(runtimeException);
        }
        return 0;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0xFFFFBC4E) & 0xFFFF;
        if (h[n4] == null) {
            int n5;
            int n6;
            char[] cArray = g[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 58;
                    break;
                }
                case 1: {
                    n6 = 21;
                    break;
                }
                case 2: {
                    n6 = 79;
                    break;
                }
                case 3: {
                    n6 = 169;
                    break;
                }
                case 4: {
                    n6 = 221;
                    break;
                }
                case 5: {
                    n6 = 245;
                    break;
                }
                case 6: {
                    n6 = 70;
                    break;
                }
                case 7: {
                    n6 = 57;
                    break;
                }
                case 8: {
                    n6 = 39;
                    break;
                }
                case 9: {
                    n6 = 229;
                    break;
                }
                case 10: {
                    n6 = 109;
                    break;
                }
                case 11: {
                    n6 = 85;
                    break;
                }
                case 12: {
                    n6 = 160;
                    break;
                }
                case 13: {
                    n6 = 191;
                    break;
                }
                case 14: {
                    n6 = 147;
                    break;
                }
                case 15: {
                    n6 = 30;
                    break;
                }
                case 16: {
                    n6 = 48;
                    break;
                }
                case 17: {
                    n6 = 66;
                    break;
                }
                case 18: {
                    n6 = 126;
                    break;
                }
                case 19: {
                    n6 = 135;
                    break;
                }
                case 20: {
                    n6 = 121;
                    break;
                }
                case 21: {
                    n6 = 213;
                    break;
                }
                case 22: {
                    n6 = 12;
                    break;
                }
                case 23: {
                    n6 = 95;
                    break;
                }
                case 24: {
                    n6 = 82;
                    break;
                }
                case 25: {
                    n6 = 59;
                    break;
                }
                case 26: {
                    n6 = 252;
                    break;
                }
                case 27: {
                    n6 = 142;
                    break;
                }
                case 28: {
                    n6 = 76;
                    break;
                }
                case 29: {
                    n6 = 232;
                    break;
                }
                case 30: {
                    n6 = 108;
                    break;
                }
                case 31: {
                    n6 = 5;
                    break;
                }
                case 32: {
                    n6 = 89;
                    break;
                }
                case 33: {
                    n6 = 189;
                    break;
                }
                case 34: {
                    n6 = 33;
                    break;
                }
                case 35: {
                    n6 = 123;
                    break;
                }
                case 36: {
                    n6 = 49;
                    break;
                }
                case 37: {
                    n6 = 206;
                    break;
                }
                case 38: {
                    n6 = 125;
                    break;
                }
                case 39: {
                    n6 = 133;
                    break;
                }
                case 40: {
                    n6 = 148;
                    break;
                }
                case 41: {
                    n6 = 17;
                    break;
                }
                case 42: {
                    n6 = 118;
                    break;
                }
                case 43: {
                    n6 = 143;
                    break;
                }
                case 44: {
                    n6 = 7;
                    break;
                }
                case 45: {
                    n6 = 110;
                    break;
                }
                case 46: {
                    n6 = 11;
                    break;
                }
                case 47: {
                    n6 = 224;
                    break;
                }
                case 48: {
                    n6 = 136;
                    break;
                }
                case 49: {
                    n6 = 171;
                    break;
                }
                case 50: {
                    n6 = 144;
                    break;
                }
                case 51: {
                    n6 = 227;
                    break;
                }
                case 52: {
                    n6 = 242;
                    break;
                }
                case 53: {
                    n6 = 158;
                    break;
                }
                case 54: {
                    n6 = 199;
                    break;
                }
                case 55: {
                    n6 = 163;
                    break;
                }
                case 56: {
                    n6 = 225;
                    break;
                }
                case 57: {
                    n6 = 96;
                    break;
                }
                case 58: {
                    n6 = 128;
                    break;
                }
                case 59: {
                    n6 = 75;
                    break;
                }
                case 60: {
                    n6 = 200;
                    break;
                }
                case 61: {
                    n6 = 71;
                    break;
                }
                case 62: {
                    n6 = 238;
                    break;
                }
                case 63: {
                    n6 = 25;
                    break;
                }
                case 64: {
                    n6 = 26;
                    break;
                }
                case 65: {
                    n6 = 168;
                    break;
                }
                case 66: {
                    n6 = 9;
                    break;
                }
                case 67: {
                    n6 = 204;
                    break;
                }
                case 68: {
                    n6 = 146;
                    break;
                }
                case 69: {
                    n6 = 103;
                    break;
                }
                case 70: {
                    n6 = 230;
                    break;
                }
                case 71: {
                    n6 = 55;
                    break;
                }
                case 72: {
                    n6 = 141;
                    break;
                }
                case 73: {
                    n6 = 78;
                    break;
                }
                case 74: {
                    n6 = 14;
                    break;
                }
                case 75: {
                    n6 = 129;
                    break;
                }
                case 76: {
                    n6 = 132;
                    break;
                }
                case 77: {
                    n6 = 150;
                    break;
                }
                case 78: {
                    n6 = 186;
                    break;
                }
                case 79: {
                    n6 = 63;
                    break;
                }
                case 80: {
                    n6 = 177;
                    break;
                }
                case 81: {
                    n6 = 139;
                    break;
                }
                case 82: {
                    n6 = 187;
                    break;
                }
                case 83: {
                    n6 = 196;
                    break;
                }
                case 84: {
                    n6 = 202;
                    break;
                }
                case 85: {
                    n6 = 228;
                    break;
                }
                case 86: {
                    n6 = 244;
                    break;
                }
                case 87: {
                    n6 = 28;
                    break;
                }
                case 88: {
                    n6 = 211;
                    break;
                }
                case 89: {
                    n6 = 81;
                    break;
                }
                case 90: {
                    n6 = 247;
                    break;
                }
                case 91: {
                    n6 = 237;
                    break;
                }
                case 92: {
                    n6 = 235;
                    break;
                }
                case 93: {
                    n6 = 231;
                    break;
                }
                case 94: {
                    n6 = 166;
                    break;
                }
                case 95: {
                    n6 = 203;
                    break;
                }
                case 96: {
                    n6 = 87;
                    break;
                }
                case 97: {
                    n6 = 29;
                    break;
                }
                case 98: {
                    n6 = 32;
                    break;
                }
                case 99: {
                    n6 = 124;
                    break;
                }
                case 100: {
                    n6 = 174;
                    break;
                }
                case 101: {
                    n6 = 157;
                    break;
                }
                case 102: {
                    n6 = 84;
                    break;
                }
                case 103: {
                    n6 = 218;
                    break;
                }
                case 104: {
                    n6 = 240;
                    break;
                }
                case 105: {
                    n6 = 105;
                    break;
                }
                case 106: {
                    n6 = 181;
                    break;
                }
                case 107: {
                    n6 = 212;
                    break;
                }
                case 108: {
                    n6 = 188;
                    break;
                }
                case 109: {
                    n6 = 239;
                    break;
                }
                case 110: {
                    n6 = 18;
                    break;
                }
                case 111: {
                    n6 = 114;
                    break;
                }
                case 112: {
                    n6 = 117;
                    break;
                }
                case 113: {
                    n6 = 27;
                    break;
                }
                case 114: {
                    n6 = 90;
                    break;
                }
                case 115: {
                    n6 = 219;
                    break;
                }
                case 116: {
                    n6 = 23;
                    break;
                }
                case 117: {
                    n6 = 24;
                    break;
                }
                case 118: {
                    n6 = 164;
                    break;
                }
                case 119: {
                    n6 = 62;
                    break;
                }
                case 120: {
                    n6 = 115;
                    break;
                }
                case 121: {
                    n6 = 106;
                    break;
                }
                case 122: {
                    n6 = 253;
                    break;
                }
                case 123: {
                    n6 = 149;
                    break;
                }
                case 124: {
                    n6 = 99;
                    break;
                }
                case 125: {
                    n6 = 178;
                    break;
                }
                case 126: {
                    n6 = 107;
                    break;
                }
                case 127: {
                    n6 = 50;
                    break;
                }
                case 128: {
                    n6 = 180;
                    break;
                }
                case 129: {
                    n6 = 207;
                    break;
                }
                case 130: {
                    n6 = 161;
                    break;
                }
                case 131: {
                    n6 = 176;
                    break;
                }
                case 132: {
                    n6 = 68;
                    break;
                }
                case 133: {
                    n6 = 40;
                    break;
                }
                case 134: {
                    n6 = 53;
                    break;
                }
                case 135: {
                    n6 = 116;
                    break;
                }
                case 136: {
                    n6 = 54;
                    break;
                }
                case 137: {
                    n6 = 104;
                    break;
                }
                case 138: {
                    n6 = 172;
                    break;
                }
                case 139: {
                    n6 = 246;
                    break;
                }
                case 140: {
                    n6 = 64;
                    break;
                }
                case 141: {
                    n6 = 152;
                    break;
                }
                case 142: {
                    n6 = 167;
                    break;
                }
                case 143: {
                    n6 = 65;
                    break;
                }
                case 144: {
                    n6 = 173;
                    break;
                }
                case 145: {
                    n6 = 91;
                    break;
                }
                case 146: {
                    n6 = 197;
                    break;
                }
                case 147: {
                    n6 = 101;
                    break;
                }
                case 148: {
                    n6 = 34;
                    break;
                }
                case 149: {
                    n6 = 111;
                    break;
                }
                case 150: {
                    n6 = 43;
                    break;
                }
                case 151: {
                    n6 = 3;
                    break;
                }
                case 152: {
                    n6 = 182;
                    break;
                }
                case 153: {
                    n6 = 156;
                    break;
                }
                case 154: {
                    n6 = 60;
                    break;
                }
                case 155: {
                    n6 = 243;
                    break;
                }
                case 156: {
                    n6 = 153;
                    break;
                }
                case 157: {
                    n6 = 83;
                    break;
                }
                case 158: {
                    n6 = 162;
                    break;
                }
                case 159: {
                    n6 = 42;
                    break;
                }
                case 160: {
                    n6 = 80;
                    break;
                }
                case 161: {
                    n6 = 119;
                    break;
                }
                case 162: {
                    n6 = 93;
                    break;
                }
                case 163: {
                    n6 = 31;
                    break;
                }
                case 164: {
                    n6 = 100;
                    break;
                }
                case 165: {
                    n6 = 51;
                    break;
                }
                case 166: {
                    n6 = 56;
                    break;
                }
                case 167: {
                    n6 = 67;
                    break;
                }
                case 168: {
                    n6 = 47;
                    break;
                }
                case 169: {
                    n6 = 234;
                    break;
                }
                case 170: {
                    n6 = 97;
                    break;
                }
                case 171: {
                    n6 = 6;
                    break;
                }
                case 172: {
                    n6 = 170;
                    break;
                }
                case 173: {
                    n6 = 184;
                    break;
                }
                case 174: {
                    n6 = 159;
                    break;
                }
                case 175: {
                    n6 = 134;
                    break;
                }
                case 176: {
                    n6 = 112;
                    break;
                }
                case 177: {
                    n6 = 16;
                    break;
                }
                case 178: {
                    n6 = 217;
                    break;
                }
                case 179: {
                    n6 = 145;
                    break;
                }
                case 180: {
                    n6 = 0;
                    break;
                }
                case 181: {
                    n6 = 209;
                    break;
                }
                case 182: {
                    n6 = 193;
                    break;
                }
                case 183: {
                    n6 = 208;
                    break;
                }
                case 184: {
                    n6 = 255;
                    break;
                }
                case 185: {
                    n6 = 77;
                    break;
                }
                case 186: {
                    n6 = 185;
                    break;
                }
                case 187: {
                    n6 = 236;
                    break;
                }
                case 188: {
                    n6 = 41;
                    break;
                }
                case 189: {
                    n6 = 233;
                    break;
                }
                case 190: {
                    n6 = 61;
                    break;
                }
                case 191: {
                    n6 = 15;
                    break;
                }
                case 192: {
                    n6 = 220;
                    break;
                }
                case 193: {
                    n6 = 122;
                    break;
                }
                case 194: {
                    n6 = 88;
                    break;
                }
                case 195: {
                    n6 = 74;
                    break;
                }
                case 196: {
                    n6 = 251;
                    break;
                }
                case 197: {
                    n6 = 20;
                    break;
                }
                case 198: {
                    n6 = 94;
                    break;
                }
                case 199: {
                    n6 = 13;
                    break;
                }
                case 200: {
                    n6 = 216;
                    break;
                }
                case 201: {
                    n6 = 250;
                    break;
                }
                case 202: {
                    n6 = 175;
                    break;
                }
                case 203: {
                    n6 = 248;
                    break;
                }
                case 204: {
                    n6 = 254;
                    break;
                }
                case 205: {
                    n6 = 154;
                    break;
                }
                case 206: {
                    n6 = 92;
                    break;
                }
                case 207: {
                    n6 = 52;
                    break;
                }
                case 208: {
                    n6 = 130;
                    break;
                }
                case 209: {
                    n6 = 214;
                    break;
                }
                case 210: {
                    n6 = 46;
                    break;
                }
                case 211: {
                    n6 = 113;
                    break;
                }
                case 212: {
                    n6 = 19;
                    break;
                }
                case 213: {
                    n6 = 38;
                    break;
                }
                case 214: {
                    n6 = 183;
                    break;
                }
                case 215: {
                    n6 = 165;
                    break;
                }
                case 216: {
                    n6 = 22;
                    break;
                }
                case 217: {
                    n6 = 45;
                    break;
                }
                case 218: {
                    n6 = 241;
                    break;
                }
                case 219: {
                    n6 = 137;
                    break;
                }
                case 220: {
                    n6 = 37;
                    break;
                }
                case 221: {
                    n6 = 10;
                    break;
                }
                case 222: {
                    n6 = 8;
                    break;
                }
                case 223: {
                    n6 = 4;
                    break;
                }
                case 224: {
                    n6 = 198;
                    break;
                }
                case 225: {
                    n6 = 195;
                    break;
                }
                case 226: {
                    n6 = 215;
                    break;
                }
                case 227: {
                    n6 = 44;
                    break;
                }
                case 228: {
                    n6 = 155;
                    break;
                }
                case 229: {
                    n6 = 194;
                    break;
                }
                case 230: {
                    n6 = 86;
                    break;
                }
                case 231: {
                    n6 = 35;
                    break;
                }
                case 232: {
                    n6 = 2;
                    break;
                }
                case 233: {
                    n6 = 72;
                    break;
                }
                case 234: {
                    n6 = 190;
                    break;
                }
                case 235: {
                    n6 = 222;
                    break;
                }
                case 236: {
                    n6 = 69;
                    break;
                }
                case 237: {
                    n6 = 210;
                    break;
                }
                case 238: {
                    n6 = 192;
                    break;
                }
                case 239: {
                    n6 = 226;
                    break;
                }
                case 240: {
                    n6 = 201;
                    break;
                }
                case 241: {
                    n6 = 36;
                    break;
                }
                case 242: {
                    n6 = 127;
                    break;
                }
                case 243: {
                    n6 = 205;
                    break;
                }
                case 244: {
                    n6 = 223;
                    break;
                }
                case 245: {
                    n6 = 98;
                    break;
                }
                case 246: {
                    n6 = 140;
                    break;
                }
                case 247: {
                    n6 = 179;
                    break;
                }
                case 248: {
                    n6 = 131;
                    break;
                }
                case 249: {
                    n6 = 151;
                    break;
                }
                case 250: {
                    n6 = 1;
                    break;
                }
                case 251: {
                    n6 = 120;
                    break;
                }
                case 252: {
                    n6 = 73;
                    break;
                }
                case 253: {
                    n6 = 249;
                    break;
                }
                case 254: {
                    n6 = 102;
                    break;
                }
                default: {
                    n6 = 138;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            ECGNUPoint.h[n4] = new String(cArray).intern();
        }
        return h[n4];
    }
}

