/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.field;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;

public class FieldF2mPolynomial
extends Field {
    private final int a;
    private final BigInteger c;
    private final byte[] d;
    private final int[] e;
    private final BigInteger f;
    private final int g;
    private static final BigInteger h = BigInteger.ONE;
    private static final BigInteger i = new BigInteger("2");

    private FieldF2mPolynomial(int n2, BigInteger bigInteger) {
        super(h.shiftLeft(n2));
        byte[] byArray;
        this.a = n2;
        this.c = bigInteger;
        this.d = this.c.toByteArray();
        this.f = this.mSize.subtract(i);
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2[0] != 0) {
            byArray = byArray2;
        } else {
            byArray = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray, 0, byArray.length);
        }
        this.e = new int[bigInteger.bitCount()];
        int n3 = byArray.length - 1;
        int n4 = 0;
        int n5 = 0;
        while (n3 >= 0) {
            if (byArray[n3] != 0) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    if (((byArray[n3] & 0xFF) >> i2 & 1) != 1) continue;
                    this.e[n5++] = n4 + i2;
                }
            }
            --n3;
            n4 += 8;
        }
        this.g = this.d[0] == 0 || this.d[0] == 1 ? this.d.length - 1 : this.d.length;
    }

    public static synchronized FieldF2mPolynomial getInstance(int aM, BigInteger aReductionP) {
        FieldF2mPolynomial fieldF2mPolynomial = (FieldF2mPolynomial)INSTANCES.get(h.shiftLeft(aM));
        if (fieldF2mPolynomial == null) {
            fieldF2mPolynomial = new FieldF2mPolynomial(aM, aReductionP);
        }
        return fieldF2mPolynomial;
    }

    public int getMM() {
        return this.a;
    }

    @Override
    public boolean equals(Object aObject) {
        if (super.equals(aObject)) {
            return this.c.equals(((FieldF2mPolynomial)aObject).c);
        }
        return false;
    }

    public BigInteger getMReductionP() {
        return this.c;
    }

    public byte[] getMReductionPArray() {
        return this.d;
    }

    public int[] getMReductionPOnes() {
        return this.e;
    }

    @Override
    public int hashCode() {
        return this.mSize.hashCode() ^ this.c.hashCode();
    }

    @Override
    public BigInteger fromOctetToFieldElement(byte[] aOctet) {
        return new BigInteger(1, aOctet);
    }

    public BigInteger getMFieldSizeMinusOne() {
        return this.mFieldSizeMinusOne;
    }

    public BigInteger getMFieldSizeMinusTwo() {
        return this.f;
    }

    public BigInteger reduce(BigInteger aPol) {
        return this.reduce(aPol.toByteArray());
    }

    public BigInteger reduce(byte[] aPol) {
        int n2;
        int n3;
        byte by;
        int n4;
        int n5;
        int n6;
        int n7 = (aPol.length << 3) - 8 - this.a;
        int n8 = 0;
        String[] stringArray = Field.b();
        while (n8 < aPol.length - this.g) {
            if (aPol[n8] != 0) {
                for (n6 = this.e.length - 2; n6 >= 0; --n6) {
                    n5 = n7 + this.e[n6];
                    n4 = n5 & 7;
                    by = (byte)((aPol[n8] & 0xFF) >> 8 - n4);
                    int n9 = n3 = aPol.length - (n5 >> 3) - 1;
                    aPol[n9] = (byte)(aPol[n9] ^ (byte)(aPol[n8] << n4));
                    if (by <= 0) continue;
                    int n10 = n3 - 1;
                    aPol[n10] = (byte)(aPol[n10] ^ by);
                    if (stringArray != null) continue;
                    BaseCipher.b("CWPPJ");
                    break;
                }
            }
            ++n8;
            n7 -= 8;
            if (stringArray != null) continue;
        }
        if ((n2 = (this.c.bitLength() - 1) % 8) > 0) {
            byte by2 = (byte)((aPol[n8] & 0xFF) >> n2);
            if (by2 != 0) {
                for (n6 = this.e.length - 2; n6 >= 0; --n6) {
                    n5 = this.e[n6];
                    n4 = n5 & 7;
                    by = (byte)((by2 & 0xFF) >> 8 - n4);
                    int n11 = n3 = aPol.length - (n5 >> 3) - 1;
                    aPol[n11] = (byte)(aPol[n11] ^ (byte)(by2 << n4));
                    if (by <= 0) continue;
                    int n12 = n3 - 1;
                    aPol[n12] = (byte)(aPol[n12] ^ by);
                    if (stringArray != null) continue;
                }
            }
            aPol[n8] = (byte)(((byte)(aPol[n8] << 8 - n2) & 0xFF) >> 8 - n2);
        }
        byte[] byArray = new byte[aPol.length < this.g ? aPol.length : this.g];
        System.arraycopy(aPol, aPol.length - byArray.length, byArray, 0, byArray.length);
        return new BigInteger(1, byArray);
    }

    public BigInteger _reduce1(BigInteger aPol) {
        BigInteger bigInteger = aPol;
        String[] stringArray = Field.b();
        while (bigInteger.bitLength() > this.a) {
            BigInteger bigInteger2 = this.c.shiftLeft(bigInteger.bitLength() - this.c.bitLength());
            bigInteger = bigInteger.xor(bigInteger2);
            if (stringArray != null) continue;
        }
        if (BaseCipher.b() != null) {
            Field.b(new String[2]);
        }
        return bigInteger;
    }
}

