/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMembersSupplier
extends ParameterSupplier {
    private final TestClass fClass;

    public AllMembersSupplier(TestClass type) {
        this.fClass = type;
    }

    @Override
    public List<PotentialAssignment> getValueSources(ParameterSignature sig) {
        ArrayList<PotentialAssignment> list = new ArrayList<PotentialAssignment>();
        this.addFields(sig, list);
        this.addSinglePointMethods(sig, list);
        this.addMultiPointMethods(sig, list);
        return list;
    }

    private void addMultiPointMethods(ParameterSignature sig, List<PotentialAssignment> list) {
        for (FrameworkMethod dataPointsMethod : this.fClass.getAnnotatedMethods(DataPoints.class)) {
            try {
                this.addMultiPointArrayValues(sig, dataPointsMethod.getName(), list, dataPointsMethod.invokeExplosively(null, new Object[0]));
            }
            catch (Throwable e2) {}
        }
    }

    private void addSinglePointMethods(ParameterSignature sig, List<PotentialAssignment> list) {
        for (FrameworkMethod dataPointMethod : this.fClass.getAnnotatedMethods(DataPoint.class)) {
            if (!this.isCorrectlyTyped(sig, dataPointMethod.getType())) continue;
            list.add(new MethodParameterValue(dataPointMethod));
        }
    }

    private void addFields(ParameterSignature sig, List<PotentialAssignment> list) {
        for (Field field : this.fClass.getJavaClass().getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Class<?> type = field.getType();
            if (sig.canAcceptArrayType(type) && field.getAnnotation(DataPoints.class) != null) {
                try {
                    this.addArrayValues(field.getName(), list, this.getStaticFieldValue(field));
                }
                catch (Throwable e2) {}
                continue;
            }
            if (!sig.canAcceptType(type) || field.getAnnotation(DataPoint.class) == null) continue;
            list.add(PotentialAssignment.forValue(field.getName(), this.getStaticFieldValue(field)));
        }
    }

    private void addArrayValues(String name, List<PotentialAssignment> list, Object array) {
        for (int i2 = 0; i2 < Array.getLength(array); ++i2) {
            list.add(PotentialAssignment.forValue(name + "[" + i2 + "]", Array.get(array, i2)));
        }
    }

    private void addMultiPointArrayValues(ParameterSignature sig, String name, List<PotentialAssignment> list, Object array) throws Throwable {
        for (int i2 = 0; i2 < Array.getLength(array); ++i2) {
            if (!this.isCorrectlyTyped(sig, Array.get(array, i2).getClass())) {
                return;
            }
            list.add(PotentialAssignment.forValue(name + "[" + i2 + "]", Array.get(array, i2)));
        }
    }

    private boolean isCorrectlyTyped(ParameterSignature parameterSignature, Class<?> type) {
        return parameterSignature.canAcceptType(type);
    }

    private Object getStaticFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalArgumentException e2) {
            throw new RuntimeException("unexpected: field from getClass doesn't exist on object");
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException("unexpected: getFields returned an inaccessible field");
        }
    }

    static class MethodParameterValue
    extends PotentialAssignment {
        private final FrameworkMethod fMethod;

        private MethodParameterValue(FrameworkMethod dataPointMethod) {
            this.fMethod = dataPointMethod;
        }

        public Object getValue() throws PotentialAssignment.CouldNotGenerateValueException {
            try {
                return this.fMethod.invokeExplosively(null, new Object[0]);
            }
            catch (IllegalArgumentException e2) {
                throw new RuntimeException("unexpected: argument length is checked");
            }
            catch (IllegalAccessException e3) {
                throw new RuntimeException("unexpected: getMethods returned an inaccessible method");
            }
            catch (Throwable e4) {
                throw new PotentialAssignment.CouldNotGenerateValueException();
            }
        }

        public String getDescription() throws PotentialAssignment.CouldNotGenerateValueException {
            return this.fMethod.getName();
        }
    }
}

