/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.StatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.deltacrl.DeltaCRLController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Find;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.CertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.cross.CrossCertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.trusted.TrustedCertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.crl.CRLFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.crl.delta.DeltaCRLFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ocsp.OCSPResponseFinder;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;

public class FindSystem {
    private static Logger a;
    private static final List<ECertificate> b;
    private static final List<ECRL> c;
    private List<ECertificate> d = new ArrayList<ECertificate>(0);
    private boolean e;
    private List<CertificateFinder> f = new ArrayList<CertificateFinder>(0);
    private List<CRLFinder> g = new ArrayList<CRLFinder>(0);
    private List<OCSPResponseFinder> h = new ArrayList<OCSPResponseFinder>(0);
    private List<TrustedCertificateFinder> i = new ArrayList<TrustedCertificateFinder>();
    private List<CrossCertificateFinder> j = new ArrayList<CrossCertificateFinder>(0);
    private List<DeltaCRLFinder> k = new ArrayList<DeltaCRLFinder>(0);
    private static final String[] l;
    private static final String[] m;

    public FindSystem() {
        try {
            LV.getInstance().checkLD(LV.Urunler.SERTIFIKADOGRULAMA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(FindSystem.a(4526, -13282) + lE.getMessage());
        }
    }

    public List<ECertificate> getTrustedCertificates() {
        return this.d;
    }

    public void findTrustedCertificates() {
        boolean bl = StatusInfo.c;
        if (!this.e) {
            for (TrustedCertificateFinder trustedCertificateFinder : this.i) {
                this.d.addAll(trustedCertificateFinder.findTrustedCertificate());
                if (!bl) continue;
            }
            this.e = true;
        }
    }

    public void addTrustedCertificate(ECertificate aCertificate) {
        if (this.d.indexOf(aCertificate) < 0) {
            this.d.add(aCertificate);
        }
    }

    public boolean isTrustedCertificate(ECertificate aCertificate) {
        Iterator<ECertificate> iterator = this.d.iterator();
        boolean bl = StatusInfo.c;
        while (iterator.hasNext()) {
            ECertificate eCertificate = iterator.next();
            if (aCertificate.equals(eCertificate)) {
                return true;
            }
            if (!bl) continue;
        }
        return false;
    }

    public List<CertificateFinder> getCertificateFinders() {
        return this.f;
    }

    public void setCertificateFinders(List<CertificateFinder> aCertificateFinders) {
        this.f = aCertificateFinders;
    }

    public void addCertificateFinder(CertificateFinder aCertificateFinder) {
        this.f.add(aCertificateFinder);
    }

    public List<TrustedCertificateFinder> getTrustedCertificateFinders() {
        return this.i;
    }

    public void setTrustedCertificateFinders(List<TrustedCertificateFinder> aTrustedCertificateFinders) {
        this.i = aTrustedCertificateFinders;
    }

    public void addTrustedCertificateFinder(TrustedCertificateFinder aTrustedCertificateFinder) {
        this.i.add(aTrustedCertificateFinder);
    }

    public List<CrossCertificateFinder> getCrossCertificateFinders() {
        return this.j;
    }

    public void setCrossCertificateFinders(List<CrossCertificateFinder> aCrossCertificateFinders) {
        this.j = aCrossCertificateFinders;
    }

    public void addCrossCertificateFinder(CrossCertificateFinder aCrossCertificateFinder) {
        this.j.add(aCrossCertificateFinder);
    }

    public List<CRLFinder> getCRLFinders() {
        return this.g;
    }

    public void setCRLFinders(List<CRLFinder> aCRLFinders) {
        this.g = aCRLFinders;
    }

    public void addCRLFinder(CRLFinder aCRLFinder) {
        this.g.add(aCRLFinder);
    }

    public List<OCSPResponseFinder> getOCSPResponseFinders() {
        return this.h;
    }

    public void setOCSPResponseFinders(List<OCSPResponseFinder> aOCSPResponseFinders) {
        this.h = aOCSPResponseFinders;
    }

    public void addOCSPResponseFinder(OCSPResponseFinder aOCSPResponseFinder) {
        this.h.add(aOCSPResponseFinder);
    }

    public List<DeltaCRLFinder> getDeltaCRLFinders() {
        return this.k;
    }

    public void setDeltaCRLFinders(List<DeltaCRLFinder> aDeltaCRLFinders) {
        this.k = aDeltaCRLFinders;
    }

    public void addDeltaCRLFinder(DeltaCRLFinder aDeltaCRLFinder) {
        this.k.add(aDeltaCRLFinder);
    }

    public List<ECertificate> findTrustedCertificates(ValidationSystem aValidationSystem) {
        boolean bl = StatusInfo.c;
        if (this.i.isEmpty()) {
            return b;
        }
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>(0);
        for (TrustedCertificateFinder trustedCertificateFinder : this.i) {
            arrayList.addAll(trustedCertificateFinder.findTrustedCertificate());
            if (!bl) continue;
        }
        return arrayList;
    }

    public ECertificate findIssuerCertificate(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        String string = eCertificate.getSubject().stringValue();
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(4523, 13544));
        }
        ECertificate eCertificate2 = null;
        List<ECertificate> list = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
        eCertificate2 = Find.fromList(matchSystem, list, eCertificate);
        if (eCertificate2 != null) {
            CertificateStatusInfo certificateStatusInfo = aValidationSystem.getCertificateValidationCache().getCheckResult(eCertificate2);
            aCertStatusInfo.setSigningCertficateInfo(certificateStatusInfo.clone());
            if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                return eCertificate2;
            }
            return null;
        }
        List<ECertificate> list2 = this.getTrustedCertificates();
        eCertificate2 = Find.fromList(matchSystem, list2, eCertificate);
        if (eCertificate2 != null) {
            CertificateController certificateController = new CertificateController();
            CertificateStatusInfo certificateStatusInfo = certificateController.check(aValidationSystem, eCertificate2);
            aCertStatusInfo.setSigningCertficateInfo(certificateStatusInfo);
            if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                return eCertificate2;
            }
            return null;
        }
        for (CertificateFinder certificateFinder : this.f) {
            block20: {
                block19: {
                    list = certificateFinder.findCertificate(aCertStatusInfo.getCertificate());
                    eCertificate2 = Find.fromList(matchSystem, list, eCertificate);
                    if (eCertificate2 == null) break block19;
                    if (!certificateFinder.isToBeChecked()) break block20;
                    if (this.a(aValidationSystem, aCertStatusInfo, eCertificate2)) break block20;
                }
                eCertificate2 = null;
                continue;
            }
            if (certificateFinder.isToBeChecked()) {
                Find.saveCertificate(aValidationSystem.getSaveSystem(), eCertificate2);
            }
            return eCertificate2;
        }
        return eCertificate2;
    }

    public ECertificate findCRLIssuerCertificate(ValidationSystem aValidationSystem, CRLStatusInfo aCRLStatusInfo) throws ESYAException {
        List<ECertificate> list;
        ECRL eCRL;
        MatchSystem matchSystem;
        ECertificate eCertificate;
        block24: {
            block23: {
                eCertificate = null;
                matchSystem = aValidationSystem.getMatchSystem();
                FindSystem findSystem = aValidationSystem.getFindSystem();
                eCRL = aCRLStatusInfo.getCRL();
                list = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
                eCertificate = Find.issuerCertificateFromList(matchSystem, list, eCRL);
                if (eCertificate != null) {
                    CertificateStatusInfo certificateStatusInfo = aValidationSystem.getCertificateValidationCache().getCheckResult(eCertificate);
                    aCRLStatusInfo.setSigningCertficateInfo(certificateStatusInfo.clone());
                    if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                        return eCertificate;
                    }
                    return null;
                }
                List<ECertificate> list2 = findSystem.getTrustedCertificates();
                eCertificate = Find.issuerCertificateFromList(matchSystem, list2, eCRL);
                if (eCertificate != null) {
                    CertificateController certificateController = new CertificateController();
                    CertificateStatusInfo certificateStatusInfo = certificateController.check(aValidationSystem, eCertificate);
                    aCRLStatusInfo.setSigningCertficateInfo(certificateStatusInfo);
                    if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                        return eCertificate;
                    }
                    return null;
                }
                List<ECertificate> list3 = aValidationSystem.getUserInitialCertificateSet();
                if (list3 != null) {
                    eCertificate = Find.issuerCertificateFromList(matchSystem, list3, eCRL);
                }
                if (eCertificate == null || !this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break block23;
                return eCertificate;
            }
            eCertificate = null;
            List<ECertificate> list4 = aValidationSystem.getCachedCACertificates(eCRL.getIssuer().stringValue());
            eCertificate = Find.issuerCertificateFromList(matchSystem, list4, eCRL);
            if (eCertificate == null || !this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break block24;
            return eCertificate;
        }
        eCertificate = null;
        for (CertificateFinder certificateFinder : this.f) {
            list = certificateFinder.findCertificate();
            eCertificate = Find.issuerCertificateFromList(matchSystem, list, eCRL);
            if (eCertificate != null && this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break;
            eCertificate = null;
        }
        if (eCertificate != null) {
            Find.saveCertificate(aValidationSystem.getSaveSystem(), eCertificate);
        }
        return eCertificate;
    }

    public EOCSPResponse findOCSPResponseFromInitial(ValidationSystem aValidationSystem, ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) {
        block6: {
            ECertificate eCertificate = aCertStatusInfo.getCertificate();
            boolean bl = StatusInfo.c;
            List<EOCSPResponse> list = aValidationSystem.getUserInitialOCSPResponseSet();
            if (list == null || list.size() <= 0) break block6;
            a.debug(FindSystem.a(4520, -17865) + list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                EOCSPResponse eOCSPResponse = list.get(i2);
                EResponseData eResponseData = eOCSPResponse.getBasicOCSPResponse().getTbsResponseData();
                for (int i3 = 0; i3 < eResponseData.getSingleResponseCount(); ++i3) {
                    ECertID eCertID = eResponseData.getSingleResponse(i3).getCertID();
                    if (!this.a(aValidationSystem, eCertID, eCertificate)) continue;
                    return eOCSPResponse;
                }
                if (!bl) continue;
            }
        }
        return null;
    }

    public EOCSPResponse findOCSPResponse(ValidationSystem aValidationSystem, ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) {
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        Iterator<OCSPResponseFinder> iterator = this.h.iterator();
        boolean bl = StatusInfo.c;
        while (iterator.hasNext()) {
            OCSPResponseFinder oCSPResponseFinder = iterator.next();
            a.debug(FindSystem.a(4524, -9754) + oCSPResponseFinder);
            EOCSPResponse eOCSPResponse = oCSPResponseFinder.findOCSPResponse(aCertStatusInfo.getCertificate(), aIssuerCertificate);
            if (eOCSPResponse != null) {
                return eOCSPResponse;
            }
            if (!bl) continue;
        }
        return null;
    }

    private boolean a(ValidationSystem validationSystem, ECertID eCertID, ECertificate eCertificate) {
        if (!eCertID.getSerialNumber().equals(eCertificate.getSerialNumber())) {
            return false;
        }
        try {
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier(eCertID.getHashAlgorithm());
            byte[] byArray = eCertificate.getIssuer().getEncoded();
            byte[] byArray2 = DigestUtil.digest(digestAlg, byArray);
            if (!Arrays.equals(eCertID.getIssuerNameHash(), byArray2)) {
                return false;
            }
            List<ECertificate> list = this.findIssuerCertificate(validationSystem, eCertificate, true);
            ECertificate eCertificate2 = list.get(0);
            byte[] byArray3 = eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey();
            byte[] byArray4 = DigestUtil.digest(digestAlg, byArray3);
            if (!Arrays.equals(eCertID.getIssuerKeyHash(), byArray4)) {
                return false;
            }
        }
        catch (Exception exception) {
            a.error(FindSystem.a(4514, 8672), exception);
            return false;
        }
        return true;
    }

    public List<ECRL> findCRL(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        boolean bl = StatusInfo.c;
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        Object var7_7 = null;
        String string = eCertificate.getSubject().stringValue();
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(4525, -25414));
        }
        List<ECRL> list = new ArrayList<ECRL>();
        a.debug(FindSystem.a(4521, 5947) + aValidationSystem.getUserInitialCRLSet().size());
        list = Find.crlsFromList(matchSystem, aValidationSystem.getUserInitialCRLSet(), list, eCertificate);
        a.debug(FindSystem.a(4522, 21131) + list.size());
        for (CRLFinder object : this.g) {
            List<ECRL> list2 = object.findCRL(eCertificate);
            list = Find.crlsFromList(matchSystem, list2, list, eCertificate);
            if (!bl) continue;
            boolean bl2 = !Checker.c;
            Checker.c = bl2;
            break;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ECRL eCRL = list.get(i2);
            if (!this.checkCRL(aValidationSystem, aCertStatusInfo, eCRL)) continue;
            arrayList.add(eCRL);
            continue;
        }
        return arrayList;
    }

    public ECRL findDeltaCRL(ValidationSystem aValidationSystem, ECRL aBaseCRL, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECRL eCRL;
        block7: {
            eCRL = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECRL> list = aValidationSystem.getUserInitialCRLSet();
            eCRL = Find.deltaCRLFromList(matchSystem, list, aBaseCRL);
            if (eCRL != null && this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block7;
            eCRL = null;
            for (DeltaCRLFinder deltaCRLFinder : this.k) {
                block9: {
                    block8: {
                        List<ECRL> list2 = deltaCRLFinder.findDeltaCRL(aBaseCRL);
                        eCRL = Find.deltaCRLFromList(matchSystem, list2, aBaseCRL);
                        if (eCRL == null) break block8;
                        if (!deltaCRLFinder.isToBeChecked()) break block9;
                        if (this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block9;
                    }
                    eCRL = null;
                    continue;
                }
                return eCRL;
            }
        }
        return eCRL;
    }

    public ECRL findDeltaCRL(ValidationSystem aValidationSystem, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECRL eCRL;
        block7: {
            eCRL = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECRL> list = aValidationSystem.getUserInitialCRLSet();
            eCRL = Find.deltaCRLFromList(matchSystem, list, aCertificate);
            if (eCRL != null && this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block7;
            eCRL = null;
            for (DeltaCRLFinder deltaCRLFinder : this.k) {
                block9: {
                    block8: {
                        List<ECRL> list2 = deltaCRLFinder.findDeltaCRL(aCertificate);
                        eCRL = Find.deltaCRLFromList(matchSystem, list2, aCertificate);
                        if (eCRL == null) break block8;
                        if (!deltaCRLFinder.isToBeChecked()) break block9;
                        if (this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block9;
                    }
                    eCRL = null;
                    continue;
                }
                return eCRL;
            }
        }
        return eCRL;
    }

    public ECertificate findCrossCertificate(ValidationSystem aValidationSystem, ECertificate aCertificate) throws ESYAException {
        ECertificate eCertificate;
        block9: {
            eCertificate = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECertificate> list = aValidationSystem.getValidCertificateSet();
            eCertificate = Find.crossCertificateFromList(matchSystem, list, aCertificate);
            if (eCertificate != null) {
                return eCertificate;
            }
            List<ECertificate> list2 = aValidationSystem.getUserInitialCertificateSet();
            eCertificate = Find.crossCertificateFromList(matchSystem, list2, aCertificate);
            if (eCertificate == null) {
                List<ECertificate> list3 = this.getTrustedCertificates();
                eCertificate = Find.crossCertificateFromList(matchSystem, list3, aCertificate);
            }
            if (eCertificate != null && this.a(aValidationSystem, eCertificate)) break block9;
            eCertificate = null;
            for (CrossCertificateFinder crossCertificateFinder : this.j) {
                block10: {
                    List<ECertificate> list4 = crossCertificateFinder.findCrossCertificate();
                    eCertificate = Find.crossCertificateFromList(matchSystem, list4, aCertificate);
                    if (eCertificate != null && this.a(aValidationSystem, eCertificate)) break block10;
                    eCertificate = null;
                    continue;
                }
                return eCertificate;
            }
        }
        return eCertificate;
    }

    boolean a(ValidationSystem validationSystem, StatusInfo statusInfo, ECertificate eCertificate) throws ESYAException {
        boolean bl;
        block5: {
            block4: {
                IssuerCheckParameters issuerCheckParameters = validationSystem.getCheckSystem().getConstraintCheckParam();
                issuerCheckParameters.increaseCertificateOrder();
                CertificateController certificateController = new CertificateController();
                CertificateStatusInfo certificateStatusInfo = certificateController.check(validationSystem, eCertificate);
                statusInfo.setSigningCertficateInfo(certificateStatusInfo);
                issuerCheckParameters.decreaseCertificateOrder();
                if (certificateStatusInfo.getCertificateStatus() != CertificateStatus.VALID && certificateStatusInfo.getCertificateStatus() != CertificateStatus.NOT_CHECKED) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public boolean checkCRL(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo, ECRL aCRL) throws ESYAException {
        CRLStatusInfo cRLStatusInfo;
        block5: {
            block4: {
                CRLController cRLController = new CRLController();
                cRLStatusInfo = cRLController.check(aValidationSystem, aCRL);
                if (cRLStatusInfo.getCRLStatus() != CRLStatus.VALID) break block4;
                if (aCertStatusInfo.getTrustCertificate().equals(cRLStatusInfo.getTrustCertificate())) break block5;
                return false;
            }
            return false;
        }
        aCertStatusInfo.addCRLInfo(cRLStatusInfo);
        return true;
    }

    boolean a(ValidationSystem validationSystem, ECRL eCRL, CertificateStatusInfo certificateStatusInfo) throws ESYAException {
        DeltaCRLController deltaCRLController = new DeltaCRLController();
        CRLStatusInfo cRLStatusInfo = deltaCRLController.check(validationSystem, eCRL);
        certificateStatusInfo.addDeltaCRLInfo(cRLStatusInfo);
        boolean bl = cRLStatusInfo.getCRLStatus() == CRLStatus.VALID;
        return bl;
    }

    boolean a(ValidationSystem validationSystem, ECertificate eCertificate) throws ESYAException {
        CertificateController certificateController = new CertificateController();
        CertificateStatusInfo certificateStatusInfo = certificateController.check(validationSystem, eCertificate);
        boolean bl = certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID;
        return bl;
    }

    public List<ECertificate> findIssuerCertificate(ValidationSystem aValidationSystem, ECertificate aCertificate, boolean aRemoteSearch) {
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        boolean bl = StatusInfo.c;
        String string = aCertificate.getSubject().stringValue();
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(4527, -19558));
        }
        List<ECertificate> list = new ArrayList<ECertificate>();
        List<ECertificate> list2 = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
        list = Find.issuerCertificatesFromList(matchSystem, list2, aCertificate, list);
        List<ECertificate> list3 = this.getTrustedCertificates();
        list = Find.issuerCertificatesFromList(matchSystem, list3, aCertificate, list);
        List<ECertificate> list4 = aValidationSystem.getUserInitialCertificateSet();
        list = Find.issuerCertificatesFromList(matchSystem, list4, aCertificate, list);
        for (CertificateFinder certificateFinder : this.f) {
            block8: {
                if (aRemoteSearch || !certificateFinder.isRemote()) break block8;
                if (!bl) continue;
            }
            list2 = certificateFinder.findCertificate(aCertificate);
            list = Find.issuerCertificatesFromList(matchSystem, list2, aCertificate, list);
            if (!bl) continue;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[9];
                var3_1 = 0;
                var2_2 = "\u0019\u000f\u00c1\u001b\u00e0\u00a9\u0090~\u00bcu5\u00832qe]2\u00d0\u0095#\u0016\u00b4\u00f1-\u00c9\\\"\u00ce\u00a8\u008e\u00e7\u00859.\u00d8\u00a9\u0006\\\u00df\u00bbQ\u00de\"\u00dc\u01ec\u00ecDK\u00a2\u00ea\u00a93\u00bf\u00e6\u0014\u0017\u008eq\u00aa-2\u0092\u00e9W\u009e\u00df\u00f6\u00ceOS\u00c0.\u0083\u0098w\u00d8H|\u00cd\u000b\u0015%\u00b7H:\u00ee\u009eYQ\u00c0$\u001b\u00a5\u00abp\u00847\u0002\u00e2^:\u00d1e\u00a1\u0095\u00e3-\u0090n\u0083\u00da\u00f0\u00b3R\u0014\u00151\u0082\u009f%\u00ee\u00e1\u00ee\u0087*\t^d'\u00db\u0016/\u0007{\u001f\u0003\u00fe\t\u00c0\u0011\u00b2\u008b^i3\u00f4\u00ee\u0005\u0093\u00dcB\u00e1\u008d*\u00f6\u0001\u0097\u0017\u008b\u0091\u00d6\u0099\u00ad\u00b3su\u00fa\u00ae\u009bn\u0019w\u00e4\u008e*%\u00c9\u0092W<\u00c3";
                var4_3 = "\u0019\u000f\u00c1\u001b\u00e0\u00a9\u0090~\u00bcu5\u00832qe]2\u00d0\u0095#\u0016\u00b4\u00f1-\u00c9\\\"\u00ce\u00a8\u008e\u00e7\u00859.\u00d8\u00a9\u0006\\\u00df\u00bbQ\u00de\"\u00dc\u01ec\u00ecDK\u00a2\u00ea\u00a93\u00bf\u00e6\u0014\u0017\u008eq\u00aa-2\u0092\u00e9W\u009e\u00df\u00f6\u00ceOS\u00c0.\u0083\u0098w\u00d8H|\u00cd\u000b\u0015%\u00b7H:\u00ee\u009eYQ\u00c0$\u001b\u00a5\u00abp\u00847\u0002\u00e2^:\u00d1e\u00a1\u0095\u00e3-\u0090n\u0083\u00da\u00f0\u00b3R\u0014\u00151\u0082\u009f%\u00ee\u00e1\u00ee\u0087*\t^d'\u00db\u0016/\u0007{\u001f\u0003\u00fe\t\u00c0\u0011\u00b2\u008b^i3\u00f4\u00ee\u0005\u0093\u00dcB\u00e1\u008d*\u00f6\u0001\u0097\u0017\u008b\u0091\u00d6\u0099\u00ad\u00b3su\u00fa\u00ae\u009bn\u0019w\u00e4\u008e*%\u00c9\u0092W<\u00c3".length();
                var1_4 = 19;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0017\u001f\u00d1X\u00cd\u00f2\u00a2\u001b\u00b84\u00e5\u00f2]\u00a8\u00ee\u00f9\u0089\u00ba9U/x\bQ\u00b1\u0013\u008b8\u009c\u0080\u0097\u001e \u00e1M\u00ab0\u00df\u008a\u008c\u00a8\u00f6Eru";
                    var4_3 = "\u0017\u001f\u00d1X\u00cd\u00f2\u00a2\u001b\u00b84\u00e5\u00f2]\u00a8\u00ee\u00f9\u0089\u00ba9U/x\bQ\u00b1\u0013\u008b8\u009c\u0080\u0097\u001e \u00e1M\u00ab0\u00df\u008a\u008c\u00a8\u00f6Eru".length();
                    var1_4 = 25;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 8;
                            break;
                        }
                        case 1: {
                            v13 = 77;
                            break;
                        }
                        case 2: {
                            v13 = 115;
                            break;
                        }
                        case 3: {
                            v13 = 125;
                            break;
                        }
                        case 4: {
                            v13 = 36;
                            break;
                        }
                        case 5: {
                            v13 = 3;
                            break;
                        }
                        default: {
                            v13 = 3;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        FindSystem.l = var5;
        FindSystem.m = new String[9];
        FindSystem.a = LoggerFactory.getLogger(FindSystem.class);
        FindSystem.b = new ArrayList<ECertificate>(0);
        FindSystem.c = new ArrayList<ECRL>(0);
    }

    private static String a(int n2, int n3) {
        int n4 = (n2 ^ 0x11AA) & 0xFFFF;
        if (m[n4] == null) {
            int n5;
            int n6;
            char[] cArray = l[n4].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n6 = 99;
                    break;
                }
                case 1: {
                    n6 = 8;
                    break;
                }
                case 2: {
                    n6 = 73;
                    break;
                }
                case 3: {
                    n6 = 195;
                    break;
                }
                case 4: {
                    n6 = 27;
                    break;
                }
                case 5: {
                    n6 = 150;
                    break;
                }
                case 6: {
                    n6 = 223;
                    break;
                }
                case 7: {
                    n6 = 164;
                    break;
                }
                case 8: {
                    n6 = 183;
                    break;
                }
                case 9: {
                    n6 = 56;
                    break;
                }
                case 10: {
                    n6 = 250;
                    break;
                }
                case 11: {
                    n6 = 11;
                    break;
                }
                case 12: {
                    n6 = 129;
                    break;
                }
                case 13: {
                    n6 = 133;
                    break;
                }
                case 14: {
                    n6 = 103;
                    break;
                }
                case 15: {
                    n6 = 75;
                    break;
                }
                case 16: {
                    n6 = 65;
                    break;
                }
                case 17: {
                    n6 = 47;
                    break;
                }
                case 18: {
                    n6 = 33;
                    break;
                }
                case 19: {
                    n6 = 58;
                    break;
                }
                case 20: {
                    n6 = 227;
                    break;
                }
                case 21: {
                    n6 = 224;
                    break;
                }
                case 22: {
                    n6 = 1;
                    break;
                }
                case 23: {
                    n6 = 5;
                    break;
                }
                case 24: {
                    n6 = 22;
                    break;
                }
                case 25: {
                    n6 = 78;
                    break;
                }
                case 26: {
                    n6 = 159;
                    break;
                }
                case 27: {
                    n6 = 31;
                    break;
                }
                case 28: {
                    n6 = 234;
                    break;
                }
                case 29: {
                    n6 = 221;
                    break;
                }
                case 30: {
                    n6 = 170;
                    break;
                }
                case 31: {
                    n6 = 123;
                    break;
                }
                case 32: {
                    n6 = 54;
                    break;
                }
                case 33: {
                    n6 = 85;
                    break;
                }
                case 34: {
                    n6 = 246;
                    break;
                }
                case 35: {
                    n6 = 15;
                    break;
                }
                case 36: {
                    n6 = 181;
                    break;
                }
                case 37: {
                    n6 = 20;
                    break;
                }
                case 38: {
                    n6 = 88;
                    break;
                }
                case 39: {
                    n6 = 237;
                    break;
                }
                case 40: {
                    n6 = 125;
                    break;
                }
                case 41: {
                    n6 = 113;
                    break;
                }
                case 42: {
                    n6 = 28;
                    break;
                }
                case 43: {
                    n6 = 202;
                    break;
                }
                case 44: {
                    n6 = 220;
                    break;
                }
                case 45: {
                    n6 = 68;
                    break;
                }
                case 46: {
                    n6 = 216;
                    break;
                }
                case 47: {
                    n6 = 124;
                    break;
                }
                case 48: {
                    n6 = 13;
                    break;
                }
                case 49: {
                    n6 = 196;
                    break;
                }
                case 50: {
                    n6 = 138;
                    break;
                }
                case 51: {
                    n6 = 21;
                    break;
                }
                case 52: {
                    n6 = 157;
                    break;
                }
                case 53: {
                    n6 = 92;
                    break;
                }
                case 54: {
                    n6 = 152;
                    break;
                }
                case 55: {
                    n6 = 57;
                    break;
                }
                case 56: {
                    n6 = 89;
                    break;
                }
                case 57: {
                    n6 = 4;
                    break;
                }
                case 58: {
                    n6 = 155;
                    break;
                }
                case 59: {
                    n6 = 63;
                    break;
                }
                case 60: {
                    n6 = 107;
                    break;
                }
                case 61: {
                    n6 = 210;
                    break;
                }
                case 62: {
                    n6 = 18;
                    break;
                }
                case 63: {
                    n6 = 252;
                    break;
                }
                case 64: {
                    n6 = 87;
                    break;
                }
                case 65: {
                    n6 = 59;
                    break;
                }
                case 66: {
                    n6 = 128;
                    break;
                }
                case 67: {
                    n6 = 192;
                    break;
                }
                case 68: {
                    n6 = 77;
                    break;
                }
                case 69: {
                    n6 = 14;
                    break;
                }
                case 70: {
                    n6 = 194;
                    break;
                }
                case 71: {
                    n6 = 120;
                    break;
                }
                case 72: {
                    n6 = 43;
                    break;
                }
                case 73: {
                    n6 = 211;
                    break;
                }
                case 74: {
                    n6 = 110;
                    break;
                }
                case 75: {
                    n6 = 232;
                    break;
                }
                case 76: {
                    n6 = 208;
                    break;
                }
                case 77: {
                    n6 = 7;
                    break;
                }
                case 78: {
                    n6 = 95;
                    break;
                }
                case 79: {
                    n6 = 42;
                    break;
                }
                case 80: {
                    n6 = 23;
                    break;
                }
                case 81: {
                    n6 = 171;
                    break;
                }
                case 82: {
                    n6 = 143;
                    break;
                }
                case 83: {
                    n6 = 222;
                    break;
                }
                case 84: {
                    n6 = 162;
                    break;
                }
                case 85: {
                    n6 = 172;
                    break;
                }
                case 86: {
                    n6 = 83;
                    break;
                }
                case 87: {
                    n6 = 50;
                    break;
                }
                case 88: {
                    n6 = 243;
                    break;
                }
                case 89: {
                    n6 = 173;
                    break;
                }
                case 90: {
                    n6 = 86;
                    break;
                }
                case 91: {
                    n6 = 156;
                    break;
                }
                case 92: {
                    n6 = 249;
                    break;
                }
                case 93: {
                    n6 = 165;
                    break;
                }
                case 94: {
                    n6 = 226;
                    break;
                }
                case 95: {
                    n6 = 229;
                    break;
                }
                case 96: {
                    n6 = 67;
                    break;
                }
                case 97: {
                    n6 = 182;
                    break;
                }
                case 98: {
                    n6 = 135;
                    break;
                }
                case 99: {
                    n6 = 178;
                    break;
                }
                case 100: {
                    n6 = 32;
                    break;
                }
                case 101: {
                    n6 = 70;
                    break;
                }
                case 102: {
                    n6 = 126;
                    break;
                }
                case 103: {
                    n6 = 76;
                    break;
                }
                case 104: {
                    n6 = 241;
                    break;
                }
                case 105: {
                    n6 = 203;
                    break;
                }
                case 106: {
                    n6 = 69;
                    break;
                }
                case 107: {
                    n6 = 6;
                    break;
                }
                case 108: {
                    n6 = 205;
                    break;
                }
                case 109: {
                    n6 = 90;
                    break;
                }
                case 110: {
                    n6 = 98;
                    break;
                }
                case 111: {
                    n6 = 55;
                    break;
                }
                case 112: {
                    n6 = 255;
                    break;
                }
                case 113: {
                    n6 = 190;
                    break;
                }
                case 114: {
                    n6 = 71;
                    break;
                }
                case 115: {
                    n6 = 209;
                    break;
                }
                case 116: {
                    n6 = 119;
                    break;
                }
                case 117: {
                    n6 = 41;
                    break;
                }
                case 118: {
                    n6 = 160;
                    break;
                }
                case 119: {
                    n6 = 130;
                    break;
                }
                case 120: {
                    n6 = 49;
                    break;
                }
                case 121: {
                    n6 = 100;
                    break;
                }
                case 122: {
                    n6 = 214;
                    break;
                }
                case 123: {
                    n6 = 244;
                    break;
                }
                case 124: {
                    n6 = 200;
                    break;
                }
                case 125: {
                    n6 = 142;
                    break;
                }
                case 126: {
                    n6 = 40;
                    break;
                }
                case 127: {
                    n6 = 166;
                    break;
                }
                case 128: {
                    n6 = 174;
                    break;
                }
                case 129: {
                    n6 = 253;
                    break;
                }
                case 130: {
                    n6 = 240;
                    break;
                }
                case 131: {
                    n6 = 26;
                    break;
                }
                case 132: {
                    n6 = 149;
                    break;
                }
                case 133: {
                    n6 = 60;
                    break;
                }
                case 134: {
                    n6 = 104;
                    break;
                }
                case 135: {
                    n6 = 176;
                    break;
                }
                case 136: {
                    n6 = 74;
                    break;
                }
                case 137: {
                    n6 = 24;
                    break;
                }
                case 138: {
                    n6 = 233;
                    break;
                }
                case 139: {
                    n6 = 19;
                    break;
                }
                case 140: {
                    n6 = 248;
                    break;
                }
                case 141: {
                    n6 = 186;
                    break;
                }
                case 142: {
                    n6 = 48;
                    break;
                }
                case 143: {
                    n6 = 153;
                    break;
                }
                case 144: {
                    n6 = 180;
                    break;
                }
                case 145: {
                    n6 = 201;
                    break;
                }
                case 146: {
                    n6 = 236;
                    break;
                }
                case 147: {
                    n6 = 175;
                    break;
                }
                case 148: {
                    n6 = 52;
                    break;
                }
                case 149: {
                    n6 = 158;
                    break;
                }
                case 150: {
                    n6 = 238;
                    break;
                }
                case 151: {
                    n6 = 66;
                    break;
                }
                case 152: {
                    n6 = 112;
                    break;
                }
                case 153: {
                    n6 = 242;
                    break;
                }
                case 154: {
                    n6 = 10;
                    break;
                }
                case 155: {
                    n6 = 37;
                    break;
                }
                case 156: {
                    n6 = 167;
                    break;
                }
                case 157: {
                    n6 = 161;
                    break;
                }
                case 158: {
                    n6 = 17;
                    break;
                }
                case 159: {
                    n6 = 251;
                    break;
                }
                case 160: {
                    n6 = 136;
                    break;
                }
                case 161: {
                    n6 = 217;
                    break;
                }
                case 162: {
                    n6 = 140;
                    break;
                }
                case 163: {
                    n6 = 64;
                    break;
                }
                case 164: {
                    n6 = 53;
                    break;
                }
                case 165: {
                    n6 = 81;
                    break;
                }
                case 166: {
                    n6 = 177;
                    break;
                }
                case 167: {
                    n6 = 127;
                    break;
                }
                case 168: {
                    n6 = 199;
                    break;
                }
                case 169: {
                    n6 = 114;
                    break;
                }
                case 170: {
                    n6 = 93;
                    break;
                }
                case 171: {
                    n6 = 62;
                    break;
                }
                case 172: {
                    n6 = 219;
                    break;
                }
                case 173: {
                    n6 = 61;
                    break;
                }
                case 174: {
                    n6 = 139;
                    break;
                }
                case 175: {
                    n6 = 3;
                    break;
                }
                case 176: {
                    n6 = 163;
                    break;
                }
                case 177: {
                    n6 = 12;
                    break;
                }
                case 178: {
                    n6 = 109;
                    break;
                }
                case 179: {
                    n6 = 79;
                    break;
                }
                case 180: {
                    n6 = 122;
                    break;
                }
                case 181: {
                    n6 = 168;
                    break;
                }
                case 182: {
                    n6 = 115;
                    break;
                }
                case 183: {
                    n6 = 80;
                    break;
                }
                case 184: {
                    n6 = 118;
                    break;
                }
                case 185: {
                    n6 = 213;
                    break;
                }
                case 186: {
                    n6 = 45;
                    break;
                }
                case 187: {
                    n6 = 116;
                    break;
                }
                case 188: {
                    n6 = 96;
                    break;
                }
                case 189: {
                    n6 = 147;
                    break;
                }
                case 190: {
                    n6 = 189;
                    break;
                }
                case 191: {
                    n6 = 185;
                    break;
                }
                case 192: {
                    n6 = 16;
                    break;
                }
                case 193: {
                    n6 = 145;
                    break;
                }
                case 194: {
                    n6 = 230;
                    break;
                }
                case 195: {
                    n6 = 204;
                    break;
                }
                case 196: {
                    n6 = 254;
                    break;
                }
                case 197: {
                    n6 = 44;
                    break;
                }
                case 198: {
                    n6 = 106;
                    break;
                }
                case 199: {
                    n6 = 97;
                    break;
                }
                case 200: {
                    n6 = 102;
                    break;
                }
                case 201: {
                    n6 = 239;
                    break;
                }
                case 202: {
                    n6 = 35;
                    break;
                }
                case 203: {
                    n6 = 101;
                    break;
                }
                case 204: {
                    n6 = 144;
                    break;
                }
                case 205: {
                    n6 = 191;
                    break;
                }
                case 206: {
                    n6 = 206;
                    break;
                }
                case 207: {
                    n6 = 117;
                    break;
                }
                case 208: {
                    n6 = 187;
                    break;
                }
                case 209: {
                    n6 = 84;
                    break;
                }
                case 210: {
                    n6 = 39;
                    break;
                }
                case 211: {
                    n6 = 29;
                    break;
                }
                case 212: {
                    n6 = 154;
                    break;
                }
                case 213: {
                    n6 = 184;
                    break;
                }
                case 214: {
                    n6 = 30;
                    break;
                }
                case 215: {
                    n6 = 9;
                    break;
                }
                case 216: {
                    n6 = 36;
                    break;
                }
                case 217: {
                    n6 = 94;
                    break;
                }
                case 218: {
                    n6 = 146;
                    break;
                }
                case 219: {
                    n6 = 105;
                    break;
                }
                case 220: {
                    n6 = 245;
                    break;
                }
                case 221: {
                    n6 = 82;
                    break;
                }
                case 222: {
                    n6 = 91;
                    break;
                }
                case 223: {
                    n6 = 231;
                    break;
                }
                case 224: {
                    n6 = 207;
                    break;
                }
                case 225: {
                    n6 = 46;
                    break;
                }
                case 226: {
                    n6 = 108;
                    break;
                }
                case 227: {
                    n6 = 131;
                    break;
                }
                case 228: {
                    n6 = 0;
                    break;
                }
                case 229: {
                    n6 = 218;
                    break;
                }
                case 230: {
                    n6 = 212;
                    break;
                }
                case 231: {
                    n6 = 225;
                    break;
                }
                case 232: {
                    n6 = 148;
                    break;
                }
                case 233: {
                    n6 = 34;
                    break;
                }
                case 234: {
                    n6 = 132;
                    break;
                }
                case 235: {
                    n6 = 72;
                    break;
                }
                case 236: {
                    n6 = 51;
                    break;
                }
                case 237: {
                    n6 = 198;
                    break;
                }
                case 238: {
                    n6 = 247;
                    break;
                }
                case 239: {
                    n6 = 121;
                    break;
                }
                case 240: {
                    n6 = 141;
                    break;
                }
                case 241: {
                    n6 = 197;
                    break;
                }
                case 242: {
                    n6 = 228;
                    break;
                }
                case 243: {
                    n6 = 2;
                    break;
                }
                case 244: {
                    n6 = 215;
                    break;
                }
                case 245: {
                    n6 = 151;
                    break;
                }
                case 246: {
                    n6 = 134;
                    break;
                }
                case 247: {
                    n6 = 169;
                    break;
                }
                case 248: {
                    n6 = 38;
                    break;
                }
                case 249: {
                    n6 = 193;
                    break;
                }
                case 250: {
                    n6 = 25;
                    break;
                }
                case 251: {
                    n6 = 111;
                    break;
                }
                case 252: {
                    n6 = 235;
                    break;
                }
                case 253: {
                    n6 = 137;
                    break;
                }
                case 254: {
                    n6 = 188;
                    break;
                }
                default: {
                    n6 = 179;
                }
            }
            int n7 = n6;
            int n8 = (n3 & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n5 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n5 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            FindSystem.m[n4] = new String(cArray).intern();
        }
        return m[n4];
    }
}

