/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation;

import java.util.ArrayList;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ParameterList;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationFromCRLChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationFromOCSPChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationInfoMap;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevokeCheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.deltacrl.DeltaCRLController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Find;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;

public class RevocationCheckerFromMap
extends RevocationChecker {
    protected RevocationInfoMap mRevocationInfoMap;
    private static final String e;

    public RevocationCheckerFromMap(RevocationInfoMap aRevocationInfoMap) {
        this.mRevocationInfoMap = aRevocationInfoMap;
        this.setCheckParameters(new ParameterList());
        this.mCheckParams.addParameter(e, Boolean.TRUE);
    }

    protected RevokeCheckStatus _checkFromCRL(ECertificate aIssuerCert, CertificateStatusInfo iCSI, RevocationInfoMap.RevocationInfoItems iRI) throws ESYAException {
        int n2 = RevocationChecker.d;
        if (this.mParentSystem == null) {
            return RevokeCheckStatus.CANT_CHECK;
        }
        MatchSystem matchSystem = this.mParentSystem.getMatchSystem();
        RevocationFromCRLChecker.RevocationCoverage revocationCoverage = new RevocationFromCRLChecker.RevocationCoverage();
        ECertificate eCertificate = iCSI.getCertificate();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i2 = 0; i2 < iRI.a().size(); ++i2) {
            ECRL eCRL;
            ECRL eCRL2;
            block17: {
                block16: {
                    eCRL2 = iRI.a().get(i2);
                    byte[] byArray = eCRL2.getSignature();
                    eCRL = this._deltaSilAl(eCRL2, iRI.a(), iCSI);
                    if (arrayList.contains(byArray) && n2 == 0) continue;
                    arrayList.add(byArray);
                    if (Find.isMatcingCRL(matchSystem, eCertificate, eCRL2)) break block16;
                    if (n2 == 0) continue;
                }
                if (this.mParentSystem.getFindSystem().checkCRL(this.mParentSystem, iCSI, eCRL2)) break block17;
                if (n2 == 0) continue;
            }
            RevokeCheckStatus revokeCheckStatus = RevocationFromCRLChecker.checkFromCRL(this.mParentSystem, iCSI, eCRL2, eCRL, revocationCoverage);
            if (revokeCheckStatus == RevokeCheckStatus.CANT_CHECK) continue;
            return revokeCheckStatus;
        }
        return RevokeCheckStatus.CANT_CHECK;
    }

    protected RevokeCheckStatus _checkFromOCSP(ECertificate aIssuerCert, CertificateStatusInfo iCSI, RevocationInfoMap.RevocationInfoItems iRI) throws ESYAException {
        int n2 = RevocationChecker.d;
        if (this.mParentSystem == null) {
            return RevokeCheckStatus.CANT_CHECK;
        }
        MatchSystem matchSystem = this.mParentSystem.getMatchSystem();
        ECertificate eCertificate = iCSI.getCertificate();
        for (int i2 = 0; i2 < iRI.b().size(); ++i2) {
            EOCSPResponse eOCSPResponse = iRI.b().get(i2);
            if (!Find.isMatchingOCSPResponse(matchSystem, eCertificate, aIssuerCert, eOCSPResponse) && n2 == 0) continue;
            RevokeCheckStatus revokeCheckStatus = RevocationFromOCSPChecker.checkFromOCSP(this.mParentSystem, iCSI, eOCSPResponse);
            if (revokeCheckStatus == RevokeCheckStatus.CANT_CHECK) continue;
            return revokeCheckStatus;
        }
        return RevokeCheckStatus.CANT_CHECK;
    }

    @Override
    protected RevokeCheckStatus _check(ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        RevokeCheckStatus revokeCheckStatus;
        block9: {
            revokeCheckStatus = null;
            ECertificate eCertificate = aCertStatusInfo.getCertificate();
            if (this.mParentSystem == null) {
                return RevokeCheckStatus.CANT_CHECK;
            }
            if (!this.mRevocationInfoMap.contains(eCertificate)) {
                return RevokeCheckStatus.CANT_CHECK;
            }
            RevocationInfoMap.RevocationInfoItems revocationInfoItems = this.mRevocationInfoMap.getMap().get(eCertificate);
            if (!revocationInfoItems.a().isEmpty()) {
                revokeCheckStatus = this._checkFromCRL(aIssuerCertificate, aCertStatusInfo, revocationInfoItems);
            }
            if (revokeCheckStatus == RevokeCheckStatus.NOT_REVOKED || revocationInfoItems.b().isEmpty()) break block9;
            revokeCheckStatus = this._checkFromOCSP(aIssuerCertificate, aCertStatusInfo, revocationInfoItems);
        }
        return revokeCheckStatus;
    }

    protected ECRL _deltaSilAl(ECRL aBaseSil, List<ECRL> aCRLList, CertificateStatusInfo aSDB) throws ESYAException {
        int n2 = RevocationChecker.d;
        if (this.mParentSystem == null) {
            return null;
        }
        MatchSystem matchSystem = this.mParentSystem.getMatchSystem();
        for (int i2 = 0; i2 < aCRLList.size(); ++i2) {
            if (!Find.isMatchingDeltaCRL(matchSystem, aBaseSil, aCRLList.get(i2)) && n2 == 0) continue;
            DeltaCRLController deltaCRLController = new DeltaCRLController();
            CRLStatusInfo cRLStatusInfo = deltaCRLController.check(this.mParentSystem, aCRLList.get(i2));
            aSDB.addDeltaCRLInfo(cRLStatusInfo);
            if (cRLStatusInfo.getCRLStatus() != CRLStatus.VALID) continue;
            return aCRLList.get(i2);
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block11: {
                char[] cArray3 = "$[X\u001a8".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block11;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 7) {
                        case 0: {
                            n7 = 64;
                            break;
                        }
                        case 1: {
                            n7 = 62;
                            break;
                        }
                        case 2: {
                            n7 = 46;
                            break;
                        }
                        case 3: {
                            n7 = 123;
                            break;
                        }
                        case 4: {
                            n7 = 85;
                            break;
                        }
                        case 5: {
                            n7 = 28;
                            break;
                        }
                        default: {
                            n7 = 3;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        e = new String(cArray).intern();
    }
}

