/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPSignatureChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class SigningCertificateChecker
extends OCSPResponseChecker {
    private static final Logger d;
    private static final String e;

    @Override
    protected PathValidationResult _check(EOCSPResponse aOCSPResponse, OCSPResponseStatusInfo aOCSPResponseInfo) throws ESYAException {
        if (this.mParentSystem == null) {
            return null;
        }
        ECertificate eCertificate = aOCSPResponse.getBasicOCSPResponse().getCertificate(0);
        if (!this.a(eCertificate)) {
            d.error(e);
            aOCSPResponseInfo.addDetail(this, OCSPSignatureChecker.OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, false);
            return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
        }
        IssuerCheckParameters issuerCheckParameters = this.mParentSystem.getCheckSystem().getConstraintCheckParam();
        long l2 = issuerCheckParameters.getCertificateOrder();
        issuerCheckParameters.setCertificateOrder(-1L);
        CertificateController certificateController = new CertificateController();
        CertificateStatusInfo certificateStatusInfo = certificateController.check(this.mParentSystem, eCertificate);
        aOCSPResponseInfo.setSigningCertficateInfo(certificateStatusInfo);
        issuerCheckParameters.setCertificateOrder(l2);
        if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
            aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.VALID, true);
            return PathValidationResult.SUCCESS;
        }
        aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.INVALID, false);
        return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
    }

    private boolean a(ECertificate eCertificate) {
        EExtendedKeyUsage eExtendedKeyUsage = eCertificate.getExtensions().getExtendedKeyUsage();
        return eExtendedKeyUsage == null || eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING);
    }

    @Override
    public String getCheckText() {
        return CertI18n.message(CertI18n.OCSP_IMZALAYAN_SERTIFIKA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block11: {
                char[] cArray3 = "6;9(#\t5\u00165*i<\r>\u000b?% $\tl0\u0015\u0010\u0019o\u0001!\u00057/(6\t/\u014ev\u00b53*\u0004 \u0016\u0149*'*H?\u001e>*9o\f)\u0160?/".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block11;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 7) {
                        case 0: {
                            n7 = 127;
                            break;
                        }
                        case 1: {
                            n7 = 86;
                            break;
                        }
                        case 2: {
                            n7 = 67;
                            break;
                        }
                        case 3: {
                            n7 = 73;
                            break;
                        }
                        case 4: {
                            n7 = 79;
                            break;
                        }
                        case 5: {
                            n7 = 104;
                            break;
                        }
                        default: {
                            n7 = 76;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        e = new String(cArray).intern();
        d = LoggerFactory.getLogger(SigningCertificateChecker.class);
    }

    public static final class SigningCertificateCheckStatus
    extends Enum<SigningCertificateCheckStatus>
    implements CheckStatus {
        public static final /* enum */ SigningCertificateCheckStatus VALID;
        public static final /* enum */ SigningCertificateCheckStatus INVALID;
        private static final /* synthetic */ SigningCertificateCheckStatus[] a;

        public static SigningCertificateCheckStatus[] values() {
            return (SigningCertificateCheckStatus[])a.clone();
        }

        public static SigningCertificateCheckStatus valueOf(String name) {
            return Enum.valueOf(SigningCertificateCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case VALID: {
                    return CertI18n.message(CertI18n.IMZALAYAN_SERTIFIKA_GECERLI);
                }
                case INVALID: {
                    return CertI18n.message(CertI18n.IMZALAYAN_SERTIFIKA_GECERSIZ);
                }
            }
            return CertI18n.message(CertI18n.KONTROL_SONUCU);
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var6 = new String[2];
                var4_1 = 0;
                var3_2 = "l\r\u001c=[(a\u0005s\u0002\u00065S";
                var5_3 = "l\r\u001c=[(a\u0005s\u0002\u00065S".length();
                var2_4 = 7;
                var1_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var6[var4_1++] = new String(v0).intern();
                    if ((var1_5 += var2_4) < var5_3) {
                        var2_4 = var3_2.charAt(var1_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var1_5;
                v2 = var3_2.substring(v1, v1 + var2_4).toCharArray();
                var7_6 = 0;
                v3 = v2.length;
                v4 = v2;
                v5 = v3;
                if (v3 > 1) ** GOTO lbl59
                do {
                    v6 = v4;
                    v7 = v4;
                    v8 = var7_6;
                    while (true) {
                        v9 = v6[v8];
                        switch (var7_6 % 7) {
                            case 0: {
                                v10 = 37;
                                break;
                            }
                            case 1: {
                                v10 = 67;
                                break;
                            }
                            case 2: {
                                v10 = 74;
                                break;
                            }
                            case 3: {
                                v10 = 124;
                                break;
                            }
                            case 4: {
                                v10 = 23;
                                break;
                            }
                            case 5: {
                                v10 = 97;
                                break;
                            }
                            default: {
                                v10 = 37;
                            }
                        }
                        v6[v8] = (char)(v9 ^ v10);
                        ++var7_6;
                        v4 = v7;
                        v5 = v5;
                        if (v5 != 0) break;
                        v7 = v4;
                        v11 = v5;
                        v8 = v5;
                        v6 = v4;
                    }
lbl59:
                    // 2 sources

                    v0 = v4;
                    v11 = v5;
                } while (v5 > var7_6);
                ** while (true)
            }
            var0_7 = var6;
            SigningCertificateCheckStatus.VALID = new SigningCertificateCheckStatus();
            SigningCertificateCheckStatus.INVALID = new SigningCertificateCheckStatus();
            SigningCertificateCheckStatus.a = new SigningCertificateCheckStatus[]{SigningCertificateCheckStatus.VALID, SigningCertificateCheckStatus.INVALID};
        }
    }
}

